static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2016 Thomas Manni <thomas.manni@free.fr>                         \n"
" */                                                                           \n"
"                                                                              \n"
"/* partial implementation of the algorithm described on the paper             \n"
" * \"WATERPIXELS: SUPERPIXELS BASED ON THE WATERSHED TRANSFORMATION\"         \n"
" * written by V. Machairas, E. Decencière and T. Walter.                     \n"
" */                                                                           \n"
"                                                                              \n"
"/* FIXME: spatial regularization influence                                    \n"
" * TODO: option to add superpixels boundaries to the output                   \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"enum_start (gegl_waterpixels_fill)                                            \n"
"   enum_value (GEGL_WATERPIXELS_FILL_AVERAGE, \"average\", N_(\"Average\"))   \n"
"   enum_value (GEGL_WATERPIXELS_FILL_RANDOM,  \"random\",  N_(\"Random\"))    \n"
"enum_end (GeglWaterpixelsFill)                                                \n"
"                                                                              \n"
"property_int (size, _(\"Superpixels size\"), 32)                              \n"
"  value_range (8, G_MAXINT)                                                   \n"
"  ui_range (8, 256)                                                           \n"
"                                                                              \n"
"property_double (smoothness, _(\"Gradient smoothness\"), 1.0)                 \n"
"  value_range (0.0, 1000.0)                                                   \n"
"  ui_range (0.0, 10.0)                                                        \n"
"  ui_gamma (1.5)                                                              \n"
"                                                                              \n"
"property_int (regularization, _(\"Spatial regularization\"), 0)               \n"
"  value_range (0, 50)                                                         \n"
"  description (_(\"trade-off between superpixel regularity and \"             \n"
"                 \"adherence to object boundaries\"))                         \n"
"                                                                              \n"
"property_enum (fill, _(\"Superpixels color\"),                                \n"
"               GeglWaterpixelsFill, gegl_waterpixels_fill,                    \n"
"               GEGL_WATERPIXELS_FILL_AVERAGE)                                 \n"
"  description (_(\"How to fill superpixels\"))                                \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_NAME     waterpixels                                          \n"
"#define GEGL_OP_C_SOURCE waterpixels.c                                        \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#define POW2(x) ((x)*(x))                                                     \n"
"                                                                              \n"
"typedef struct _Cell                                                          \n"
"{                                                                             \n"
"  gint          center_x;                                                     \n"
"  gint          center_y;                                                     \n"
"  GeglRectangle area;                                                         \n"
"  gfloat        color[3];                                                     \n"
"  glong         n_pixels;                                                     \n"
"} Cell;                                                                       \n"
"                                                                              \n"
"typedef struct _CellsGrid                                                     \n"
"{                                                                             \n"
"  Cell  *cells;                                                               \n"
"  gint   n_cells;                                                             \n"
"  gint   cell_size;                                                           \n"
"  gint   cells_per_row;                                                       \n"
"  gint   cells_per_column;                                                    \n"
"} CellsGrid;                                                                  \n"
"                                                                              \n"
"static void                                                                   \n"
"initiliaze_cellsgrid (CellsGrid           *grid,                              \n"
"                      const GeglRectangle *input_extent,                      \n"
"                      gint                 cell_size)                         \n"
"{                                                                             \n"
"  gint cells_per_row;                                                         \n"
"  gint cells_per_column;                                                      \n"
"  gint x, y;                                                                  \n"
"  gint half_size = cell_size / 2;                                             \n"
"  gint two_third_size = cell_size * 2 / 3 ;                                   \n"
"                                                                              \n"
"  cells_per_row = input_extent->width / cell_size;                            \n"
"  if (input_extent->width % cell_size)                                        \n"
"    cells_per_row++;                                                          \n"
"                                                                              \n"
"  cells_per_column = input_extent->height / cell_size;                        \n"
"  if (input_extent->height % cell_size)                                       \n"
"    cells_per_column++;                                                       \n"
"                                                                              \n"
"  grid->n_cells          = cells_per_row * cells_per_column;                  \n"
"  grid->cells            = g_new0 (Cell, grid->n_cells);                      \n"
"  grid->cell_size        = cell_size;                                         \n"
"  grid->cells_per_row    = cells_per_row;                                     \n"
"  grid->cells_per_column = cells_per_column;                                  \n"
"                                                                              \n"
"  for (y = 0; y < grid->cells_per_column; y++)                                \n"
"    for (x = 0; x < grid->cells_per_row; x++)                                 \n"
"      {                                                                       \n"
"        gint  i    = x + y * grid->cells_per_row;                             \n"
"        Cell *cell = grid->cells + i;                                         \n"
"                                                                              \n"
"        cell->center_x = x * cell_size + half_size;                           \n"
"        cell->center_y = y * cell_size + half_size;                           \n"
"                                                                              \n"
"        cell->area.x   = x * cell_size + cell_size / 6;                       \n"
"        cell->area.y   = y * cell_size + cell_size / 6;                       \n"
"        cell->area.width  = two_third_size;                                   \n"
"        cell->area.height = two_third_size;                                   \n"
"                                                                              \n"
"        gegl_rectangle_intersect (&grid->cells[i].area,                       \n"
"                                  &grid->cells[i].area,                       \n"
"                                  input_extent);                              \n"
"      }                                                                       \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglBuffer *                                                           \n"
"generate_gradient (GeglBuffer *input,                                         \n"
"                   gdouble     smoothness)                                    \n"
"{                                                                             \n"
"  GeglBuffer *gradient;                                                       \n"
"  GeglNode   *gegl;                                                           \n"
"  GeglNode   *source;                                                         \n"
"  GeglNode   *write;                                                          \n"
"  GeglNode   *blur;                                                           \n"
"  GeglNode   *gradient_magnitude;                                             \n"
"                                                                              \n"
"  gradient = gegl_buffer_new (gegl_buffer_get_extent (input),                 \n"
"                              babl_format (\"Y float\"));                     \n"
"                                                                              \n"
"  gegl = gegl_node_new ();                                                    \n"
"                                                                              \n"
"  source = gegl_node_new_child (gegl,                                         \n"
"                                \"operation\", \"gegl:buffer-source\",        \n"
"                                \"buffer\", input,                            \n"
"                                 NULL);                                       \n"
"                                                                              \n"
"  blur = gegl_node_new_child (gegl,                                           \n"
"                              \"operation\", \"gegl:gaussian-blur\",          \n"
"                              \"std-dev-x\", smoothness,                      \n"
"                              \"std-dev-y\", smoothness,                      \n"
"                              NULL);                                          \n"
"                                                                              \n"
"  gradient_magnitude = gegl_node_new_child (gegl,                             \n"
"                                  \"operation\", \"gegl:image-gradient\",     \n"
"                                  NULL);                                      \n"
"                                                                              \n"
"  write = gegl_node_new_child (gegl,                                          \n"
"                              \"operation\", \"gegl:write-buffer\",           \n"
"                              \"buffer\", gradient,                           \n"
"                              NULL);                                          \n"
"                                                                              \n"
"  gegl_node_link_many (source, blur, gradient_magnitude, write, NULL);        \n"
"  gegl_node_process (write);                                                  \n"
"  g_object_unref (gegl);                                                      \n"
"                                                                              \n"
"  return gradient;                                                            \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"regularize_gradient  (GeglBuffer *gradient,                                   \n"
"                      gint32      regularization,                             \n"
"                      CellsGrid  *grid)                                       \n"
"{                                                                             \n"
"  GeglBufferIterator *iter;                                                   \n"
"  gint x, y;                                                                  \n"
"                                                                              \n"
"  iter = gegl_buffer_iterator_new (gradient, NULL, 0, babl_format (\"Y float\"),\n"
"                                   GEGL_ACCESS_READWRITE, GEGL_ABYSS_NONE);   \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (iter))                                    \n"
"    {                                                                         \n"
"      gfloat  *pixel = iter->data[0];                                         \n"
"                                                                              \n"
"      for (y = iter->roi->y; y < iter->roi->y + iter->roi->height; y++)       \n"
"        for (x = iter->roi->x; x < iter->roi->x + iter->roi->width; x++)      \n"
"          {                                                                   \n"
"            gint X = x / grid->cell_size;                                     \n"
"            gint Y = y / grid->cell_size;                                     \n"
"                                                                              \n"
"            Cell *cell = grid->cells + X + Y * grid->cells_per_row;           \n"
"                                                                              \n"
"            //gdouble distance = (POW2(x - cell->center_x) + POW2(y - cell->center_y)) / 255.0;\n"
"            gdouble distance = sqrt (POW2(x - cell->center_x)                 \n"
"                                     + POW2(y - cell->center_y))              \n"
"                                / (gdouble) grid->cell_size;                  \n"
"                                                                              \n"
"           *pixel = *pixel + regularization * 2.0 * distance / (gdouble) grid->cell_size;\n"
"                                                                              \n"
"            pixel++;                                                          \n"
"          }                                                                   \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglBuffer *                                                           \n"
"generate_labels (GeglBuffer *gradient,                                        \n"
"                 CellsGrid  *grid)                                            \n"
"{                                                                             \n"
"  GeglBuffer  *labels;                                                        \n"
"  gfloat      *buff;                                                          \n"
"  guint32      i;                                                             \n"
"  guint32      label[2];                                                      \n"
"                                                                              \n"
"  labels = gegl_buffer_new (gegl_buffer_get_extent (gradient),                \n"
"                            babl_format (\"YA u32\"));                        \n"
"                                                                              \n"
"  for (i = 0; i < grid->n_cells; i++)                                         \n"
"    {                                                                         \n"
"      Cell *cell   = grid->cells + i;                                         \n"
"      GeglRectangle min_pixel = {0, 0, 1, 1};                                 \n"
"      gfloat min_value = G_MAXFLOAT;                                          \n"
"      gfloat  *pixel;                                                         \n"
"      gint x = cell->area.x;                                                  \n"
"      gint y = cell->area.y;                                                  \n"
"      gint n_pixels = cell->area.width * cell->area.height;                   \n"
"                                                                              \n"
"      buff = g_new (gfloat, n_pixels);                                        \n"
"                                                                              \n"
"      gegl_buffer_get (gradient, &cell->area, 1.0, babl_format (\"Y float\"), \n"
"                       buff, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);           \n"
"                                                                              \n"
"      pixel = buff;                                                           \n"
"                                                                              \n"
"      while (n_pixels--)                                                      \n"
"        {                                                                     \n"
"          if (*pixel < min_value)                                             \n"
"            {                                                                 \n"
"              min_value = *pixel;                                             \n"
"              min_pixel.x = x;                                                \n"
"              min_pixel.y = y;                                                \n"
"            }                                                                 \n"
"                                                                              \n"
"          pixel++;                                                            \n"
"          x++;                                                                \n"
"                                                                              \n"
"          if (x >= cell->area.x + cell->area.width)                           \n"
"            {                                                                 \n"
"              x = cell->area.x;                                               \n"
"              y++;                                                            \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      label[0] = i;                                                           \n"
"      label[1] = 1;                                                           \n"
"      gegl_buffer_set (labels, &min_pixel, 0, babl_format (\"YA u32\"),       \n"
"                       label, GEGL_AUTO_ROWSTRIDE);                           \n"
"                                                                              \n"
"      g_free (buff);                                                          \n"
"    }                                                                         \n"
"                                                                              \n"
"  return labels;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static GeglBuffer *                                                           \n"
"propagate_labels (GeglBuffer *labels,                                         \n"
"                  GeglBuffer *gradient)                                       \n"
"{                                                                             \n"
"  GeglNode   *gegl;                                                           \n"
"  GeglNode   *source_labels;                                                  \n"
"  GeglNode   *source_gradient;                                                \n"
"  GeglNode   *write;                                                          \n"
"  GeglNode   *watershed;                                                      \n"
"                                                                              \n"
"  GeglBuffer *result = gegl_buffer_new (gegl_buffer_get_extent (labels),      \n"
"                       babl_format (\"YA u32\"));                             \n"
"                                                                              \n"
"  gegl = gegl_node_new ();                                                    \n"
"                                                                              \n"
"  source_labels = gegl_node_new_child (gegl,                                  \n"
"                                \"operation\", \"gegl:buffer-source\",        \n"
"                                \"buffer\", labels,                           \n"
"                                 NULL);                                       \n"
"                                                                              \n"
"  source_gradient = gegl_node_new_child (gegl,                                \n"
"                                \"operation\", \"gegl:buffer-source\",        \n"
"                                \"buffer\", gradient,                         \n"
"                                 NULL);                                       \n"
"                                                                              \n"
"  watershed = gegl_node_new_child (gegl,                                      \n"
"                              \"operation\", \"gegl:watershed-transform\",    \n"
"                              NULL);                                          \n"
"                                                                              \n"
"  write = gegl_node_new_child (gegl,                                          \n"
"                              \"operation\", \"gegl:write-buffer\",           \n"
"                              \"buffer\", result,                             \n"
"                              NULL);                                          \n"
"                                                                              \n"
"  gegl_node_link_many (source_labels, watershed, write, NULL);                \n"
"  gegl_node_connect_from (watershed, \"aux\", source_gradient, \"output\");   \n"
"  gegl_node_process (write);                                                  \n"
"  g_object_unref (gegl);                                                      \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"get_random_colors (CellsGrid  *grid)                                          \n"
"{                                                                             \n"
"  GeglRandom *gr;                                                             \n"
"  gint        i;                                                              \n"
"                                                                              \n"
"  gr = gegl_random_new ();                                                    \n"
"                                                                              \n"
"  for (i = 0; i < grid->n_cells; i++)                                         \n"
"    {                                                                         \n"
"      Cell *cell = grid->cells + i;                                           \n"
"                                                                              \n"
"      cell->color[0] = gegl_random_float_range (gr,                           \n"
"                                          cell->center_x,                     \n"
"                                          cell->center_y,                     \n"
"                                          i, 0, 0.0, 1.0);                    \n"
"      cell->color[1] = gegl_random_float_range (gr,                           \n"
"                                          cell->center_x+1,                   \n"
"                                          cell->center_y+1,                   \n"
"                                          i+1, 0, 0.0, 1.0);                  \n"
"      cell->color[2] = gegl_random_float_range (gr,                           \n"
"                                          cell->center_x+2,                   \n"
"                                          cell->center_y+2,                   \n"
"                                          i+2, 0, 0.0, 1.0);                  \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_random_free (gr);                                                      \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"get_average_colors (GeglBuffer *input,                                        \n"
"                    GeglBuffer *labels,                                       \n"
"                    CellsGrid  *grid)                                         \n"
"{                                                                             \n"
"  GeglBufferIterator *iter;                                                   \n"
"  gint                i;                                                      \n"
"                                                                              \n"
"  iter = gegl_buffer_iterator_new (labels, gegl_buffer_get_extent (labels),   \n"
"                                   0, babl_format (\"YA u32\"),               \n"
"                                   GEGL_ACCESS_READ, GEGL_ABYSS_NONE);        \n"
"                                                                              \n"
"  gegl_buffer_iterator_add (iter, input, gegl_buffer_get_extent (labels), 0,  \n"
"                            babl_format (\"R'G'B' float\"),                   \n"
"                            GEGL_ACCESS_READ, GEGL_ABYSS_NONE);               \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (iter))                                    \n"
"    {                                                                         \n"
"      guint32  *label    = iter->data[0];                                     \n"
"      gfloat   *pixel    = iter->data[1];                                     \n"
"      glong     n_pixels = iter->length;                                      \n"
"                                                                              \n"
"      while (n_pixels--)                                                      \n"
"        {                                                                     \n"
"          Cell *cell = grid->cells + label[0];                                \n"
"                                                                              \n"
"          cell->color[0] += pixel[0];                                         \n"
"          cell->color[1] += pixel[1];                                         \n"
"          cell->color[2] += pixel[2];                                         \n"
"                                                                              \n"
"          cell->n_pixels++;                                                   \n"
"                                                                              \n"
"          pixel += 3;                                                         \n"
"          label += 2;                                                         \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  for (i = 0; i < grid->n_cells; i++)                                         \n"
"    {                                                                         \n"
"      Cell *cell = grid->cells + i;                                           \n"
"      cell->color[0] /= cell->n_pixels;                                       \n"
"      cell->color[1] /= cell->n_pixels;                                       \n"
"      cell->color[2] /= cell->n_pixels;                                       \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"fill_output (GeglBuffer *output,                                              \n"
"             GeglBuffer *labels,                                              \n"
"             CellsGrid  *grid)                                                \n"
"{                                                                             \n"
"  GeglBufferIterator *iter;                                                   \n"
"                                                                              \n"
"  iter = gegl_buffer_iterator_new (labels, NULL, 0, babl_format (\"YA u32\"), \n"
"                                   GEGL_ACCESS_READ, GEGL_ABYSS_NONE);        \n"
"                                                                              \n"
"  gegl_buffer_iterator_add (iter, output, NULL, 0,                            \n"
"                            babl_format (\"R'G'B' float\"),                   \n"
"                            GEGL_ACCESS_WRITE, GEGL_ABYSS_NONE);              \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (iter))                                    \n"
"    {                                                                         \n"
"      guint32  *label    = iter->data[0];                                     \n"
"      gfloat   *pixel    = iter->data[1];                                     \n"
"      glong     n_pixels = iter->length;                                      \n"
"                                                                              \n"
"      while (n_pixels--)                                                      \n"
"        {                                                                     \n"
"          Cell *cell = grid->cells + label[0];                                \n"
"                                                                              \n"
"          pixel[0] = cell->color[0];                                          \n"
"          pixel[1] = cell->color[1];                                          \n"
"          pixel[2] = cell->color[2];                                          \n"
"                                                                              \n"
"          pixel += 3;                                                         \n"
"          label += 2;                                                         \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  const Babl *format = babl_format (\"R'G'B' float\");                        \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\",  format);                  \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *roi)                            \n"
"{                                                                             \n"
"  GeglRectangle result = *gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  /* Don't request an infinite plane */                                       \n"
"  if (gegl_rectangle_is_infinite_plane (&result))                             \n"
"    return *roi;                                                              \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *operation,                            \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  GeglRectangle result = *gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  if (gegl_rectangle_is_infinite_plane (&result))                             \n"
"    return *roi;                                                              \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties  *o = GEGL_PROPERTIES (operation);                           \n"
"                                                                              \n"
"  GeglBuffer *gradient;                                                       \n"
"  GeglBuffer *initial_labels;                                                 \n"
"  GeglBuffer *propagated_labels;                                              \n"
"  CellsGrid   grid;                                                           \n"
"                                                                              \n"
"  initiliaze_cellsgrid (&grid, gegl_buffer_get_extent (input), o->size);      \n"
"                                                                              \n"
"  gradient       = generate_gradient (input, o->smoothness);                  \n"
"  initial_labels = generate_labels (gradient, &grid);                         \n"
"                                                                              \n"
"  if (o->regularization)                                                      \n"
"    regularize_gradient (gradient, o->regularization, &grid);                 \n"
"                                                                              \n"
"  propagated_labels = propagate_labels (initial_labels, gradient);            \n"
"                                                                              \n"
"  if (o->fill == GEGL_WATERPIXELS_FILL_RANDOM)                                \n"
"    get_random_colors (&grid);                                                \n"
"  else                                                                        \n"
"    get_average_colors (input, propagated_labels, &grid);                     \n"
"                                                                              \n"
"  fill_output (output, propagated_labels, &grid);                             \n"
"                                                                              \n"
"  g_object_unref (gradient);                                                  \n"
"  g_object_unref (initial_labels);                                            \n"
"  g_object_unref (propagated_labels);                                         \n"
"  g_free (grid.cells);                                                        \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process                    = process;                         \n"
"  operation_class->prepare                 = prepare;                         \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"  operation_class->get_cached_region       = get_cached_region;               \n"
"  operation_class->opencl_support          = FALSE;                           \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:waterpixels\",                                    \n"
"    \"title\",       _(\"Waterpixels\"),                                      \n"
"    \"categories\",  \"segmentation\",                                        \n"
"    \"reference-hash\", \"9aac02fb4816ea0b1142d86a55495072\",                 \n"
"    \"description\", _(\"Superpixels based on the watershed transformation\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
