static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2017 Elle Stone <ellestone@ninedegreesbelow.com>                 \n"
" *                Michael Natterer <mitch@gimp.org>                           \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (hue, _(\"Hue\"),  0.0)                                       \n"
"   description  (_(\"Hue adjustment\"))                                       \n"
"   value_range  (-180.0, 180.0)                                               \n"
"                                                                              \n"
"property_double (chroma, _(\"Chroma\"), 0.0)                                  \n"
"   description  (_(\"Chroma adjustment\"))                                    \n"
"   value_range  (-100.0, 100.0)                                               \n"
"                                                                              \n"
"property_double (lightness, _(\"Lightness\"), 0.0)                            \n"
"   description  (_(\"Lightness adjustment\"))                                 \n"
"   value_range  (-100.0, 100.0)                                               \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"                                                                              \n"
"#define GEGL_OP_NAME     hue_chroma                                           \n"
"#define GEGL_OP_C_SOURCE hue-chroma.c                                         \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\",                            \n"
"                             babl_format (\"CIE LCH(ab) alpha float\"));      \n"
"  gegl_operation_set_format (operation, \"output\",                           \n"
"                             babl_format (\"CIE LCH(ab) alpha float\"));      \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *op,                                             \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (op);                                   \n"
"  gfloat         *GEGL_ALIGNED in_pixel;                                      \n"
"  gfloat         *GEGL_ALIGNED out_pixel;                                     \n"
"  gfloat          hue;                                                        \n"
"  gfloat          chroma;                                                     \n"
"  gfloat          lightness;                                                  \n"
"                                                                              \n"
"  in_pixel   = in_buf;                                                        \n"
"  out_pixel  = out_buf;                                                       \n"
"                                                                              \n"
"  hue       = o->hue;                                                         \n"
"  chroma    = o->chroma;                                                      \n"
"  lightness = o->lightness;                                                   \n"
"                                                                              \n"
"  while (n_pixels--)                                                          \n"
"    {                                                                         \n"
"      out_pixel[0] = in_pixel[0] + lightness;                                 \n"
"      out_pixel[1] = in_pixel[1] + chroma;                                    \n"
"      out_pixel[2] = in_pixel[2] + hue;                                       \n"
"                                                                              \n"
"      out_pixel[1] = CLAMP (out_pixel[1], 0, 200.0);                          \n"
"                                                                              \n"
"      out_pixel[3] = in_pixel[3];                                             \n"
"                                                                              \n"
"      in_pixel  += 4;                                                         \n"
"      out_pixel += 4;                                                         \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *point_filter_class;                          \n"
"                                                                              \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_filter_class = GEGL_OPERATION_POINT_FILTER_CLASS (klass);             \n"
"                                                                              \n"
"  operation_class->prepare    = prepare;                                      \n"
"  point_filter_class->process = process;                                      \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"      \"name\",       \"gegl:hue-chroma\",                                    \n"
"      \"title\",      _(\"Hue-Chroma\"),                                      \n"
"      \"categories\", \"color\",                                              \n"
"      \"description\", _(\"Adjust LCH Hue, Chroma, and Lightness\"),          \n"
"      NULL);                                                                  \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
