static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"   /* no properties */                                                        \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_NAME     grey                                                 \n"
"#define GEGL_OP_C_SOURCE grey.c                                               \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <string.h>                                                           \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  const Babl *format = babl_format (\"YA float\");                            \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"/* XXX: could be sped up by special casing op-filter behavior */              \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *op,                                             \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                samples,                                        \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  memmove (out_buf, in_buf, sizeof (gfloat) * 2 * samples);                   \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *op,                                          \n"
"            cl_mem               in_tex,                                      \n"
"            cl_mem               out_tex,                                     \n"
"            size_t               global_worksize,                             \n"
"            const GeglRectangle *roi,                                         \n"
"            gint                 level)                                       \n"
"{                                                                             \n"
"  cl_int cl_err = 0;                                                          \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueCopyBuffer(gegl_cl_get_command_queue(),              \n"
"                                    in_tex , out_tex , 0 , 0 ,                \n"
"                                    global_worksize * sizeof (cl_float2),     \n"
"                                    0, NULL, NULL);                           \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"                                                                              \n"
"error:                                                                        \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *point_filter_class;                          \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  point_filter_class = GEGL_OPERATION_POINT_FILTER_CLASS (klass);             \n"
"                                                                              \n"
"  point_filter_class->process = process;                                      \n"
"  point_filter_class->cl_process = cl_process;                                \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  operation_class->opencl_support = TRUE;                                     \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"      \"name\",        \"gegl:gray\",                                         \n"
"      \"compat-name\", \"gegl:grey\",                                         \n"
"      \"title\",       _(\"Make Grey\"),                                      \n"
"      \"categories\" , \"grayscale:color\",                                   \n"
"      \"reference-hash\", \"43ddd80572ab34095298ac7c36368b0c\",               \n"
"      \"description\", _(\"Turns the image grayscale\"),                      \n"
"      NULL);                                                                  \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
