#include "db_config.h"
/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.7
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */

#define SWIGJAVA

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# undef _CRT_SECURE_NO_DEPRECATE
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif


/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  (*jenv)->ExceptionClear(jenv);
  excep = (*jenv)->FindClass(jenv, except_ptr->java_exception);
  if (excep)
    (*jenv)->ThrowNew(jenv, excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else


#include "db_int.h"
#include "dbinc/txn.h"

#ifdef HAVE_CRYPTO
#define	CRYPTO_ONLY(x) (x);
#else
#define	CRYPTO_ONLY(x)
#endif


/* don't use SWIG's array handling - save code space */
#define	SWIG_NOINCLUDE 1

#define	DB_ENV_INTERNAL(dbenv) ((dbenv)->api2_internal)
#define	DB_INTERNAL(db) ((db)->api_internal)

#define	DB_PKG "com/sleepycat/db/"

/* Forward declarations */
static int __dbj_throw(JNIEnv *jenv,
    int ret, const char *msg, jobject obj, jobject jdbenv);

/* Global data - JVM handle, classes, fields and methods */
static JavaVM *javavm;

static jclass db_class, dbc_class, dbenv_class, dbt_class, dblsn_class;
static jclass dbpreplist_class, dbstream_class, dbtxn_class;
static jclass keyrange_class;
static jclass bt_stat_class, compact_class, h_stat_class, heap_stat_class;
static jclass lock_stat_class, log_stat_class, mpool_stat_class, mpool_fstat_class;
static jclass mutex_stat_class, qam_stat_class, rep_stat_class;
static jclass repmgr_stat_class, repmgr_siteinfo_class, rephost_class;
static jclass seq_stat_class, txn_stat_class;
static jclass txn_active_class;
static jclass lock_class, lockreq_class;
static jclass dbex_class, deadex_class, heapfullex_class, lockex_class, memex_class;
static jclass metachkfailex_class, repdupmasterex_class, rephandledeadex_class;
static jclass repholdelectionex_class, repjoinfailex_class;
static jclass repleaseexpiredex_class;
static jclass replockoutex_class, repunavailex_class;
static jclass runrecex_class, sliceex_class, versionex_class;
static jclass filenotfoundex_class, illegalargex_class, outofmemerr_class;
static jclass bytearray_class, string_class, outputstream_class;

static jfieldID db_cptr_fid, dbc_cptr_fid, dbenv_cptr_fid;
static jfieldID dblsn_file_fid, dblsn_offset_fid;
static jfieldID dbt_data_fid, dbt_data_nio_fid, dbt_size_fid, dbt_ulen_fid;
static jfieldID dbt_dlen_fid, dbt_doff_fid, dbt_flags_fid, dbt_offset_fid;
static jfieldID dbstream_cptr_fid;
static jfieldID kr_less_fid, kr_equal_fid, kr_greater_fid;
static jfieldID lock_cptr_fid;
static jfieldID lockreq_op_fid, lockreq_modeflag_fid, lockreq_timeout_fid;
static jfieldID lockreq_obj_fid, lockreq_lock_fid;
static jfieldID repmgr_siteinfo_flags_fid, repmgr_siteinfo_status_fid;
static jfieldID txn_commit_token;

/* BEGIN-STAT-FIELD-DECLS */
static jfieldID bt_stat_bt_magic_fid;
static jfieldID bt_stat_bt_version_fid;
static jfieldID bt_stat_bt_metaflags_fid;
static jfieldID bt_stat_bt_nkeys_fid;
static jfieldID bt_stat_bt_ndata_fid;
static jfieldID bt_stat_bt_pagecnt_fid;
static jfieldID bt_stat_bt_pagesize_fid;
static jfieldID bt_stat_bt_minkey_fid;
static jfieldID bt_stat_bt_ext_files_fid;
static jfieldID bt_stat_bt_nblobs_fid;
static jfieldID bt_stat_bt_re_len_fid;
static jfieldID bt_stat_bt_re_pad_fid;
static jfieldID bt_stat_bt_levels_fid;
static jfieldID bt_stat_bt_int_pg_fid;
static jfieldID bt_stat_bt_leaf_pg_fid;
static jfieldID bt_stat_bt_dup_pg_fid;
static jfieldID bt_stat_bt_over_pg_fid;
static jfieldID bt_stat_bt_empty_pg_fid;
static jfieldID bt_stat_bt_free_fid;
static jfieldID bt_stat_bt_int_pgfree_fid;
static jfieldID bt_stat_bt_leaf_pgfree_fid;
static jfieldID bt_stat_bt_dup_pgfree_fid;
static jfieldID bt_stat_bt_over_pgfree_fid;
static jfieldID compact_compact_fillpercent_fid;
static jfieldID compact_compact_timeout_fid;
static jfieldID compact_compact_pages_fid;
static jfieldID compact_compact_empty_buckets_fid;
static jfieldID compact_compact_pages_free_fid;
static jfieldID compact_compact_pages_examine_fid;
static jfieldID compact_compact_levels_fid;
static jfieldID compact_compact_deadlock_fid;
static jfieldID compact_compact_pages_truncated_fid;
static jfieldID compact_compact_truncate_fid;
static jfieldID h_stat_hash_magic_fid;
static jfieldID h_stat_hash_version_fid;
static jfieldID h_stat_hash_metaflags_fid;
static jfieldID h_stat_hash_nkeys_fid;
static jfieldID h_stat_hash_ndata_fid;
static jfieldID h_stat_hash_ext_files_fid;
static jfieldID h_stat_hash_nblobs_fid;
static jfieldID h_stat_hash_pagecnt_fid;
static jfieldID h_stat_hash_pagesize_fid;
static jfieldID h_stat_hash_ffactor_fid;
static jfieldID h_stat_hash_buckets_fid;
static jfieldID h_stat_hash_free_fid;
static jfieldID h_stat_hash_bfree_fid;
static jfieldID h_stat_hash_bigpages_fid;
static jfieldID h_stat_hash_big_bfree_fid;
static jfieldID h_stat_hash_overflows_fid;
static jfieldID h_stat_hash_ovfl_free_fid;
static jfieldID h_stat_hash_dup_fid;
static jfieldID h_stat_hash_dup_free_fid;
static jfieldID heap_stat_heap_magic_fid;
static jfieldID heap_stat_heap_version_fid;
static jfieldID heap_stat_heap_metaflags_fid;
static jfieldID heap_stat_heap_ext_files_fid;
static jfieldID heap_stat_heap_nblobs_fid;
static jfieldID heap_stat_heap_nrecs_fid;
static jfieldID heap_stat_heap_pagecnt_fid;
static jfieldID heap_stat_heap_pagesize_fid;
static jfieldID heap_stat_heap_nregions_fid;
static jfieldID heap_stat_heap_regionsize_fid;
static jfieldID lock_stat_st_id_fid;
static jfieldID lock_stat_st_cur_maxid_fid;
static jfieldID lock_stat_st_initlocks_fid;
static jfieldID lock_stat_st_initlockers_fid;
static jfieldID lock_stat_st_initobjects_fid;
static jfieldID lock_stat_st_locks_fid;
static jfieldID lock_stat_st_lockers_fid;
static jfieldID lock_stat_st_objects_fid;
static jfieldID lock_stat_st_maxlocks_fid;
static jfieldID lock_stat_st_maxlockers_fid;
static jfieldID lock_stat_st_maxobjects_fid;
static jfieldID lock_stat_st_partitions_fid;
static jfieldID lock_stat_st_tablesize_fid;
static jfieldID lock_stat_st_nmodes_fid;
static jfieldID lock_stat_st_nlockers_fid;
static jfieldID lock_stat_st_nlocks_fid;
static jfieldID lock_stat_st_maxnlocks_fid;
static jfieldID lock_stat_st_maxhlocks_fid;
static jfieldID lock_stat_st_locksteals_fid;
static jfieldID lock_stat_st_maxlsteals_fid;
static jfieldID lock_stat_st_maxnlockers_fid;
static jfieldID lock_stat_st_nobjects_fid;
static jfieldID lock_stat_st_maxnobjects_fid;
static jfieldID lock_stat_st_maxhobjects_fid;
static jfieldID lock_stat_st_objectsteals_fid;
static jfieldID lock_stat_st_maxosteals_fid;
static jfieldID lock_stat_st_nrequests_fid;
static jfieldID lock_stat_st_nreleases_fid;
static jfieldID lock_stat_st_nupgrade_fid;
static jfieldID lock_stat_st_ndowngrade_fid;
static jfieldID lock_stat_st_lock_wait_fid;
static jfieldID lock_stat_st_lock_nowait_fid;
static jfieldID lock_stat_st_ndeadlocks_fid;
static jfieldID lock_stat_st_locktimeout_fid;
static jfieldID lock_stat_st_nlocktimeouts_fid;
static jfieldID lock_stat_st_txntimeout_fid;
static jfieldID lock_stat_st_ntxntimeouts_fid;
static jfieldID lock_stat_st_part_wait_fid;
static jfieldID lock_stat_st_part_nowait_fid;
static jfieldID lock_stat_st_part_max_wait_fid;
static jfieldID lock_stat_st_part_max_nowait_fid;
static jfieldID lock_stat_st_objs_wait_fid;
static jfieldID lock_stat_st_objs_nowait_fid;
static jfieldID lock_stat_st_lockers_wait_fid;
static jfieldID lock_stat_st_lockers_nowait_fid;
static jfieldID lock_stat_st_region_wait_fid;
static jfieldID lock_stat_st_region_nowait_fid;
static jfieldID lock_stat_st_nlockers_hit_fid;
static jfieldID lock_stat_st_nlockers_reused_fid;
static jfieldID lock_stat_st_hash_len_fid;
static jfieldID lock_stat_st_regsize_fid;
static jfieldID log_stat_st_magic_fid;
static jfieldID log_stat_st_version_fid;
static jfieldID log_stat_st_mode_fid;
static jfieldID log_stat_st_lg_bsize_fid;
static jfieldID log_stat_st_lg_size_fid;
static jfieldID log_stat_st_wc_bytes_fid;
static jfieldID log_stat_st_wc_mbytes_fid;
static jfieldID log_stat_st_fileid_init_fid;
static jfieldID log_stat_st_nfileid_fid;
static jfieldID log_stat_st_maxnfileid_fid;
static jfieldID log_stat_st_record_fid;
static jfieldID log_stat_st_w_bytes_fid;
static jfieldID log_stat_st_w_mbytes_fid;
static jfieldID log_stat_st_wcount_fid;
static jfieldID log_stat_st_wcount_fill_fid;
static jfieldID log_stat_st_rcount_fid;
static jfieldID log_stat_st_scount_fid;
static jfieldID log_stat_st_region_wait_fid;
static jfieldID log_stat_st_region_nowait_fid;
static jfieldID log_stat_st_cur_file_fid;
static jfieldID log_stat_st_cur_offset_fid;
static jfieldID log_stat_st_disk_file_fid;
static jfieldID log_stat_st_disk_offset_fid;
static jfieldID log_stat_st_maxcommitperflush_fid;
static jfieldID log_stat_st_mincommitperflush_fid;
static jfieldID log_stat_st_regsize_fid;
static jfieldID mpool_fstat_st_pagesize_fid;
static jfieldID mpool_fstat_st_map_fid;
static jfieldID mpool_fstat_st_cache_hit_fid;
static jfieldID mpool_fstat_st_cache_miss_fid;
static jfieldID mpool_fstat_st_page_create_fid;
static jfieldID mpool_fstat_st_page_in_fid;
static jfieldID mpool_fstat_st_page_out_fid;
static jfieldID mpool_fstat_st_backup_spins_fid;
static jfieldID mpool_fstat_file_name_fid;
static jfieldID mpool_stat_st_gbytes_fid;
static jfieldID mpool_stat_st_bytes_fid;
static jfieldID mpool_stat_st_ncache_fid;
static jfieldID mpool_stat_st_max_ncache_fid;
static jfieldID mpool_stat_st_mmapsize_fid;
static jfieldID mpool_stat_st_maxopenfd_fid;
static jfieldID mpool_stat_st_maxwrite_fid;
static jfieldID mpool_stat_st_maxwrite_sleep_fid;
static jfieldID mpool_stat_st_pages_fid;
static jfieldID mpool_stat_st_map_fid;
static jfieldID mpool_stat_st_cache_hit_fid;
static jfieldID mpool_stat_st_cache_miss_fid;
static jfieldID mpool_stat_st_page_create_fid;
static jfieldID mpool_stat_st_page_in_fid;
static jfieldID mpool_stat_st_page_out_fid;
static jfieldID mpool_stat_st_ro_evict_fid;
static jfieldID mpool_stat_st_rw_evict_fid;
static jfieldID mpool_stat_st_page_trickle_fid;
static jfieldID mpool_stat_st_page_clean_fid;
static jfieldID mpool_stat_st_page_dirty_fid;
static jfieldID mpool_stat_st_hash_buckets_fid;
static jfieldID mpool_stat_st_hash_mutexes_fid;
static jfieldID mpool_stat_st_pagesize_fid;
static jfieldID mpool_stat_st_hash_searches_fid;
static jfieldID mpool_stat_st_hash_longest_fid;
static jfieldID mpool_stat_st_hash_examined_fid;
static jfieldID mpool_stat_st_hash_nowait_fid;
static jfieldID mpool_stat_st_hash_wait_fid;
static jfieldID mpool_stat_st_hash_max_nowait_fid;
static jfieldID mpool_stat_st_hash_max_wait_fid;
static jfieldID mpool_stat_st_region_nowait_fid;
static jfieldID mpool_stat_st_region_wait_fid;
static jfieldID mpool_stat_st_mvcc_frozen_fid;
static jfieldID mpool_stat_st_mvcc_thawed_fid;
static jfieldID mpool_stat_st_mvcc_freed_fid;
static jfieldID mpool_stat_st_mvcc_reused_fid;
static jfieldID mpool_stat_st_alloc_fid;
static jfieldID mpool_stat_st_alloc_buckets_fid;
static jfieldID mpool_stat_st_alloc_max_buckets_fid;
static jfieldID mpool_stat_st_alloc_pages_fid;
static jfieldID mpool_stat_st_alloc_max_pages_fid;
static jfieldID mpool_stat_st_io_wait_fid;
static jfieldID mpool_stat_st_sync_interrupted_fid;
static jfieldID mpool_stat_st_oddfsize_detect_fid;
static jfieldID mpool_stat_st_oddfsize_resolve_fid;
static jfieldID mpool_stat_st_regsize_fid;
static jfieldID mpool_stat_st_regmax_fid;
static jfieldID mutex_stat_st_mutex_align_fid;
static jfieldID mutex_stat_st_mutex_tas_spins_fid;
static jfieldID mutex_stat_st_mutex_init_fid;
static jfieldID mutex_stat_st_mutex_cnt_fid;
static jfieldID mutex_stat_st_mutex_max_fid;
static jfieldID mutex_stat_st_mutex_free_fid;
static jfieldID mutex_stat_st_mutex_inuse_fid;
static jfieldID mutex_stat_st_mutex_inuse_max_fid;
static jfieldID mutex_stat_st_region_wait_fid;
static jfieldID mutex_stat_st_region_nowait_fid;
static jfieldID mutex_stat_st_regsize_fid;
static jfieldID mutex_stat_st_regmax_fid;
static jfieldID qam_stat_qs_magic_fid;
static jfieldID qam_stat_qs_version_fid;
static jfieldID qam_stat_qs_metaflags_fid;
static jfieldID qam_stat_qs_nkeys_fid;
static jfieldID qam_stat_qs_ndata_fid;
static jfieldID qam_stat_qs_pagesize_fid;
static jfieldID qam_stat_qs_extentsize_fid;
static jfieldID qam_stat_qs_pages_fid;
static jfieldID qam_stat_qs_re_len_fid;
static jfieldID qam_stat_qs_re_pad_fid;
static jfieldID qam_stat_qs_pgfree_fid;
static jfieldID qam_stat_qs_first_recno_fid;
static jfieldID qam_stat_qs_cur_recno_fid;
static jfieldID rep_stat_st_startup_complete_fid;
static jfieldID rep_stat_st_view_fid;
static jfieldID rep_stat_st_log_queued_fid;
static jfieldID rep_stat_st_status_fid;
static jfieldID rep_stat_st_next_lsn_fid;
static jfieldID rep_stat_st_waiting_lsn_fid;
static jfieldID rep_stat_st_max_perm_lsn_fid;
static jfieldID rep_stat_st_next_pg_fid;
static jfieldID rep_stat_st_waiting_pg_fid;
static jfieldID rep_stat_st_dupmasters_fid;
static jfieldID rep_stat_st_env_id_fid;
static jfieldID rep_stat_st_env_priority_fid;
static jfieldID rep_stat_st_ext_duplicated_fid;
static jfieldID rep_stat_st_ext_records_fid;
static jfieldID rep_stat_st_ext_rereq_fid;
static jfieldID rep_stat_st_ext_update_rereq_fid;
static jfieldID rep_stat_st_bulk_fills_fid;
static jfieldID rep_stat_st_bulk_overflows_fid;
static jfieldID rep_stat_st_bulk_records_fid;
static jfieldID rep_stat_st_bulk_transfers_fid;
static jfieldID rep_stat_st_client_rerequests_fid;
static jfieldID rep_stat_st_client_svc_req_fid;
static jfieldID rep_stat_st_client_svc_miss_fid;
static jfieldID rep_stat_st_gen_fid;
static jfieldID rep_stat_st_egen_fid;
static jfieldID rep_stat_st_lease_chk_fid;
static jfieldID rep_stat_st_lease_chk_misses_fid;
static jfieldID rep_stat_st_lease_chk_refresh_fid;
static jfieldID rep_stat_st_lease_sends_fid;
static jfieldID rep_stat_st_log_duplicated_fid;
static jfieldID rep_stat_st_log_queued_max_fid;
static jfieldID rep_stat_st_log_queued_total_fid;
static jfieldID rep_stat_st_log_records_fid;
static jfieldID rep_stat_st_log_requested_fid;
static jfieldID rep_stat_st_master_fid;
static jfieldID rep_stat_st_master_changes_fid;
static jfieldID rep_stat_st_msgs_badgen_fid;
static jfieldID rep_stat_st_msgs_processed_fid;
static jfieldID rep_stat_st_msgs_recover_fid;
static jfieldID rep_stat_st_msgs_send_failures_fid;
static jfieldID rep_stat_st_msgs_sent_fid;
static jfieldID rep_stat_st_newsites_fid;
static jfieldID rep_stat_st_nsites_fid;
static jfieldID rep_stat_st_nthrottles_fid;
static jfieldID rep_stat_st_outdated_fid;
static jfieldID rep_stat_st_pg_duplicated_fid;
static jfieldID rep_stat_st_pg_records_fid;
static jfieldID rep_stat_st_pg_requested_fid;
static jfieldID rep_stat_st_txns_applied_fid;
static jfieldID rep_stat_st_startsync_delayed_fid;
static jfieldID rep_stat_st_elections_fid;
static jfieldID rep_stat_st_elections_won_fid;
static jfieldID rep_stat_st_election_cur_winner_fid;
static jfieldID rep_stat_st_election_gen_fid;
static jfieldID rep_stat_st_election_datagen_fid;
static jfieldID rep_stat_st_election_lsn_fid;
static jfieldID rep_stat_st_election_nsites_fid;
static jfieldID rep_stat_st_election_nvotes_fid;
static jfieldID rep_stat_st_election_priority_fid;
static jfieldID rep_stat_st_election_status_fid;
static jfieldID rep_stat_st_election_tiebreaker_fid;
static jfieldID rep_stat_st_election_votes_fid;
static jfieldID rep_stat_st_election_sec_fid;
static jfieldID rep_stat_st_election_usec_fid;
static jfieldID rep_stat_st_max_lease_sec_fid;
static jfieldID rep_stat_st_max_lease_usec_fid;
static jfieldID repmgr_stat_st_perm_failed_fid;
static jfieldID repmgr_stat_st_msgs_queued_fid;
static jfieldID repmgr_stat_st_msgs_dropped_fid;
static jfieldID repmgr_stat_st_incoming_queue_gbytes_fid;
static jfieldID repmgr_stat_st_incoming_queue_bytes_fid;
static jfieldID repmgr_stat_st_incoming_msgs_dropped_fid;
static jfieldID repmgr_stat_st_connection_drop_fid;
static jfieldID repmgr_stat_st_connect_fail_fid;
static jfieldID repmgr_stat_st_elect_threads_fid;
static jfieldID repmgr_stat_st_max_elect_threads_fid;
static jfieldID repmgr_stat_st_site_participants_fid;
static jfieldID repmgr_stat_st_site_total_fid;
static jfieldID repmgr_stat_st_site_views_fid;
static jfieldID repmgr_stat_st_takeovers_fid;
static jfieldID repmgr_stat_st_write_ops_forwarded_fid;
static jfieldID repmgr_stat_st_write_ops_received_fid;
static jfieldID seq_stat_st_wait_fid;
static jfieldID seq_stat_st_nowait_fid;
static jfieldID seq_stat_st_current_fid;
static jfieldID seq_stat_st_value_fid;
static jfieldID seq_stat_st_last_value_fid;
static jfieldID seq_stat_st_min_fid;
static jfieldID seq_stat_st_max_fid;
static jfieldID seq_stat_st_cache_size_fid;
static jfieldID seq_stat_st_flags_fid;
static jfieldID txn_stat_st_nrestores_fid;
static jfieldID txn_stat_st_last_ckp_fid;
static jfieldID txn_stat_st_time_ckp_fid;
static jfieldID txn_stat_st_last_txnid_fid;
static jfieldID txn_stat_st_inittxns_fid;
static jfieldID txn_stat_st_maxtxns_fid;
static jfieldID txn_stat_st_naborts_fid;
static jfieldID txn_stat_st_nbegins_fid;
static jfieldID txn_stat_st_ncommits_fid;
static jfieldID txn_stat_st_nactive_fid;
static jfieldID txn_stat_st_nsnapshot_fid;
static jfieldID txn_stat_st_maxnactive_fid;
static jfieldID txn_stat_st_maxnsnapshot_fid;
static jfieldID txn_stat_st_region_wait_fid;
static jfieldID txn_stat_st_region_nowait_fid;
static jfieldID txn_stat_st_regsize_fid;
static jfieldID txn_stat_st_txnarray_fid;
static jfieldID txn_active_txnid_fid;
static jfieldID txn_active_parentid_fid;
static jfieldID txn_active_pid_fid;
static jfieldID txn_active_lsn_fid;
static jfieldID txn_active_read_lsn_fid;
static jfieldID txn_active_mvcc_ref_fid;
static jfieldID txn_active_priority_fid;
static jfieldID txn_active_gid_fid;
static jfieldID txn_active_name_fid;
static jfieldID txn_active_slice_txns_fid;
/* END-STAT-FIELD-DECLS */

static jmethodID db_construct, dbenv_construct, dbt_construct, dblsn_construct;
static jmethodID dbpreplist_construct, dbtxn_construct;
static jmethodID bt_stat_construct, get_err_msg_method, h_stat_construct;
static jmethodID heap_stat_construct, lock_stat_construct, log_stat_construct;
static jmethodID mpool_stat_construct, mpool_fstat_construct;
static jmethodID mutex_stat_construct, qam_stat_construct;
static jmethodID rep_stat_construct, repmgr_stat_construct, seq_stat_construct;
static jmethodID txn_stat_construct, txn_active_construct;
static jmethodID dbex_construct, deadex_construct, lockex_construct;
static jmethodID heapfullex_construct, memex_construct, memex_update_method;
static jmethodID metachkfailex_construct, repdupmasterex_construct;
static jmethodID rephandledeadex_construct;
static jmethodID repholdelectionex_construct, repjoinfailex_construct;
static jmethodID repmgr_siteinfo_construct, rephost_construct, repleaseexpiredex_construct;
static jmethodID replockoutex_construct;
static jmethodID repunavailex_construct;
static jmethodID runrecex_construct, sliceex_construct, versionex_construct;
static jmethodID filenotfoundex_construct, illegalargex_construct;
static jmethodID outofmemerr_construct;
static jmethodID lock_construct;

static jmethodID app_dispatch_method, errcall_method, env_feedback_method;
static jmethodID msgcall_method, paniccall_method, rep_transport_method;
static jmethodID panic_event_notify_method;
static jmethodID rep_autotakeover_failed_event_notify_method;
static jmethodID rep_client_event_notify_method;
static jmethodID rep_connect_broken_event_notify_method;
static jmethodID rep_connect_established_event_notify_method;
static jmethodID rep_connect_try_failed_event_notify_method;
static jmethodID rep_dupmaster_event_notify_method;
static jmethodID rep_elected_event_notify_method;
static jmethodID rep_election_failed_event_notify_method;
static jmethodID rep_init_done_event_notify_method;
static jmethodID rep_inqueue_full_event_notify_method;
static jmethodID rep_join_failure_event_notify_method;
static jmethodID rep_local_site_removed_notify_method;
static jmethodID rep_master_event_notify_method;
static jmethodID rep_master_failure_event_notify_method;
static jmethodID rep_new_master_event_notify_method;
static jmethodID rep_perm_failed_event_notify_method;
static jmethodID rep_site_added_event_notify_method;
static jmethodID rep_site_removed_event_notify_method;
static jmethodID rep_startup_done_event_notify_method;
static jmethodID repmgr_msg_dispatch_method;
static jmethodID write_failed_event_notify_method;

static jmethodID append_recno_method, backup_close_method, backup_open_method;
static jmethodID backup_write_method, bt_compare_method, bt_compress_method;
static jmethodID bt_decompress_method, bt_prefix_method;
static jmethodID db_feedback_method, dup_compare_method;
static jmethodID foreignkey_nullify_method, h_compare_method, h_hash_method;
static jmethodID rep_view_method, partition_method, seckey_create_method;
static jmethodID slice_method;

static jmethodID outputstream_write_method;

const struct {
	jclass *cl;
	const char *name;
} all_classes[] = {
	{ &dbenv_class, DB_PKG "internal/DbEnv" },
	{ &db_class, DB_PKG "internal/Db" },
	{ &dbc_class, DB_PKG "internal/Dbc" },
	{ &dbt_class, DB_PKG "DatabaseEntry" },
	{ &dblsn_class, DB_PKG "LogSequenceNumber" },
	{ &dbpreplist_class, DB_PKG "PreparedTransaction" },
	{ &dbstream_class, DB_PKG "internal/DbStream" },
	{ &dbtxn_class, DB_PKG "internal/DbTxn" },

	{ &bt_stat_class, DB_PKG "BtreeStats" },
	{ &compact_class, DB_PKG "CompactStats" },
	{ &h_stat_class, DB_PKG "HashStats" },
	{ &heap_stat_class, DB_PKG "HeapStats" },
	{ &lock_stat_class, DB_PKG "LockStats" },
	{ &log_stat_class, DB_PKG "LogStats" },
	{ &mpool_fstat_class, DB_PKG "CacheFileStats" },
	{ &mpool_stat_class, DB_PKG "CacheStats" },
	{ &mutex_stat_class, DB_PKG "MutexStats" },
	{ &qam_stat_class, DB_PKG "QueueStats" },
	{ &rep_stat_class, DB_PKG "ReplicationStats" },
	{ &repmgr_stat_class, DB_PKG "ReplicationManagerStats" },
	{ &seq_stat_class, DB_PKG "SequenceStats" },
	{ &txn_stat_class, DB_PKG "TransactionStats" },
	{ &txn_active_class, DB_PKG "TransactionStats$Active" },

	{ &keyrange_class, DB_PKG "KeyRange" },
	{ &lock_class, DB_PKG "internal/DbLock" },
	{ &lockreq_class, DB_PKG "LockRequest" },

	{ &dbex_class, DB_PKG "DatabaseException" },
	{ &deadex_class, DB_PKG "DeadlockException" },
	{ &heapfullex_class, DB_PKG "HeapFullException" },
	{ &lockex_class, DB_PKG "LockNotGrantedException" },
	{ &memex_class, DB_PKG "MemoryException" },
	{ &metachkfailex_class, DB_PKG "MetaCheckSumFailException" },
	{ &repdupmasterex_class, DB_PKG "ReplicationDuplicateMasterException" },
	{ &rephandledeadex_class, DB_PKG "ReplicationHandleDeadException" },
	{ &repholdelectionex_class, DB_PKG "ReplicationHoldElectionException" },
	{ &rephost_class, DB_PKG "ReplicationHostAddress" },
	{ &repmgr_siteinfo_class, DB_PKG "ReplicationManagerSiteInfo" },
	{ &repjoinfailex_class, DB_PKG "ReplicationJoinFailureException" },
	{ &repleaseexpiredex_class, DB_PKG "ReplicationLeaseExpiredException" },
	{ &replockoutex_class, DB_PKG "ReplicationLockoutException" },
	{ &repunavailex_class, DB_PKG "ReplicationSiteUnavailableException" },
	{ &runrecex_class, DB_PKG "RunRecoveryException" },
	{ &sliceex_class, DB_PKG "SliceCorruptException" },
	{ &versionex_class, DB_PKG "VersionMismatchException" },
	{ &filenotfoundex_class, "java/io/FileNotFoundException" },
	{ &illegalargex_class, "java/lang/IllegalArgumentException" },
	{ &outofmemerr_class, "java/lang/OutOfMemoryError" },

	{ &bytearray_class, "[B" },
	{ &string_class, "java/lang/String" },
	{ &outputstream_class, "java/io/OutputStream" }
};

const struct {
	jfieldID *fid;
	jclass *cl;
	const char *name;
	const char *sig;
} all_fields[] = {
 	{ &db_cptr_fid, &db_class, "swigCPtr", "J" },
	{ &dbc_cptr_fid, &dbc_class, "swigCPtr", "J" },
 	{ &dbenv_cptr_fid, &dbenv_class, "swigCPtr", "J" },

	{ &dblsn_file_fid, &dblsn_class, "file", "I" },
	{ &dblsn_offset_fid, &dblsn_class, "offset", "I" },

	{ &dbstream_cptr_fid, &dbstream_class, "swigCPtr", "J" },

	{ &dbt_data_fid, &dbt_class, "data", "[B" },
	{ &dbt_data_nio_fid, &dbt_class, "data_nio", "Ljava/nio/ByteBuffer;" },
	{ &dbt_size_fid, &dbt_class, "size", "I" },
	{ &dbt_ulen_fid, &dbt_class, "ulen", "I" },
	{ &dbt_dlen_fid, &dbt_class, "dlen", "I" },
	{ &dbt_doff_fid, &dbt_class, "doff", "I" },
	{ &dbt_flags_fid, &dbt_class, "flags", "I" },
	{ &dbt_offset_fid, &dbt_class, "offset", "I" },

	{ &kr_less_fid, &keyrange_class, "less", "D" },
	{ &kr_equal_fid, &keyrange_class, "equal", "D" },
	{ &kr_greater_fid, &keyrange_class, "greater", "D" },

	{ &lock_cptr_fid, &lock_class, "swigCPtr", "J" },

	{ &lockreq_op_fid, &lockreq_class, "op", "I" },
	{ &lockreq_modeflag_fid, &lockreq_class, "modeFlag", "I" },
	{ &lockreq_timeout_fid, &lockreq_class, "timeout", "I" },
	{ &lockreq_obj_fid, &lockreq_class, "obj",
	    "L" DB_PKG "DatabaseEntry;" },
	{ &lockreq_lock_fid, &lockreq_class, "lock",
	    "L" DB_PKG "internal/DbLock;" },
       { &txn_commit_token, &dbtxn_class, "commitToken", "[B" },

/* BEGIN-STAT-FIELDS */
	{ &bt_stat_bt_magic_fid, &bt_stat_class, "bt_magic", "I" },
	{ &bt_stat_bt_version_fid, &bt_stat_class, "bt_version", "I" },
	{ &bt_stat_bt_metaflags_fid, &bt_stat_class, "bt_metaflags", "I" },
	{ &bt_stat_bt_nkeys_fid, &bt_stat_class, "bt_nkeys", "I" },
	{ &bt_stat_bt_ndata_fid, &bt_stat_class, "bt_ndata", "I" },
	{ &bt_stat_bt_pagecnt_fid, &bt_stat_class, "bt_pagecnt", "I" },
	{ &bt_stat_bt_pagesize_fid, &bt_stat_class, "bt_pagesize", "I" },
	{ &bt_stat_bt_minkey_fid, &bt_stat_class, "bt_minkey", "I" },
	{ &bt_stat_bt_ext_files_fid, &bt_stat_class, "bt_ext_files", "I" },
	{ &bt_stat_bt_nblobs_fid, &bt_stat_class, "bt_nblobs", "I" },
	{ &bt_stat_bt_re_len_fid, &bt_stat_class, "bt_re_len", "I" },
	{ &bt_stat_bt_re_pad_fid, &bt_stat_class, "bt_re_pad", "I" },
	{ &bt_stat_bt_levels_fid, &bt_stat_class, "bt_levels", "I" },
	{ &bt_stat_bt_int_pg_fid, &bt_stat_class, "bt_int_pg", "I" },
	{ &bt_stat_bt_leaf_pg_fid, &bt_stat_class, "bt_leaf_pg", "I" },
	{ &bt_stat_bt_dup_pg_fid, &bt_stat_class, "bt_dup_pg", "I" },
	{ &bt_stat_bt_over_pg_fid, &bt_stat_class, "bt_over_pg", "I" },
	{ &bt_stat_bt_empty_pg_fid, &bt_stat_class, "bt_empty_pg", "I" },
	{ &bt_stat_bt_free_fid, &bt_stat_class, "bt_free", "I" },
	{ &bt_stat_bt_int_pgfree_fid, &bt_stat_class, "bt_int_pgfree", "J" },
	{ &bt_stat_bt_leaf_pgfree_fid, &bt_stat_class, "bt_leaf_pgfree", "J" },
	{ &bt_stat_bt_dup_pgfree_fid, &bt_stat_class, "bt_dup_pgfree", "J" },
	{ &bt_stat_bt_over_pgfree_fid, &bt_stat_class, "bt_over_pgfree", "J" },
	{ &compact_compact_fillpercent_fid, &compact_class, "compact_fillpercent", "I" },
	{ &compact_compact_timeout_fid, &compact_class, "compact_timeout", "I" },
	{ &compact_compact_pages_fid, &compact_class, "compact_pages", "I" },
	{ &compact_compact_empty_buckets_fid, &compact_class, "compact_empty_buckets", "I" },
	{ &compact_compact_pages_free_fid, &compact_class, "compact_pages_free", "I" },
	{ &compact_compact_pages_examine_fid, &compact_class, "compact_pages_examine", "I" },
	{ &compact_compact_levels_fid, &compact_class, "compact_levels", "I" },
	{ &compact_compact_deadlock_fid, &compact_class, "compact_deadlock", "I" },
	{ &compact_compact_pages_truncated_fid, &compact_class, "compact_pages_truncated", "I" },
	{ &compact_compact_truncate_fid, &compact_class, "compact_truncate", "I" },
	{ &h_stat_hash_magic_fid, &h_stat_class, "hash_magic", "I" },
	{ &h_stat_hash_version_fid, &h_stat_class, "hash_version", "I" },
	{ &h_stat_hash_metaflags_fid, &h_stat_class, "hash_metaflags", "I" },
	{ &h_stat_hash_nkeys_fid, &h_stat_class, "hash_nkeys", "I" },
	{ &h_stat_hash_ndata_fid, &h_stat_class, "hash_ndata", "I" },
	{ &h_stat_hash_ext_files_fid, &h_stat_class, "hash_ext_files", "I" },
	{ &h_stat_hash_nblobs_fid, &h_stat_class, "hash_nblobs", "I" },
	{ &h_stat_hash_pagecnt_fid, &h_stat_class, "hash_pagecnt", "I" },
	{ &h_stat_hash_pagesize_fid, &h_stat_class, "hash_pagesize", "I" },
	{ &h_stat_hash_ffactor_fid, &h_stat_class, "hash_ffactor", "I" },
	{ &h_stat_hash_buckets_fid, &h_stat_class, "hash_buckets", "I" },
	{ &h_stat_hash_free_fid, &h_stat_class, "hash_free", "I" },
	{ &h_stat_hash_bfree_fid, &h_stat_class, "hash_bfree", "J" },
	{ &h_stat_hash_bigpages_fid, &h_stat_class, "hash_bigpages", "I" },
	{ &h_stat_hash_big_bfree_fid, &h_stat_class, "hash_big_bfree", "J" },
	{ &h_stat_hash_overflows_fid, &h_stat_class, "hash_overflows", "I" },
	{ &h_stat_hash_ovfl_free_fid, &h_stat_class, "hash_ovfl_free", "J" },
	{ &h_stat_hash_dup_fid, &h_stat_class, "hash_dup", "I" },
	{ &h_stat_hash_dup_free_fid, &h_stat_class, "hash_dup_free", "J" },
	{ &heap_stat_heap_magic_fid, &heap_stat_class, "heap_magic", "I" },
	{ &heap_stat_heap_version_fid, &heap_stat_class, "heap_version", "I" },
	{ &heap_stat_heap_metaflags_fid, &heap_stat_class, "heap_metaflags", "I" },
	{ &heap_stat_heap_ext_files_fid, &heap_stat_class, "heap_ext_files", "I" },
	{ &heap_stat_heap_nblobs_fid, &heap_stat_class, "heap_nblobs", "I" },
	{ &heap_stat_heap_nrecs_fid, &heap_stat_class, "heap_nrecs", "I" },
	{ &heap_stat_heap_pagecnt_fid, &heap_stat_class, "heap_pagecnt", "I" },
	{ &heap_stat_heap_pagesize_fid, &heap_stat_class, "heap_pagesize", "I" },
	{ &heap_stat_heap_nregions_fid, &heap_stat_class, "heap_nregions", "I" },
	{ &heap_stat_heap_regionsize_fid, &heap_stat_class, "heap_regionsize", "I" },
	{ &lock_stat_st_id_fid, &lock_stat_class, "st_id", "I" },
	{ &lock_stat_st_cur_maxid_fid, &lock_stat_class, "st_cur_maxid", "I" },
	{ &lock_stat_st_initlocks_fid, &lock_stat_class, "st_initlocks", "I" },
	{ &lock_stat_st_initlockers_fid, &lock_stat_class, "st_initlockers", "I" },
	{ &lock_stat_st_initobjects_fid, &lock_stat_class, "st_initobjects", "I" },
	{ &lock_stat_st_locks_fid, &lock_stat_class, "st_locks", "I" },
	{ &lock_stat_st_lockers_fid, &lock_stat_class, "st_lockers", "I" },
	{ &lock_stat_st_objects_fid, &lock_stat_class, "st_objects", "I" },
	{ &lock_stat_st_maxlocks_fid, &lock_stat_class, "st_maxlocks", "I" },
	{ &lock_stat_st_maxlockers_fid, &lock_stat_class, "st_maxlockers", "I" },
	{ &lock_stat_st_maxobjects_fid, &lock_stat_class, "st_maxobjects", "I" },
	{ &lock_stat_st_partitions_fid, &lock_stat_class, "st_partitions", "I" },
	{ &lock_stat_st_tablesize_fid, &lock_stat_class, "st_tablesize", "I" },
	{ &lock_stat_st_nmodes_fid, &lock_stat_class, "st_nmodes", "I" },
	{ &lock_stat_st_nlockers_fid, &lock_stat_class, "st_nlockers", "I" },
	{ &lock_stat_st_nlocks_fid, &lock_stat_class, "st_nlocks", "I" },
	{ &lock_stat_st_maxnlocks_fid, &lock_stat_class, "st_maxnlocks", "I" },
	{ &lock_stat_st_maxhlocks_fid, &lock_stat_class, "st_maxhlocks", "I" },
	{ &lock_stat_st_locksteals_fid, &lock_stat_class, "st_locksteals", "J" },
	{ &lock_stat_st_maxlsteals_fid, &lock_stat_class, "st_maxlsteals", "J" },
	{ &lock_stat_st_maxnlockers_fid, &lock_stat_class, "st_maxnlockers", "I" },
	{ &lock_stat_st_nobjects_fid, &lock_stat_class, "st_nobjects", "I" },
	{ &lock_stat_st_maxnobjects_fid, &lock_stat_class, "st_maxnobjects", "I" },
	{ &lock_stat_st_maxhobjects_fid, &lock_stat_class, "st_maxhobjects", "I" },
	{ &lock_stat_st_objectsteals_fid, &lock_stat_class, "st_objectsteals", "J" },
	{ &lock_stat_st_maxosteals_fid, &lock_stat_class, "st_maxosteals", "J" },
	{ &lock_stat_st_nrequests_fid, &lock_stat_class, "st_nrequests", "J" },
	{ &lock_stat_st_nreleases_fid, &lock_stat_class, "st_nreleases", "J" },
	{ &lock_stat_st_nupgrade_fid, &lock_stat_class, "st_nupgrade", "J" },
	{ &lock_stat_st_ndowngrade_fid, &lock_stat_class, "st_ndowngrade", "J" },
	{ &lock_stat_st_lock_wait_fid, &lock_stat_class, "st_lock_wait", "J" },
	{ &lock_stat_st_lock_nowait_fid, &lock_stat_class, "st_lock_nowait", "J" },
	{ &lock_stat_st_ndeadlocks_fid, &lock_stat_class, "st_ndeadlocks", "J" },
	{ &lock_stat_st_locktimeout_fid, &lock_stat_class, "st_locktimeout", "I" },
	{ &lock_stat_st_nlocktimeouts_fid, &lock_stat_class, "st_nlocktimeouts", "J" },
	{ &lock_stat_st_txntimeout_fid, &lock_stat_class, "st_txntimeout", "I" },
	{ &lock_stat_st_ntxntimeouts_fid, &lock_stat_class, "st_ntxntimeouts", "J" },
	{ &lock_stat_st_part_wait_fid, &lock_stat_class, "st_part_wait", "J" },
	{ &lock_stat_st_part_nowait_fid, &lock_stat_class, "st_part_nowait", "J" },
	{ &lock_stat_st_part_max_wait_fid, &lock_stat_class, "st_part_max_wait", "J" },
	{ &lock_stat_st_part_max_nowait_fid, &lock_stat_class, "st_part_max_nowait", "J" },
	{ &lock_stat_st_objs_wait_fid, &lock_stat_class, "st_objs_wait", "J" },
	{ &lock_stat_st_objs_nowait_fid, &lock_stat_class, "st_objs_nowait", "J" },
	{ &lock_stat_st_lockers_wait_fid, &lock_stat_class, "st_lockers_wait", "J" },
	{ &lock_stat_st_lockers_nowait_fid, &lock_stat_class, "st_lockers_nowait", "J" },
	{ &lock_stat_st_region_wait_fid, &lock_stat_class, "st_region_wait", "J" },
	{ &lock_stat_st_region_nowait_fid, &lock_stat_class, "st_region_nowait", "J" },
	{ &lock_stat_st_nlockers_hit_fid, &lock_stat_class, "st_nlockers_hit", "J" },
	{ &lock_stat_st_nlockers_reused_fid, &lock_stat_class, "st_nlockers_reused", "J" },
	{ &lock_stat_st_hash_len_fid, &lock_stat_class, "st_hash_len", "I" },
	{ &lock_stat_st_regsize_fid, &lock_stat_class, "st_regsize", "J" },
	{ &log_stat_st_magic_fid, &log_stat_class, "st_magic", "I" },
	{ &log_stat_st_version_fid, &log_stat_class, "st_version", "I" },
	{ &log_stat_st_mode_fid, &log_stat_class, "st_mode", "I" },
	{ &log_stat_st_lg_bsize_fid, &log_stat_class, "st_lg_bsize", "I" },
	{ &log_stat_st_lg_size_fid, &log_stat_class, "st_lg_size", "I" },
	{ &log_stat_st_wc_bytes_fid, &log_stat_class, "st_wc_bytes", "I" },
	{ &log_stat_st_wc_mbytes_fid, &log_stat_class, "st_wc_mbytes", "I" },
	{ &log_stat_st_fileid_init_fid, &log_stat_class, "st_fileid_init", "I" },
	{ &log_stat_st_nfileid_fid, &log_stat_class, "st_nfileid", "I" },
	{ &log_stat_st_maxnfileid_fid, &log_stat_class, "st_maxnfileid", "I" },
	{ &log_stat_st_record_fid, &log_stat_class, "st_record", "J" },
	{ &log_stat_st_w_bytes_fid, &log_stat_class, "st_w_bytes", "I" },
	{ &log_stat_st_w_mbytes_fid, &log_stat_class, "st_w_mbytes", "I" },
	{ &log_stat_st_wcount_fid, &log_stat_class, "st_wcount", "J" },
	{ &log_stat_st_wcount_fill_fid, &log_stat_class, "st_wcount_fill", "J" },
	{ &log_stat_st_rcount_fid, &log_stat_class, "st_rcount", "J" },
	{ &log_stat_st_scount_fid, &log_stat_class, "st_scount", "J" },
	{ &log_stat_st_region_wait_fid, &log_stat_class, "st_region_wait", "J" },
	{ &log_stat_st_region_nowait_fid, &log_stat_class, "st_region_nowait", "J" },
	{ &log_stat_st_cur_file_fid, &log_stat_class, "st_cur_file", "I" },
	{ &log_stat_st_cur_offset_fid, &log_stat_class, "st_cur_offset", "I" },
	{ &log_stat_st_disk_file_fid, &log_stat_class, "st_disk_file", "I" },
	{ &log_stat_st_disk_offset_fid, &log_stat_class, "st_disk_offset", "I" },
	{ &log_stat_st_maxcommitperflush_fid, &log_stat_class, "st_maxcommitperflush", "I" },
	{ &log_stat_st_mincommitperflush_fid, &log_stat_class, "st_mincommitperflush", "I" },
	{ &log_stat_st_regsize_fid, &log_stat_class, "st_regsize", "J" },
	{ &mpool_fstat_st_pagesize_fid, &mpool_fstat_class, "st_pagesize", "I" },
	{ &mpool_fstat_st_map_fid, &mpool_fstat_class, "st_map", "I" },
	{ &mpool_fstat_st_cache_hit_fid, &mpool_fstat_class, "st_cache_hit", "J" },
	{ &mpool_fstat_st_cache_miss_fid, &mpool_fstat_class, "st_cache_miss", "J" },
	{ &mpool_fstat_st_page_create_fid, &mpool_fstat_class, "st_page_create", "J" },
	{ &mpool_fstat_st_page_in_fid, &mpool_fstat_class, "st_page_in", "J" },
	{ &mpool_fstat_st_page_out_fid, &mpool_fstat_class, "st_page_out", "J" },
	{ &mpool_fstat_st_backup_spins_fid, &mpool_fstat_class, "st_backup_spins", "J" },
	{ &mpool_fstat_file_name_fid, &mpool_fstat_class, "file_name", "Ljava/lang/String;" },
	{ &mpool_stat_st_gbytes_fid, &mpool_stat_class, "st_gbytes", "I" },
	{ &mpool_stat_st_bytes_fid, &mpool_stat_class, "st_bytes", "I" },
	{ &mpool_stat_st_ncache_fid, &mpool_stat_class, "st_ncache", "I" },
	{ &mpool_stat_st_max_ncache_fid, &mpool_stat_class, "st_max_ncache", "I" },
	{ &mpool_stat_st_mmapsize_fid, &mpool_stat_class, "st_mmapsize", "J" },
	{ &mpool_stat_st_maxopenfd_fid, &mpool_stat_class, "st_maxopenfd", "I" },
	{ &mpool_stat_st_maxwrite_fid, &mpool_stat_class, "st_maxwrite", "I" },
	{ &mpool_stat_st_maxwrite_sleep_fid, &mpool_stat_class, "st_maxwrite_sleep", "I" },
	{ &mpool_stat_st_pages_fid, &mpool_stat_class, "st_pages", "I" },
	{ &mpool_stat_st_map_fid, &mpool_stat_class, "st_map", "I" },
	{ &mpool_stat_st_cache_hit_fid, &mpool_stat_class, "st_cache_hit", "J" },
	{ &mpool_stat_st_cache_miss_fid, &mpool_stat_class, "st_cache_miss", "J" },
	{ &mpool_stat_st_page_create_fid, &mpool_stat_class, "st_page_create", "J" },
	{ &mpool_stat_st_page_in_fid, &mpool_stat_class, "st_page_in", "J" },
	{ &mpool_stat_st_page_out_fid, &mpool_stat_class, "st_page_out", "J" },
	{ &mpool_stat_st_ro_evict_fid, &mpool_stat_class, "st_ro_evict", "J" },
	{ &mpool_stat_st_rw_evict_fid, &mpool_stat_class, "st_rw_evict", "J" },
	{ &mpool_stat_st_page_trickle_fid, &mpool_stat_class, "st_page_trickle", "J" },
	{ &mpool_stat_st_page_clean_fid, &mpool_stat_class, "st_page_clean", "I" },
	{ &mpool_stat_st_page_dirty_fid, &mpool_stat_class, "st_page_dirty", "I" },
	{ &mpool_stat_st_hash_buckets_fid, &mpool_stat_class, "st_hash_buckets", "I" },
	{ &mpool_stat_st_hash_mutexes_fid, &mpool_stat_class, "st_hash_mutexes", "I" },
	{ &mpool_stat_st_pagesize_fid, &mpool_stat_class, "st_pagesize", "I" },
	{ &mpool_stat_st_hash_searches_fid, &mpool_stat_class, "st_hash_searches", "I" },
	{ &mpool_stat_st_hash_longest_fid, &mpool_stat_class, "st_hash_longest", "I" },
	{ &mpool_stat_st_hash_examined_fid, &mpool_stat_class, "st_hash_examined", "J" },
	{ &mpool_stat_st_hash_nowait_fid, &mpool_stat_class, "st_hash_nowait", "J" },
	{ &mpool_stat_st_hash_wait_fid, &mpool_stat_class, "st_hash_wait", "J" },
	{ &mpool_stat_st_hash_max_nowait_fid, &mpool_stat_class, "st_hash_max_nowait", "J" },
	{ &mpool_stat_st_hash_max_wait_fid, &mpool_stat_class, "st_hash_max_wait", "J" },
	{ &mpool_stat_st_region_nowait_fid, &mpool_stat_class, "st_region_nowait", "J" },
	{ &mpool_stat_st_region_wait_fid, &mpool_stat_class, "st_region_wait", "J" },
	{ &mpool_stat_st_mvcc_frozen_fid, &mpool_stat_class, "st_mvcc_frozen", "J" },
	{ &mpool_stat_st_mvcc_thawed_fid, &mpool_stat_class, "st_mvcc_thawed", "J" },
	{ &mpool_stat_st_mvcc_freed_fid, &mpool_stat_class, "st_mvcc_freed", "J" },
	{ &mpool_stat_st_mvcc_reused_fid, &mpool_stat_class, "st_mvcc_reused", "J" },
	{ &mpool_stat_st_alloc_fid, &mpool_stat_class, "st_alloc", "J" },
	{ &mpool_stat_st_alloc_buckets_fid, &mpool_stat_class, "st_alloc_buckets", "J" },
	{ &mpool_stat_st_alloc_max_buckets_fid, &mpool_stat_class, "st_alloc_max_buckets", "J" },
	{ &mpool_stat_st_alloc_pages_fid, &mpool_stat_class, "st_alloc_pages", "J" },
	{ &mpool_stat_st_alloc_max_pages_fid, &mpool_stat_class, "st_alloc_max_pages", "J" },
	{ &mpool_stat_st_io_wait_fid, &mpool_stat_class, "st_io_wait", "J" },
	{ &mpool_stat_st_sync_interrupted_fid, &mpool_stat_class, "st_sync_interrupted", "J" },
	{ &mpool_stat_st_oddfsize_detect_fid, &mpool_stat_class, "st_oddfsize_detect", "I" },
	{ &mpool_stat_st_oddfsize_resolve_fid, &mpool_stat_class, "st_oddfsize_resolve", "I" },
	{ &mpool_stat_st_regsize_fid, &mpool_stat_class, "st_regsize", "J" },
	{ &mpool_stat_st_regmax_fid, &mpool_stat_class, "st_regmax", "J" },
	{ &mutex_stat_st_mutex_align_fid, &mutex_stat_class, "st_mutex_align", "I" },
	{ &mutex_stat_st_mutex_tas_spins_fid, &mutex_stat_class, "st_mutex_tas_spins", "I" },
	{ &mutex_stat_st_mutex_init_fid, &mutex_stat_class, "st_mutex_init", "I" },
	{ &mutex_stat_st_mutex_cnt_fid, &mutex_stat_class, "st_mutex_cnt", "I" },
	{ &mutex_stat_st_mutex_max_fid, &mutex_stat_class, "st_mutex_max", "I" },
	{ &mutex_stat_st_mutex_free_fid, &mutex_stat_class, "st_mutex_free", "I" },
	{ &mutex_stat_st_mutex_inuse_fid, &mutex_stat_class, "st_mutex_inuse", "I" },
	{ &mutex_stat_st_mutex_inuse_max_fid, &mutex_stat_class, "st_mutex_inuse_max", "I" },
	{ &mutex_stat_st_region_wait_fid, &mutex_stat_class, "st_region_wait", "J" },
	{ &mutex_stat_st_region_nowait_fid, &mutex_stat_class, "st_region_nowait", "J" },
	{ &mutex_stat_st_regsize_fid, &mutex_stat_class, "st_regsize", "J" },
	{ &mutex_stat_st_regmax_fid, &mutex_stat_class, "st_regmax", "J" },
	{ &qam_stat_qs_magic_fid, &qam_stat_class, "qs_magic", "I" },
	{ &qam_stat_qs_version_fid, &qam_stat_class, "qs_version", "I" },
	{ &qam_stat_qs_metaflags_fid, &qam_stat_class, "qs_metaflags", "I" },
	{ &qam_stat_qs_nkeys_fid, &qam_stat_class, "qs_nkeys", "I" },
	{ &qam_stat_qs_ndata_fid, &qam_stat_class, "qs_ndata", "I" },
	{ &qam_stat_qs_pagesize_fid, &qam_stat_class, "qs_pagesize", "I" },
	{ &qam_stat_qs_extentsize_fid, &qam_stat_class, "qs_extentsize", "I" },
	{ &qam_stat_qs_pages_fid, &qam_stat_class, "qs_pages", "I" },
	{ &qam_stat_qs_re_len_fid, &qam_stat_class, "qs_re_len", "I" },
	{ &qam_stat_qs_re_pad_fid, &qam_stat_class, "qs_re_pad", "I" },
	{ &qam_stat_qs_pgfree_fid, &qam_stat_class, "qs_pgfree", "I" },
	{ &qam_stat_qs_first_recno_fid, &qam_stat_class, "qs_first_recno", "I" },
	{ &qam_stat_qs_cur_recno_fid, &qam_stat_class, "qs_cur_recno", "I" },
	{ &rep_stat_st_startup_complete_fid, &rep_stat_class, "st_startup_complete", "I" },
	{ &rep_stat_st_view_fid, &rep_stat_class, "st_view", "I" },
	{ &rep_stat_st_log_queued_fid, &rep_stat_class, "st_log_queued", "J" },
	{ &rep_stat_st_status_fid, &rep_stat_class, "st_status", "I" },
	{ &rep_stat_st_next_lsn_fid, &rep_stat_class, "st_next_lsn", "L" DB_PKG "LogSequenceNumber;" },
	{ &rep_stat_st_waiting_lsn_fid, &rep_stat_class, "st_waiting_lsn", "L" DB_PKG "LogSequenceNumber;" },
	{ &rep_stat_st_max_perm_lsn_fid, &rep_stat_class, "st_max_perm_lsn", "L" DB_PKG "LogSequenceNumber;" },
	{ &rep_stat_st_next_pg_fid, &rep_stat_class, "st_next_pg", "I" },
	{ &rep_stat_st_waiting_pg_fid, &rep_stat_class, "st_waiting_pg", "I" },
	{ &rep_stat_st_dupmasters_fid, &rep_stat_class, "st_dupmasters", "I" },
	{ &rep_stat_st_env_id_fid, &rep_stat_class, "st_env_id", "J" },
	{ &rep_stat_st_env_priority_fid, &rep_stat_class, "st_env_priority", "I" },
	{ &rep_stat_st_ext_duplicated_fid, &rep_stat_class, "st_ext_duplicated", "J" },
	{ &rep_stat_st_ext_records_fid, &rep_stat_class, "st_ext_records", "J" },
	{ &rep_stat_st_ext_rereq_fid, &rep_stat_class, "st_ext_rereq", "J" },
	{ &rep_stat_st_ext_update_rereq_fid, &rep_stat_class, "st_ext_update_rereq", "J" },
	{ &rep_stat_st_bulk_fills_fid, &rep_stat_class, "st_bulk_fills", "J" },
	{ &rep_stat_st_bulk_overflows_fid, &rep_stat_class, "st_bulk_overflows", "J" },
	{ &rep_stat_st_bulk_records_fid, &rep_stat_class, "st_bulk_records", "J" },
	{ &rep_stat_st_bulk_transfers_fid, &rep_stat_class, "st_bulk_transfers", "J" },
	{ &rep_stat_st_client_rerequests_fid, &rep_stat_class, "st_client_rerequests", "J" },
	{ &rep_stat_st_client_svc_req_fid, &rep_stat_class, "st_client_svc_req", "J" },
	{ &rep_stat_st_client_svc_miss_fid, &rep_stat_class, "st_client_svc_miss", "J" },
	{ &rep_stat_st_gen_fid, &rep_stat_class, "st_gen", "I" },
	{ &rep_stat_st_egen_fid, &rep_stat_class, "st_egen", "I" },
	{ &rep_stat_st_lease_chk_fid, &rep_stat_class, "st_lease_chk", "J" },
	{ &rep_stat_st_lease_chk_misses_fid, &rep_stat_class, "st_lease_chk_misses", "J" },
	{ &rep_stat_st_lease_chk_refresh_fid, &rep_stat_class, "st_lease_chk_refresh", "J" },
	{ &rep_stat_st_lease_sends_fid, &rep_stat_class, "st_lease_sends", "J" },
	{ &rep_stat_st_log_duplicated_fid, &rep_stat_class, "st_log_duplicated", "J" },
	{ &rep_stat_st_log_queued_max_fid, &rep_stat_class, "st_log_queued_max", "J" },
	{ &rep_stat_st_log_queued_total_fid, &rep_stat_class, "st_log_queued_total", "J" },
	{ &rep_stat_st_log_records_fid, &rep_stat_class, "st_log_records", "J" },
	{ &rep_stat_st_log_requested_fid, &rep_stat_class, "st_log_requested", "J" },
	{ &rep_stat_st_master_fid, &rep_stat_class, "st_master", "J" },
	{ &rep_stat_st_master_changes_fid, &rep_stat_class, "st_master_changes", "J" },
	{ &rep_stat_st_msgs_badgen_fid, &rep_stat_class, "st_msgs_badgen", "J" },
	{ &rep_stat_st_msgs_processed_fid, &rep_stat_class, "st_msgs_processed", "J" },
	{ &rep_stat_st_msgs_recover_fid, &rep_stat_class, "st_msgs_recover", "J" },
	{ &rep_stat_st_msgs_send_failures_fid, &rep_stat_class, "st_msgs_send_failures", "J" },
	{ &rep_stat_st_msgs_sent_fid, &rep_stat_class, "st_msgs_sent", "J" },
	{ &rep_stat_st_newsites_fid, &rep_stat_class, "st_newsites", "J" },
	{ &rep_stat_st_nsites_fid, &rep_stat_class, "st_nsites", "I" },
	{ &rep_stat_st_nthrottles_fid, &rep_stat_class, "st_nthrottles", "J" },
	{ &rep_stat_st_outdated_fid, &rep_stat_class, "st_outdated", "J" },
	{ &rep_stat_st_pg_duplicated_fid, &rep_stat_class, "st_pg_duplicated", "J" },
	{ &rep_stat_st_pg_records_fid, &rep_stat_class, "st_pg_records", "J" },
	{ &rep_stat_st_pg_requested_fid, &rep_stat_class, "st_pg_requested", "J" },
	{ &rep_stat_st_txns_applied_fid, &rep_stat_class, "st_txns_applied", "J" },
	{ &rep_stat_st_startsync_delayed_fid, &rep_stat_class, "st_startsync_delayed", "J" },
	{ &rep_stat_st_elections_fid, &rep_stat_class, "st_elections", "J" },
	{ &rep_stat_st_elections_won_fid, &rep_stat_class, "st_elections_won", "J" },
	{ &rep_stat_st_election_cur_winner_fid, &rep_stat_class, "st_election_cur_winner", "J" },
	{ &rep_stat_st_election_gen_fid, &rep_stat_class, "st_election_gen", "I" },
	{ &rep_stat_st_election_datagen_fid, &rep_stat_class, "st_election_datagen", "I" },
	{ &rep_stat_st_election_lsn_fid, &rep_stat_class, "st_election_lsn", "L" DB_PKG "LogSequenceNumber;" },
	{ &rep_stat_st_election_nsites_fid, &rep_stat_class, "st_election_nsites", "I" },
	{ &rep_stat_st_election_nvotes_fid, &rep_stat_class, "st_election_nvotes", "I" },
	{ &rep_stat_st_election_priority_fid, &rep_stat_class, "st_election_priority", "I" },
	{ &rep_stat_st_election_status_fid, &rep_stat_class, "st_election_status", "I" },
	{ &rep_stat_st_election_tiebreaker_fid, &rep_stat_class, "st_election_tiebreaker", "I" },
	{ &rep_stat_st_election_votes_fid, &rep_stat_class, "st_election_votes", "I" },
	{ &rep_stat_st_election_sec_fid, &rep_stat_class, "st_election_sec", "I" },
	{ &rep_stat_st_election_usec_fid, &rep_stat_class, "st_election_usec", "I" },
	{ &rep_stat_st_max_lease_sec_fid, &rep_stat_class, "st_max_lease_sec", "I" },
	{ &rep_stat_st_max_lease_usec_fid, &rep_stat_class, "st_max_lease_usec", "I" },
	{ &repmgr_stat_st_perm_failed_fid, &repmgr_stat_class, "st_perm_failed", "J" },
	{ &repmgr_stat_st_msgs_queued_fid, &repmgr_stat_class, "st_msgs_queued", "J" },
	{ &repmgr_stat_st_msgs_dropped_fid, &repmgr_stat_class, "st_msgs_dropped", "J" },
	{ &repmgr_stat_st_incoming_queue_gbytes_fid, &repmgr_stat_class, "st_incoming_queue_gbytes", "I" },
	{ &repmgr_stat_st_incoming_queue_bytes_fid, &repmgr_stat_class, "st_incoming_queue_bytes", "I" },
	{ &repmgr_stat_st_incoming_msgs_dropped_fid, &repmgr_stat_class, "st_incoming_msgs_dropped", "J" },
	{ &repmgr_stat_st_connection_drop_fid, &repmgr_stat_class, "st_connection_drop", "J" },
	{ &repmgr_stat_st_connect_fail_fid, &repmgr_stat_class, "st_connect_fail", "J" },
	{ &repmgr_stat_st_elect_threads_fid, &repmgr_stat_class, "st_elect_threads", "I" },
	{ &repmgr_stat_st_max_elect_threads_fid, &repmgr_stat_class, "st_max_elect_threads", "I" },
	{ &repmgr_stat_st_site_participants_fid, &repmgr_stat_class, "st_site_participants", "I" },
	{ &repmgr_stat_st_site_total_fid, &repmgr_stat_class, "st_site_total", "I" },
	{ &repmgr_stat_st_site_views_fid, &repmgr_stat_class, "st_site_views", "I" },
	{ &repmgr_stat_st_takeovers_fid, &repmgr_stat_class, "st_takeovers", "J" },
	{ &repmgr_stat_st_write_ops_forwarded_fid, &repmgr_stat_class, "st_write_ops_forwarded", "J" },
	{ &repmgr_stat_st_write_ops_received_fid, &repmgr_stat_class, "st_write_ops_received", "J" },
	{ &seq_stat_st_wait_fid, &seq_stat_class, "st_wait", "J" },
	{ &seq_stat_st_nowait_fid, &seq_stat_class, "st_nowait", "J" },
	{ &seq_stat_st_current_fid, &seq_stat_class, "st_current", "J" },
	{ &seq_stat_st_value_fid, &seq_stat_class, "st_value", "J" },
	{ &seq_stat_st_last_value_fid, &seq_stat_class, "st_last_value", "J" },
	{ &seq_stat_st_min_fid, &seq_stat_class, "st_min", "J" },
	{ &seq_stat_st_max_fid, &seq_stat_class, "st_max", "J" },
	{ &seq_stat_st_cache_size_fid, &seq_stat_class, "st_cache_size", "I" },
	{ &seq_stat_st_flags_fid, &seq_stat_class, "st_flags", "I" },
	{ &txn_stat_st_nrestores_fid, &txn_stat_class, "st_nrestores", "I" },
	{ &txn_stat_st_last_ckp_fid, &txn_stat_class, "st_last_ckp", "L" DB_PKG "LogSequenceNumber;" },
	{ &txn_stat_st_time_ckp_fid, &txn_stat_class, "st_time_ckp", "J" },
	{ &txn_stat_st_last_txnid_fid, &txn_stat_class, "st_last_txnid", "I" },
	{ &txn_stat_st_inittxns_fid, &txn_stat_class, "st_inittxns", "I" },
	{ &txn_stat_st_maxtxns_fid, &txn_stat_class, "st_maxtxns", "I" },
	{ &txn_stat_st_naborts_fid, &txn_stat_class, "st_naborts", "J" },
	{ &txn_stat_st_nbegins_fid, &txn_stat_class, "st_nbegins", "J" },
	{ &txn_stat_st_ncommits_fid, &txn_stat_class, "st_ncommits", "J" },
	{ &txn_stat_st_nactive_fid, &txn_stat_class, "st_nactive", "I" },
	{ &txn_stat_st_nsnapshot_fid, &txn_stat_class, "st_nsnapshot", "I" },
	{ &txn_stat_st_maxnactive_fid, &txn_stat_class, "st_maxnactive", "I" },
	{ &txn_stat_st_maxnsnapshot_fid, &txn_stat_class, "st_maxnsnapshot", "I" },
	{ &txn_stat_st_region_wait_fid, &txn_stat_class, "st_region_wait", "J" },
	{ &txn_stat_st_region_nowait_fid, &txn_stat_class, "st_region_nowait", "J" },
	{ &txn_stat_st_regsize_fid, &txn_stat_class, "st_regsize", "J" },
	{ &txn_stat_st_txnarray_fid, &txn_stat_class, "st_txnarray", "[L" DB_PKG "TransactionStats$Active;" },
	{ &txn_active_txnid_fid, &txn_active_class, "txnid", "I" },
	{ &txn_active_parentid_fid, &txn_active_class, "parentid", "I" },
	{ &txn_active_pid_fid, &txn_active_class, "pid", "I" },
	{ &txn_active_lsn_fid, &txn_active_class, "lsn", "L" DB_PKG "LogSequenceNumber;" },
	{ &txn_active_read_lsn_fid, &txn_active_class, "read_lsn", "L" DB_PKG "LogSequenceNumber;" },
	{ &txn_active_mvcc_ref_fid, &txn_active_class, "mvcc_ref", "I" },
	{ &txn_active_priority_fid, &txn_active_class, "priority", "I" },
	{ &txn_active_gid_fid, &txn_active_class, "gid", "[B" },
	{ &txn_active_name_fid, &txn_active_class, "name", "Ljava/lang/String;" },
	{ &txn_active_slice_txns_fid, &txn_active_class, "slice_txns", "[I" },
/* END-STAT-FIELDS */

	{ &repmgr_siteinfo_flags_fid, &repmgr_siteinfo_class, "flags", "I" },
	{ &repmgr_siteinfo_status_fid, &repmgr_siteinfo_class, "status", "I" }
};

const struct {
	jmethodID *mid;
	jclass *cl;
	const char *name;
	const char *sig;
} all_methods[] = {
	{ &db_construct, &db_class, "<init>", "(JZ)V" },
	{ &dbenv_construct, &dbenv_class, "<init>", "(JZ)V" },
	{ &dbt_construct, &dbt_class, "<init>", "()V" },
	{ &dblsn_construct, &dblsn_class, "<init>", "(II)V" },
	{ &dbpreplist_construct, &dbpreplist_class, "<init>",
	    "(L" DB_PKG "internal/DbTxn;[B)V" },
	{ &dbtxn_construct, &dbtxn_class, "<init>", "(JZ)V" },

	{ &bt_stat_construct, &bt_stat_class, "<init>", "()V" },
	{ &get_err_msg_method, &dbenv_class, "get_err_msg",
	    "(Ljava/lang/String;)Ljava/lang/String;" },
	{ &h_stat_construct, &h_stat_class, "<init>", "()V" },
	{ &heap_stat_construct, &heap_stat_class, "<init>", "()V" },
	{ &lock_stat_construct, &lock_stat_class, "<init>", "()V" },
	{ &log_stat_construct, &log_stat_class, "<init>", "()V" },
	{ &mpool_stat_construct, &mpool_stat_class, "<init>", "()V" },
	{ &mpool_fstat_construct, &mpool_fstat_class, "<init>", "()V" },
	{ &mutex_stat_construct, &mutex_stat_class, "<init>", "()V" },
	{ &qam_stat_construct, &qam_stat_class, "<init>", "()V" },
	{ &rep_stat_construct, &rep_stat_class, "<init>", "()V" },
	{ &repmgr_stat_construct, &repmgr_stat_class, "<init>", "()V" },
	{ &seq_stat_construct, &seq_stat_class, "<init>", "()V" },
	{ &txn_stat_construct, &txn_stat_class, "<init>", "()V" },
	{ &txn_active_construct, &txn_active_class, "<init>", "()V" },
	{ &rephost_construct, &rephost_class, "<init>", "(Ljava/lang/String;I)V" },
        { &repmgr_siteinfo_construct, &repmgr_siteinfo_class, "<init>", 
	    "(L" DB_PKG "ReplicationHostAddress;I)V" },

	{ &dbex_construct, &dbex_class, "<init>",
	    "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &deadex_construct, &deadex_class, "<init>",
	    "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &heapfullex_construct, &heapfullex_class, "<init>",
	    "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &lockex_construct, &lockex_class, "<init>",
	    "(Ljava/lang/String;IIL" DB_PKG "DatabaseEntry;L"
	    DB_PKG "internal/DbLock;IL" DB_PKG "internal/DbEnv;)V" },
	{ &memex_construct, &memex_class, "<init>",
	    "(Ljava/lang/String;L" DB_PKG "DatabaseEntry;IL"
	    DB_PKG "internal/DbEnv;)V" },
	{ &memex_update_method, &memex_class, "updateDatabaseEntry",
	    "(L" DB_PKG "DatabaseEntry;)V" },
	{ &metachkfailex_construct, &metachkfailex_class, "<init>",
	    "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &repdupmasterex_construct, &repdupmasterex_class, "<init>",
	    "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &rephandledeadex_construct, &rephandledeadex_class, "<init>",
	    "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &repholdelectionex_construct, &repholdelectionex_class, "<init>",
	    "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &repjoinfailex_construct, &repjoinfailex_class, "<init>",
	    "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &repleaseexpiredex_construct, &repleaseexpiredex_class, "<init>",
	    "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &replockoutex_construct, &replockoutex_class, "<init>",
	    "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &repunavailex_construct, &repunavailex_class, "<init>",
	    "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &runrecex_construct, &runrecex_class, "<init>",
	    "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &sliceex_construct, &sliceex_class, "<init>",
	    "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &versionex_construct, &versionex_class, "<init>",
	    "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &filenotfoundex_construct, &filenotfoundex_class, "<init>",
	    "(Ljava/lang/String;)V" },
	{ &illegalargex_construct, &illegalargex_class, "<init>",
	    "(Ljava/lang/String;)V" },
	{ &outofmemerr_construct, &outofmemerr_class, "<init>",
	    "(Ljava/lang/String;)V" },

	{ &lock_construct, &lock_class, "<init>", "(JZ)V" },

	{ &app_dispatch_method, &dbenv_class, "handle_app_dispatch",
	    "(L" DB_PKG "DatabaseEntry;L" DB_PKG "LogSequenceNumber;I)I" },
	{ &backup_close_method, &dbenv_class, "handle_backup_close", 
	    "(Ljava/lang/String;)I" },
	{ &backup_open_method, &dbenv_class, "handle_backup_open", 
	    "(Ljava/lang/String;Ljava/lang/String;)I" },
	{ &backup_write_method, &dbenv_class, "handle_backup_write", 
	    "(III[B)I" },
	{ &panic_event_notify_method, &dbenv_class, "handle_panic_event_notify",
	    "()V" },
	{ &rep_autotakeover_failed_event_notify_method, &dbenv_class,
	    "handle_rep_autotakeover_failed_event_notify", "()V" },
	{ &rep_connect_broken_event_notify_method, &dbenv_class, 
	    "handle_rep_connect_broken_event_notify", "()V" },
	{ &rep_connect_established_event_notify_method, &dbenv_class, 
	    "handle_rep_connect_established_event_notify", "()V" },
	{ &rep_connect_try_failed_event_notify_method, &dbenv_class, 
	    "handle_rep_connect_try_failed_event_notify", "()V" },
	{ &rep_client_event_notify_method, &dbenv_class, 
	    "handle_rep_client_event_notify", "()V" },
	{ &rep_dupmaster_event_notify_method, &dbenv_class, 
	    "handle_rep_dupmaster_event_notify" ,"()V" },
	{ &rep_elected_event_notify_method, &dbenv_class, 
	    "handle_rep_elected_event_notify" ,"()V" },
	{ &rep_election_failed_event_notify_method, &dbenv_class, 
	    "handle_rep_election_failed_event_notify" ,"()V" },
	{ &rep_init_done_event_notify_method, &dbenv_class,
	    "handle_rep_init_done_event_notify" , "()V" },
	{ &rep_inqueue_full_event_notify_method, &dbenv_class,
	    "handle_rep_inqueue_full_event_notify" , "()V" },
	{ &rep_join_failure_event_notify_method, &dbenv_class, 
	    "handle_rep_join_failure_event_notify" ,"()V" },
	{ &rep_master_event_notify_method, &dbenv_class, 
	    "handle_rep_master_event_notify", "()V" },
	{ &rep_master_failure_event_notify_method, &dbenv_class, 
	    "handle_rep_master_failure_event_notify", "()V" },
	{ &rep_local_site_removed_notify_method, &dbenv_class, 
	    "handle_rep_local_site_removed_event_notify", "()V" },
	{ &rep_new_master_event_notify_method, &dbenv_class, 
	    "handle_rep_new_master_event_notify", "(I)V" },
	{ &rep_perm_failed_event_notify_method, &dbenv_class, 
	    "handle_rep_perm_failed_event_notify", "()V" },
	{ &rep_site_added_event_notify_method, &dbenv_class, 
	    "handle_rep_site_added_event_notify", "()V" },
	{ &rep_site_removed_event_notify_method, &dbenv_class, 
	    "handle_rep_site_removed_event_notify", "()V" },
	{ &rep_startup_done_event_notify_method, &dbenv_class, 
	    "handle_rep_startup_done_event_notify", "()V" },
	{ &write_failed_event_notify_method, &dbenv_class, 
	    "handle_write_failed_event_notify", "(I)V" },
	{ &env_feedback_method, &dbenv_class, "handle_env_feedback", "(II)V" },
	{ &errcall_method, &dbenv_class, "handle_error",
	    "(Ljava/lang/String;)V" },
	{ &msgcall_method, &dbenv_class, "handle_message",
	    "(Ljava/lang/String;)V" },
	{ &paniccall_method, &dbenv_class, "handle_panic",
	    "(L" DB_PKG "DatabaseException;)V" },
	{ &rep_transport_method, &dbenv_class, "handle_rep_transport",
	    "(L" DB_PKG "DatabaseEntry;L" DB_PKG "DatabaseEntry;L"
	    DB_PKG "LogSequenceNumber;II)I" },
	{ &repmgr_msg_dispatch_method, &dbenv_class, 
	    "handle_repmgr_message_dispatch", 
	    "(L" DB_PKG "ReplicationChannel;[L" DB_PKG "DatabaseEntry;I)V" },

	{ &append_recno_method, &db_class, "handle_append_recno",
	    "(L" DB_PKG "DatabaseEntry;I)V" },
	{ &bt_compare_method, &db_class, "handle_bt_compare",
	    "([B[B)I" },
	{ &bt_compress_method, &db_class, "handle_bt_compress",
	    "(L" DB_PKG "DatabaseEntry;L" DB_PKG "DatabaseEntry;L" DB_PKG
	    "DatabaseEntry;L" DB_PKG "DatabaseEntry;L" DB_PKG
	    "DatabaseEntry;)I" },
	{ &bt_decompress_method, &db_class, "handle_bt_decompress",
	    "(L" DB_PKG "DatabaseEntry;L" DB_PKG "DatabaseEntry;L" DB_PKG
	    "DatabaseEntry;L" DB_PKG "DatabaseEntry;L" DB_PKG
	    "DatabaseEntry;)I" },
	{ &bt_prefix_method, &db_class, "handle_bt_prefix",
	    "(L" DB_PKG "DatabaseEntry;L" DB_PKG "DatabaseEntry;)I" },
	{ &db_feedback_method, &db_class, "handle_db_feedback", "(II)V" },
	{ &dup_compare_method, &db_class, "handle_dup_compare",
	    "([B[B)I" },
	{ &foreignkey_nullify_method, &db_class, "handle_foreignkey_nullify",
	    "(L" DB_PKG "DatabaseEntry;L" DB_PKG "DatabaseEntry;L" DB_PKG
	    "DatabaseEntry;)Z" },
	{ &h_compare_method, &db_class, "handle_h_compare",
	    "([B[B)I" },
	{ &h_hash_method, &db_class, "handle_h_hash", "([BI)I" },
	{ &partition_method, &db_class, "handle_partition", 
            "(L" DB_PKG "DatabaseEntry;)I" },
	{ &seckey_create_method, &db_class, "handle_seckey_create",
	    "(L" DB_PKG "DatabaseEntry;L" DB_PKG "DatabaseEntry;)[L"
	    DB_PKG "DatabaseEntry;" },
	{ &slice_method, &db_class, "handle_slice",
	    "(L" DB_PKG "DatabaseEntry;L" DB_PKG "DatabaseEntry;)I" },
	{&rep_view_method, &dbenv_class, "handle_rep_view",
	    "(Ljava/lang/String;I)Z" },

	{ &outputstream_write_method, &outputstream_class, "write", "([BII)V" }
};

#define	NELEM(x) (sizeof (x) / sizeof (x[0]))

SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_initialize(
    JNIEnv *jenv, jclass clazz)
{
	jclass cl;
	unsigned int i, j;

	COMPQUIET(clazz, NULL);

	if ((*jenv)->GetJavaVM(jenv, &javavm) != 0) {
		__db_errx(NULL, "Cannot get Java VM");
		return;
	}

	for (i = 0; i < NELEM(all_classes); i++) {
		cl = (*jenv)->FindClass(jenv, all_classes[i].name);
		if (cl == NULL) {
			fprintf(stderr,
			    "Failed to load class %s - check CLASSPATH\n",
			    all_classes[i].name);
			return;
		}

		/*
		 * Wrap classes in GlobalRefs so we keep the reference between
		 * calls.
		 */
		*all_classes[i].cl = (jclass)(*jenv)->NewGlobalRef(jenv, cl);

		if (*all_classes[i].cl == NULL) {
			fprintf(stderr,
			    "Failed to create a global reference for %s\n",
			    all_classes[i].name);
			return;
		}
	}

	/* Get field IDs */
	for (i = 0; i < NELEM(all_fields); i++) {
		*all_fields[i].fid = (*jenv)->GetFieldID(jenv,
		    *all_fields[i].cl, all_fields[i].name, all_fields[i].sig);

		if (*all_fields[i].fid == NULL) {
			fprintf(stderr,
			    "Failed to look up field %s with sig %s\n",
			    all_fields[i].name, all_fields[i].sig);
			return;
		}
	}

	/* Get method IDs */
	for (i = 0; i < NELEM(all_methods); i++) {
		*all_methods[i].mid = (*jenv)->GetMethodID(jenv,
		    *all_methods[i].cl, all_methods[i].name,
		    all_methods[i].sig);

		if (*all_methods[i].mid == NULL) {
			for (j = 0; j < NELEM(all_classes); j++)
				if (all_methods[i].cl == all_classes[j].cl)
					break;
			fprintf(stderr,
			    "Failed to look up method %s.%s with sig %s\n",
			    all_classes[j].name, all_methods[i].name,
			    all_methods[i].sig);
			return;
		}
	}
}

static JNIEnv *__dbj_get_jnienv(int *needDetach)
{
	/*
	 * Note: Different versions of the JNI disagree on the signature for
	 * AttachCurrentThreadAsDaemon.  The most recent documentation seems to
	 * say that (JNIEnv **) is correct, but newer JNIs seem to use
	 * (void **), oddly enough.
	 */
#ifdef JNI_VERSION_1_2
	void *jenv = 0;
#else
	JNIEnv *jenv = 0;
#endif

	*needDetach = 0;
	if ((*javavm)->GetEnv(javavm, &jenv, JNI_VERSION_1_2) == JNI_OK)
		return ((JNIEnv *)jenv);

	/*
	 * This should always succeed, as we are called via some Java activity.
	 * I think therefore I am (a thread).
	 */
	if ((*javavm)->AttachCurrentThread(javavm, &jenv, 0) != 0)
		return (0);

        *needDetach = 1;
	return ((JNIEnv *)jenv);
}

static void __dbj_detach()
{
	(void)(*javavm)->DetachCurrentThread(javavm);
}

static jobject __dbj_wrap_DB_LSN(JNIEnv *jenv, const DB_LSN *lsn)
{
	return (*jenv)->NewObject(jenv, dblsn_class, dblsn_construct,
	    lsn->file, lsn->offset);
}


/*
 * Macros to find the Java DbEnv object for methods in various classes.
 * Note that "arg1" is from the code SWIG generates for the "this"/"self".
 */
#define	JDBENV (arg1 ? (jobject)DB_ENV_INTERNAL(arg1) : NULL)
#define	DB2JDBENV ((jobject)DB_ENV_INTERNAL(arg1->dbenv))
#define	DBC2JDBENV ((jobject)DB_ENV_INTERNAL(arg1->dbp->dbenv))
#define	TXN2JDBENV ((jobject)DB_ENV_INTERNAL(arg1->mgrp->env->dbenv))


static jthrowable __dbj_get_except(JNIEnv *jenv,
    int ret, const char *msg, jobject obj, jobject jdbenv) {
	jobject jmsg;

	if (msg == NULL)
		msg = db_strerror(ret);

	jmsg = (*jenv)->NewStringUTF(jenv, msg);

	/* Retrieve error message logged by DB */
	if (jdbenv != NULL) {
		jmsg = (jstring) (*jenv)->CallNonvirtualObjectMethod(jenv,
		    jdbenv, dbenv_class, get_err_msg_method, jmsg);
	}

	switch (ret) {
	case EINVAL:
		return (jthrowable)(*jenv)->NewObject(jenv,
		    illegalargex_class, illegalargex_construct, jmsg);

	case ENOENT:
		return (jthrowable)(*jenv)->NewObject(jenv,
		    filenotfoundex_class, filenotfoundex_construct, jmsg);

	case ENOMEM:
		return (jthrowable)(*jenv)->NewObject(jenv,
		    outofmemerr_class, outofmemerr_construct, jmsg);

	case DB_BUFFER_SMALL:
		return (jthrowable)(*jenv)->NewObject(jenv, memex_class,
		    memex_construct, jmsg, obj, ret, jdbenv);

	case DB_HEAP_FULL:
		return (jthrowable)(*jenv)->NewObject(jenv, heapfullex_class,
		    heapfullex_construct, jmsg, ret, jdbenv);

	case DB_META_CHKSUM_FAIL:        
		return (jthrowable)(*jenv)->NewObject(jenv, metachkfailex_class,
		    metachkfailex_construct, jmsg, ret, jdbenv);      

	case DB_REP_DUPMASTER:
		return (jthrowable)(*jenv)->NewObject(jenv,
		    repdupmasterex_class, repdupmasterex_construct,
		    jmsg, ret, jdbenv);

	case DB_REP_HANDLE_DEAD:
		return (jthrowable)(*jenv)->NewObject(jenv,
		    rephandledeadex_class, rephandledeadex_construct,
		    jmsg, ret, jdbenv);

	case DB_REP_HOLDELECTION:
		return (jthrowable)(*jenv)->NewObject(jenv,
		    repholdelectionex_class, repholdelectionex_construct,
		    jmsg, ret, jdbenv);

	case DB_REP_JOIN_FAILURE:
		return (jthrowable)(*jenv)->NewObject(jenv,
		    repjoinfailex_class, repjoinfailex_construct,
		    jmsg, ret, jdbenv);

	case DB_REP_LEASE_EXPIRED:
		return (jthrowable)(*jenv)->NewObject(jenv,
		    repleaseexpiredex_class, repleaseexpiredex_construct,
		    jmsg, ret, jdbenv);

	case DB_REP_LOCKOUT:
		return (jthrowable)(*jenv)->NewObject(jenv,
		    replockoutex_class, replockoutex_construct,
		    jmsg, ret, jdbenv);

	case DB_REP_UNAVAIL:
		return (jthrowable)(*jenv)->NewObject(jenv,
		    repunavailex_class, repunavailex_construct,
		    jmsg, ret, jdbenv);

	case DB_RUNRECOVERY:
		return (jthrowable)(*jenv)->NewObject(jenv, runrecex_class,
		    runrecex_construct, jmsg, ret, jdbenv);

	case DB_LOCK_DEADLOCK:
		return (jthrowable)(*jenv)->NewObject(jenv, deadex_class,
		    deadex_construct, jmsg, ret, jdbenv);

	case DB_LOCK_NOTGRANTED:
		return (jthrowable)(*jenv)->NewObject(jenv, lockex_class,
		    lockex_construct, jmsg, ret, 0, NULL, NULL, 0, jdbenv);

	case DB_SLICE_CORRUPT:
		return (jthrowable)(*jenv)->NewObject(jenv, sliceex_class,
		    sliceex_construct, jmsg, ret, jdbenv);

	case DB_VERSION_MISMATCH:
		return (jthrowable)(*jenv)->NewObject(jenv, versionex_class,
		    versionex_construct, jmsg, ret, jdbenv);

	default:
		return (jthrowable)(*jenv)->NewObject(jenv, dbex_class,
		    dbex_construct, jmsg, ret, jdbenv);
	}
}

static int __dbj_throw(JNIEnv *jenv,
    int ret, const char *msg, jobject obj, jobject jdbenv)
{
	jthrowable t;

	/* If an exception is pending, ignore requests to throw a new one. */
	if ((*jenv)->ExceptionOccurred(jenv) == NULL) {
		t = __dbj_get_except(jenv, ret, msg, obj, jdbenv);
		if (t == NULL) {
			/*
			 * This is a problem - something went wrong creating an
			 * exception.  We have to assume there is an exception
			 * created by the JVM that is pending as a result
			 * (e.g., OutOfMemoryError), but we don't want to lose
			 * this error, so we just call __db_errx here.
			 */
			if (msg == NULL)
				msg = db_strerror(ret);

			 __db_errx(NULL, "Couldn't create exception for: '%s'",
			     msg);
		} else
			(*jenv)->Throw(jenv, t);
	}

	return (ret);
}


typedef int db_ret_t;
typedef int int_bool;

struct __db_lk_conflicts {
       u_int8_t *lk_conflicts;
       int lk_modes;
};

struct __db_out_stream {
       void *handle;
       int (*callback) __P((void *, const void *));
};

struct __db_repmgr_site_address {
	const char *host;
	u_int port;
};

struct __db_repmgr_sites {
       DB_REPMGR_SITE *sites;
       u_int32_t nsites;
};

#define        Db __db
#define        Dbc __dbc
#define        Dbt __db_dbt
#define        DbChannel __db_channel
#define        DbEnv __db_env
#define        DbLock __db_lock_u
#define        DbLogc __db_log_cursor
#define        DbLsn __db_lsn
#define        DbMpoolFile __db_mpoolfile
#define        DbSequence __db_sequence
#define        DbSite __db_site
#define        DbStream __db_stream
#define        DbTxn __db_txn

/* Suppress a compilation warning for an unused symbol */
void *unused = (void *)SWIG_JavaThrowException;


typedef struct __dbt_locked {
	JNIEnv *jenv;
	jobject jdbt;
	DBT dbt;
	jobject jdata_nio;
	jbyteArray jarr;
	jint offset;
	int reuse;
	u_int32_t orig_size;
	jsize array_len;
} DBT_LOCKED;

struct __dbt_arr {
	DBT *arr_ptr;
	int len;
};

static int __dbj_dbt_memcopy(DBT *dbt, u_int32_t offset, void *buf, u_int32_t size, u_int32_t flags) {
	DBT_LOCKED *ldbt = dbt->app_data;
	JNIEnv *jenv = ldbt->jenv;

	if (size == 0)
		return (0);
	else if (!F_ISSET(dbt, DB_DBT_USERCOPY)) {
		/*
		  * For simplicity, the Java API calls this function directly,
		  * so it needs to work with regular DBTs.
		  */
		switch (flags) {
		case DB_USERCOPY_GETDATA:
			memcpy(buf, (u_int8_t *)dbt->data + offset, size);
			return (0);
		case DB_USERCOPY_SETDATA:
			memcpy((u_int8_t *)dbt->data + offset, buf, size);
			return (0);
		default:
			return (EINVAL);
		}
	}

	switch (flags) {
	case DB_USERCOPY_GETDATA:
		(*jenv)->GetByteArrayRegion(jenv, ldbt->jarr, ldbt->offset +
					    offset, size, buf);
		break;
	case DB_USERCOPY_SETDATA:
		/*
		 * Check whether this is the first time through the callback by relying
		 * on the offset being zero.
		 */
		if (offset == 0 && (!ldbt->reuse ||
		    (jsize)(ldbt->offset + dbt->size) > ldbt->array_len)) {
			if (ldbt->jarr != NULL)
				(*jenv)->DeleteLocalRef(jenv, ldbt->jarr);
			ldbt->jarr = (*jenv)->NewByteArray(jenv, (jsize)dbt->size);
			if (ldbt->jarr == NULL)
				return (ENOMEM);
			(*jenv)->SetObjectField(jenv, ldbt->jdbt, dbt_data_fid, ldbt->jarr);
			/* We've allocated a new array, start from the beginning. */
			ldbt->offset = 0;
		}
		(*jenv)->SetByteArrayRegion(jenv, ldbt->jarr, ldbt->offset +
					    offset, size, buf);
		break;
	default:
		return (EINVAL);
	}
	return ((*jenv)->ExceptionOccurred(jenv) ? EINVAL : 0);
}

static void __dbj_dbt_copyout(
    JNIEnv *jenv, const DBT *dbt, jbyteArray *jarr, jobject jdbt)
{
	jbyteArray newarr = (*jenv)->NewByteArray(jenv, (jsize)dbt->size);
	if (newarr == NULL)
		return; /* An exception is pending */
	(*jenv)->SetByteArrayRegion(jenv, newarr, 0, (jsize)dbt->size,
	    (jbyte *)dbt->data);
	(*jenv)->SetObjectField(jenv, jdbt, dbt_data_fid, newarr);
	(*jenv)->SetIntField(jenv, jdbt, dbt_offset_fid, 0);
	(*jenv)->SetIntField(jenv, jdbt, dbt_size_fid, (jint)dbt->size);
	if (jarr != NULL)
		*jarr = newarr;
	else
		(*jenv)->DeleteLocalRef(jenv, newarr);
}

static int __dbj_dbt_copyin(
    JNIEnv *jenv, DBT_LOCKED *ldbt, DBT **dbtp, jobject jdbt, int allow_null)
{
	DBT *dbt;
	jlong capacity;

	memset(ldbt, 0, sizeof (*ldbt));
	ldbt->jenv = jenv;
	ldbt->jdbt = jdbt;

	if (jdbt == NULL) {
		if (allow_null) {
			*dbtp = NULL;
			return (0);
		} else {
			return (__dbj_throw(jenv, EINVAL,
			    "DatabaseEntry must not be null", NULL, NULL));
		}
	}

	dbt = &ldbt->dbt;
	if (dbtp != NULL)
		*dbtp = dbt;

	ldbt->jdata_nio = (*jenv)->GetObjectField(jenv, jdbt, dbt_data_nio_fid);
	if (ldbt->jdata_nio != NULL)
		F_SET(dbt, DB_DBT_USERMEM);
	else
		ldbt->jarr = (jbyteArray)(*jenv)->GetObjectField(jenv, jdbt, dbt_data_fid);
	ldbt->offset = (*jenv)->GetIntField(jenv, jdbt, dbt_offset_fid);
	dbt->size = (*jenv)->GetIntField(jenv, jdbt, dbt_size_fid);
	ldbt->orig_size = dbt->size;
	dbt->flags = (*jenv)->GetIntField(jenv, jdbt, dbt_flags_fid);

	if (F_ISSET(dbt, DB_DBT_USERMEM))
		dbt->ulen = (*jenv)->GetIntField(jenv, jdbt, dbt_ulen_fid);
	if (F_ISSET(dbt, DB_DBT_PARTIAL)) {
		dbt->dlen = (*jenv)->GetIntField(jenv, jdbt, dbt_dlen_fid);
		dbt->doff = (*jenv)->GetIntField(jenv, jdbt, dbt_doff_fid);

		if ((jint)dbt->doff < 0)
			return (__dbj_throw(jenv, EINVAL, "DatabaseEntry doff illegal",
			    NULL, NULL));
	}

	/*
	 * We don't support DB_DBT_REALLOC - map anything that's not USERMEM to
	 * MALLOC.
	 */
	if (!F_ISSET(dbt, DB_DBT_USERMEM)) {
		ldbt->reuse = !F_ISSET(dbt, DB_DBT_MALLOC);
		F_CLR(dbt, DB_DBT_MALLOC | DB_DBT_REALLOC);
	}

	/* Verify parameters before allocating or locking data. */
	if (ldbt->jdata_nio != NULL) {
		capacity = (*jenv)->GetDirectBufferCapacity(jenv,
				ldbt->jdata_nio);
		if (capacity > (jlong)UINT32_MAX)
			return (__dbj_throw(jenv, EINVAL,
			    "DirectBuffer may not be larger than 4GB",
			    NULL, NULL));
		ldbt->array_len = (u_int32_t)capacity;
	} else if (ldbt->jarr == NULL) {
		/*
		 * Some code makes the assumption that if a DBT's size or ulen
		 * is non-zero, there is data to copy from dbt->data.
		 *
		 * Clean up the dbt fields so we don't run into trouble.
		 * (Note that doff, dlen, and flags all may contain
		 * meaningful values.)
		 */
		dbt->data = NULL;
		ldbt->array_len = ldbt->offset = dbt->size = dbt->ulen = 0;
	} else
		ldbt->array_len = (*jenv)->GetArrayLength(jenv, ldbt->jarr);

	if (F_ISSET(dbt, DB_DBT_USERMEM)) {
		if (ldbt->offset < 0)
			return (__dbj_throw(jenv, EINVAL,
			    "offset cannot be negative",
			    NULL, NULL));
		if (dbt->size > dbt->ulen)
			return (__dbj_throw(jenv, EINVAL,
			    "size must be less than or equal to ulen",
			    NULL, NULL));
		if ((jsize)(ldbt->offset + dbt->ulen) > ldbt->array_len)
			return (__dbj_throw(jenv, EINVAL,
			    "offset + ulen greater than array length",
			    NULL, NULL));
	}

	if (ldbt->jdata_nio) {
		dbt->data = (*jenv)->GetDirectBufferAddress(jenv,
				ldbt->jdata_nio);
		dbt->data = (u_int8_t *)dbt->data + ldbt->offset;
	} else if (F_ISSET(dbt, DB_DBT_USERMEM)) {
		if (ldbt->jarr != NULL &&
		    (dbt->data = (*jenv)->GetByteArrayElements(jenv,
		    ldbt->jarr, NULL)) == NULL)
			return (EINVAL); /* an exception will be pending */
		dbt->data = (u_int8_t *)dbt->data + ldbt->offset;
	} else
		F_SET(dbt, DB_DBT_USERCOPY);
	dbt->app_data = ldbt;

	return (0);
}

static void __dbj_dbt_release(
    JNIEnv *jenv, jobject jdbt, DBT *dbt, DBT_LOCKED *ldbt) {
	jthrowable t;

	if (dbt == NULL)
		return;

	if (dbt->size != ldbt->orig_size)
		(*jenv)->SetIntField(jenv, jdbt, dbt_size_fid, (jint)dbt->size);

	if (F_ISSET(dbt, DB_DBT_USERMEM)) {
		if (ldbt->jarr != NULL)
			(*jenv)->ReleaseByteArrayElements(jenv, ldbt->jarr,
			    (jbyte *)dbt->data - ldbt->offset, 0);

		if (dbt->size > dbt->ulen &&
		    (t = (*jenv)->ExceptionOccurred(jenv)) != NULL &&
		    (*jenv)->IsInstanceOf(jenv, t, memex_class)) {
			(*jenv)->CallNonvirtualVoidMethod(jenv, t, memex_class,
			    memex_update_method, jdbt);
			/*
			 * We have to rethrow the exception because calling
			 * into Java clears it.
			 */
			(*jenv)->Throw(jenv, t);
		}
	}
}


struct __dbj_verify_data {
	JNIEnv *jenv;
	jobject streamobj;
	jbyteArray bytes;
	int nbytes;
};

static int __dbj_verify_callback(void *handle, const void *str_arg) {
	char *str;
	struct __dbj_verify_data *vd;
	int len;
	JNIEnv *jenv;

	str = (char *)str_arg;
	vd = (struct __dbj_verify_data *)handle;
	jenv = vd->jenv;
	len = (int)strlen(str) + 1;
	if (len > vd->nbytes) {
		vd->nbytes = len;
		if (vd->bytes != NULL)
			(*jenv)->DeleteLocalRef(jenv, vd->bytes);
		if ((vd->bytes = (*jenv)->NewByteArray(jenv, (jsize)len))
		    == NULL)
			return (ENOMEM);
	}

	if (vd->bytes != NULL) {
		(*jenv)->SetByteArrayRegion(jenv, vd->bytes, 0, (jsize)len,
		    (jbyte*)str);
		(*jenv)->CallVoidMethod(jenv, vd->streamobj,
		    outputstream_write_method, vd->bytes, 0, len - 1);
	}

	if ((*jenv)->ExceptionOccurred(jenv) != NULL)
		return (EIO);

	return (0);
}


SWIGEXPORT void JNICALL
Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1lock_1vec(JNIEnv *jenv,
    jclass jcls, jlong jdbenvp, jobject jdbenv, jint locker, jint flags,
    jobjectArray list, jint offset, jint count) {
	DB_ENV *dbenv;
	DB_LOCKREQ *lockreq;
	DB_LOCKREQ *prereq;	/* preprocessed requests */
	DB_LOCKREQ *failedreq;
	DB_LOCK *lockp;
	DBT_LOCKED *locked_dbts;
	DBT *obj;
	ENV *env;
	int alloc_err, i, ret;
	size_t bytesize, ldbtsize;
	jobject jlockreq;
	db_lockop_t op;
	jobject jobj, jlock;
	jlong jlockp;
	int completed;

	/*       
	 * We can't easily #include "dbinc/db_ext.h" because of name
	 * clashes, so we declare this explicitly.
	 */     
	extern int __dbt_usercopy __P((ENV *, DBT *));
	extern void __dbt_userfree __P((ENV *, DBT *, DBT *, DBT *));

	COMPQUIET(jcls, NULL);
	dbenv = *(DB_ENV **)(void *)&jdbenvp;
	env = dbenv->env;
	locked_dbts = NULL;
	lockreq = NULL;

	if (dbenv == NULL) {
		__dbj_throw(jenv, EINVAL, "null object", NULL, jdbenv);
		return;
	}

	if ((*jenv)->GetArrayLength(jenv, list) < offset + count) {
		__dbj_throw(jenv, EINVAL,
		    "DbEnv.lock_vec array not large enough", NULL, jdbenv);
		return;
	}

	bytesize = sizeof(DB_LOCKREQ) * count;
	if ((ret = __os_malloc(env, bytesize, &lockreq)) != 0) {
		__dbj_throw(jenv, ret, NULL, NULL, jdbenv);
		return;
	}
	memset(lockreq, 0, bytesize);

	ldbtsize = sizeof(DBT_LOCKED) * count;
	if ((ret = __os_malloc(env, ldbtsize, &locked_dbts)) != 0) {
		__dbj_throw(jenv, ret, NULL, NULL, jdbenv);
		goto err;
	}
	memset(locked_dbts, 0, ldbtsize);
	prereq = &lockreq[0];

	/* fill in the lockreq array */
	for (i = 0, prereq = &lockreq[0]; i < count; i++, prereq++) {
		jlockreq = (*jenv)->GetObjectArrayElement(jenv, list,
		    offset + i);
		if (jlockreq == NULL) {
			__dbj_throw(jenv, EINVAL,
			    "DbEnv.lock_vec list entry is null", NULL, jdbenv);
			goto err;
		}
		op = (db_lockop_t)(*jenv)->GetIntField(
                    jenv, jlockreq, lockreq_op_fid);
		prereq->op = op;

		switch (op) {
		case DB_LOCK_GET_TIMEOUT:
			/* Needed: mode, timeout, obj.  Returned: lock. */
			prereq->op = (db_lockop_t)(*jenv)->GetIntField(
			    jenv, jlockreq, lockreq_timeout_fid);
			/* FALLTHROUGH */
		case DB_LOCK_GET:
			/* Needed: mode, obj.  Returned: lock. */
			prereq->mode = (db_lockmode_t)(*jenv)->GetIntField(
			    jenv, jlockreq, lockreq_modeflag_fid);
			jobj = (*jenv)->GetObjectField(jenv, jlockreq,
			    lockreq_obj_fid);
			if ((ret = __dbj_dbt_copyin(jenv,
			    &locked_dbts[i], &obj, jobj, 0)) != 0 ||
			    (ret = __dbt_usercopy(env, obj)) != 0)
				goto err;
			prereq->obj = obj;
			break;
		case DB_LOCK_PUT:
			/* Needed: lock.  Ignored: mode, obj. */
			jlock = (*jenv)->GetObjectField(jenv, jlockreq,
				lockreq_lock_fid);
			if (jlock == NULL ||
			    (jlockp = (*jenv)->GetLongField(jenv, jlock,
			    lock_cptr_fid)) == 0L) {
				__dbj_throw(jenv, EINVAL,
				    "LockRequest lock field is NULL", NULL,
				    jdbenv);
				goto err;
			}
			lockp = *(DB_LOCK **)(void *)&jlockp;
			prereq->lock = *lockp;
			break;
		case DB_LOCK_PUT_ALL:
		case DB_LOCK_TIMEOUT:
			/* Needed: (none).  Ignored: lock, mode, obj. */
			break;
		case DB_LOCK_PUT_OBJ:
			/* Needed: obj.  Ignored: lock, mode. */
			jobj = (*jenv)->GetObjectField(jenv, jlockreq,
			    lockreq_obj_fid);
			if ((ret = __dbj_dbt_copyin(jenv,
			    &locked_dbts[i], &obj, jobj, 0)) != 0 ||
			    (ret = __dbt_usercopy(env, obj)) != 0)
				goto err;
			prereq->obj = obj;
			break;
		default:
			__dbj_throw(jenv, EINVAL,
			    "DbEnv.lock_vec bad op value", NULL, jdbenv);
			goto err;
		}
	}

	ret = dbenv->lock_vec(dbenv, (u_int32_t)locker, (u_int32_t)flags,
	    lockreq, count, &failedreq);
	if (ret == 0)
		completed = count;
	else
		completed = (int)(failedreq - lockreq);

	/* do post processing for any and all requests that completed */
	for (i = 0; i < completed; i++) {
		op = lockreq[i].op;
		if (op == DB_LOCK_PUT) {
			/*
			 * After a successful put, the DbLock can no longer be
			 * used, so we release the storage related to it.
			 */
			jlockreq = (*jenv)->GetObjectArrayElement(jenv,
			    list, i + offset);
			jlock = (*jenv)->GetObjectField(jenv, jlockreq,
			    lockreq_lock_fid);
			jlockp = (*jenv)->GetLongField(jenv, jlock,
			    lock_cptr_fid);
			lockp = *(DB_LOCK **)(void *)&jlockp;
			__os_free(NULL, lockp);
			(*jenv)->SetLongField(jenv, jlock, lock_cptr_fid,
			    (jlong)0);
		} else if (op == DB_LOCK_GET_TIMEOUT || op == DB_LOCK_GET) {
			/*
			 * Store the lock that was obtained.  We need to create
			 * storage for it since the lockreq array only exists
			 * during this method call.
			 */
			if ((alloc_err =
			    __os_malloc(env, sizeof(DB_LOCK), &lockp)) != 0) {
				__dbj_throw(jenv, alloc_err, NULL, NULL,
				    jdbenv);
				goto err;
			}

			*lockp = lockreq[i].lock;
			*(DB_LOCK **)(void *)&jlockp = lockp;

			jlockreq = (*jenv)->GetObjectArrayElement(jenv,
			    list, i + offset);
			jlock = (*jenv)->NewObject(jenv, lock_class,
			    lock_construct, jlockp, JNI_TRUE);
			if (jlock == NULL)
				goto err; /* An exception is pending */
			(*jenv)->SetLongField(jenv, jlock, lock_cptr_fid,
			    jlockp);
			(*jenv)->SetObjectField(jenv, jlockreq,
			    lockreq_lock_fid, jlock);
		}
	}

	/* If one of the locks was not granted, build the exception now. */
	if (ret == DB_LOCK_NOTGRANTED && i < count) {
		jlockreq = (*jenv)->GetObjectArrayElement(jenv, list,
		    i + offset);
		jobj = (*jenv)->GetObjectField(jenv, jlockreq, lockreq_obj_fid);
		jlock = (*jenv)->GetObjectField(jenv, jlockreq,
		    lockreq_lock_fid);
		(*jenv)->Throw(jenv,
		    (*jenv)->NewObject(jenv, lockex_class, lockex_construct,
		    (*jenv)->NewStringUTF(jenv, "DbEnv.lock_vec incomplete"),
		    lockreq[i].op, lockreq[i].mode, jobj, jlock, i, jdbenv));
	} else if (ret != 0)
		__dbj_throw(jenv, ret, NULL, NULL, jdbenv);

err:	for (i = 0, prereq = &lockreq[0]; i < count; i++, prereq++)
		if (prereq->op == DB_LOCK_GET_TIMEOUT ||
		    prereq->op == DB_LOCK_GET ||
		    prereq->op == DB_LOCK_PUT_OBJ) {
			jlockreq = (*jenv)->GetObjectArrayElement(jenv,
			    list, i + offset);
			jobj = (*jenv)->GetObjectField(jenv,
			    jlockreq, lockreq_obj_fid);
			__dbt_userfree(env, prereq->obj, NULL, NULL);
			__dbj_dbt_release(jenv, jobj, prereq->obj, &locked_dbts[i]);
	}
	if (locked_dbts != NULL)
		__os_free(env, locked_dbts);
	if (lockreq != NULL)
		__os_free(env, lockreq);
}


SWIGEXPORT void JNICALL
Java_com_sleepycat_db_internal_db_1javaJNI_DbTxn_1commit(JNIEnv *jenv,
    jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbTxn *txn = (struct DbTxn *) 0 ;
  DB_ENV *dbenv = (DB_ENV *) 0 ;
  DB_REP_STAT *rep_stat = (DB_REP_STAT *) 0 ;
  ENV *env = (ENV *) 0 ;
  u_int32_t flags;
  DB_TXN_TOKEN token;
  db_ret_t result;
  db_ret_t result1;
  db_ret_t result2;
  int is_nested, is_logging_enabled, is_rep_client, commit_token_enabled;
  
  (void)jcls;
  txn = *(struct DbTxn **)&jarg1; 
  flags = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
     __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
  return ;
  }

  /*
   * The Java API uses set_commit_token in a different way to the C API.
   * In Java a commit token is always generated, unless doing so would
   * generate an error from the C API.
   * The checks below are based on those in place in the implementation
   * of set_commit_token in the C API. It is invalid to set a commit
   * token for a subtransaction, or if logging is disabled, or on a rep
   * client node.
   */
  env = txn->mgrp->env;
  dbenv = env->dbenv;
  is_nested = (txn->parent != NULL);
  is_logging_enabled = env->lg_handle != NULL;
  /*
   * It is an illegal configuration to enable Java and disable statistics
   * or enable the small build, so Java should always have access to the
   * stat function.
   */
  is_rep_client = 0;
  if (env->rep_handle != NULL && env->rep_handle->region != NULL) {
    result2 = dbenv->rep_stat(dbenv, &rep_stat, 0);
    if (DB_RETOK_STD(result2)) {
      is_rep_client = (rep_stat->st_status == DB_REP_CLIENT);
      free(rep_stat);
    }
  }
  commit_token_enabled = (!is_nested && is_logging_enabled && !is_rep_client);

  if (commit_token_enabled) {
    result1 = (db_ret_t)txn->set_commit_token(txn, &token);
  }

  result = (db_ret_t)txn->commit(txn, flags);
  if (!DB_RETOK_STD(result)) {
     __dbj_throw(jenv, result, NULL, NULL, NULL);
  }

  /* 
   * Set the commit token in the Java Transaction class object only if 
   * the Core has generated a valid token for this transaction
   */
  if (commit_token_enabled && DB_RETOK_STD(result1)) {
     jbyteArray newarr = (*jenv)->NewByteArray(jenv, (jsize)DB_TXN_TOKEN_SIZE);
     if (newarr == NULL) {
        return; /* An exception is pending */
     }
     (*jenv)->SetByteArrayRegion(jenv, newarr, 0, (jsize)DB_TXN_TOKEN_SIZE,
        (jbyte *)&token);
     (*jenv)->SetObjectField(jenv, jarg1_, txn_commit_token, newarr);
  }
}


/*
 * These macros are used by code generated by the s_java script.
 */
#define JAVADB_STAT_INT(jenv, jobj, fid, statp, name)			\
		(*jenv)->SetIntField(jenv, jobj, fid, (jint)statp->name)

#define JAVADB_STAT_STRING(jenv, jobj, fid, statp, name)		\
		(*jenv)->SetObjectField(jenv, jobj, fid,		\
		    (*jenv)->NewStringUTF(jenv, statp->name))

#define JAVADB_STAT_LSN(jenv, jobj, fid, statp, name)			\
		(*jenv)->SetObjectField(jenv, jobj, fid,		\
		    __dbj_wrap_DB_LSN(jenv, &statp->name))

#define JAVADB_STAT_LONG(jenv, jobj, fid, statp, name)			\
		(*jenv)->SetLongField(jenv, jobj, fid,			\
		    (jlong)statp->name)

#define JAVADB_STAT_GID(jenv, jobj, fid, statp, name) {			\
	jobject jarr =							\
	    (*jenv)->NewByteArray(jenv, (jsize)DB_GID_SIZE);		\
	(*jenv)->SetByteArrayRegion(jenv, jarr,				\
	    0, (jsize)DB_GID_SIZE, (jbyte *)statp->name);		\
	(*jenv)->SetObjectField(jenv, jobj, fid, jarr);			\
	}

#define JAVADB_STAT_ACTIVE_SLICE(jenv, jobj, fid, statp, name, dbenv) {   \
	jobject jarr =							\
	    (*jenv)->NewIntArray(jenv, dbenv->slice_cnt);		\
	(*jenv)->SetIntArrayRegion(jenv, jarr,				\
	    0, dbenv->slice_cnt, (jint *)statp->name);			\
	(*jenv)->SetObjectField(jenv, jobj, fid, jarr);			\
	}

/*
 * We build the active list separately.
 */
#define JAVADB_STAT_ACTIVE(jenv, cl, jobj, statp, name) \
	do {} while(0)

#include "java_stat_auto.c"


static void __dbj_error(const DB_ENV *dbenv,
    const char *prefix, const char *msg)
{
	int detach;
	JNIEnv *jenv = __dbj_get_jnienv(&detach);
	jobject jdbenv = (jobject)DB_ENV_INTERNAL(dbenv);
	jobject jmsg;

	COMPQUIET(prefix, NULL);

	if (jdbenv != NULL){
		jmsg = (*jenv)->NewStringUTF(jenv, msg);
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv, dbenv_class,
		    errcall_method, jmsg);
		(*jenv)->DeleteLocalRef(jenv, jmsg);
	}

	if (detach)
		__dbj_detach();
}

static void __dbj_env_feedback(DB_ENV *dbenv, int opcode, int percent)
{
	int detach;
	JNIEnv *jenv = __dbj_get_jnienv(&detach);
	jobject jdbenv = (jobject)DB_ENV_INTERNAL(dbenv);

	if (jdbenv != NULL)
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv, dbenv_class,
		    env_feedback_method, opcode, percent);

	if (detach)
		__dbj_detach();
}

static void __dbj_message(const DB_ENV *dbenv,
    const char *prefix, const char *msg)
{
	int detach;
	JNIEnv *jenv = __dbj_get_jnienv(&detach);
	jobject jdbenv = (jobject)DB_ENV_INTERNAL(dbenv);
	jobject jmsg;

	COMPQUIET(prefix, NULL);

	if (jdbenv != NULL){
		jmsg = (*jenv)->NewStringUTF(jenv, msg);
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv, dbenv_class,
		    msgcall_method, jmsg);
		(*jenv)->DeleteLocalRef(jenv, jmsg);
	}

	if (detach)
		__dbj_detach();
}

static void __dbj_repmgr_msg_dispatch(DB_ENV *dbenv, DB_CHANNEL *chan, DBT *msgs, u_int32_t nmsgs, u_int32_t flags)
{
	int detach;
	JNIEnv *jenv = __dbj_get_jnienv(&detach);
	jobject jdbenv = (jobject)DB_ENV_INTERNAL(dbenv);
	jobject jdbt;
	jobjectArray jmsgs;
	jbyteArray jdbtarr;
	u_int32_t i;

	if (jdbenv == NULL)
		return;
	
	jmsgs = (*jenv)->NewObjectArray(jenv, nmsgs, dbt_class, NULL);
	if (jmsgs == NULL)
		goto err;
	for (i = 0; i < nmsgs; i++) {
		jdbt = (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
		__dbj_dbt_copyout(jenv, &(msgs[i]), &jdbtarr, jdbt);
		if (jdbt == NULL) {
			/* An exception is pending. */
			goto err;
		}
		(*jenv)->SetObjectArrayElement(jenv, jmsgs, i, jdbt);
	}
	
	(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv, dbenv_class, repmgr_msg_dispatch_method, chan, jmsgs, flags);
	
	(*jenv)->DeleteLocalRef(jenv, jdbt);
	(*jenv)->DeleteLocalRef(jenv, jdbtarr);
	(*jenv)->DeleteLocalRef(jenv, jmsgs);

err:	if (detach)
		__dbj_detach();
}

static void __dbj_panic(DB_ENV *dbenv, int ret)
{
	int detach;
	JNIEnv *jenv = __dbj_get_jnienv(&detach);
	jobject jdbenv = (jobject)DB_ENV_INTERNAL(dbenv);

	if (jdbenv != NULL)
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv, dbenv_class,
		    paniccall_method,
		    __dbj_get_except(jenv, ret, NULL, NULL, jdbenv));

	if (detach)
		__dbj_detach();
}

static int __dbj_app_dispatch(DB_ENV *dbenv,
    DBT *dbt, DB_LSN *lsn, db_recops recops)
{
	int detach;
	JNIEnv *jenv = __dbj_get_jnienv(&detach);
	jobject jdbenv = (jobject)DB_ENV_INTERNAL(dbenv);
	jobject jdbt, jlsn;
	jbyteArray jdbtarr;
	int ret;

	if (jdbenv == NULL) {
		ret = EINVAL;
		goto err;
	}

	jdbt = (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	__dbj_dbt_copyout(jenv, dbt, &jdbtarr, jdbt);
	if (jdbt == NULL) {
		ret = ENOMEM; /* An exception is pending */
		goto err;
	}

	jlsn = (lsn == NULL) ? NULL : __dbj_wrap_DB_LSN(jenv, lsn);

	ret = (*jenv)->CallNonvirtualIntMethod(jenv, jdbenv, dbenv_class,
	    app_dispatch_method, jdbt, jlsn, recops);

	if ((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		ret = EINVAL;
	}

	(*jenv)->DeleteLocalRef(jenv, jdbtarr);
	(*jenv)->DeleteLocalRef(jenv, jdbt);
	if (jlsn != NULL)
		(*jenv)->DeleteLocalRef(jenv, jlsn);

err:	if (detach)
		__dbj_detach();
	return (ret);
}

static void __dbj_event_notify(DB_ENV *dbenv, u_int32_t event_id, void * info)
{
	int detach;
	JNIEnv *jenv = __dbj_get_jnienv(&detach);
	jobject jdbenv = (jobject)DB_ENV_INTERNAL(dbenv);

	if (jdbenv == NULL)
		goto done;

	switch (event_id) {
	case DB_EVENT_PANIC:
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv,
		    dbenv_class, panic_event_notify_method);
		break;
	case DB_EVENT_REP_AUTOTAKEOVER_FAILED:
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv,
		    dbenv_class, rep_autotakeover_failed_event_notify_method);
		break;
	case DB_EVENT_REP_CLIENT:
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv,
		    dbenv_class, rep_client_event_notify_method);
		break;
	case DB_EVENT_REP_CONNECT_BROKEN:
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv,
		    dbenv_class, rep_connect_broken_event_notify_method);
		break;
	case DB_EVENT_REP_CONNECT_ESTD:
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv,
		    dbenv_class, rep_connect_established_event_notify_method);
		break;
	case DB_EVENT_REP_CONNECT_TRY_FAILED:
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv,
		    dbenv_class, rep_connect_try_failed_event_notify_method);
		break;
	case DB_EVENT_REP_DUPMASTER:
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv,
		    dbenv_class, rep_dupmaster_event_notify_method);
		break;
	case DB_EVENT_REP_ELECTED:
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv,
		    dbenv_class, rep_elected_event_notify_method);
		break;
	case DB_EVENT_REP_ELECTION_FAILED:
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv,
		    dbenv_class, rep_election_failed_event_notify_method);
		break;
	case DB_EVENT_REP_INIT_DONE:
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv,
		    dbenv_class, rep_init_done_event_notify_method);
		break;
	case DB_EVENT_REP_INQUEUE_FULL:
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv,
		    dbenv_class, rep_inqueue_full_event_notify_method);
		break;
	case DB_EVENT_REP_JOIN_FAILURE:
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv,
		    dbenv_class, rep_join_failure_event_notify_method);
		break;
	case DB_EVENT_REP_LOCAL_SITE_REMOVED:
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv,
		    dbenv_class, rep_local_site_removed_notify_method);
		break;
	case DB_EVENT_REP_MASTER:
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv,
		    dbenv_class, rep_master_event_notify_method);
		break;
	case DB_EVENT_REP_MASTER_FAILURE:
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv,
		    dbenv_class, rep_master_failure_event_notify_method);
		break;
	case DB_EVENT_REP_NEWMASTER:
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv,
		    dbenv_class, rep_new_master_event_notify_method, 
		    *(int*)info);
		break;
	case DB_EVENT_REP_PERM_FAILED:
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv,
		    dbenv_class, rep_perm_failed_event_notify_method);
		break;
	case DB_EVENT_REP_SITE_ADDED:
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv,
		    dbenv_class, rep_site_added_event_notify_method);
		break;
	case DB_EVENT_REP_SITE_REMOVED:
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv,
		    dbenv_class, rep_site_removed_event_notify_method);
		break;
	case DB_EVENT_REP_STARTUPDONE:
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv,
		    dbenv_class, rep_startup_done_event_notify_method);
		break;
	case DB_EVENT_WRITE_FAILED:
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdbenv,
		    dbenv_class, write_failed_event_notify_method, 
		    *(int*)info);
		break;
	default:
                dbenv->errx(dbenv, "Unhandled event callback in the Java API");
                DB_ASSERT(dbenv->env, 0);
	}

done:	if (detach)
		__dbj_detach();
}

static int __dbj_rep_transport(DB_ENV *dbenv,
    const DBT *control, const DBT *rec, const DB_LSN *lsn, int envid,
    u_int32_t flags)
{
	int detach;
	JNIEnv *jenv = __dbj_get_jnienv(&detach);
	jobject jdbenv = (jobject)DB_ENV_INTERNAL(dbenv);
	jobject jcontrol, jrec, jlsn;
	jbyteArray jcontrolarr, jrecarr;
	int ret;

	if (jdbenv == NULL) {
		ret = EINVAL;
		goto err;
	}

	jcontrol = (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	jrec = (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	if (jcontrol == NULL || jrec == NULL) {
		ret = ENOMEM; /* An exception is pending */
		goto err;
	}

	__dbj_dbt_copyout(jenv, control, &jcontrolarr, jcontrol);
	__dbj_dbt_copyout(jenv, rec, &jrecarr, jrec);
	jlsn = (lsn == NULL) ? NULL : __dbj_wrap_DB_LSN(jenv, (DB_LSN *)lsn);

	if (jcontrolarr == NULL || jrecarr == NULL) {
		ret = ENOMEM; /* An exception is pending */
		goto err;
	}

	ret = (*jenv)->CallNonvirtualIntMethod(jenv, jdbenv, dbenv_class,
	    rep_transport_method, jcontrol, jrec, jlsn, envid, flags);

	if ((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		ret = EINVAL;
	}

	(*jenv)->DeleteLocalRef(jenv, jrecarr);
	(*jenv)->DeleteLocalRef(jenv, jcontrolarr);
	(*jenv)->DeleteLocalRef(jenv, jrec);
	(*jenv)->DeleteLocalRef(jenv, jcontrol);
	if (jlsn != NULL)
		(*jenv)->DeleteLocalRef(jenv, jlsn);

err:	if (detach)
		__dbj_detach();
	return (ret);
}

static int __dbj_foreignkey_nullify(DB *db, 
    const DBT *key, DBT *data, const DBT *skey, int *changed)
{
	int detach;
	JNIEnv *jenv = __dbj_get_jnienv(&detach);
	DBT_LOCKED lresult;
	jobject jdb = (jobject)DB_INTERNAL(db);
	jobject jkey, jdata, jskey;
	jbyteArray jkeyarr, jdataarr, jskeyarr;
	jboolean jresult;
	int ret;

	if (jdb == NULL) {
		ret = EINVAL;
		goto err;
	}

	jkey = (key->app_data != NULL) ?
	    ((DBT_LOCKED *)key->app_data)->jdbt :
	    (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	jdata = (data->app_data != NULL) ?
	    ((DBT_LOCKED *)data->app_data)->jdbt :
	    (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	jskey = (skey->app_data != NULL) ?
	    ((DBT_LOCKED *)skey->app_data)->jdbt :
	    (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	if (jkey == NULL || jdata == NULL || jskey == NULL) {
		ret = ENOMEM; /* An exception is pending */
		goto err;
	}

	if (key->app_data == NULL) {
		__dbj_dbt_copyout(jenv, key, &jkeyarr, jkey);
		if (jkeyarr == NULL) {
			ret = ENOMEM; /* An exception is pending */
			goto err;
		}
	}
	if (data->app_data == NULL) {
		__dbj_dbt_copyout(jenv, data, &jdataarr, jdata);
		if (jdataarr == NULL) {
			ret = ENOMEM; /* An exception is pending */
			goto err;
		}
	}
	if (skey->app_data == NULL) {
		__dbj_dbt_copyout(jenv, skey, &jskeyarr, jskey);
		if (jskeyarr == NULL) {
			ret = ENOMEM; /* An exception is pending */
			goto err;
		}
	}

	jresult = (*jenv)->CallNonvirtualBooleanMethod(jenv, jdb, db_class, foreignkey_nullify_method, jkey, jdata, jskey);

	if ((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		ret = EINVAL;
		goto err;
	}

	if (jresult == JNI_FALSE)
		*changed = ret = 0;
	else{
		*changed = 1;
		/* copy jdata into data */
		if ((ret = __dbj_dbt_copyin(jenv, &lresult, NULL, jdata, 0)) != 0)
			goto err;
		if (lresult.dbt.size != 0){
			data->size = lresult.dbt.size;
			if ((ret = __os_umalloc(
			    NULL, data->size, &data->data)) != 0)
				goto err;
			if ((ret = __dbj_dbt_memcopy(&lresult.dbt, 0, 
			    data->data, data->size, DB_USERCOPY_GETDATA)) != 0)
				goto err;
			__dbj_dbt_release(jenv, jdata,  &lresult.dbt, &lresult);
			(*jenv)->DeleteLocalRef(jenv, lresult.jarr);
			F_SET(data, DB_DBT_APPMALLOC);
		} 
	}			

err:	if (key->app_data == NULL) {
		(*jenv)->DeleteLocalRef(jenv, jkeyarr);
		(*jenv)->DeleteLocalRef(jenv, jkey);
	}
	if (data->app_data == NULL) {
		(*jenv)->DeleteLocalRef(jenv, jdataarr);
		(*jenv)->DeleteLocalRef(jenv, jdata);
	}

	if (detach)
		__dbj_detach();
	return ret;
}

static int __dbj_seckey_create(DB *db,
    const DBT *key, const DBT *data, DBT *result)
{
	int detach;
	JNIEnv *jenv = __dbj_get_jnienv(&detach);
	jobject jdb = (jobject)DB_INTERNAL(db);
	jobject jkey, jdata, jresult;
	jobjectArray jskeys;
	jsize i, num_skeys;
	jbyteArray jkeyarr, jdataarr;
	DBT_LOCKED lresult;
	DBT *tresult;
	int ret;

	jskeys = NULL;
	jkeyarr = jdataarr = NULL;
	jkey = jdata = NULL;
	if (jdb == NULL) {
		ret = EINVAL;
		goto err;
	}

	jkey = (key->app_data != NULL) ?
	    ((DBT_LOCKED *)key->app_data)->jdbt :
	    (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	jdata = (data->app_data != NULL) ?
	    ((DBT_LOCKED *)data->app_data)->jdbt :
	    (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	if (jkey == NULL || jdata == NULL) {
		ret = ENOMEM; /* An exception is pending */
		goto err;
	}

	if (key->app_data == NULL) {
		__dbj_dbt_copyout(jenv, key, &jkeyarr, jkey);
		if (jkeyarr == NULL) {
			ret = ENOMEM; /* An exception is pending */
			goto err;
		}
	}
	if (data->app_data == NULL) {
		__dbj_dbt_copyout(jenv, data, &jdataarr, jdata);
		if (jdataarr == NULL) {
			ret = ENOMEM; /* An exception is pending */
			goto err;
		}
	}

	jskeys = (jobjectArray)(*jenv)->CallNonvirtualObjectMethod(jenv,
	    jdb, db_class, seckey_create_method, jkey, jdata);

	if (jskeys == NULL ||
	    (num_skeys = (*jenv)->GetArrayLength(jenv, jskeys)) == 0) {
		ret = DB_DONOTINDEX;
		goto err;
	} else if (num_skeys == 1) {
		memset(result, 0, sizeof (DBT));
		tresult = result;
	} else {
		if ((ret = __os_umalloc(db->env,
		    num_skeys * sizeof (DBT), &result->data)) != 0)
			goto err;
		memset(result->data, 0, num_skeys * sizeof (DBT));
		result->size = num_skeys;
		F_SET(result, DB_DBT_APPMALLOC | DB_DBT_MULTIPLE);
		tresult = (DBT *)result->data;
	}

	if ((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		ret = EINVAL;
		goto err;
	}

	for (i = 0; i < num_skeys; i++, tresult++) {
		jresult = (*jenv)->GetObjectArrayElement(jenv, jskeys, i);

		if ((ret =
		    __dbj_dbt_copyin(jenv, &lresult, NULL, jresult, 0)) != 0)
			goto err;

		if (lresult.dbt.size != 0) {
			/* If there's data, we need to take a copy of it.  */
			tresult->size = lresult.dbt.size;
			if ((ret = __os_umalloc(NULL,
			    tresult->size, &tresult->data)) != 0)
				goto err;
			if ((ret = __dbj_dbt_memcopy(&lresult.dbt, 0,
			    tresult->data, tresult->size,
			    DB_USERCOPY_GETDATA)) != 0)
				goto err;
			__dbj_dbt_release(jenv,
			    jresult, &lresult.dbt, &lresult);
			(*jenv)->DeleteLocalRef(jenv, lresult.jarr);
			F_SET(tresult, DB_DBT_APPMALLOC);
		}

		(*jenv)->DeleteLocalRef(jenv, jresult);
	}

err:	if (key->app_data == NULL) {
		(*jenv)->DeleteLocalRef(jenv, jkeyarr);
		(*jenv)->DeleteLocalRef(jenv, jkey);
	}
	if (data->app_data == NULL) {
		(*jenv)->DeleteLocalRef(jenv, jdataarr);
		(*jenv)->DeleteLocalRef(jenv, jdata);
	}
	if (jskeys != NULL) {
		(*jenv)->DeleteLocalRef(jenv, jskeys);
	}

	if (detach)
		__dbj_detach();
	return (ret);
}

static int __dbj_append_recno(DB *db, DBT *dbt, db_recno_t recno)
{
	int detach;
	JNIEnv *jenv = __dbj_get_jnienv(&detach);
	jobject jdb = (jobject)DB_INTERNAL(db);
	jobject jdbt;
	DBT_LOCKED lresult;
	jbyteArray jdbtarr;
	int ret;

	jdbtarr = NULL;
	jdbt = NULL;
	if (jdb == NULL) {
		ret = EINVAL;
		goto err;
	}

	/*
	 * The dbt we're passed will be from the application, but we can't
	 * just reuse it, since we will have already taken a copy of the data.
	 * Make a new DatabaseEntry object here for the callback.
	 */
	jdbt = (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
	if (jdbt == NULL) {
		ret = ENOMEM; /* An exception is pending */
		goto err;
	}

	__dbj_dbt_copyout(jenv, dbt, &jdbtarr, jdbt);
	if (jdbtarr == NULL) {
		ret = ENOMEM; /* An exception is pending */
		goto err;
	}

	ret = 0;
	(*jenv)->CallNonvirtualVoidMethod(jenv, jdb, db_class,
	    append_recno_method, jdbt, recno);

	if ((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		ret = EINVAL;
		goto err;
	}

	ret = __dbj_dbt_copyin(jenv, &lresult, NULL, jdbt, 0);
	memset(dbt, 0, sizeof (DBT));

	if (ret == 0 && lresult.dbt.size != 0) {
		/* If there's data, we need to take a copy of it.  */
		dbt->size = lresult.dbt.size;
		if ((ret =
		    __os_umalloc(NULL, dbt->size, &dbt->data)) != 0)
			goto err;
		if ((ret = __dbj_dbt_memcopy(&lresult.dbt, 0,
		    dbt->data, dbt->size,
		    DB_USERCOPY_GETDATA)) != 0)
			goto err;
		__dbj_dbt_release(jenv, jdbt, &lresult.dbt, &lresult);
		(*jenv)->DeleteLocalRef(jenv, lresult.jarr);
		F_SET(dbt, DB_DBT_APPMALLOC);
	}

err:	(*jenv)->DeleteLocalRef(jenv, jdbtarr);
	(*jenv)->DeleteLocalRef(jenv, jdbt);

	if (detach)
		__dbj_detach();
	return (ret);
}

/*
 * Shared by __dbj_bt_compare and __dbj_h_compare
 */
static int __dbj_am_compare(DB *db, const DBT *dbt1, const DBT *dbt2,
    jmethodID compare_method)
{
	int detach;
	JNIEnv *jenv = __dbj_get_jnienv(&detach);
	jobject jdb = (jobject)DB_INTERNAL(db);
	jbyteArray jdbtarr1, jdbtarr2;
	int ret;

	if (jdb == NULL) {
		ret = EINVAL;
		goto err;
	}

	if (dbt1->app_data != NULL)
		jdbtarr1 = ((DBT_LOCKED *)dbt1->app_data)->jarr;
	else {
		jdbtarr1 = (*jenv)->NewByteArray(jenv, (jsize)dbt1->size);
		if (jdbtarr1 == NULL) {
			ret = ENOMEM;
			goto err;
		}
		(*jenv)->SetByteArrayRegion(jenv, jdbtarr1, 0,
		    (jsize)dbt1->size, (jbyte *)dbt1->data);
	}

	if (dbt2->app_data != NULL)
		jdbtarr2 = ((DBT_LOCKED *)dbt2->app_data)->jarr;
	else {
		jdbtarr2 = (*jenv)->NewByteArray(jenv, (jsize)dbt2->size);
		if (jdbtarr2 == NULL) {
			ret = ENOMEM;
			goto err;
		}
		(*jenv)->SetByteArrayRegion(jenv, jdbtarr2, 0,
		    (jsize)dbt2->size, (jbyte *)dbt2->data);
	}

	ret = (int)(*jenv)->CallNonvirtualIntMethod(jenv, jdb, db_class,
	    compare_method, jdbtarr1, jdbtarr2);

	if ((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		ret = EINVAL;
	}

err:	if (dbt1->app_data == NULL)
		(*jenv)->DeleteLocalRef(jenv, jdbtarr1);
	if (dbt2->app_data == NULL)
		(*jenv)->DeleteLocalRef(jenv, jdbtarr2);

	if (detach)
		__dbj_detach();
	return (ret);
}

static int __dbj_bt_compare(DB *db,
    const DBT *dbt1, const DBT *dbt2, size_t *locp)
{
	if (locp != NULL)
		locp = NULL;
	return __dbj_am_compare(db, dbt1, dbt2, bt_compare_method);
}

#define DBT_COPYOUT(num) do {						\
	if (dbt##num->app_data != NULL)					\
		jdbt##num = ((DBT_LOCKED *)dbt##num->app_data)->jdbt;	\
	else {								\
		if ((jdbt##num = (*jenv)->NewObject(			\
		    jenv, dbt_class, dbt_construct)) == NULL) {		\
			ret = ENOMEM; /* An exception is pending */	\
			goto err;					\
		}							\
		__dbj_dbt_copyout(jenv, dbt##num, &jdbtarr##num, jdbt##num);\
		if (jdbtarr##num == NULL) {				\
			ret = ENOMEM; /* An exception is pending */	\
			goto err;					\
		}							\
	}								\
} while (0)

#define DBT_COPIED_FREE(num) do {					\
	if (dbt##num->app_data == NULL) {				\
		(*jenv)->DeleteLocalRef(jenv, jdbtarr##num);		\
		(*jenv)->DeleteLocalRef(jenv, jdbt##num);		\
	}								\
} while (0)

#define DBT_COPYIN_DATA(num) do {					\
	ret = __dbj_dbt_copyin(jenv, &lresult, NULL, jdbt##num, 0);	\
	/* Re-initialize the output DBT. Preserve app_data. */		\
	dbt##num->data = NULL;						\
	dbt##num->size = 0;						\
	dbt##num->ulen = 0;						\
	dbt##num->dlen = 0;						\
	dbt##num->doff = 0;						\
	dbt##num->flags = 0;						\
	if (ret == 0 && lresult.dbt.size != 0) {			\
		/* If there's data, we need to take a copy of it.  */	\
		dbt##num->size = lresult.dbt.size;			\
		if ((ret = __os_umalloc(				\
		    NULL, dbt##num->size, &dbt##num->data)) != 0)	\
			goto err;					\
		if ((ret = __dbj_dbt_memcopy(&lresult.dbt, 0,		\
		    dbt##num->data, dbt##num->size,			\
		    DB_USERCOPY_GETDATA)) != 0)				\
			goto err;					\
		__dbj_dbt_release(jenv, jdbt##num, &lresult.dbt, &lresult);\
		(*jenv)->DeleteLocalRef(jenv, lresult.jarr);		\
		F_SET(dbt##num, DB_DBT_APPMALLOC);			\
	}								\
} while (0)

static int __dbj_bt_compress(DB *db, const DBT *dbt1, const DBT *dbt2,
    const DBT *dbt3, const DBT *dbt4, DBT *dbt5)
{
	int detach;
	JNIEnv *jenv = __dbj_get_jnienv(&detach);
	jobject jdb = (jobject)DB_INTERNAL(db);
	jobject jdbt1, jdbt2, jdbt3, jdbt4, jdbt5;
	jbyteArray jdbtarr1, jdbtarr2, jdbtarr3, jdbtarr4, jdbtarr5;
	DBT_LOCKED lresult;
	int ret;

	if (jdb == NULL) {
		ret = EINVAL;
		goto err;
	}

	jdbt1 = jdbt2 = jdbt3 = jdbt4 = jdbt5 = NULL;

	DBT_COPYOUT(1);
	DBT_COPYOUT(2);
	DBT_COPYOUT(3);
	DBT_COPYOUT(4);
	DBT_COPYOUT(5);

	ret = (int)(*jenv)->CallNonvirtualIntMethod(jenv, jdb, db_class,
	    bt_compress_method, jdbt1, jdbt2, jdbt3, jdbt4, jdbt5);

	if ((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		ret = EINVAL;
		goto err;
	}

	DBT_COPYIN_DATA(5);

err:	DBT_COPIED_FREE(1);
	DBT_COPIED_FREE(2);
	DBT_COPIED_FREE(3);
	DBT_COPIED_FREE(4);
	DBT_COPIED_FREE(5);
	if (detach)
		__dbj_detach();
	return (ret);
}

static int __dbj_bt_decompress(DB *db, const DBT *dbt1, const DBT *dbt2,
    DBT *dbt3, DBT *dbt4, DBT *dbt5)
{
	int detach;
	JNIEnv *jenv = __dbj_get_jnienv(&detach);
	jobject jdb = (jobject)DB_INTERNAL(db);
	jobject jdbt1, jdbt2, jdbt3, jdbt4, jdbt5;
	jbyteArray jdbtarr1, jdbtarr2, jdbtarr3, jdbtarr4, jdbtarr5;
	DBT_LOCKED lresult;
	int ret;

	jdbt1 = jdbt2 = jdbt3 = jdbt4 = jdbt5 = NULL;

	if (jdb == NULL) {
		ret = EINVAL;
		goto err;
	}

	DBT_COPYOUT(1);
	DBT_COPYOUT(2);
	DBT_COPYOUT(3);
	DBT_COPYOUT(4);
	DBT_COPYOUT(5);

	ret = (int)(*jenv)->CallNonvirtualIntMethod(jenv, jdb, db_class,
	    bt_decompress_method, jdbt1, jdbt2, jdbt3, jdbt4, jdbt5);

	if ((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		ret = EINVAL;
		goto err;
	}

	DBT_COPYIN_DATA(3);
	DBT_COPYIN_DATA(4);
	DBT_COPYIN_DATA(5);

err:	DBT_COPIED_FREE(1);
	DBT_COPIED_FREE(2);
	DBT_COPIED_FREE(3);
	DBT_COPIED_FREE(4);
	DBT_COPIED_FREE(5);
	if (detach)
		__dbj_detach();
	return (ret);
}

static size_t __dbj_bt_prefix(DB *db, const DBT *dbt1, const DBT *dbt2)
{
	int detach;
	JNIEnv *jenv = __dbj_get_jnienv(&detach);
	jobject jdb = (jobject)DB_INTERNAL(db);
	jobject jdbt1, jdbt2;
	jbyteArray jdbtarr1, jdbtarr2;
	int ret;

	if (jdb == NULL) {
		ret = EINVAL;
		goto err;
	}

	if (dbt1->app_data != NULL)
		jdbt1 = ((DBT_LOCKED *)dbt1->app_data)->jdbt;
	else {
		if ((jdbt1 =
		    (*jenv)->NewObject(jenv, dbt_class, dbt_construct)) == NULL) {
			ret = ENOMEM; /* An exception is pending */
			goto err;
		}
		__dbj_dbt_copyout(jenv, dbt1, &jdbtarr1, jdbt1);
		if (jdbtarr1 == NULL) {
			ret = ENOMEM; /* An exception is pending */
			goto err;
		}
	}

	if (dbt2->app_data != NULL)
		jdbt2 = ((DBT_LOCKED *)dbt2->app_data)->jdbt;
	else {
		if ((jdbt2 =
		    (*jenv)->NewObject(jenv, dbt_class, dbt_construct)) == NULL) {
			ret = ENOMEM; /* An exception is pending */
			goto err;
		}
		__dbj_dbt_copyout(jenv, dbt2, &jdbtarr2, jdbt2);
		if (jdbtarr2 == NULL) {
			ret = ENOMEM; /* An exception is pending */
			goto err;
		}
	}

	ret = (int)(*jenv)->CallNonvirtualIntMethod(jenv, jdb, db_class,
	    bt_prefix_method, jdbt1, jdbt2);

err:	if (dbt1->app_data == NULL) {
		(*jenv)->DeleteLocalRef(jenv, jdbtarr1);
		(*jenv)->DeleteLocalRef(jenv, jdbt1);
	}
	if (dbt2->app_data == NULL) {
		(*jenv)->DeleteLocalRef(jenv, jdbtarr2);
		(*jenv)->DeleteLocalRef(jenv, jdbt2);
	}

	if (detach)
		__dbj_detach();
	return (ret);
}

static int __dbj_dup_compare(DB *db,
    const DBT *dbt1, const DBT *dbt2, size_t *locp)
{
	int detach;
	JNIEnv *jenv = __dbj_get_jnienv(&detach);
	jobject jdb = (jobject)DB_INTERNAL(db);
	jbyteArray jdbtarr1, jdbtarr2;
	int ret;

	if (locp != NULL)
		locp = NULL;
	if (jdb == NULL)
		return (EINVAL);

	jdbtarr1 = (*jenv)->NewByteArray(jenv, (jsize)dbt1->size);
	if (jdbtarr1 == NULL)
		return (ENOMEM);
	(*jenv)->SetByteArrayRegion(jenv, jdbtarr1, 0, (jsize)dbt1->size,
	    (jbyte *)dbt1->data);

	jdbtarr2 = (*jenv)->NewByteArray(jenv, (jsize)dbt2->size);
	if (jdbtarr2 == NULL)
		return (ENOMEM);
	(*jenv)->SetByteArrayRegion(jenv, jdbtarr2, 0, (jsize)dbt2->size,
	    (jbyte *)dbt2->data);

	ret = (int)(*jenv)->CallNonvirtualIntMethod(jenv, jdb, db_class,
	    dup_compare_method, jdbtarr1, jdbtarr2);

	if ((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		ret = EINVAL;
	}

	(*jenv)->DeleteLocalRef(jenv, jdbtarr2);
	(*jenv)->DeleteLocalRef(jenv, jdbtarr1);

	if (detach)
		__dbj_detach();
	return (ret);
}

static void __dbj_db_feedback(DB *db, int opcode, int percent)
{
	int detach;
	JNIEnv *jenv = __dbj_get_jnienv(&detach);
	jobject jdb = (jobject)DB_INTERNAL(db);

	if (jdb != NULL)
		(*jenv)->CallNonvirtualVoidMethod(jenv, jdb, db_class,
		    db_feedback_method, opcode, percent);

	if (detach)
		__dbj_detach();
}

static int __dbj_h_compare(DB *db,
    const DBT *dbt1, const DBT *dbt2, size_t *locp)
{
	if (locp != NULL)
		locp = NULL;
	return __dbj_am_compare(db, dbt1, dbt2, h_compare_method);
}

static u_int32_t __dbj_h_hash(DB *db, const void *data, u_int32_t len)
{
	int detach;
	JNIEnv *jenv = __dbj_get_jnienv(&detach);
	jobject jdb = (jobject)DB_INTERNAL(db);
	jbyteArray jarr = (*jenv)->NewByteArray(jenv, (jsize)len);
	int ret;

	if (jdb == NULL)
		return (EINVAL);

	if ((jarr = (*jenv)->NewByteArray(jenv, (jsize)len)) == NULL)
		return (ENOMEM); /* An exception is pending */

	(*jenv)->SetByteArrayRegion(jenv, jarr, 0, (jsize)len, (jbyte *)data);

	ret = (int)(*jenv)->CallNonvirtualIntMethod(jenv, jdb, db_class,
	    h_hash_method, jarr, len);

	(*jenv)->DeleteLocalRef(jenv, jarr);

	if (detach)
		__dbj_detach();
	return (ret);
}

static u_int32_t __dbj_partition(DB *db, DBT *dbt1)
{
	int detach, ret;
	JNIEnv *jenv = __dbj_get_jnienv(&detach);
	jobject jdb = (jobject)DB_INTERNAL(db);
	jobject jdbt1 = NULL;
	jbyteArray jdbtarr1;
	DBT_LOCKED lresult;

	DBT_COPYOUT(1);

	ret = (int)(*jenv)->CallNonvirtualIntMethod(jenv, jdb, db_class,
	    partition_method, jdbt1);
	if ((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		ret = EINVAL;
		goto err;
	}

	DBT_COPYIN_DATA(1);
err:	DBT_COPIED_FREE(1);

	if (detach)
		__dbj_detach();
	return (ret);
}

static int __dbj_backup_close(DB_ENV *dbenv, const char *dbname, void *handle) {
	int detach;
	JNIEnv *jenv = __dbj_get_jnienv(&detach);
	jobject jdbenv = (jobject)DB_ENV_INTERNAL(dbenv);
	jobject jdbname;
	int ret;

	COMPQUIET(handle, NULL);

	if (jdbenv == NULL) {
		ret = EINVAL;
		goto err;
	}

	jdbname = (*jenv)->NewStringUTF(jenv, dbname);
	ret = (*jenv)->CallNonvirtualIntMethod(jenv, jdbenv, dbenv_class, backup_close_method, jdbname);

	if ((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		ret = EINVAL;
	}

err:	if (detach)
		__dbj_detach();
	return (ret);
}

static int __dbj_backup_open(DB_ENV *dbenv, const char *target, const char *dbname, void **handle) {
	int detach;
	JNIEnv *jenv = __dbj_get_jnienv(&detach);
	jobject jdbenv = (jobject)DB_ENV_INTERNAL(dbenv);
	jobject jtarget, jdbname;
	int ret;

	COMPQUIET(handle, NULL);

	if (jdbenv == NULL) {
		ret = EINVAL;
		goto err;
	}

	jtarget = (*jenv)->NewStringUTF(jenv, target);
	jdbname = (*jenv)->NewStringUTF(jenv, dbname);
	ret = (*jenv)->CallNonvirtualIntMethod(jenv, jdbenv, dbenv_class, backup_open_method, jtarget, jdbname);

	if ((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		ret = EINVAL;
	}

err:	if (detach)
		__dbj_detach();
	return (ret);
}

static int __dbj_backup_write(DB_ENV *dbenv, u_int32_t file_pos_gbytes, u_int32_t file_pos_bytes, u_int32_t size, u_int8_t *buf, void *handle) {
	int detach;
	JNIEnv *jenv = __dbj_get_jnienv(&detach);
	jobject jdbenv = (jobject)DB_ENV_INTERNAL(dbenv);
	jbyteArray jarr;
	int ret;

	COMPQUIET(handle, NULL);

	if (jdbenv == NULL) {
		ret = EINVAL;
		goto err;
	}

	if ((jarr = (*jenv)->NewByteArray(jenv, (jsize)size)) == NULL) {
		/* An exception is pending. */
		ret = ENOMEM;
		goto err;
	}
	(*jenv)->SetByteArrayRegion(jenv, jarr, 0, (jsize)size, (jbyte *)buf);
	
	ret = (*jenv)->CallNonvirtualIntMethod(jenv, jdbenv, dbenv_class, backup_write_method, file_pos_gbytes, file_pos_bytes, size, jarr);
	(*jenv)->DeleteLocalRef(jenv, jarr);
	if ((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		ret = EINVAL;
	}

err:	if (detach)
		__dbj_detach();
	return (ret);
}

static int __dbj_rep_view(DB_ENV *dbenv, const char *name, int *result, u_int32_t flags) {
	int detach;
	JNIEnv *jenv = __dbj_get_jnienv(&detach);
	jobject jdbenv = (jobject)DB_ENV_INTERNAL(dbenv);
	jobject jname;
	jboolean jresult;
	int ret;

	if (jdbenv == NULL) {
		ret = EINVAL;
		goto err;
	}

	jname = (*jenv)->NewStringUTF(jenv, name);

	jresult = (*jenv)->CallNonvirtualBooleanMethod(jenv, jdbenv, dbenv_class, rep_view_method, jname, flags);

	if ((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		ret = EINVAL;
		goto err;
	}

	ret = 0;
	if (jresult == JNI_FALSE)
		*result = 0;
	else
		*result = 1;

err:	if (detach)
		__dbj_detach();
	return (ret);
}

static int __dbj_slice(const DB *db, const DBT *dbt1, DBT *dbt2)
{
	int detach;
	JNIEnv *jenv = __dbj_get_jnienv(&detach);
	jobject jdb = (jobject)DB_INTERNAL(db);
	jobject jdbt1, jdbt2;
	jbyteArray jdbtarr1, jdbtarr2;
	DBT_LOCKED lresult;
	int ret;

	if (jdb == NULL) {
		ret = EINVAL;
		goto err;
	}

	jdbt1 = jdbt2 = NULL;

	DBT_COPYOUT(1);
	DBT_COPYOUT(2);

	ret = (int)(*jenv)->CallNonvirtualIntMethod(jenv, jdb, db_class,
	    slice_method, jdbt1, jdbt2);

	if ((*jenv)->ExceptionOccurred(jenv)) {
		/* The exception will be thrown, so this could be any error. */
		ret = EINVAL;
		goto err;
	}

	DBT_COPYIN_DATA(2);

err:	DBT_COPIED_FREE(1);
	DBT_COPIED_FREE(2);
	if (detach)
		__dbj_detach();
	return (ret);
}


SWIGEXPORT jlong JNICALL
Java_com_sleepycat_db_internal_db_1javaJNI_initDbEnvRef0(
    JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
	DB_ENV *self = *(DB_ENV **)(void *)&jarg1;
	jlong ret;
	COMPQUIET(jcls, NULL);
	COMPQUIET(jarg1_, NULL);

	DB_ENV_INTERNAL(self) = (void *)(*jenv)->NewGlobalRef(jenv, jarg2);
	*(jobject *)(void *)&ret = (jobject)DB_ENV_INTERNAL(self);
	return (ret);
}

SWIGEXPORT jlong JNICALL
Java_com_sleepycat_db_internal_db_1javaJNI_initDbRef0(
    JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
	DB *self = *(DB **)(void *)&jarg1;
	jlong ret;
	COMPQUIET(jcls, NULL);
	COMPQUIET(jarg1_, NULL);

	DB_INTERNAL(self) = (void *)(*jenv)->NewGlobalRef(jenv, jarg2);
	*(jobject *)(void *)&ret = (jobject)DB_INTERNAL(self);
	return (ret);
}

SWIGEXPORT void JNICALL
Java_com_sleepycat_db_internal_db_1javaJNI_deleteRef0(
    JNIEnv *jenv, jclass jcls, jlong jarg1) {
	jobject jref = *(jobject *)(void *)&jarg1;
	COMPQUIET(jcls, NULL);

	if (jref != 0L)
		(*jenv)->DeleteGlobalRef(jenv, jref);
}

SWIGEXPORT jlong JNICALL
Java_com_sleepycat_db_internal_db_1javaJNI_getDbEnv0(
    JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
	DB *self = *(DB **)(void *)&jarg1;
	jlong ret;

	COMPQUIET(jenv, NULL);
	COMPQUIET(jcls, NULL);
	COMPQUIET(jarg1_, NULL);

	*(DB_ENV **)(void *)&ret = self->dbenv;
	return (ret);
}

SWIGEXPORT jboolean JNICALL
Java_com_sleepycat_db_internal_DbUtil_is_1big_1endian(
    JNIEnv *jenv, jclass clazz)
{
	COMPQUIET(jenv, NULL);
	COMPQUIET(clazz, NULL);

	return (__db_isbigendian() ? JNI_TRUE : JNI_FALSE);
}

SWIGINTERN struct Db *new_Db(DB_ENV *dbenv,u_int32_t flags){
		DB *self = NULL;
		errno = db_create(&self, dbenv, flags);
		if (errno == 0 && dbenv == NULL)
			self->env->dbt_usercopy = __dbj_dbt_memcopy;
		return self;
	}
SWIGINTERN db_ret_t Db_associate(struct Db *self,DB_TXN *txnid,DB *secondary,int (*callback)(DB *,DBT const *,DBT const *,DBT *),u_int32_t flags){
		return self->associate(self, txnid, secondary, callback, flags);
	}
SWIGINTERN db_ret_t Db_associate_foreign(struct Db *self,DB *primary,int (*callback)(DB *,DBT const *,DBT *,DBT const *,int *),u_int32_t flags){
		return self->associate_foreign(self, primary, callback, flags);
	}
SWIGINTERN db_ret_t Db_compact(struct Db *self,DB_TXN *txnid,DBT *start,DBT *stop,DB_COMPACT *c_data,u_int32_t flags,DBT *end){
		return self->compact(self, txnid, start, stop, c_data, flags,
		    end);
	}
SWIGINTERN int Db_close(struct Db *self,u_int32_t flags){
		errno = self->close(self, flags);
		return errno;
	}
SWIGINTERN DBC *Db_cursor(struct Db *self,DB_TXN *txnid,u_int32_t flags){
		DBC *cursorp = NULL;
		errno = self->cursor(self, txnid, &cursorp, flags);
		return cursorp;
	}
SWIGINTERN int Db_del(struct Db *self,DB_TXN *txnid,DBT *key,u_int32_t flags){
		return self->del(self, txnid, key, flags);
	}
SWIGINTERN void Db_err(struct Db *self,int ret,char const *message){
		self->err(self, ret, message);
	}
SWIGINTERN void Db_errx(struct Db *self,char const *message){
		self->errx(self, message);
	}
SWIGINTERN int Db_exists(struct Db *self,DB_TXN *txnid,DBT *key,u_int32_t flags){
		return self->exists(self, txnid, key, flags);
	}
SWIGINTERN int Db_get(struct Db *self,DB_TXN *txnid,DBT *key,DBT *data,u_int32_t flags){
		return self->get(self, txnid, key, data, flags);
	}
SWIGINTERN u_int32_t Db_get_assoc_flags(struct Db *self){
		u_int32_t ret = 0;
		errno = self->get_assoc_flags(self, &ret);
		return ret;
	}
SWIGINTERN char const *Db_get_blob_sub_dir(struct Db *self){
		const char *ret;
		errno = self->get_blob_sub_dir(self, &ret);
		return ret;
	}
SWIGINTERN int_bool Db_get_byteswapped(struct Db *self){
		int ret = 0;
		errno = self->get_byteswapped(self, &ret);
		return ret;
	}
SWIGINTERN jlong Db_get_cachesize(struct Db *self){
		u_int32_t gbytes = 0, bytes = 0;
		errno = self->get_cachesize(self, &gbytes, &bytes, NULL);
		return (jlong)gbytes * GIGABYTE + bytes;
	}
SWIGINTERN u_int32_t Db_get_cachesize_ncache(struct Db *self){
		int ret = 0;
		errno = self->get_cachesize(self, NULL, NULL, &ret);
		return ret;
	}
SWIGINTERN char const *Db_get_create_dir(struct Db *self){
		const char *ret;
		errno = self->get_create_dir(self, &ret);
		return ret;
	}
SWIGINTERN char const *Db_get_filename(struct Db *self){
		const char *ret = NULL;
		errno = self->get_dbname(self, &ret, NULL);
		return ret;
	}
SWIGINTERN char const *Db_get_dbname(struct Db *self){
		const char *ret = NULL;
		errno = self->get_dbname(self, NULL, &ret);
		return ret;
	}
SWIGINTERN u_int32_t Db_get_encrypt_flags(struct Db *self){
		u_int32_t ret = 0;
		CRYPTO_ONLY(errno = self->get_encrypt_flags(self, &ret))
		return ret;
	}
SWIGINTERN char const *Db_get_ext_file_dir(struct Db *self){
		const char *ret;
		errno = self->get_ext_file_dir(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t Db_get_ext_file_threshold(struct Db *self){
	  	u_int32_t ret = 0;
	  	errno = self->get_ext_file_threshold(self, &ret);
	  	return ret;
	}
SWIGINTERN u_int32_t Db_get_flags(struct Db *self){
		u_int32_t ret = 0;
		errno = self->get_flags(self, &ret);
		return ret;
	}
SWIGINTERN int Db_get_lk_exclusive(struct Db *self){
		int onoff = 0, nowait = 0;
		errno = self->get_lk_exclusive(self, &onoff, &nowait);
		return onoff ? nowait + 1 : 0;
	}
SWIGINTERN int Db_get_lorder(struct Db *self){
		int ret = 0;
		errno = self->get_lorder(self, &ret);
		return ret;
	}
SWIGINTERN DB_MPOOLFILE *Db_get_mpf(struct Db *self){
		errno = 0;
		return self->get_mpf(self);
	}
SWIGINTERN u_int32_t Db_get_open_flags(struct Db *self){
		u_int32_t ret = 0;
		errno = self->get_open_flags(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t Db_get_pagesize(struct Db *self){
		u_int32_t ret = 0;
		errno = self->get_pagesize(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t Db_get_bt_minkey(struct Db *self){
		u_int32_t ret = 0;
		errno = self->get_bt_minkey(self, &ret);
		return ret;
	}
SWIGINTERN jlong Db_get_heapsize(struct Db *self){
		u_int32_t gbytes = 0, bytes = 0;
		errno = self->get_heapsize(self, &gbytes, &bytes);
		return (jlong)gbytes * GIGABYTE + bytes;
	}
SWIGINTERN u_int32_t Db_get_heap_regionsize(struct Db *self){
		u_int32_t ret = 0;
		errno = self->get_heap_regionsize(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t Db_get_h_ffactor(struct Db *self){
		u_int32_t ret = 0;
		errno = self->get_h_ffactor(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t Db_get_h_nelem(struct Db *self){
		u_int32_t ret = 0;
		errno = self->get_h_nelem(self, &ret);
		return ret;
	}
SWIGINTERN int Db_get_re_delim(struct Db *self){
		int ret = 0;
		errno = self->get_re_delim(self, &ret);
		return ret;
	}
SWIGINTERN DB_CACHE_PRIORITY Db_get_priority(struct Db *self){
		DB_CACHE_PRIORITY ret;
		errno = self->get_priority(self, &ret);
		return ret;
	}
SWIGINTERN char const **Db_get_partition_dirs(struct Db *self){
		const char **ret;
		errno = self->get_partition_dirs(self, &ret);
		return ret;
	}
SWIGINTERN struct __dbt_arr Db_get_partition_keys(struct Db *self){
		struct __dbt_arr ret;
                u_int32_t len;
		errno = self->get_partition_keys(self, &len, &ret.arr_ptr);
                ret.len = (int)len;
		ret.len--;
		return ret;
	}
SWIGINTERN int Db_get_partition_parts(struct Db *self){
		u_int32_t ret = 0;
		errno = self->get_partition_keys(self, &ret, NULL);
                /* If not partitioned by range, check by callback. */
		if (ret == 0)
			errno = self->get_partition_callback(self, &ret, NULL);
		return ret;
	}
SWIGINTERN u_int32_t Db_get_re_len(struct Db *self){
		u_int32_t ret = 0;
		errno = self->get_re_len(self, &ret);
		return ret;
	}
SWIGINTERN int Db_get_re_pad(struct Db *self){
		int ret = 0;
		errno = self->get_re_pad(self, &ret);
		return ret;
	}
SWIGINTERN char const *Db_get_re_source(struct Db *self){
		const char *ret = NULL;
		errno = self->get_re_source(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t Db_get_q_extentsize(struct Db *self){
		u_int32_t ret = 0;
		errno = self->get_q_extentsize(self, &ret);
		return ret;
	}
SWIGINTERN int_bool Db_get_multiple(struct Db *self){
		return self->get_multiple(self);
	}
SWIGINTERN DB **Db_get_slices(struct Db *self){
		DB **dbps;
		u_int32_t i, count = 0;
		errno = self->get_slices(self, &dbps);
		if (errno == 0) {
		  	self->dbenv->get_slice_count(self->dbenv, &count);
			dbps[count] = NULL;
			for (i = 0; dbps[i] != NULL; i++)
			  	dbps[i]->env->dbt_usercopy = __dbj_dbt_memcopy;
		}
		return dbps;
	}
SWIGINTERN int_bool Db_get_transactional(struct Db *self){
		return self->get_transactional(self);
	}
SWIGINTERN DBTYPE Db_get_type(struct Db *self){
		DBTYPE type = (DBTYPE)0;
		errno = self->get_type(self, &type);
		return type;
	}
SWIGINTERN DBC *Db_join(struct Db *self,DBC **curslist,u_int32_t flags){
		DBC *dbcp = NULL;
		errno = self->join(self, curslist, &dbcp, flags);
		return dbcp;
	}
SWIGINTERN db_ret_t Db_key_range(struct Db *self,DB_TXN *txnid,DBT *key,DB_KEY_RANGE *key_range,u_int32_t flags){
		return self->key_range(self, txnid, key, key_range, flags);
	}
SWIGINTERN db_ret_t Db_open(struct Db *self,DB_TXN *txnid,char const *file,char const *database,DBTYPE type,u_int32_t flags,int mode){
		return self->open(self, txnid, file, database,
		    type, flags, mode);
	}
SWIGINTERN int Db_pget(struct Db *self,DB_TXN *txnid,DBT *key,DBT *pkey,DBT *data,u_int32_t flags){
		return self->pget(self, txnid, key, pkey, data, flags);
	}
SWIGINTERN int Db_put(struct Db *self,DB_TXN *txnid,DBT *key,DBT *db_put_data,u_int32_t flags){
		return self->put(self, txnid, key, db_put_data, flags);
	}
SWIGINTERN db_ret_t Db_remove(struct Db *self,char const *file,char const *database,u_int32_t flags){
		return self->remove(self, file, database, flags);
	}
SWIGINTERN db_ret_t Db_rename(struct Db *self,char const *file,char const *database,char const *newname,u_int32_t flags){
		return self->rename(self, file, database, newname, flags);
	}
SWIGINTERN db_ret_t Db_set_append_recno(struct Db *self,int (*db_append_recno_fcn)(DB *,DBT *,db_recno_t)){
		return self->set_append_recno(self, db_append_recno_fcn);
	}
SWIGINTERN db_ret_t Db_set_bt_compare(struct Db *self,int (*bt_compare_fcn)(DB *,DBT const *,DBT const *,size_t *)){
		return self->set_bt_compare(self, bt_compare_fcn);
	}
SWIGINTERN db_ret_t Db_set_bt_minkey(struct Db *self,u_int32_t bt_minkey){
		return self->set_bt_minkey(self, bt_minkey);
	}
SWIGINTERN db_ret_t Db_set_bt_compress(struct Db *self,int (*bt_compress_fcn)(DB *,DBT const *,DBT const *,DBT const *,DBT const *,DBT *),int (*bt_decompress_fcn)(DB *,DBT const *,DBT const *,DBT *,DBT *,DBT *)){
		return self->set_bt_compress(
		    self, bt_compress_fcn, bt_decompress_fcn);
	}
SWIGINTERN db_ret_t Db_set_bt_prefix(struct Db *self,size_t (*bt_prefix_fcn)(DB *,DBT const *,DBT const *)){
		return self->set_bt_prefix(self, bt_prefix_fcn);
	}
SWIGINTERN db_ret_t Db_set_cachesize(struct Db *self,jlong bytes,int ncache){
		return self->set_cachesize(self,
		    (u_int32_t)(bytes / GIGABYTE),
		    (u_int32_t)(bytes % GIGABYTE), ncache);
	}
SWIGINTERN db_ret_t Db_set_create_dir(struct Db *self,char const *dir){
		return self->set_create_dir(self, dir);
	}
SWIGINTERN db_ret_t Db_set_dup_compare(struct Db *self,int (*dup_compare_fcn)(DB *,DBT const *,DBT const *,size_t *)){
		return self->set_dup_compare(self, dup_compare_fcn);
	}
SWIGINTERN db_ret_t Db_set_encrypt(struct Db *self,char const *passwd,u_int32_t flags){
		return self->set_encrypt(self, passwd, flags);
	}
SWIGINTERN db_ret_t Db_set_ext_file_dir(struct Db *self,char const *dir){
		return self->set_ext_file_dir(self, dir);
	}
SWIGINTERN db_ret_t Db_set_ext_file_threshold(struct Db *self,u_int32_t bytes,u_int32_t flags){
		return self->set_ext_file_threshold(self, bytes, flags);
	}
SWIGINTERN db_ret_t Db_set_feedback(struct Db *self,void (*db_feedback_fcn)(DB *,int,int)){
		return self->set_feedback(self, db_feedback_fcn);
	}
SWIGINTERN db_ret_t Db_set_flags(struct Db *self,u_int32_t flags){
		return self->set_flags(self, flags);
	}
SWIGINTERN db_ret_t Db_set_heapsize(struct Db *self,jlong bytes){
		return self->set_heapsize(self,
		    (u_int32_t)(bytes / GIGABYTE),
		    (u_int32_t)(bytes % GIGABYTE), 0);
	}
SWIGINTERN db_ret_t Db_set_heap_regionsize(struct Db *self,u_int32_t npages){
		return self->set_heap_regionsize(self, npages);
	}
SWIGINTERN db_ret_t Db_set_h_compare(struct Db *self,int (*h_compare_fcn)(DB *,DBT const *,DBT const *,size_t *)){
		return self->set_h_compare(self, h_compare_fcn);
	}
SWIGINTERN db_ret_t Db_set_h_ffactor(struct Db *self,u_int32_t h_ffactor){
		return self->set_h_ffactor(self, h_ffactor);
	}
SWIGINTERN db_ret_t Db_set_h_hash(struct Db *self,u_int32_t (*h_hash_fcn)(DB *,void const *,u_int32_t)){
		return self->set_h_hash(self, h_hash_fcn);
	}
SWIGINTERN db_ret_t Db_set_h_nelem(struct Db *self,u_int32_t h_nelem){
		return self->set_h_nelem(self, h_nelem);
	}
SWIGINTERN db_ret_t Db_set_lk_exclusive(struct Db *self,int nowait){
		return self->set_lk_exclusive(self, nowait);
	}
SWIGINTERN db_ret_t Db_set_lorder(struct Db *self,int lorder){
		return self->set_lorder(self, lorder);
	}
SWIGINTERN int Db_set_msgfile(struct Db *self,char const *msgfile){
		int ret;
		FILE *fmsg;
		ret = 0;
		fmsg = NULL;
		self->get_msgfile(self, &fmsg);
		if (fmsg != NULL && fmsg != stdout && fmsg != stderr) {
			fclose(fmsg);
			fmsg = NULL;
		}
		if (strcmp(msgfile, "") == 0 || msgfile == NULL)
			self->set_msgfile(self, NULL);
		else if (strcmp(msgfile, "stdout") == 0)
			self->set_msgfile(self, stdout);
		else if (strcmp(msgfile, "stderr") == 0)
			self->set_msgfile(self, stderr);
		else {
			fmsg = fopen(msgfile, "a");
			if (fmsg != NULL) {
				self->set_msgfile(self, fmsg);
			}
			else
				ret = 1;
		}
		return ret;
	}
SWIGINTERN db_ret_t Db_set_pagesize(struct Db *self,u_int32_t pagesize){
		return self->set_pagesize(self, pagesize);
	}
SWIGINTERN db_ret_t Db_set_partition(struct Db *self,u_int32_t parts,DBT *keys,u_int32_t (*db_partition_fcn)(DB *,DBT *)){
		return self->set_partition(self, parts, keys, db_partition_fcn);
	}
SWIGINTERN db_ret_t Db_set_partition_dirs(struct Db *self,char const **dirp){
		return self->set_partition_dirs(self, dirp);
	}
SWIGINTERN db_ret_t Db_set_priority(struct Db *self,DB_CACHE_PRIORITY priority){
		return self->set_priority(self, priority);
	}
SWIGINTERN db_ret_t Db_set_re_delim(struct Db *self,int re_delim){
		return self->set_re_delim(self, re_delim);
	}
SWIGINTERN db_ret_t Db_set_re_len(struct Db *self,u_int32_t re_len){
		return self->set_re_len(self, re_len);
	}
SWIGINTERN db_ret_t Db_set_re_pad(struct Db *self,int re_pad){
		return self->set_re_pad(self, re_pad);
	}
SWIGINTERN db_ret_t Db_set_re_source(struct Db *self,char *source){
		return self->set_re_source(self, source);
	}
SWIGINTERN db_ret_t Db_set_q_extentsize(struct Db *self,u_int32_t extentsize){
		return self->set_q_extentsize(self, extentsize);
	}
SWIGINTERN db_ret_t Db_set_slice_callback(struct Db *self,int (*slice_fcn)(DB const *,DBT const *,DBT *)){
		return self->set_slice_callback(self, slice_fcn);
	}
SWIGINTERN DB *Db_slice_lookup(struct Db *self,DBT const *key,u_int32_t flags){
		DB *slice = NULL;
		errno = self->slice_lookup(self, key, &slice, flags);
		if (slice != NULL)
			slice->env->dbt_usercopy = __dbj_dbt_memcopy;
		return slice;
	}
SWIGINTERN db_ret_t Db_sort_multiple(struct Db *self,DBT *key,DBT *data){
		return self->sort_multiple(self, key, data, 0);
	}
SWIGINTERN void *Db_stat(struct Db *self,DB_TXN *txnid,u_int32_t flags){
		void *statp = NULL;
		errno = self->stat(self, txnid, &statp, flags);
		return statp;
	}
SWIGINTERN int Db_stat_print(struct Db *self,u_int32_t flags){
		return self->stat_print(self, flags);
	}
SWIGINTERN db_ret_t Db_sync(struct Db *self,u_int32_t flags){
		return self->sync(self, flags);
	}
SWIGINTERN int Db_truncate(struct Db *self,DB_TXN *txnid,u_int32_t flags){
		u_int32_t count = 0;
		errno = self->truncate(self, txnid, &count, flags);
		return count;
	}
SWIGINTERN db_ret_t Db_upgrade(struct Db *self,char const *file,u_int32_t flags){
		return self->upgrade(self, file, flags);
	}
SWIGINTERN int_bool Db_verify(struct Db *self,char const *file,char const *database,struct __db_out_stream outfile,u_int32_t flags){
		/*
		 * We can't easily #include "dbinc/db_ext.h" because of name
		 * clashes, so we declare this explicitly.
		 */
		extern int __db_verify_internal __P((DB *, const char *, const
		    char *, void *, int (*)(void *, const void *), u_int32_t));
		errno = __db_verify_internal(self, file, database,
		    outfile.handle, outfile.callback, flags);
		if (errno == DB_VERIFY_BAD) {
			errno = 0;
			return 0;
		} else
			return 1;
	}
SWIGINTERN db_ret_t Dbc_close(struct Dbc *self){
		return self->close(self);
	}
SWIGINTERN int Dbc_cmp(struct Dbc *self,DBC *odbc,u_int32_t flags){
		int result = 0;
		errno = self->cmp(self, odbc, &result, flags);
		return result;
	}
SWIGINTERN db_recno_t Dbc_count(struct Dbc *self,u_int32_t flags){
		db_recno_t count = 0;
		errno = self->count(self, &count, flags);
		return count;
	}
SWIGINTERN DB_STREAM *Dbc_db_stream(struct Dbc *self,u_int32_t flags){
		DB_STREAM *dbsp = NULL;
		errno = self->db_stream(self, &dbsp, flags);
		return dbsp;
	}
SWIGINTERN int Dbc_del(struct Dbc *self,u_int32_t flags){
		return self->del(self, flags);
	}
SWIGINTERN DBC *Dbc_dup(struct Dbc *self,u_int32_t flags){
		DBC *newcurs = NULL;
		errno = self->dup(self, &newcurs, flags);
		return newcurs;
	}
SWIGINTERN int Dbc_get(struct Dbc *self,DBT *key,DBT *data,u_int32_t flags){
		return self->get(self, key, data, flags);
	}
SWIGINTERN DB_CACHE_PRIORITY Dbc_get_priority(struct Dbc *self){
		DB_CACHE_PRIORITY ret;
		errno = self->get_priority(self, &ret);
		return ret;
	}
SWIGINTERN int Dbc_pget(struct Dbc *self,DBT *key,DBT *pkey,DBT *data,u_int32_t flags){
		return self->pget(self, key, pkey, data, flags);
	}
SWIGINTERN int Dbc_put(struct Dbc *self,DBT *key,DBT *db_put_data,u_int32_t flags){
		return self->put(self, key, db_put_data, flags);
	}
SWIGINTERN db_ret_t Dbc_set_priority(struct Dbc *self,DB_CACHE_PRIORITY priority){
		return self->set_priority(self, priority);
	}
SWIGINTERN struct DbEnv *new_DbEnv(u_int32_t flags){
		DB_ENV *self = NULL;
		errno = db_env_create(&self, flags);
		if (errno == 0)
			self->env->dbt_usercopy = __dbj_dbt_memcopy;
		return self;
	}
SWIGINTERN db_ret_t DbEnv_close(struct DbEnv *self,u_int32_t flags){
		return self->close(self, flags);
	}
SWIGINTERN db_ret_t DbEnv_dbremove(struct DbEnv *self,DB_TXN *txnid,char const *file,char const *database,u_int32_t flags){
		return self->dbremove(self, txnid, file, database, flags);
	}
SWIGINTERN db_ret_t DbEnv_dbrename(struct DbEnv *self,DB_TXN *txnid,char const *file,char const *database,char const *newname,u_int32_t flags){
		return self->dbrename(self,
		    txnid, file, database, newname, flags);
	}
SWIGINTERN void DbEnv_err(struct DbEnv *self,int ret,char const *message){
		self->err(self, ret, message);
	}
SWIGINTERN void DbEnv_errx(struct DbEnv *self,char const *message){
		self->errx(self, message);
	}
SWIGINTERN DB_ENV **DbEnv_get_slices(struct DbEnv *self){
		DB_ENV **slices = NULL;
		int i;
		errno = self->get_slices(self, &slices);
		if (slices != NULL) {
		  	for (i = 0; slices[i] != NULL; i++)
				slices[i]->env->dbt_usercopy = __dbj_dbt_memcopy;
		}
		return slices;
	}
SWIGINTERN DB_TXN *DbEnv_cdsgroup_begin(struct DbEnv *self){
		DB_TXN *tid = NULL;
		errno = self->cdsgroup_begin(self, &tid);
		return tid;
	}
SWIGINTERN db_ret_t DbEnv_fileid_reset(struct DbEnv *self,char const *file,u_int32_t flags){
		return self->fileid_reset(self, file, flags);
	}
SWIGINTERN char const **DbEnv_get_data_dirs(struct DbEnv *self){
		const char **ret;
		errno = self->get_data_dirs(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_get_encrypt_flags(struct DbEnv *self){
		u_int32_t ret = 0;
		CRYPTO_ONLY(errno = self->get_encrypt_flags(self, &ret))
		return ret;
	}
SWIGINTERN char const *DbEnv_get_ext_file_dir(struct DbEnv *self){
		const char *ret;
		errno = self->get_ext_file_dir(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_get_ext_file_threshold(struct DbEnv *self){
		u_int32_t ret;
		errno = self->get_ext_file_threshold(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_get_flags(struct DbEnv *self){
		u_int32_t ret;
		errno = self->get_flags(self, &ret);
		return ret;
	}
SWIGINTERN char const *DbEnv_get_home(struct DbEnv *self){
		const char *ret;
		errno = self->get_home(self, &ret);
		return ret;
	}
SWIGINTERN char const *DbEnv_get_intermediate_dir_mode(struct DbEnv *self){
		const char *ret;
		errno = self->get_intermediate_dir_mode(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_get_open_flags(struct DbEnv *self){
		u_int32_t ret;
		errno = self->get_open_flags(self, &ret);
		return ret;
	}
SWIGINTERN char const *DbEnv_get_metadata_dir(struct DbEnv *self){
		const char *ret;
		errno = self->get_metadata_dir(self, &ret);
		return ret;
	
}
SWIGINTERN long DbEnv_get_shm_key(struct DbEnv *self){
		long ret;
		errno = self->get_shm_key(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_get_slice_count(struct DbEnv *self){
		u_int32_t ret;
		errno = self->get_slice_count(self, &ret);
		return ret;
	}
SWIGINTERN char const *DbEnv_get_tmp_dir(struct DbEnv *self){
		const char *ret;
		errno = self->get_tmp_dir(self, &ret);
		return ret;
	}
SWIGINTERN int_bool DbEnv_get_verbose(struct DbEnv *self,u_int32_t which){
		int ret;
		errno = self->get_verbose(self, which, &ret);
		return ret;
	}
SWIGINTERN int_bool DbEnv_is_bigendian(struct DbEnv *self){
		return self->is_bigendian();
	}
SWIGINTERN db_ret_t DbEnv_lsn_reset(struct DbEnv *self,char const *file,u_int32_t flags){
		return self->lsn_reset(self, file, flags);
	}
SWIGINTERN db_ret_t DbEnv_open(struct DbEnv *self,char const *db_home,u_int32_t flags,int mode){
		return self->open(self, db_home, flags, mode);
	}
SWIGINTERN db_ret_t DbEnv_remove(struct DbEnv *self,char const *db_home,u_int32_t flags){
		return self->remove(self, db_home, flags);
	}
SWIGINTERN db_ret_t DbEnv_set_cachesize(struct DbEnv *self,jlong bytes,int ncache){
		return self->set_cachesize(self,
		    (u_int32_t)(bytes / GIGABYTE),
		    (u_int32_t)(bytes % GIGABYTE), ncache);
	}
SWIGINTERN db_ret_t DbEnv_set_cache_max(struct DbEnv *self,jlong bytes){
		return self->set_cache_max(self,
		    (u_int32_t)(bytes / GIGABYTE),
		    (u_int32_t)(bytes % GIGABYTE));
	}
SWIGINTERN db_ret_t DbEnv_set_create_dir(struct DbEnv *self,char const *dir){
		return self->set_create_dir(self, dir);
	}
SWIGINTERN db_ret_t DbEnv_add_data_dir(struct DbEnv *self,char const *dir){
		return self->add_data_dir(self, dir);
	}
SWIGINTERN db_ret_t DbEnv_set_intermediate_dir_mode(struct DbEnv *self,char const *mode){
		return self->set_intermediate_dir_mode(self, mode);
	}
SWIGINTERN db_ret_t DbEnv_set_encrypt(struct DbEnv *self,char const *passwd,u_int32_t flags){
		return self->set_encrypt(self, passwd, flags);
	}
SWIGINTERN void DbEnv_set_errcall(struct DbEnv *self,void (*db_errcall_fcn)(DB_ENV const *,char const *,char const *)){
		self->set_errcall(self, db_errcall_fcn);
	}
SWIGINTERN db_ret_t DbEnv_set_ext_file_dir(struct DbEnv *self,char const *dir){
		return self->set_ext_file_dir(self, dir);
	}
SWIGINTERN db_ret_t DbEnv_set_ext_file_threshold(struct DbEnv *self,u_int32_t bytes,u_int32_t flags){
		return self->set_ext_file_threshold(self, bytes, flags);
	}
SWIGINTERN db_ret_t DbEnv_set_flags(struct DbEnv *self,u_int32_t flags,int_bool onoff){
		return self->set_flags(self, flags, onoff);
	}
SWIGINTERN db_ret_t DbEnv_set_feedback(struct DbEnv *self,void (*env_feedback_fcn)(DB_ENV *,int,int)){
		return self->set_feedback(self, env_feedback_fcn);
	}
SWIGINTERN db_ret_t DbEnv_set_metadata_dir(struct DbEnv *self,char const *dir){
		return self->set_metadata_dir(self, dir);
	}
SWIGINTERN db_ret_t DbEnv_set_mp_max_openfd(struct DbEnv *self,int maxopenfd){
		return self->set_mp_max_openfd(self, maxopenfd);
	}
SWIGINTERN db_ret_t DbEnv_set_mp_max_write(struct DbEnv *self,int maxwrite,db_timeout_t maxwrite_sleep){
		return self->set_mp_max_write(self, maxwrite, maxwrite_sleep);
	}
SWIGINTERN db_ret_t DbEnv_set_mp_mmapsize(struct DbEnv *self,size_t mp_mmapsize){
		return self->set_mp_mmapsize(self, mp_mmapsize);
	}
SWIGINTERN db_ret_t DbEnv_set_mp_pagesize(struct DbEnv *self,u_int32_t mp_pagesize){
		return self->set_mp_pagesize(self, mp_pagesize);
	}
SWIGINTERN db_ret_t DbEnv_set_mp_tablesize(struct DbEnv *self,u_int32_t mp_tablesize){
		return self->set_mp_tablesize(self, mp_tablesize);
	}
SWIGINTERN void DbEnv_set_msgcall(struct DbEnv *self,void (*db_msgcall_fcn)(DB_ENV const *,char const *,char const *)){
		self->set_msgcall(self, db_msgcall_fcn);
	}
SWIGINTERN int DbEnv_set_msgfile(struct DbEnv *self,char const *msgfile){
		int ret;
		FILE *fmsg;
		ret = 0;
		fmsg = NULL;
		self->get_msgfile(self, &fmsg);
		if (fmsg != NULL && fmsg != stdout && fmsg != stderr) {
			fclose(fmsg);
			fmsg = NULL;
		}
		if (strcmp(msgfile, "") == 0 || msgfile == NULL)
			self->set_msgfile(self, NULL);
		else if (strcmp(msgfile, "stdout") == 0)
			self->set_msgfile(self, stdout);
		else if (strcmp(msgfile, "stderr") == 0)
			self->set_msgfile(self, stderr);
		else {
			fmsg = fopen(msgfile, "a");
			if (fmsg != NULL) {
				self->set_msgfile(self, fmsg);
			}
			else
				ret = 1;
		}
		return ret;
	}
SWIGINTERN db_ret_t DbEnv_set_paniccall(struct DbEnv *self,void (*db_panic_fcn)(DB_ENV *,int)){
		return self->set_paniccall(self, db_panic_fcn);
	}
SWIGINTERN db_ret_t DbEnv_set_shm_key(struct DbEnv *self,long shm_key){
		return self->set_shm_key(self, shm_key);
	}
SWIGINTERN db_ret_t DbEnv_set_timeout(struct DbEnv *self,db_timeout_t timeout,u_int32_t flags){
		return self->set_timeout(self, timeout, flags);
	}
SWIGINTERN db_ret_t DbEnv_set_tmp_dir(struct DbEnv *self,char const *dir){
		return self->set_tmp_dir(self, dir);
	}
SWIGINTERN db_ret_t DbEnv_set_tx_max(struct DbEnv *self,u_int32_t max){
		return self->set_tx_max(self, max);
	}
SWIGINTERN db_ret_t DbEnv_set_app_dispatch(struct DbEnv *self,int (*tx_recover)(DB_ENV *,DBT *,DB_LSN *,db_recops)){
		return self->set_app_dispatch(self, tx_recover);
	}
SWIGINTERN db_ret_t DbEnv_set_event_notify(struct DbEnv *self,void (*event_notify)(DB_ENV *,u_int32_t,void *)){
		return self->set_event_notify(self, event_notify);
	}
SWIGINTERN db_ret_t DbEnv_set_tx_timestamp(struct DbEnv *self,time_t *timestamp){
		return self->set_tx_timestamp(self, timestamp);
	}
SWIGINTERN db_ret_t DbEnv_set_verbose(struct DbEnv *self,u_int32_t which,int_bool onoff){
		return self->set_verbose(self, which, onoff);
	}
SWIGINTERN struct __db_lk_conflicts DbEnv_get_lk_conflicts(struct DbEnv *self){
		struct __db_lk_conflicts ret;
		errno = self->get_lk_conflicts(self,
		    (const u_int8_t **)&ret.lk_conflicts, &ret.lk_modes);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_get_lk_detect(struct DbEnv *self){
		u_int32_t ret;
		errno = self->get_lk_detect(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_get_lk_max_locks(struct DbEnv *self){
		u_int32_t ret;
		errno = self->get_lk_max_locks(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_get_lk_max_lockers(struct DbEnv *self){
		u_int32_t ret;
		errno = self->get_lk_max_lockers(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_get_lk_max_objects(struct DbEnv *self){
		u_int32_t ret;
		errno = self->get_lk_max_objects(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_get_lk_partitions(struct DbEnv *self){
		u_int32_t ret;
		errno = self->get_lk_partitions(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_get_lk_priority(struct DbEnv *self,u_int32_t lockerid){
		u_int32_t ret;
		errno = self->get_lk_priority(self, lockerid, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_get_lk_tablesize(struct DbEnv *self){
		u_int32_t ret;
		errno = self->get_lk_tablesize(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_get_memory_init(struct DbEnv *self,u_int32_t config_type){
		u_int32_t ret;
		errno = self->get_memory_init(self, (DB_MEM_CONFIG)config_type, &ret);
		return ret;
	}
SWIGINTERN jlong DbEnv_get_memory_max(struct DbEnv *self){
		u_int32_t gbytes, bytes;
		errno = self->get_memory_max(self, &gbytes, &bytes);
		return (jlong)gbytes * GIGABYTE + bytes;
	}
SWIGINTERN int DbEnv_lock_detect(struct DbEnv *self,u_int32_t flags,u_int32_t atype){
		int aborted;
		errno = self->lock_detect(self, flags, atype, &aborted);
		return aborted;
	}
SWIGINTERN DB_LOCK *DbEnv_lock_get(struct DbEnv *self,u_int32_t locker,u_int32_t flags,DBT *object,db_lockmode_t lock_mode){
		DB_LOCK *lock = NULL;
		if ((errno = __os_malloc(self->env, sizeof (DB_LOCK), &lock)) == 0)
			errno = self->lock_get(self, locker, flags, object,
			    lock_mode, lock);
		return lock;
	}
SWIGINTERN u_int32_t DbEnv_lock_id(struct DbEnv *self){
		u_int32_t id;
		errno = self->lock_id(self, &id);
		return id;
	}
SWIGINTERN db_ret_t DbEnv_lock_id_free(struct DbEnv *self,u_int32_t id){
		return self->lock_id_free(self, id);
	}
SWIGINTERN db_ret_t DbEnv_lock_put(struct DbEnv *self,DB_LOCK *lock){
		return self->lock_put(self, lock);
	}
SWIGINTERN DB_LOCK_STAT *DbEnv_lock_stat(struct DbEnv *self,u_int32_t flags){
		DB_LOCK_STAT *statp = NULL;
		errno = self->lock_stat(self, &statp, flags);
		return statp;
	}
SWIGINTERN int DbEnv_lock_stat_print(struct DbEnv *self,u_int32_t flags){
		return self->lock_stat_print(self, flags);
	}
SWIGINTERN db_ret_t DbEnv_set_lk_conflicts(struct DbEnv *self,struct __db_lk_conflicts conflicts){
		return self->set_lk_conflicts(self,
		    conflicts.lk_conflicts, conflicts.lk_modes);
	}
SWIGINTERN db_ret_t DbEnv_set_lk_detect(struct DbEnv *self,u_int32_t detect){
		return self->set_lk_detect(self, detect);
	}
SWIGINTERN db_ret_t DbEnv_set_lk_max_lockers(struct DbEnv *self,u_int32_t max){
		return self->set_lk_max_lockers(self, max);
	}
SWIGINTERN db_ret_t DbEnv_set_lk_max_locks(struct DbEnv *self,u_int32_t max){
		return self->set_lk_max_locks(self, max);
	}
SWIGINTERN db_ret_t DbEnv_set_lk_max_objects(struct DbEnv *self,u_int32_t max){
		return self->set_lk_max_objects(self, max);
	}
SWIGINTERN db_ret_t DbEnv_set_lk_partitions(struct DbEnv *self,u_int32_t partitions){
		return self->set_lk_partitions(self, partitions);
	}
SWIGINTERN db_ret_t DbEnv_set_lk_priority(struct DbEnv *self,u_int32_t lockerid,u_int32_t priority){
		return self->set_lk_priority(self, lockerid, priority);
	}
SWIGINTERN db_ret_t DbEnv_set_lk_tablesize(struct DbEnv *self,u_int32_t size){
		return self->set_lk_tablesize(self, size);
	}
SWIGINTERN db_ret_t DbEnv_set_memory_init(struct DbEnv *self,u_int32_t config_type,u_int32_t value){
		return self->set_memory_init(self, (DB_MEM_CONFIG)config_type, value);
	}
SWIGINTERN db_ret_t DbEnv_set_memory_max(struct DbEnv *self,jlong bytes){
		return self->set_memory_max(self,
		    (u_int32_t)(bytes / GIGABYTE),
		    (u_int32_t)(bytes % GIGABYTE));
	}
SWIGINTERN u_int32_t DbEnv_get_lg_bsize(struct DbEnv *self){
		u_int32_t ret;
		errno = self->get_lg_bsize(self, &ret);
		return ret;
	}
SWIGINTERN char const *DbEnv_get_lg_dir(struct DbEnv *self){
		const char *ret;
		errno = self->get_lg_dir(self, &ret);
		return ret;
	}
SWIGINTERN int DbEnv_get_lg_filemode(struct DbEnv *self){
		int ret;
		errno = self->get_lg_filemode(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_get_lg_max(struct DbEnv *self){
		u_int32_t ret;
		errno = self->get_lg_max(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_get_lg_regionmax(struct DbEnv *self){
		u_int32_t ret;
		errno = self->get_lg_regionmax(self, &ret);
		return ret;
	}
SWIGINTERN char **DbEnv_log_archive(struct DbEnv *self,u_int32_t flags){
		char **list = NULL;
		errno = self->log_archive(self, &list, flags);
		return list;
	}
SWIGINTERN int DbEnv_log_compare(DB_LSN const *lsn0,DB_LSN const *lsn1){
		return log_compare(lsn0, lsn1);
	}
SWIGINTERN DB_LOGC *DbEnv_log_cursor(struct DbEnv *self,u_int32_t flags){
		DB_LOGC *cursor = NULL;
		errno = self->log_cursor(self, &cursor, flags);
		return cursor;
	}
SWIGINTERN char *DbEnv_log_file(struct DbEnv *self,DB_LSN *lsn){
		char namebuf[DB_MAXPATHLEN];
		errno = self->log_file(self, lsn, namebuf, sizeof namebuf);
		return (errno == 0) ? strdup(namebuf) : NULL;
	}
SWIGINTERN db_ret_t DbEnv_log_flush(struct DbEnv *self,DB_LSN const *lsn_or_null){
		return self->log_flush(self, lsn_or_null);
	}
SWIGINTERN int_bool DbEnv_log_get_config(struct DbEnv *self,u_int32_t which){
		int ret;
		errno = self->log_get_config(self, which, &ret);
		return ret;
	}
SWIGINTERN db_ret_t DbEnv_log_put(struct DbEnv *self,DB_LSN *lsn,DBT const *data,u_int32_t flags){
		return self->log_put(self, lsn, data, flags);
	}
SWIGINTERN db_ret_t DbEnv_log_print(struct DbEnv *self,DB_TXN *txn,char const *msg){
		return self->log_printf(self, txn, "%s", msg);
	}
SWIGINTERN db_ret_t DbEnv_log_set_config(struct DbEnv *self,u_int32_t which,int_bool onoff){
		return self->log_set_config(self, which, onoff);
	}
SWIGINTERN DB_LOG_STAT *DbEnv_log_stat(struct DbEnv *self,u_int32_t flags){
		DB_LOG_STAT *sp = NULL;
		errno = self->log_stat(self, &sp, flags);
		return sp;
	}
SWIGINTERN int DbEnv_log_stat_print(struct DbEnv *self,u_int32_t flags){
		return self->log_stat_print(self, flags);
	}
SWIGINTERN int DbEnv_log_verify(struct DbEnv *self,char const *envhome,u_int32_t cachesz,char const *dbfile,char const *dbname,time_t stime,time_t etime,u_int32_t stfile,u_int32_t stoffset,u_int32_t efile,u_int32_t eoffset,int caf,int verbose){
                return self->env->log_verify_wrap(self->env, envhome, cachesz,
                    dbfile, dbname, stime, etime, stfile, stoffset, efile, 
                    eoffset, caf, verbose);
        }
SWIGINTERN db_ret_t DbEnv_set_lg_bsize(struct DbEnv *self,u_int32_t lg_bsize){
		return self->set_lg_bsize(self, lg_bsize);
	}
SWIGINTERN db_ret_t DbEnv_set_lg_dir(struct DbEnv *self,char const *dir){
		return self->set_lg_dir(self, dir);
	}
SWIGINTERN db_ret_t DbEnv_set_lg_filemode(struct DbEnv *self,int mode){
		return self->set_lg_filemode(self, mode);
	}
SWIGINTERN db_ret_t DbEnv_set_lg_max(struct DbEnv *self,u_int32_t lg_max){
		return self->set_lg_max(self, lg_max);
	}
SWIGINTERN db_ret_t DbEnv_set_lg_regionmax(struct DbEnv *self,u_int32_t lg_regionmax){
		return self->set_lg_regionmax(self, lg_regionmax);
	}
SWIGINTERN jlong DbEnv_get_cachesize(struct DbEnv *self){
		u_int32_t gbytes, bytes;
		errno = self->get_cachesize(self, &gbytes, &bytes, NULL);
		return (jlong)gbytes * GIGABYTE + bytes;
	}
SWIGINTERN int DbEnv_get_cachesize_ncache(struct DbEnv *self){
		int ret;
		errno = self->get_cachesize(self, NULL, NULL, &ret);
		return ret;
	}
SWIGINTERN jlong DbEnv_get_cache_max(struct DbEnv *self){
		u_int32_t gbytes, bytes;
		errno = self->get_cache_max(self, &gbytes, &bytes);
		return (jlong)gbytes * GIGABYTE + bytes;
	}
SWIGINTERN char const *DbEnv_get_create_dir(struct DbEnv *self){
		const char *ret;
		errno = self->get_create_dir(self, &ret);
		return ret;
	}
SWIGINTERN int DbEnv_get_mp_max_openfd(struct DbEnv *self){
		int ret;
		errno = self->get_mp_max_openfd(self, &ret);
		return ret;
	}
SWIGINTERN int DbEnv_get_mp_max_write(struct DbEnv *self){
		int maxwrite;
		db_timeout_t sleep;
		errno = self->get_mp_max_write(self, &maxwrite, &sleep);
		return maxwrite;
	}
SWIGINTERN db_timeout_t DbEnv_get_mp_max_write_sleep(struct DbEnv *self){
		int maxwrite;
		db_timeout_t sleep;
		errno = self->get_mp_max_write(self, &maxwrite, &sleep);
		return sleep;
	}
SWIGINTERN size_t DbEnv_get_mp_mmapsize(struct DbEnv *self){
		size_t ret;
		errno = self->get_mp_mmapsize(self, &ret);
		return ret;
	}
SWIGINTERN int DbEnv_get_mp_pagesize(struct DbEnv *self){
		u_int32_t ret;
		errno = self->get_mp_pagesize(self, &ret);
		return ret;
	}
SWIGINTERN int DbEnv_get_mp_tablesize(struct DbEnv *self){
		u_int32_t ret;
		errno = self->get_mp_tablesize(self, &ret);
		return ret;
	}
SWIGINTERN DB_MPOOL_STAT *DbEnv_memp_stat(struct DbEnv *self,u_int32_t flags){
		DB_MPOOL_STAT *mp_stat = NULL;
		errno = self->memp_stat(self, &mp_stat, NULL, flags);
		return mp_stat;
	}
SWIGINTERN int DbEnv_memp_stat_print(struct DbEnv *self,u_int32_t flags){
		return self->memp_stat_print(self, flags);
	}
SWIGINTERN DB_MPOOL_FSTAT **DbEnv_memp_fstat(struct DbEnv *self,u_int32_t flags){
		DB_MPOOL_FSTAT **mp_fstat = NULL;
		errno = self->memp_stat(self, NULL, &mp_fstat, flags);
		return mp_fstat;
	}
SWIGINTERN db_ret_t DbEnv_memp_sync(struct DbEnv *self,DB_LSN *lsn_or_null){
		return self->memp_sync(self, lsn_or_null);
	}
SWIGINTERN int DbEnv_memp_trickle(struct DbEnv *self,int percent){
		int ret;
		errno = self->memp_trickle(self, percent, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_mutex_get_align(struct DbEnv *self){
		u_int32_t ret;
		errno = self->mutex_get_align(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_mutex_get_increment(struct DbEnv *self){
		u_int32_t ret;
		errno = self->mutex_get_increment(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_mutex_get_init(struct DbEnv *self){
		u_int32_t ret;
		errno = self->mutex_get_init(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_mutex_get_max(struct DbEnv *self){
		u_int32_t ret;
		errno = self->mutex_get_max(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_mutex_get_tas_spins(struct DbEnv *self){
		u_int32_t ret;
		errno = self->mutex_get_tas_spins(self, &ret);
		return ret;
	}
SWIGINTERN db_ret_t DbEnv_mutex_set_align(struct DbEnv *self,u_int32_t align){
		return self->mutex_set_align(self, align);
	}
SWIGINTERN db_ret_t DbEnv_mutex_set_increment(struct DbEnv *self,u_int32_t increment){
		return self->mutex_set_increment(self, increment);
	}
SWIGINTERN db_ret_t DbEnv_mutex_set_init(struct DbEnv *self,u_int32_t mutex_init){
		return self->mutex_set_init(self, mutex_init);
	}
SWIGINTERN db_ret_t DbEnv_mutex_set_max(struct DbEnv *self,u_int32_t mutex_max){
		return self->mutex_set_max(self, mutex_max);
	}
SWIGINTERN db_ret_t DbEnv_mutex_set_tas_spins(struct DbEnv *self,u_int32_t tas_spins){
		return self->mutex_set_tas_spins(self, tas_spins);
	}
SWIGINTERN DB_MUTEX_STAT *DbEnv_mutex_stat(struct DbEnv *self,u_int32_t flags){
		DB_MUTEX_STAT *statp = NULL;
		errno = self->mutex_stat(self, &statp, flags);
		return statp;
	}
SWIGINTERN int DbEnv_mutex_stat_print(struct DbEnv *self,u_int32_t flags){
		return self->mutex_stat_print(self, flags);
	}
SWIGINTERN char const *DbEnv_get_region_dir(struct DbEnv *self){
		const char *ret;
		errno = self->get_region_dir(self, &ret);
		return ret;
	}
SWIGINTERN db_ret_t DbEnv_set_region_dir(struct DbEnv *self,char const *dir){
		return self->set_region_dir(self, dir);
	}
SWIGINTERN u_int32_t DbEnv_get_tx_max(struct DbEnv *self){
		u_int32_t ret;
		errno = self->get_tx_max(self, &ret);
		return ret;
	}
SWIGINTERN time_t DbEnv_get_tx_timestamp(struct DbEnv *self){
		time_t ret;
		errno = self->get_tx_timestamp(self, &ret);
		return ret;
	}
SWIGINTERN db_timeout_t DbEnv_get_timeout(struct DbEnv *self,u_int32_t flag){
		db_timeout_t ret;
		errno = self->get_timeout(self, &ret, flag);
		return ret;
	}
SWIGINTERN int DbEnv_stat_print(struct DbEnv *self,u_int32_t flags){
		return self->stat_print(self, flags);
	}
SWIGINTERN int DbEnv_txn_applied(struct DbEnv *self,DB_TXN_TOKEN *token,u_int32_t maxwait,u_int32_t flags){
		return self->txn_applied(self, token, maxwait, flags);
	}
SWIGINTERN DB_TXN *DbEnv_txn_begin(struct DbEnv *self,DB_TXN *parent,u_int32_t flags){
		DB_TXN *tid = NULL;
		errno = self->txn_begin(self, parent, &tid, flags);
		return tid;
	}
SWIGINTERN db_ret_t DbEnv_txn_checkpoint(struct DbEnv *self,u_int32_t kbyte,u_int32_t min,u_int32_t flags){
		return self->txn_checkpoint(self, kbyte, min, flags);
	}
SWIGINTERN DB_PREPLIST *DbEnv_txn_recover(struct DbEnv *self,long count,long flags){
		DB_PREPLIST *preplist;
		long retcount;

		/* Add a NULL element to terminate the array. */
		if ((errno = __os_malloc(self->env,
		    (count + 1) * sizeof(DB_PREPLIST), &preplist)) != 0)
			return NULL;

		if ((errno = self->txn_recover(self, preplist, count,
		    &retcount, flags)) != 0) {
			__os_free(self->env, preplist);
			return NULL;
		}

		preplist[retcount].txn = NULL;
		return preplist;
	}
SWIGINTERN DB_TXN_STAT *DbEnv_txn_stat(struct DbEnv *self,u_int32_t flags){
		DB_TXN_STAT *statp = NULL;
		errno = self->txn_stat(self, &statp, flags);
		return statp;
	}
SWIGINTERN int DbEnv_txn_stat_print(struct DbEnv *self,u_int32_t flags){
		return self->txn_stat_print(self, flags);
	}
SWIGINTERN jlong DbEnv_rep_get_limit(struct DbEnv *self){
		u_int32_t gbytes, bytes;
		errno = self->rep_get_limit(self, &gbytes, &bytes);
		return (jlong)gbytes * GIGABYTE + bytes;
	}
SWIGINTERN db_ret_t DbEnv_rep_elect(struct DbEnv *self,u_int32_t nsites,int nvotes,u_int32_t flags){
		return self->rep_elect(self, nsites, nvotes, flags);
	}
SWIGINTERN int DbEnv_rep_process_message(struct DbEnv *self,DBT *control,DBT *rec,int envid,DB_LSN *ret_lsn){
		return self->rep_process_message(self, control, rec, envid,
		    ret_lsn);
	}
SWIGINTERN db_ret_t DbEnv_rep_flush(struct DbEnv *self){
		return self->rep_flush(self);
	}
SWIGINTERN db_ret_t DbEnv_rep_set_config(struct DbEnv *self,u_int32_t which,int_bool onoff){
		return self->rep_set_config(self, which, onoff);
	}
SWIGINTERN db_ret_t DbEnv_rep_set_clockskew(struct DbEnv *self,u_int32_t fast_clock,u_int32_t slow_clock){
		return self->rep_set_clockskew(self, fast_clock, slow_clock);
	}
SWIGINTERN u_int32_t DbEnv_rep_get_clockskew_fast(struct DbEnv *self){
		u_int32_t fast_clock, slow_clock;
		errno = self->rep_get_clockskew(self, &fast_clock, &slow_clock);
		return fast_clock;
	}
SWIGINTERN u_int32_t DbEnv_rep_get_clockskew_slow(struct DbEnv *self){
		u_int32_t fast_clock, slow_clock;
		errno = self->rep_get_clockskew(self, &fast_clock, &slow_clock);
		return slow_clock;
	}
SWIGINTERN db_ret_t DbEnv_rep_start(struct DbEnv *self,DBT *cdata,u_int32_t flags){
		return self->rep_start(self, cdata, flags);
	}
SWIGINTERN db_ret_t DbEnv_rep_sync(struct DbEnv *self,u_int32_t flags){
		return self->rep_sync(self, flags);
	}
SWIGINTERN int_bool DbEnv_rep_get_config(struct DbEnv *self,u_int32_t which){
		int ret;
		errno = self->rep_get_config(self, which, &ret);
		return ret;
	}
SWIGINTERN DB_REP_STAT *DbEnv_rep_stat(struct DbEnv *self,u_int32_t flags){
		DB_REP_STAT *statp = NULL;
		errno = self->rep_stat(self, &statp, flags);
		return statp;
	}
SWIGINTERN int DbEnv_rep_stat_print(struct DbEnv *self,u_int32_t flags){
		return self->rep_stat_print(self, flags);
	}
SWIGINTERN db_ret_t DbEnv_rep_set_limit(struct DbEnv *self,jlong bytes){
		return self->rep_set_limit(self,
		    (u_int32_t)(bytes / GIGABYTE),
		    (u_int32_t)(bytes % GIGABYTE));
	}
SWIGINTERN u_int32_t DbEnv_rep_get_request_min(struct DbEnv *self){
		u_int32_t min, max;
		errno = self->rep_get_request(self, &min, &max);
		return min;
	}
SWIGINTERN u_int32_t DbEnv_rep_get_request_max(struct DbEnv *self){
		u_int32_t min, max;
		errno = self->rep_get_request(self, &min, &max);
		return max;
	}
SWIGINTERN DB_CHANNEL *DbEnv_repmgr_channel(struct DbEnv *self,int eid,u_int32_t flags){
		DB_CHANNEL *channel = NULL;
		errno = self->repmgr_channel(self, eid, &channel, flags);
		return channel;
	}
SWIGINTERN db_ret_t DbEnv_rep_set_request(struct DbEnv *self,u_int32_t min,u_int32_t max){
		return self->rep_set_request(self, min, max);
	}
SWIGINTERN db_ret_t DbEnv_rep_set_transport(struct DbEnv *self,int envid,int (*send)(DB_ENV *,DBT const *,DBT const *,DB_LSN const *,int,u_int32_t)){
		return self->rep_set_transport(self, envid, send);
	}
SWIGINTERN db_ret_t DbEnv_rep_set_view(struct DbEnv *self,int (*rep_view_fcn)(DB_ENV *,char const *,int *,u_int32_t)){
		return self->rep_set_view(self, rep_view_fcn);
	}
SWIGINTERN u_int32_t DbEnv_rep_get_nsites(struct DbEnv *self){
		u_int32_t ret;
		errno = self->rep_get_nsites(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_rep_get_priority(struct DbEnv *self){
		u_int32_t ret;
		errno = self->rep_get_priority(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbEnv_rep_get_timeout(struct DbEnv *self,int which){
		u_int32_t ret;
		errno = self->rep_get_timeout(self, which, &ret);
		return ret;
	}
SWIGINTERN db_ret_t DbEnv_rep_set_nsites(struct DbEnv *self,u_int32_t number){
		return self->rep_set_nsites(self, number);
	}
SWIGINTERN db_ret_t DbEnv_rep_set_priority(struct DbEnv *self,u_int32_t priority){
		return self->rep_set_priority(self, priority);
	}
SWIGINTERN db_ret_t DbEnv_rep_set_timeout(struct DbEnv *self,int which,db_timeout_t timeout){
		return self->rep_set_timeout(self, which, timeout);
	}
SWIGINTERN int DbEnv_repmgr_get_ack_policy(struct DbEnv *self){
		int ret;
		errno = self->repmgr_get_ack_policy(self, &ret);
		return ret;
	}
SWIGINTERN jlong DbEnv_repmgr_get_incoming_queue_max(struct DbEnv *self){
		u_int32_t gbytes = 0, bytes = 0;
		errno = self->repmgr_get_incoming_queue_max(self, &gbytes, &bytes);
		return (jlong)gbytes * GIGABYTE + bytes;
	}
SWIGINTERN DB_SITE *DbEnv_repmgr_local_site(struct DbEnv *self){
		DB_SITE *site = NULL;
		errno = self->repmgr_local_site(self, &site);
		return site;
	}
SWIGINTERN db_ret_t DbEnv_repmgr_set_ack_policy(struct DbEnv *self,int policy){
		return self->repmgr_set_ack_policy(self, policy);
	}
SWIGINTERN db_ret_t DbEnv_repmgr_set_incoming_queue_max(struct DbEnv *self,jlong bytes){
		return self->repmgr_set_incoming_queue_max(self, 
		    (u_int32_t)(bytes / GIGABYTE),
		    (u_int32_t)(bytes % GIGABYTE));
	}
SWIGINTERN DB_SITE *DbEnv_repmgr_site(struct DbEnv *self,char const *host,u_int port){
		DB_SITE *site = NULL;
		errno = self->repmgr_site(self, host, port, &site, 0);
		return site;
	}
SWIGINTERN DB_SITE *DbEnv_repmgr_site_by_eid(struct DbEnv *self,int eid){
		DB_SITE *site = NULL;
		errno = self->repmgr_site_by_eid(self, eid, &site);
		return site;
	}
SWIGINTERN db_ret_t DbEnv_repmgr_set_dispatch(struct DbEnv *self,void (*dispatch)(DB_ENV *,DB_CHANNEL *,DBT *,u_int32_t,u_int32_t),u_int32_t flags){
		return self->repmgr_msg_dispatch(self, dispatch, flags);
	}
SWIGINTERN struct __db_repmgr_sites DbEnv_repmgr_site_list(struct DbEnv *self){
		struct __db_repmgr_sites sites;
		errno = self->repmgr_site_list(self,
		    &sites.nsites, &sites.sites);
		return sites;
	}
SWIGINTERN db_ret_t DbEnv_repmgr_start(struct DbEnv *self,int nthreads,u_int32_t flags){
		return self->repmgr_start(self, nthreads, flags);
	}
SWIGINTERN DB_REPMGR_STAT *DbEnv_repmgr_stat(struct DbEnv *self,u_int32_t flags){
		DB_REPMGR_STAT *statp = NULL;
		errno = self->repmgr_stat(self, &statp, flags);
		return statp;
	}
SWIGINTERN int DbEnv_repmgr_stat_print(struct DbEnv *self,u_int32_t flags){
		return self->repmgr_stat_print(self, flags);
	}
SWIGINTERN u_int32_t DbEnv_get_backup_config(struct DbEnv *self,u_int32_t config_type){
		u_int32_t ret;
		errno = self->get_backup_config(self, (DB_BACKUP_CONFIG)config_type, &ret);
		if (errno == EINVAL) {
			errno = 0;
			ret = 0;
		}

		return ret;
	}
SWIGINTERN db_ret_t DbEnv_backup(struct DbEnv *self,char const *target,u_int32_t flags){
		return self->backup(self, target, flags);
	}
SWIGINTERN db_ret_t DbEnv_dbbackup(struct DbEnv *self,char const *dbfile,char const *target,u_int32_t flags){
		return self->dbbackup(self, dbfile, target, flags);
	}
SWIGINTERN db_ret_t DbEnv_set_backup_callbacks(struct DbEnv *self,int (*backup_open_fcn)(DB_ENV *,char const *,char const *,void **),int (*backup_write_fcn)(DB_ENV *,u_int32_t,u_int32_t,u_int32_t,u_int8_t *,void *),int (*backup_close_fcn)(DB_ENV *,char const *,void *)){
		return self->set_backup_callbacks(
		    self, backup_open_fcn, backup_write_fcn, backup_close_fcn);
	}
SWIGINTERN db_ret_t DbEnv_set_backup_config(struct DbEnv *self,u_int32_t config_type,u_int32_t value){
		return self->set_backup_config(self, (DB_BACKUP_CONFIG)config_type, value);
	}
SWIGINTERN char const *DbEnv_strerror(int ret){
		return db_strerror(ret);
	}
SWIGINTERN int DbEnv_get_version_family(void){
		return DB_VERSION_FAMILY;
	}
SWIGINTERN int DbEnv_get_version_release(void){
		return DB_VERSION_RELEASE;
	}
SWIGINTERN int DbEnv_get_version_major(void){
		return DB_VERSION_MAJOR;
	}
SWIGINTERN int DbEnv_get_version_minor(void){
		return DB_VERSION_MINOR;
	}
SWIGINTERN int DbEnv_get_version_patch(void){
		return DB_VERSION_PATCH;
	}
SWIGINTERN char const *DbEnv_get_version_string(void){
		return DB_VERSION_STRING;
	}
SWIGINTERN char const *DbEnv_get_version_full_string(void){
		return DB_VERSION_FULL_STRING;
	}
SWIGINTERN int DbEnv_slices_enabled(void){
		DB_ENV *dbenv;
		u_int32_t slices;
		int enabled, ret;
		enabled = 0;
		if (db_env_create(&dbenv, 0) == 0) {
			/* Hide any error messages. */
			dbenv->set_errcall(dbenv, NULL);
			dbenv->set_errfile(dbenv, NULL);
			/* Will return DB_OPNOTSUP if not enabled.*/
			ret = dbenv->get_slice_count(dbenv, &slices);
			if (ret == DB_OPNOTSUP)
				enabled = 0;
			else
				enabled = 1;
			dbenv->close(dbenv, 0);
		}
		return enabled;
	}
SWIGINTERN void delete_DbLock(struct DbLock *self){
		__os_free(NULL, self);
	}
SWIGINTERN db_ret_t DbLogc_close(struct DbLogc *self,u_int32_t flags){
		return self->close(self, flags);
	}
SWIGINTERN int DbLogc_get(struct DbLogc *self,DB_LSN *lsn,DBT *data,u_int32_t flags){
		return self->get(self, lsn, data, flags);
	}
SWIGINTERN u_int32_t DbLogc_version(struct DbLogc *self,u_int32_t flags){
		u_int32_t result;
		errno = self->version(self, &result, flags);
		return result;
	}
SWIGINTERN DB_CACHE_PRIORITY DbMpoolFile_get_priority(struct DbMpoolFile *self){
		DB_CACHE_PRIORITY ret;
		errno = self->get_priority(self, &ret);
		return ret;
	}
SWIGINTERN db_ret_t DbMpoolFile_set_priority(struct DbMpoolFile *self,DB_CACHE_PRIORITY priority){
		return self->set_priority(self, priority);
	}
SWIGINTERN u_int32_t DbMpoolFile_get_flags(struct DbMpoolFile *self){
		u_int32_t ret;
		errno = self->get_flags(self, &ret);
		return ret;
	}
SWIGINTERN db_ret_t DbMpoolFile_set_flags(struct DbMpoolFile *self,u_int32_t flags,int_bool onoff){
		return self->set_flags(self, flags, onoff);
	}
SWIGINTERN jlong DbMpoolFile_get_maxsize(struct DbMpoolFile *self){
		u_int32_t gbytes, bytes;
		errno = self->get_maxsize(self, &gbytes, &bytes);
		return (jlong)gbytes * GIGABYTE + bytes;
	}
SWIGINTERN db_ret_t DbMpoolFile_set_maxsize(struct DbMpoolFile *self,jlong bytes){
		return self->set_maxsize(self,
		    (u_int32_t)(bytes / GIGABYTE),
		    (u_int32_t)(bytes % GIGABYTE));
	}
SWIGINTERN struct DbSequence *new_DbSequence(DB *db,u_int32_t flags){
		DB_SEQUENCE *self = NULL;
		errno = db_sequence_create(&self, db, flags);
		return self;
	}
SWIGINTERN db_ret_t DbSequence_close(struct DbSequence *self,u_int32_t flags){
		return self->close(self, flags);
	}
SWIGINTERN db_seq_t DbSequence_get(struct DbSequence *self,DB_TXN *txnid,u_int32_t delta,u_int32_t flags){
		db_seq_t ret = 0;
		errno = self->get(self, txnid, delta, &ret, flags);
		return ret;
	}
SWIGINTERN u_int32_t DbSequence_get_cachesize(struct DbSequence *self){
		u_int32_t ret = 0;
		errno = self->get_cachesize(self, &ret);
		return ret;
	}
SWIGINTERN DB *DbSequence_get_db(struct DbSequence *self){
		DB *ret = NULL;
		errno = self->get_db(self, &ret);
		return ret;
	}
SWIGINTERN u_int32_t DbSequence_get_flags(struct DbSequence *self){
		u_int32_t ret = 0;
		errno = self->get_flags(self, &ret);
		return ret;
	}
SWIGINTERN db_ret_t DbSequence_get_key(struct DbSequence *self,DBT *key){
		return self->get_key(self, key);
	}
SWIGINTERN db_seq_t DbSequence_get_range_min(struct DbSequence *self){
		db_seq_t ret = 0;
		errno = self->get_range(self, &ret, NULL);
		return ret;
	}
SWIGINTERN db_seq_t DbSequence_get_range_max(struct DbSequence *self){
		db_seq_t ret = 0;
		errno = self->get_range(self, NULL, &ret);
		return ret;
	}
SWIGINTERN db_ret_t DbSequence_initial_value(struct DbSequence *self,db_seq_t val){
		return self->initial_value(self, val);
	}
SWIGINTERN db_ret_t DbSequence_open(struct DbSequence *self,DB_TXN *txnid,DBT *key,u_int32_t flags){
		return self->open(self, txnid, key, flags);
	}
SWIGINTERN db_ret_t DbSequence_remove(struct DbSequence *self,DB_TXN *txnid,u_int32_t flags){
		return self->remove(self, txnid, flags);
	}
SWIGINTERN db_ret_t DbSequence_set_cachesize(struct DbSequence *self,u_int32_t size){
		return self->set_cachesize(self, size);
	}
SWIGINTERN db_ret_t DbSequence_set_flags(struct DbSequence *self,u_int32_t flags){
		return self->set_flags(self, flags);
	}
SWIGINTERN db_ret_t DbSequence_set_range(struct DbSequence *self,db_seq_t min,db_seq_t max){
		return self->set_range(self, min, max);
	}
SWIGINTERN DB_SEQUENCE_STAT *DbSequence_stat(struct DbSequence *self,u_int32_t flags){
		DB_SEQUENCE_STAT *ret = NULL;
		errno = self->stat(self, &ret, flags);
		return ret;
	}
SWIGINTERN int DbSequence_stat_print(struct DbSequence *self,u_int32_t flags){
		return self->stat_print(self, flags);
	}
SWIGINTERN db_ret_t DbSite_close(struct DbSite *self){
		return self->close(self);
	}
SWIGINTERN struct __db_repmgr_site_address DbSite_get_address(struct DbSite *self){
		struct __db_repmgr_site_address address;
		errno = self->get_address(self, &address.host, &address.port);
		return address;
	}
SWIGINTERN int_bool DbSite_get_config(struct DbSite *self,u_int32_t which){
		u_int32_t ret = 0;
		errno = self->get_config(self, which, &ret);
		return ret;
	}
SWIGINTERN int DbSite_get_eid(struct DbSite *self){
		int ret = 0;
		errno = self->get_eid(self, &ret);
		return ret;
	}
SWIGINTERN db_ret_t DbSite_remove(struct DbSite *self){
		return self->remove(self);
	}
SWIGINTERN db_ret_t DbSite_set_config(struct DbSite *self,u_int32_t which,int_bool onoff){
		return self->set_config(self, which, onoff);
	}
SWIGINTERN db_ret_t DbStream_close(struct DbStream *self,u_int32_t flags){
		return self->close(self, flags);
	}
SWIGINTERN int DbStream_read(struct DbStream *self,DBT *data,db_off_t offset,u_int32_t size,u_int32_t flags){
		return self->read(self, data, offset, size, flags);
	}
SWIGINTERN db_off_t DbStream_size(struct DbStream *self,u_int32_t flags){
		db_off_t ret = 0;
		errno = self->size(self, &ret, flags);
		return ret;
	}
SWIGINTERN int DbStream_write(struct DbStream *self,DBT *data,db_off_t offset,u_int32_t flags){
		return self->write(self, data, offset, flags);
	}
SWIGINTERN db_ret_t DbTxn_abort(struct DbTxn *self){
		return self->abort(self);
	}
SWIGINTERN db_ret_t DbTxn_discard(struct DbTxn *self,u_int32_t flags){
		return self->discard(self, flags);
	}
SWIGINTERN char const *DbTxn_get_name(struct DbTxn *self){
		const char *name = NULL;
		errno = self->get_name(self, &name);
		return name;
	}
SWIGINTERN u_int32_t DbTxn_get_priority(struct DbTxn *self){
		u_int32_t priority;
		errno = self->get_priority(self, &priority);
		return priority;
	}
SWIGINTERN u_int32_t DbTxn_id(struct DbTxn *self){
		return self->id(self);
	}
SWIGINTERN db_ret_t DbTxn_prepare(struct DbTxn *self,u_int8_t *gid){
		return self->prepare(self, gid);
	}
SWIGINTERN db_ret_t DbTxn_set_timeout(struct DbTxn *self,db_timeout_t timeout,u_int32_t flags){
		return self->set_timeout(self, timeout, flags);
	}
SWIGINTERN db_ret_t DbTxn_set_name(struct DbTxn *self,char const *name){
		return self->set_name(self, name);
	}
SWIGINTERN db_ret_t DbTxn_set_priority(struct DbTxn *self,u_int32_t priority){
		return self->set_priority(self, priority);
	}
SWIGINTERN db_ret_t DbChannel_close(struct DbChannel *self,u_int32_t flags){
		return self->close(self, flags);
	}
SWIGINTERN db_ret_t DbChannel_send_repmsg(struct DbChannel *self,DBT *chan_msgs,u_int32_t nmsg,u_int32_t flags){
		return self->send_msg(self, chan_msgs, nmsg, flags);
	}
SWIGINTERN db_ret_t DbChannel_send_request(struct DbChannel *self,DBT *chan_msgs,u_int32_t nrequest,DBT *response,db_timeout_t timeout,u_int32_t flags){
		return self->send_request(self, chan_msgs, nrequest, response, timeout, flags);
	}
SWIGINTERN db_ret_t DbChannel_set_timeout(struct DbChannel *self,db_timeout_t timeout){
		return self->set_timeout(self, timeout);
	}

#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_new_1Db(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  DB_ENV *arg1 = (DB_ENV *) 0 ;
  u_int32_t arg2 ;
  struct Db *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(DB_ENV **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  errno = 0;
  result = (struct Db *)new_Db(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  *(struct Db **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1associate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jboolean jarg4, jint jarg5) {
  struct Db *arg1 = (struct Db *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  DB *arg3 = (DB *) 0 ;
  int (*arg4)(DB *,DBT const *,DBT const *,DBT *) = (int (*)(DB *,DBT const *,DBT const *,DBT *)) 0 ;
  u_int32_t arg5 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  arg3 = *(DB **)&jarg3; 
  
  arg4 = (jarg4 == JNI_TRUE) ? __dbj_seckey_create : NULL;
  
  arg5 = (u_int32_t)jarg5; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_associate(arg1,arg2,arg3,arg4,arg5);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1associate_1foreign(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3, jint jarg4) {
  struct Db *arg1 = (struct Db *) 0 ;
  DB *arg2 = (DB *) 0 ;
  int (*arg3)(DB *,DBT const *,DBT *,DBT const *,int *) = (int (*)(DB *,DBT const *,DBT *,DBT const *,int *)) 0 ;
  u_int32_t arg4 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = *(DB **)&jarg2; 
  
  arg3 = (jarg3 == JNI_TRUE) ? __dbj_foreignkey_nullify : NULL;
  
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_associate_foreign(arg1,arg2,arg3,arg4);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1compact(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jobject jarg5, jint jarg6, jobject jarg7) {
  struct Db *arg1 = (struct Db *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  DBT *arg4 = (DBT *) 0 ;
  DB_COMPACT *arg5 = (DB_COMPACT *) 0 ;
  u_int32_t arg6 ;
  DBT *arg7 = (DBT *) 0 ;
  DBT_LOCKED ldbt3 ;
  DBT_LOCKED ldbt4 ;
  DB_COMPACT compact5 ;
  DBT_LOCKED ldbt7 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 1) != 0) {
    return ; /* An exception will be pending. */
  }
  
  if (__dbj_dbt_copyin(jenv, &ldbt4, &arg4, jarg4, 1) != 0) {
    return ; /* An exception will be pending. */
  }
  
  memset(&compact5, 0, sizeof (DB_COMPACT));
  arg5 = &compact5;
  arg5->compact_fillpercent = (*jenv)->GetIntField(jenv, jarg5,
    compact_compact_fillpercent_fid);
  arg5->compact_timeout = (*jenv)->GetIntField(jenv, jarg5,
    compact_compact_timeout_fid);
  arg5->compact_pages = (*jenv)->GetIntField(jenv, jarg5,
    compact_compact_pages_fid);
  
  arg6 = (u_int32_t)jarg6; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt7, &arg7, jarg7, 1) != 0) {
    return ; /* An exception will be pending. */
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_compact(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
  __dbj_dbt_release(jenv, jarg4, arg4, &ldbt4); 
  __dbj_fill_compact(jenv, jarg5, arg5); 
  __dbj_dbt_release(jenv, jarg7, arg7, &ldbt7); 
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1close0(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)Db_close(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1cursor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jlong jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  u_int32_t arg3 ;
  DBC *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DBC *)Db_cursor(arg1,arg2,arg3);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  *(DBC **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1del(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jint jarg4) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  u_int32_t arg4 ;
  DBT_LOCKED ldbt3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  result = (int)Db_del(arg1,arg2,arg3,arg4);
  if (!DB_RETOK_DBDEL(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1err(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  struct Db *arg1 = (struct Db *) 0 ;
  int arg2 ;
  char *arg3 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return ;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  Db_err(arg1,arg2,(char const *)arg3); 
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1errx(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  Db_errx(arg1,(char const *)arg2); 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1exists(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jint jarg4) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  u_int32_t arg4 ;
  DBT_LOCKED ldbt3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  result = (int)Db_exists(arg1,arg2,arg3,arg4);
  if (!DB_RETOK_EXISTS(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jint jarg5) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  DBT *arg4 = (DBT *) 0 ;
  u_int32_t arg5 ;
  DBT_LOCKED ldbt3 ;
  DBT_LOCKED ldbt4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  
  if (__dbj_dbt_copyin(jenv, &ldbt4, &arg4, jarg4, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  arg5 = (u_int32_t)jarg5; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  result = (int)Db_get(arg1,arg2,arg3,arg4,arg5);
  if (!DB_RETOK_DBGET(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
  __dbj_dbt_release(jenv, jarg4, arg4, &ldbt4); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1assoc_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)Db_get_assoc_flags(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1blob_1sub_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (char *)Db_get_blob_sub_dir(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  if (result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1byteswapped(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  int_bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int_bool)Db_get_byteswapped(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (result) ? JNI_TRUE : JNI_FALSE; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1cachesize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  jlong result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = Db_get_cachesize(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1cachesize_1ncache(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)Db_get_cachesize_ncache(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1create_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (char *)Db_get_create_dir(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  if (result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1filename(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (char *)Db_get_filename(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  if (result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1dbname(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (char *)Db_get_dbname(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  if (result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1encrypt_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)Db_get_encrypt_flags(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1ext_1file_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (char *)Db_get_ext_file_dir(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  if (result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1ext_1file_1threshold(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)Db_get_ext_file_threshold(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)Db_get_flags(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1lk_1exclusive(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)Db_get_lk_exclusive(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1lorder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)Db_get_lorder(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1mpf(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  DB_MPOOLFILE *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_MPOOLFILE *)Db_get_mpf(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  *(DB_MPOOLFILE **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1open_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)Db_get_open_flags(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1pagesize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)Db_get_pagesize(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1bt_1minkey(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)Db_get_bt_minkey(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1heapsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  jlong result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = Db_get_heapsize(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1heap_1regionsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)Db_get_heap_regionsize(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1h_1ffactor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)Db_get_h_ffactor(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1h_1nelem(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)Db_get_h_nelem(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1re_1delim(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)Db_get_re_delim(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1priority(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  DB_CACHE_PRIORITY result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_CACHE_PRIORITY)Db_get_priority(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jobjectArray JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1partition_1dirs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobjectArray jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (char **)Db_get_partition_dirs(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  {
    if (result != NULL) {
      /*@SWIG:../lang/java/libdb_java/java_typemaps.i,633,STRING_ARRAY_OUT@*/	int i, len;
      
      len = 0;
      while (result[len] != NULL)
      len++;
      if ((jresult = (*jenv)->NewObjectArray(jenv, (jsize)len, string_class,
            NULL)) == NULL)
      return 0; /* an exception is pending */
      for (i = 0; i < len; i++) {
        jstring str = (*jenv)->NewStringUTF(jenv, result[i]);
        (*jenv)->SetObjectArrayElement(jenv, jresult, (jsize)i, str);
      }
      /*@SWIG@*/
    }
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1partition_1keys(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  struct __dbt_arr result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = Db_get_partition_keys(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  {
    DBT *dbt;
    void *ptr;
    int i, ret;
    u_int32_t buflen;
    
    if ((&result)->arr_ptr == NULL || (&result)->len <= 0)
    jresult = NULL;
    else {
      /* Allocate the bulk buffer and make the bulk DBT. */
      for (i = 0, buflen = 0; i < (&result)->len; i++)
      buflen += (&result)->arr_ptr[i].size * sizeof(u_int32_t);
      buflen += ((&result)->len * 2 + 1) * sizeof(u_int32_t);
      if ((ret = __os_malloc(NULL, sizeof(DBT), &dbt)) != 0) {
        __dbj_throw(jenv, ret, NULL, NULL, NULL);
        goto err;
      }
      if ((ret = __os_malloc(NULL, buflen, &dbt->data)) != 0) {
        __dbj_throw(jenv, ret, NULL, NULL, NULL);
        goto err;
      }
      dbt->size = dbt->ulen = buflen;
      DB_MULTIPLE_INIT(ptr, dbt);
      for (i = 0; i < (&result)->len; i++)
      DB_MULTIPLE_WRITE_NEXT(ptr, dbt,
        (&result)->arr_ptr[i].data, (&result)->arr_ptr[i].size);
      
      /* Map a bulk DBT into a DatabaseEntry. */
      jresult = (*jenv)->NewObject(jenv, dbt_class, dbt_construct);
      __dbj_dbt_copyout(jenv, dbt, NULL, jresult);
      if (jresult == NULL)
      goto err;
      
      err:		if (dbt != NULL) {
        if (dbt->data != NULL)
        __os_free(NULL, dbt->data);
        __os_free(NULL, dbt);
      }
      if (ret != 0 || jresult == NULL)
      return 0;
    }
  }
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1partition_1parts(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)Db_get_partition_parts(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1re_1len(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)Db_get_re_len(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1re_1pad(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)Db_get_re_pad(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1re_1source(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (char *)Db_get_re_source(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  if (result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1q_1extentsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)Db_get_q_extentsize(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1multiple(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  int_bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  result = (int_bool)Db_get_multiple(arg1); 
  jresult = (result) ? JNI_TRUE : JNI_FALSE; 
  return jresult;
}


SWIGEXPORT jobjectArray JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1slices(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobjectArray jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  DB **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB **)Db_get_slices(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  {
    int i, len;
    
    len = 0;
    while (result[len] != NULL)
    len++;
    if ((jresult = (*jenv)->NewObjectArray(jenv, (jsize)len, db_class,
          NULL)) == NULL)
    return 0; /* an exception is pending */
    for (i = 0; i < len; i++) {
      jobject jdb = (*jenv)->NewObject(jenv, db_class,
        db_construct, result[i], JNI_FALSE);
      (*jenv)->SetObjectArrayElement(jenv, jresult, (jsize)i, jdb);
    }
  }
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1transactional(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  int_bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int_bool)Db_get_transactional(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (result) ? JNI_TRUE : JNI_FALSE; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1get_1type(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  DBTYPE result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DBTYPE)Db_get_type(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1join(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jint jarg3) {
  jlong jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  DBC **arg2 = (DBC **) 0 ;
  u_int32_t arg3 ;
  DBC *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  {
    int i, count, ret;
    
    count = (*jenv)->GetArrayLength(jenv, jarg2);
    if ((ret = __os_malloc(NULL, (count + 1) * sizeof(DBC *), &arg2)) != 0) {
      __dbj_throw(jenv, ret, NULL, NULL, DB2JDBENV);
      return 0;
    }
    for (i = 0; i < count; i++) {
      jobject jobj = (*jenv)->GetObjectArrayElement(jenv, jarg2, i);
      /*
      		 * A null in the array is treated as an endpoint.
      		 */
      if (jobj == NULL) {
        arg2[i] = NULL;
        break;
      } else {
        jlong jptr = (*jenv)->GetLongField(jenv, jobj,
          dbc_cptr_fid);
        arg2[i] = *(DBC **)(void *)&jptr;
      }
    }
    arg2[count] = NULL;
  }
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DBC *)Db_join(arg1,arg2,arg3);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  *(DBC **)&jresult = result; 
  
  __os_free(NULL, arg2);
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1key_1range(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jint jarg5) {
  struct Db *arg1 = (struct Db *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  DB_KEY_RANGE *arg4 = (DB_KEY_RANGE *) 0 ;
  u_int32_t arg5 ;
  DBT_LOCKED ldbt3 ;
  DB_KEY_RANGE range4 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 0) != 0) {
    return ; /* An exception will be pending. */
  }
  {
    arg4 = &range4;
  }
  arg5 = (u_int32_t)jarg5; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_key_range(arg1,arg2,arg3,arg4,arg5);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
  {
    (*jenv)->SetDoubleField(jenv, jarg4, kr_less_fid, arg4->less);
    (*jenv)->SetDoubleField(jenv, jarg4, kr_equal_fid, arg4->equal);
    (*jenv)->SetDoubleField(jenv, jarg4, kr_greater_fid, arg4->greater);
  }
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1open(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jstring jarg4, jint jarg5, jint jarg6, jint jarg7) {
  struct Db *arg1 = (struct Db *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  DBTYPE arg5 ;
  u_int32_t arg6 ;
  int arg7 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return ;
  }
  arg5 = (DBTYPE)jarg5; 
  arg6 = (u_int32_t)jarg6; 
  arg7 = (int)jarg7; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_open(arg1,arg2,(char const *)arg3,(char const *)arg4,arg5,arg6,arg7);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, (const char *)arg4);
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1pget(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jobject jarg5, jint jarg6) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  DBT *arg4 = (DBT *) 0 ;
  DBT *arg5 = (DBT *) 0 ;
  u_int32_t arg6 ;
  DBT_LOCKED ldbt3 ;
  DBT_LOCKED ldbt4 ;
  DBT_LOCKED ldbt5 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  
  if (__dbj_dbt_copyin(jenv, &ldbt4, &arg4, jarg4, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  
  if (__dbj_dbt_copyin(jenv, &ldbt5, &arg5, jarg5, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  arg6 = (u_int32_t)jarg6; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  result = (int)Db_pget(arg1,arg2,arg3,arg4,arg5,arg6);
  if (!DB_RETOK_DBGET(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
  __dbj_dbt_release(jenv, jarg4, arg4, &ldbt4); 
  __dbj_dbt_release(jenv, jarg5, arg5, &ldbt5); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1put(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jobject jarg4, jint jarg5) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  DBT *arg4 = (DBT *) 0 ;
  u_int32_t arg5 ;
  DBT_LOCKED ldbt3 ;
  DBT_LOCKED ldbt4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  
  if (__dbj_dbt_copyin(jenv, &ldbt4, &arg4, jarg4, 1) != 0) {
    return 0; /* An exception will be pending. */
  }
  arg5 = (u_int32_t)jarg5; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  result = (int)Db_put(arg1,arg2,arg3,arg4,arg5);
  if (!DB_RETOK_DBPUT(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
  __dbj_dbt_release(jenv, jarg4, arg4, &ldbt4); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1remove0(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jint jarg4) {
  struct Db *arg1 = (struct Db *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  u_int32_t arg4 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_remove(arg1,(char const *)arg2,(char const *)arg3,arg4);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1rename0(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4, jint jarg5) {
  struct Db *arg1 = (struct Db *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  u_int32_t arg5 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return ;
  }
  arg5 = (u_int32_t)jarg5; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_rename(arg1,(char const *)arg2,(char const *)arg3,(char const *)arg4,arg5);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, (const char *)arg4);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1append_1recno(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  int (*arg2)(DB *,DBT *,db_recno_t) = (int (*)(DB *,DBT *,db_recno_t)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  arg2 = (jarg2 == JNI_TRUE) ? __dbj_append_recno : NULL;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_append_recno(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1bt_1compare(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  int (*arg2)(DB *,DBT const *,DBT const *,size_t *) = (int (*)(DB *,DBT const *,DBT const *,size_t *)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  arg2 = (jarg2 == JNI_TRUE) ? __dbj_bt_compare : NULL;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_bt_compare(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1bt_1minkey(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_bt_minkey(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1bt_1compress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2, jboolean jarg3) {
  struct Db *arg1 = (struct Db *) 0 ;
  int (*arg2)(DB *,DBT const *,DBT const *,DBT const *,DBT const *,DBT *) = (int (*)(DB *,DBT const *,DBT const *,DBT const *,DBT const *,DBT *)) 0 ;
  int (*arg3)(DB *,DBT const *,DBT const *,DBT *,DBT *,DBT *) = (int (*)(DB *,DBT const *,DBT const *,DBT *,DBT *,DBT *)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  arg2 = (jarg2 == JNI_TRUE) ? __dbj_bt_compress : NULL;
  
  
  arg3 = (jarg3 == JNI_TRUE) ? __dbj_bt_decompress : NULL;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_bt_compress(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1bt_1prefix(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  size_t (*arg2)(DB *,DBT const *,DBT const *) = (size_t (*)(DB *,DBT const *,DBT const *)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  arg2 = (jarg2 == JNI_TRUE) ? __dbj_bt_prefix : NULL;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_bt_prefix(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1cachesize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3) {
  struct Db *arg1 = (struct Db *) 0 ;
  jlong arg2 ;
  int arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = jarg2; 
  arg3 = (int)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_cachesize(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1create_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  char *arg2 = (char *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_create_dir(arg1,(char const *)arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1dup_1compare(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  int (*arg2)(DB *,DBT const *,DBT const *,size_t *) = (int (*)(DB *,DBT const *,DBT const *,size_t *)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  arg2 = (jarg2 == JNI_TRUE) ? __dbj_dup_compare : NULL;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_dup_compare(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1encrypt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  struct Db *arg1 = (struct Db *) 0 ;
  char *arg2 = (char *) 0 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_encrypt(arg1,(char const *)arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1ext_1file_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  char *arg2 = (char *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  result = (db_ret_t)Db_set_ext_file_dir(arg1,(char const *)arg2); 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1ext_1file_1threshold(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t arg2 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  result = (db_ret_t)Db_set_ext_file_threshold(arg1,arg2,arg3); 
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1feedback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  void (*arg2)(DB *,int,int) = (void (*)(DB *,int,int)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  arg2 = (jarg2 == JNI_TRUE) ? __dbj_db_feedback : NULL;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_feedback(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_flags(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1heapsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  jlong arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_heapsize(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1heap_1regionsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_heap_regionsize(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1h_1compare(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  int (*arg2)(DB *,DBT const *,DBT const *,size_t *) = (int (*)(DB *,DBT const *,DBT const *,size_t *)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  arg2 = (jarg2 == JNI_TRUE) ? __dbj_h_compare : NULL;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_h_compare(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1h_1ffactor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_h_ffactor(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1h_1hash(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t (*arg2)(DB *,void const *,u_int32_t) = (u_int32_t (*)(DB *,void const *,u_int32_t)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  arg2 = (jarg2 == JNI_TRUE) ? __dbj_h_hash : NULL;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_h_hash(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1h_1nelem(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_h_nelem(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1lk_1exclusive(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  int arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_lk_exclusive(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1lorder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  int arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_lorder(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1msgfile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  result = (int)Db_set_msgfile(arg1,(char const *)arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1pagesize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_pagesize(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1partition(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobject jarg3, jboolean jarg4) {
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t arg2 ;
  DBT *arg3 = (DBT *) 0 ;
  u_int32_t (*arg4)(DB *,DBT *) = (u_int32_t (*)(DB *,DBT *)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  {
    DBT_LOCKED lresult;
    DBT *dbt;
    void *ptr, *retdata;
    int cnt, i, ret;
    u_int32_t retlen;
    
    if (jarg3 == NULL)
    arg3 = NULL;
    else {
      /* Copy the DBT from Java to C. */
      if ((ret = __dbj_dbt_copyin(jenv,
            &lresult, &dbt, jarg3, 0)) != 0)
      /* An exception will be pending. */
      return ;
      
      /* Get the number of DBT from the bulk buffer. */
      DB_MULTIPLE_INIT(ptr, dbt);
      DB_MULTIPLE_NEXT(ptr, dbt, retdata, retlen);
      cnt = 0;
      while (ptr != NULL) {
        cnt++;
        DB_MULTIPLE_NEXT(ptr, dbt, retdata, retlen);
      }
      
      /* Make an array of DBTs. */
      if ((ret = __os_malloc(NULL,
            (cnt + 1) * sizeof(DBT), &arg3)) != 0) {
        __dbj_throw(jenv, ret, NULL, NULL, NULL);
        goto err;
      }
      memset(arg3, 0, (cnt + 1) * sizeof(DBT));
      /*
      		 * Save the key array size in the last entry so that it can
      		 * be used later when free the key array and mark its flags
      		 * as DB_DBT_BULK which is an internal flag that can't be
      		 * passed by users. The last entry will not be read by the C
      		 * call __partition_set since it only reads the first cnt
      		 * DBTs from the key array.
      		 */
      arg3[cnt].size = sizeof(int);
      arg3[cnt].data = &cnt;
      arg3[cnt].flags = DB_DBT_BULK;
      DB_MULTIPLE_INIT(ptr, dbt);
      for (i = 0; i < cnt; i++) {
        DB_MULTIPLE_NEXT(ptr, dbt, retdata, retlen);
        if (retlen != 0) {
          /*
          				 * If there's data, we need to take a copy
          				 * of it.
          				 */
          arg3[i].size = retlen;
          if ((ret = __os_malloc(NULL,
                arg3[i].size, &arg3[i].data)) != 0) {
            __dbj_throw(jenv,
              ret, NULL, NULL, NULL);
            goto err;
          }
          memcpy(arg3[i].data, retdata, retlen);
        }
      }
      
      err:		if (ret != 0) {
        if (arg3 != NULL) {
          for (i = 0; i < cnt; i++)
          __os_free(NULL, arg3[i].data);
          __os_free(NULL, arg3);
        }
        return ; 
      }
    }
  }
  
  arg4 = (jarg4 == JNI_TRUE) ? __dbj_partition : NULL;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_partition(arg1,arg2,arg3,arg4);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
  
  {
    int cnt, i;
    
    if (arg3 != NULL) {
      /* Get the array size. */
      cnt = 0;
      while (arg3[cnt].flags != DB_DBT_BULK)
      cnt++;
      for (i = 0; i < cnt; i++)
      __os_free(NULL, arg3[i].data);
      __os_free(NULL, arg3);
    }
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1partition_1dirs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  char **arg2 = (char **) 0 ;
  jint size2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  {
    /*@SWIG:../lang/java/libdb_java/java_typemaps.i,661,STRING_ARRAY_IN@*/	int i, ret;
    size_t sz;
    
    size2 = (*jenv)->GetArrayLength(jenv, jarg2);
    sz = (size_t)(size2 + 1) * sizeof(char *); 
    if ((ret = __os_malloc(NULL, sz, &arg2)) != 0) {
      __dbj_throw(jenv, ret, NULL, NULL, NULL);
      return ;
    }
    /* Make a copy of each string. */
    for (i = 0; i < size2; i++) {
      jstring j_string = (jstring)(*jenv)->GetObjectArrayElement(jenv, jarg2, i);
      const char * c_string = (*jenv)->GetStringUTFChars(jenv, j_string, 0);
      sz = strlen(c_string) + 1;
      if ((ret = __os_malloc(NULL, sz, &arg2[i])) != 0) {
        __dbj_throw(jenv, ret, NULL, NULL, NULL);
        return ;
      }
      strcpy(arg2[i], c_string);
      (*jenv)->ReleaseStringUTFChars(jenv, j_string, c_string);
      (*jenv)->DeleteLocalRef(jenv, j_string);
    }
    arg2[i] = 0;
    /*@SWIG@*/
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_partition_dirs(arg1,(char const **)arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
  {
    int i;
    for (i = 0; i < size2-1; i++)
    __os_free(NULL, arg2[i]);
    __os_free(NULL, arg2);
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1priority(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  DB_CACHE_PRIORITY arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (DB_CACHE_PRIORITY)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_priority(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1re_1delim(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  int arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_re_delim(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1re_1len(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_re_len(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1re_1pad(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  int arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_re_pad(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1re_1source(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  char *arg2 = (char *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_re_source(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1q_1extentsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_q_extentsize(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1set_1slice_1callback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  int (*arg2)(DB const *,DBT const *,DBT *) = (int (*)(DB const *,DBT const *,DBT *)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  arg2 = (jarg2 == JNI_TRUE) ? __dbj_slice : NULL;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_set_slice_callback(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1slice_1lookup(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3) {
  jlong jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  DBT *arg2 = (DBT *) 0 ;
  u_int32_t arg3 ;
  DBT_LOCKED ldbt2 ;
  DB *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt2, &arg2, jarg2, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB *)Db_slice_lookup(arg1,(struct Dbt const *)arg2,arg3);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  *(DB **)&jresult = result; 
  __dbj_dbt_release(jenv, jarg2, arg2, &ldbt2); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1sort_1multiple(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3) {
  struct Db *arg1 = (struct Db *) 0 ;
  DBT *arg2 = (DBT *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  DBT_LOCKED ldbt2 ;
  DBT_LOCKED ldbt3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt2, &arg2, jarg2, 0) != 0) {
    return ; /* An exception will be pending. */
  }
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 0) != 0) {
    return ; /* An exception will be pending. */
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  errno = 0;
  result = (db_ret_t)Db_sort_multiple(arg1,arg2,arg3);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  __dbj_dbt_release(jenv, jarg2, arg2, &ldbt2); 
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1stat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jobject jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  u_int32_t arg3 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (void *)Db_stat(arg1,arg2,arg3);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  
  if (result == NULL)
  jresult = NULL;
  else {
    DB *db = (DB *)arg1;
    DBTYPE dbtype;
    int ret;
    
    if ((ret = db->get_type(db, &dbtype)) != 0) {
      __dbj_throw(jenv, ret, NULL, NULL, DB2JDBENV);
      return 0;
    }
    
    switch (dbtype) {
      /* Btree and recno share the same stat structure */
    case DB_BTREE:
    case DB_RECNO:
      jresult = (*jenv)->NewObject(jenv, bt_stat_class,
        bt_stat_construct);
      if (jresult != NULL)
      __dbj_fill_bt_stat(jenv, jresult,
        (DB_BTREE_STAT *)result);
      break;
      
      /* Hash stat structure */
    case DB_HASH:
      jresult = (*jenv)->NewObject(jenv, h_stat_class,
        h_stat_construct);
      if (jresult != NULL)
      __dbj_fill_h_stat(jenv, jresult,
        (DB_HASH_STAT *)result);
      break;
      
      /* Heap stat structure */
    case DB_HEAP:
      jresult = (*jenv)->NewObject(jenv, heap_stat_class,
        heap_stat_construct);
      if (jresult != NULL)
      __dbj_fill_heap_stat(jenv, jresult,
        (DB_HEAP_STAT *)result);
      break;
      
    case DB_QUEUE:
      jresult = (*jenv)->NewObject(jenv, qam_stat_class,
        qam_stat_construct);
      if (jresult != NULL)
      __dbj_fill_qam_stat(jenv, jresult,
        (DB_QUEUE_STAT *)result);
      break;
      
      /* That's all the database types we're aware of! */
    default:
      __dbj_throw(jenv, EINVAL, "Db.stat only implemented for"
        " BTREE, HASH, QUEUE and RECNO", NULL, DB2JDBENV);
      break;
    }
    
    __os_ufree(db->env, result);
  }
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1stat_1print(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)Db_stat_print(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1sync(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct Db *arg1 = (struct Db *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_sync(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1truncate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jint jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  u_int32_t arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)Db_truncate(arg1,arg2,arg3);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1upgrade(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  struct Db *arg1 = (struct Db *) 0 ;
  char *arg2 = (char *) 0 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Db_upgrade(arg1,(char const *)arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DB2JDBENV);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Db_1verify0(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jobject jarg4, jint jarg5) {
  jboolean jresult = 0 ;
  struct Db *arg1 = (struct Db *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  struct __db_out_stream arg4 ;
  u_int32_t arg5 ;
  struct __dbj_verify_data data4 ;
  int_bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Db **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return 0;
  }
  {
    data4.jenv = jenv;
    data4.streamobj = jarg4;
    data4.bytes = NULL;
    data4.nbytes = 0;
    (&arg4)->handle = &data4;
    (&arg4)->callback = __dbj_verify_callback;
  }
  arg5 = (u_int32_t)jarg5; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int_bool)Db_verify(arg1,(char const *)arg2,(char const *)arg3,arg4,arg5);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  jresult = (result) ? JNI_TRUE : JNI_FALSE; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Dbc_1close0(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  struct Dbc *arg1 = (struct Dbc *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Dbc **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)Dbc_close(arg1);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Dbc_1cmp(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jint jresult = 0 ;
  struct Dbc *arg1 = (struct Dbc *) 0 ;
  DBC *arg2 = (DBC *) 0 ;
  u_int32_t arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(struct Dbc **)&jarg1; 
  arg2 = *(DBC **)&jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)Dbc_cmp(arg1,arg2,arg3);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DBC2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Dbc_1count(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  struct Dbc *arg1 = (struct Dbc *) 0 ;
  u_int32_t arg2 ;
  db_recno_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Dbc **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (db_recno_t)Dbc_count(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DBC2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Dbc_1db_1stream(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  struct Dbc *arg1 = (struct Dbc *) 0 ;
  u_int32_t arg2 ;
  DB_STREAM *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Dbc **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_STREAM *)Dbc_db_stream(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DB2JDBENV);
  }
  
  *(DB_STREAM **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Dbc_1del(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  struct Dbc *arg1 = (struct Dbc *) 0 ;
  u_int32_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Dbc **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  result = (int)Dbc_del(arg1,arg2);
  if (!DB_RETOK_DBCDEL(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DBC2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Dbc_1dup(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  struct Dbc *arg1 = (struct Dbc *) 0 ;
  u_int32_t arg2 ;
  DBC *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Dbc **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DBC *)Dbc_dup(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DBC2JDBENV);
  }
  
  *(DBC **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Dbc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jint jarg4) {
  jint jresult = 0 ;
  struct Dbc *arg1 = (struct Dbc *) 0 ;
  DBT *arg2 = (DBT *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  u_int32_t arg4 ;
  DBT_LOCKED ldbt2 ;
  DBT_LOCKED ldbt3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Dbc **)&jarg1; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt2, &arg2, jarg2, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  result = (int)Dbc_get(arg1,arg2,arg3,arg4);
  if (!DB_RETOK_DBCGET(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DBC2JDBENV);
  }
  
  jresult = (jint)result; 
  __dbj_dbt_release(jenv, jarg2, arg2, &ldbt2); 
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Dbc_1get_1priority(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct Dbc *arg1 = (struct Dbc *) 0 ;
  DB_CACHE_PRIORITY result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Dbc **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_CACHE_PRIORITY)Dbc_get_priority(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DBC2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Dbc_1pget(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jobject jarg4, jint jarg5) {
  jint jresult = 0 ;
  struct Dbc *arg1 = (struct Dbc *) 0 ;
  DBT *arg2 = (DBT *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  DBT *arg4 = (DBT *) 0 ;
  u_int32_t arg5 ;
  DBT_LOCKED ldbt2 ;
  DBT_LOCKED ldbt3 ;
  DBT_LOCKED ldbt4 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Dbc **)&jarg1; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt2, &arg2, jarg2, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  
  if (__dbj_dbt_copyin(jenv, &ldbt4, &arg4, jarg4, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  arg5 = (u_int32_t)jarg5; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  result = (int)Dbc_pget(arg1,arg2,arg3,arg4,arg5);
  if (!DB_RETOK_DBCGET(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DBC2JDBENV);
  }
  
  jresult = (jint)result; 
  __dbj_dbt_release(jenv, jarg2, arg2, &ldbt2); 
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
  __dbj_dbt_release(jenv, jarg4, arg4, &ldbt4); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Dbc_1put(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jint jarg4) {
  jint jresult = 0 ;
  struct Dbc *arg1 = (struct Dbc *) 0 ;
  DBT *arg2 = (DBT *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  u_int32_t arg4 ;
  DBT_LOCKED ldbt2 ;
  DBT_LOCKED ldbt3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Dbc **)&jarg1; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt2, &arg2, jarg2, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 1) != 0) {
    return 0; /* An exception will be pending. */
  }
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  result = (int)Dbc_put(arg1,arg2,arg3,arg4);
  if (!DB_RETOK_DBCPUT(result)) {
    __dbj_throw(jenv, result, NULL, NULL, DBC2JDBENV);
  }
  
  jresult = (jint)result; 
  __dbj_dbt_release(jenv, jarg2, arg2, &ldbt2); 
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_Dbc_1set_1priority(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct Dbc *arg1 = (struct Dbc *) 0 ;
  DB_CACHE_PRIORITY arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct Dbc **)&jarg1; 
  arg2 = (DB_CACHE_PRIORITY)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  errno = 0;
  result = (db_ret_t)Dbc_set_priority(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, DBC2JDBENV);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_new_1DbEnv(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  u_int32_t arg1 ;
  struct DbEnv *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (u_int32_t)jarg1; 
  
  errno = 0;
  result = (struct DbEnv *)new_DbEnv(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  *(struct DbEnv **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1close0(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_close(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1dbremove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jstring jarg4, jint jarg5) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  u_int32_t arg5 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return ;
  }
  arg5 = (u_int32_t)jarg5; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_dbremove(arg1,arg2,(char const *)arg3,(char const *)arg4,arg5);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, (const char *)arg4);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1dbrename(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jstring jarg4, jstring jarg5, jint jarg6) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  char *arg5 = (char *) 0 ;
  u_int32_t arg6 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return ;
  }
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg5, 0);
    if (!arg5) return ;
  }
  arg6 = (u_int32_t)jarg6; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_dbrename(arg1,arg2,(char const *)arg3,(char const *)arg4,(char const *)arg5,arg6);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, (const char *)arg4);
  if (arg5) (*jenv)->ReleaseStringUTFChars(jenv, jarg5, (const char *)arg5);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1err(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int arg2 ;
  char *arg3 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return ;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  DbEnv_err(arg1,arg2,(char const *)arg3); 
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1errx(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  DbEnv_errx(arg1,(char const *)arg2); 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
}


SWIGEXPORT jobjectArray JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1slices(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobjectArray jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  DB_ENV **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_ENV **)DbEnv_get_slices(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  {
    int i, len;
    
    len = 0;
    while (result[len] != NULL)
    len++;
    if ((jresult = (*jenv)->NewObjectArray(jenv, (jsize)len, dbenv_class,
          NULL)) == NULL)
    return 0; /* an exception is pending */
    for (i = 0; i < len; i++) {
      jobject jdbenv = (*jenv)->NewObject(jenv, dbenv_class,
        dbenv_construct, result[i], JNI_FALSE);
      (*jenv)->SetObjectArrayElement(
        jenv, jresult, (jsize)i, jdbenv);
    }
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1cdsgroup_1begin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  DB_TXN *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_TXN *)DbEnv_cdsgroup_begin(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  *(DB_TXN **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1fileid_1reset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  errno = 0;
  result = (db_ret_t)DbEnv_fileid_reset(arg1,(char const *)arg2,arg3);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
}


SWIGEXPORT jobjectArray JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1data_1dirs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobjectArray jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (char **)DbEnv_get_data_dirs(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  {
    if (result != NULL) {
      /*@SWIG:../lang/java/libdb_java/java_typemaps.i,633,STRING_ARRAY_OUT@*/	int i, len;
      
      len = 0;
      while (result[len] != NULL)
      len++;
      if ((jresult = (*jenv)->NewObjectArray(jenv, (jsize)len, string_class,
            NULL)) == NULL)
      return 0; /* an exception is pending */
      for (i = 0; i < len; i++) {
        jstring str = (*jenv)->NewStringUTF(jenv, result[i]);
        (*jenv)->SetObjectArrayElement(jenv, jresult, (jsize)i, str);
      }
      /*@SWIG@*/
    }
  }
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1encrypt_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_encrypt_flags(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1ext_1file_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (char *)DbEnv_get_ext_file_dir(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  if (result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1ext_1file_1threshold(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_ext_file_threshold(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_flags(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1home(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (char *)DbEnv_get_home(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  if (result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1intermediate_1dir_1mode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (char *)DbEnv_get_intermediate_dir_mode(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  if (result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1open_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_open_flags(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1metadata_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (char *)DbEnv_get_metadata_dir(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  if (result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1shm_1key(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  long result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (long)DbEnv_get_shm_key(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1slice_1count(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_slice_count(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1tmp_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (char *)DbEnv_get_tmp_dir(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  if (result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1verbose(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  int_bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int_bool)DbEnv_get_verbose(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (result) ? JNI_TRUE : JNI_FALSE; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1is_1bigendian(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int_bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  result = (int_bool)DbEnv_is_bigendian(arg1); 
  jresult = (result) ? JNI_TRUE : JNI_FALSE; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1lsn_1reset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_lsn_reset(arg1,(char const *)arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1open(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3, jint jarg4) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  u_int32_t arg3 ;
  int arg4 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (u_int32_t)jarg3; 
  arg4 = (int)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_open(arg1,(char const *)arg2,arg3,arg4);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1remove0(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_remove(arg1,(char const *)arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1cachesize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  jlong arg2 ;
  int arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = jarg2; 
  arg3 = (int)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_cachesize(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1cache_1max(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  jlong arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_cache_max(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1create_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_create_dir(arg1,(char const *)arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1add_1data_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_add_data_dir(arg1,(char const *)arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1intermediate_1dir_1mode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_intermediate_dir_mode(arg1,(char const *)arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1encrypt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_encrypt(arg1,(char const *)arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1errcall(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  void (*arg2)(DB_ENV const *,char const *,char const *) = (void (*)(DB_ENV const *,char const *,char const *)) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  arg2 = (jarg2 == JNI_TRUE) ? __dbj_error : NULL;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  DbEnv_set_errcall(arg1,arg2); 
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1ext_1file_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_ext_file_dir(arg1,(char const *)arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1ext_1file_1threshold(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_ext_file_threshold(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  int_bool arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  arg3 = (jarg3 == JNI_TRUE); 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_flags(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1feedback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  void (*arg2)(DB_ENV *,int,int) = (void (*)(DB_ENV *,int,int)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  arg2 = (jarg2 == JNI_TRUE) ? __dbj_env_feedback : NULL;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_feedback(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1metadata_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_metadata_dir(arg1,(char const *)arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1mp_1max_1openfd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_mp_max_openfd(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1mp_1max_1write(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int arg2 ;
  db_timeout_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (db_timeout_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_mp_max_write(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1mp_1mmapsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  size_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (size_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_mp_mmapsize(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1mp_1pagesize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_mp_pagesize(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1mp_1tablesize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_mp_tablesize(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1msgcall(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  void (*arg2)(DB_ENV const *,char const *,char const *) = (void (*)(DB_ENV const *,char const *,char const *)) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  arg2 = (jarg2 == JNI_TRUE) ? __dbj_message : NULL;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  DbEnv_set_msgcall(arg1,arg2); 
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1msgfile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  result = (int)DbEnv_set_msgfile(arg1,(char const *)arg2); 
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1paniccall(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  void (*arg2)(DB_ENV *,int) = (void (*)(DB_ENV *,int)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  arg2 = (jarg2 == JNI_TRUE) ? __dbj_panic : NULL;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_paniccall(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1shm_1key(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  long arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (long)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_shm_key(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1timeout(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  db_timeout_t arg2 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (db_timeout_t)jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_timeout(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1tmp_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_tmp_dir(arg1,(char const *)arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1tx_1max(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_tx_max(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1app_1dispatch(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int (*arg2)(DB_ENV *,DBT *,DB_LSN *,db_recops) = (int (*)(DB_ENV *,DBT *,DB_LSN *,db_recops)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  arg2 = (jarg2 == JNI_TRUE) ? __dbj_app_dispatch : NULL;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_app_dispatch(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1event_1notify(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  void (*arg2)(DB_ENV *,u_int32_t,void *) = (void (*)(DB_ENV *,u_int32_t,void *)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  arg2 = (jarg2 == JNI_TRUE) ? __dbj_event_notify : NULL;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_event_notify(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1tx_1timestamp0(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  time_t *arg2 = (time_t *) 0 ;
  time_t time2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  time2 = (time_t)jarg2;
  arg2 = &time2;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_tx_timestamp(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1verbose(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  int_bool arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  arg3 = (jarg3 == JNI_TRUE); 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_verbose(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT jobjectArray JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1lk_1conflicts(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobjectArray jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  struct __db_lk_conflicts result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = DbEnv_get_lk_conflicts(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  {
    int i;
    jbyteArray bytes;
    
    jresult = (*jenv)->NewObjectArray(jenv,
      (jsize)(&result)->lk_modes, bytearray_class, NULL);
    if (jresult == NULL)
    return 0; /* an exception is pending */
    for (i = 0; i < (&result)->lk_modes; i++) {
      bytes = (*jenv)->NewByteArray(jenv, (jsize)(&result)->lk_modes);
      if (bytes == NULL)
      return 0; /* an exception is pending */
      (*jenv)->SetByteArrayRegion(jenv, bytes, 0, (jsize)(&result)->lk_modes,
        (jbyte *)((&result)->lk_conflicts + i * (&result)->lk_modes));
      (*jenv)->SetObjectArrayElement(jenv, jresult, (jsize)i, bytes);
    }
  }
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1lk_1detect(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_lk_detect(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1lk_1max_1locks(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_lk_max_locks(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1lk_1max_1lockers(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_lk_max_lockers(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1lk_1max_1objects(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_lk_max_objects(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1lk_1partitions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_lk_partitions(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1lk_1priority(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_lk_priority(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1lk_1tablesize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_lk_tablesize(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1memory_1init(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_memory_init(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1memory_1max(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  jlong result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = DbEnv_get_memory_max(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1lock_1detect(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  u_int32_t arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_lock_detect(arg1,arg2,arg3);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1lock_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jobject jarg4, jint jarg5) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  u_int32_t arg3 ;
  DBT *arg4 = (DBT *) 0 ;
  db_lockmode_t arg5 ;
  DBT_LOCKED ldbt4 ;
  DB_LOCK *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt4, &arg4, jarg4, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  arg5 = (db_lockmode_t)jarg5; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_LOCK *)DbEnv_lock_get(arg1,arg2,arg3,arg4,arg5);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  *(DB_LOCK **)&jresult = result; 
  __dbj_dbt_release(jenv, jarg4, arg4, &ldbt4); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1lock_1id(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_lock_id(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1lock_1id_1free(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_lock_id_free(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1lock_1put(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  DB_LOCK *arg2 = (DB_LOCK *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = *(DB_LOCK **)&jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_lock_put(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1lock_1stat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobject jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  DB_LOCK_STAT *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_LOCK_STAT *)DbEnv_lock_stat(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  
  if (result == NULL)
  jresult = NULL;
  else {
    jresult = (*jenv)->NewObject(jenv, lock_stat_class, lock_stat_construct);
    if (jresult != NULL)
    __dbj_fill_lock_stat(jenv, jresult, result);
    __os_ufree(NULL, result);
  }
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1lock_1stat_1print(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_lock_stat_print(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1lk_1conflicts(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  struct __db_lk_conflicts arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  {
    int i, len, ret;
    size_t bytesize;
    
    len = (&arg2)->lk_modes = (*jenv)->GetArrayLength(jenv, jarg2);
    bytesize = sizeof(u_char) * len * len;
    
    if ((ret = __os_malloc(NULL, bytesize, &(&arg2)->lk_conflicts)) != 0) {
      __dbj_throw(jenv, ret, NULL, NULL, JDBENV);
      return ;
    }
    
    for (i = 0; i < len; i++) {
      jobject sub_array = (*jenv)->GetObjectArrayElement(jenv,
        jarg2, i);
      (*jenv)->GetByteArrayRegion(jenv,(jbyteArray)sub_array, 0, len,
        (jbyte *)&(&arg2)->lk_conflicts[i * len]);
    }
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_lk_conflicts(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  
  __os_free(NULL, (&arg2)->lk_conflicts);
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1lk_1detect(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_lk_detect(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1lk_1max_1lockers(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_lk_max_lockers(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1lk_1max_1locks(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_lk_max_locks(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1lk_1max_1objects(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_lk_max_objects(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1lk_1partitions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_lk_partitions(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1lk_1priority(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_lk_priority(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1lk_1tablesize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_lk_tablesize(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1memory_1init(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_memory_init(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1memory_1max(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  jlong arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_memory_max(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1lg_1bsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_lg_bsize(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1lg_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (char *)DbEnv_get_lg_dir(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  if (result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1lg_1filemode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_get_lg_filemode(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1lg_1max(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_lg_max(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1lg_1regionmax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_lg_regionmax(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jobjectArray JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1log_1archive(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobjectArray jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  char **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (char **)DbEnv_log_archive(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  {
    if (result != NULL) {
      /*@SWIG:../lang/java/libdb_java/java_typemaps.i,633,STRING_ARRAY_OUT@*/	int i, len;
      
      len = 0;
      while (result[len] != NULL)
      len++;
      if ((jresult = (*jenv)->NewObjectArray(jenv, (jsize)len, string_class,
            NULL)) == NULL)
      return 0; /* an exception is pending */
      for (i = 0; i < len; i++) {
        jstring str = (*jenv)->NewStringUTF(jenv, result[i]);
        (*jenv)->SetObjectArrayElement(jenv, jresult, (jsize)i, str);
      }
      /*@SWIG@*/
      __os_ufree(NULL, result);
    }
  }
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1log_1compare(JNIEnv *jenv, jclass jcls, jobject jarg1, jobject jarg2) {
  jint jresult = 0 ;
  DB_LSN *arg1 = (DB_LSN *) 0 ;
  DB_LSN *arg2 = (DB_LSN *) 0 ;
  DB_LSN lsn1 ;
  DB_LSN lsn2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  
  if (jarg1 == NULL) {
    arg1 = NULL;
  } else {
    arg1 = &lsn1;
    arg1->file = (*jenv)->GetIntField(jenv, jarg1, dblsn_file_fid);
    arg1->offset = (*jenv)->GetIntField(jenv, jarg1,
      dblsn_offset_fid);
  }
  
  
  if (jarg2 == NULL) {
    arg2 = NULL;
  } else {
    arg2 = &lsn2;
    arg2->file = (*jenv)->GetIntField(jenv, jarg2, dblsn_file_fid);
    arg2->offset = (*jenv)->GetIntField(jenv, jarg2,
      dblsn_offset_fid);
  }
  
  
  if (arg1 == NULL) {
    __dbj_throw(jenv, EINVAL, "null LogSequenceNumber", NULL, NULL);
    return 0;
  }
  
  
  if (arg2 == NULL) {
    __dbj_throw(jenv, EINVAL, "null LogSequenceNumber", NULL, NULL);
    return 0;
  }
  
  result = (int)DbEnv_log_compare((struct DbLsn const *)arg1,(struct DbLsn const *)arg2); 
  jresult = (jint)result; 
  
  if (jarg1 != NULL) {
    (*jenv)->SetIntField(jenv, jarg1, dblsn_file_fid, arg1->file);
    (*jenv)->SetIntField(jenv, jarg1,
      dblsn_offset_fid, arg1->offset);
  }
  
  
  if (jarg2 != NULL) {
    (*jenv)->SetIntField(jenv, jarg2, dblsn_file_fid, arg2->file);
    (*jenv)->SetIntField(jenv, jarg2,
      dblsn_offset_fid, arg2->offset);
  }
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1log_1cursor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  DB_LOGC *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_LOGC *)DbEnv_log_cursor(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  *(DB_LOGC **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1log_1file(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jstring jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  DB_LSN *arg2 = (DB_LSN *) 0 ;
  DB_LSN lsn2 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg2 == NULL) {
    arg2 = NULL;
  } else {
    arg2 = &lsn2;
    arg2->file = (*jenv)->GetIntField(jenv, jarg2, dblsn_file_fid);
    arg2->offset = (*jenv)->GetIntField(jenv, jarg2,
      dblsn_offset_fid);
  }
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  if (arg2 == NULL) {
    __dbj_throw(jenv, EINVAL, "null LogSequenceNumber", NULL, NULL);
    return 0;
  }
  
  
  errno = 0;
  result = (char *)DbEnv_log_file(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  if (result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  
  if (jarg2 != NULL) {
    (*jenv)->SetIntField(jenv, jarg2, dblsn_file_fid, arg2->file);
    (*jenv)->SetIntField(jenv, jarg2,
      dblsn_offset_fid, arg2->offset);
  }
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1log_1flush(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  DB_LSN *arg2 = (DB_LSN *) 0 ;
  DB_LSN lsn2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg2 == NULL) {
    arg2 = NULL;
  } else {
    arg2 = &lsn2;
    arg2->file = (*jenv)->GetIntField(jenv, jarg2, dblsn_file_fid);
    arg2->offset = (*jenv)->GetIntField(jenv, jarg2,
      dblsn_offset_fid);
  }
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  
  result = (db_ret_t)DbEnv_log_flush(arg1,(struct DbLsn const *)arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  
  if (jarg2 != NULL) {
    (*jenv)->SetIntField(jenv, jarg2, dblsn_file_fid, arg2->file);
    (*jenv)->SetIntField(jenv, jarg2,
      dblsn_offset_fid, arg2->offset);
  }
  
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1log_1get_1config(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  int_bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int_bool)DbEnv_log_get_config(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (result) ? JNI_TRUE : JNI_FALSE; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1log_1put(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jint jarg4) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  DB_LSN *arg2 = (DB_LSN *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  u_int32_t arg4 ;
  DB_LSN lsn2 ;
  DBT_LOCKED ldbt3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg2 == NULL) {
    arg2 = NULL;
  } else {
    arg2 = &lsn2;
    arg2->file = (*jenv)->GetIntField(jenv, jarg2, dblsn_file_fid);
    arg2->offset = (*jenv)->GetIntField(jenv, jarg2,
      dblsn_offset_fid);
  }
  
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 0) != 0) {
    return ; /* An exception will be pending. */
  }
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  if (arg2 == NULL) {
    __dbj_throw(jenv, EINVAL, "null LogSequenceNumber", NULL, NULL);
    return ;
  }
  
  
  result = (db_ret_t)DbEnv_log_put(arg1,arg2,(struct Dbt const *)arg3,arg4);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  
  if (jarg2 != NULL) {
    (*jenv)->SetIntField(jenv, jarg2, dblsn_file_fid, arg2->file);
    (*jenv)->SetIntField(jenv, jarg2,
      dblsn_offset_fid, arg2->offset);
  }
  
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1log_1print(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  char *arg3 = (char *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return ;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_log_print(arg1,arg2,(char const *)arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1log_1set_1config(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  int_bool arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  arg3 = (jarg3 == JNI_TRUE); 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_log_set_config(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1log_1stat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobject jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  DB_LOG_STAT *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_LOG_STAT *)DbEnv_log_stat(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  
  if (result == NULL)
  jresult = NULL;
  else {
    jresult = (*jenv)->NewObject(jenv, log_stat_class, log_stat_construct);
    if (jresult != NULL)
    __dbj_fill_log_stat(jenv, jresult, result);
    __os_ufree(NULL, result);
  }
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1log_1stat_1print(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_log_stat_print(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1log_1verify(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3, jstring jarg4, jstring jarg5, jlong jarg6, jlong jarg7, jint jarg8, jint jarg9, jint jarg10, jint jarg11, jint jarg12, jint jarg13) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  u_int32_t arg3 ;
  char *arg4 = (char *) 0 ;
  char *arg5 = (char *) 0 ;
  time_t arg6 ;
  time_t arg7 ;
  u_int32_t arg8 ;
  u_int32_t arg9 ;
  u_int32_t arg10 ;
  u_int32_t arg11 ;
  int arg12 ;
  int arg13 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (u_int32_t)jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg4, 0);
    if (!arg4) return 0;
  }
  arg5 = 0;
  if (jarg5) {
    arg5 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg5, 0);
    if (!arg5) return 0;
  }
  
  arg6 = jarg6;
  
  
  arg7 = jarg7;
  
  arg8 = (u_int32_t)jarg8; 
  arg9 = (u_int32_t)jarg9; 
  arg10 = (u_int32_t)jarg10; 
  arg11 = (u_int32_t)jarg11; 
  arg12 = (int)jarg12; 
  arg13 = (int)jarg13; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_log_verify(arg1,(char const *)arg2,arg3,(char const *)arg4,(char const *)arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
  if (arg4) (*jenv)->ReleaseStringUTFChars(jenv, jarg4, (const char *)arg4);
  if (arg5) (*jenv)->ReleaseStringUTFChars(jenv, jarg5, (const char *)arg5);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1lg_1bsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_lg_bsize(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1lg_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_lg_dir(arg1,(char const *)arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1lg_1filemode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_lg_filemode(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1lg_1max(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_lg_max(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1lg_1regionmax(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_lg_regionmax(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1cachesize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  jlong result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = DbEnv_get_cachesize(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1cachesize_1ncache(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_get_cachesize_ncache(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1cache_1max(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  jlong result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = DbEnv_get_cache_max(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1create_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (char *)DbEnv_get_create_dir(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  if (result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1mp_1max_1openfd(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_get_mp_max_openfd(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1mp_1max_1write(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_get_mp_max_write(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1mp_1max_1write_1sleep(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  db_timeout_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (db_timeout_t)DbEnv_get_mp_max_write_sleep(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1mp_1mmapsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = DbEnv_get_mp_mmapsize(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1mp_1pagesize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_get_mp_pagesize(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1mp_1tablesize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_get_mp_tablesize(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1memp_1stat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobject jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  DB_MPOOL_STAT *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_MPOOL_STAT *)DbEnv_memp_stat(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  
  if (result == NULL)
  jresult = NULL;
  else {
    jresult = (*jenv)->NewObject(jenv, mpool_stat_class, mpool_stat_construct);
    if (jresult != NULL)
    __dbj_fill_mpool_stat(jenv, jresult, result);
    __os_ufree(NULL, result);
  }
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1memp_1stat_1print(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_memp_stat_print(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jobjectArray JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1memp_1fstat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobjectArray jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  DB_MPOOL_FSTAT **result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_MPOOL_FSTAT **)DbEnv_memp_fstat(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  {
    int i, len;
    
    if (result == NULL)
    jresult = NULL;
    else {
      len = 0;
      while (result[len] != NULL)
      len++;
      jresult = (*jenv)->NewObjectArray(jenv, (jsize)len,
        mpool_fstat_class, 0);
      if (jresult == NULL) {
        __os_ufree(NULL, result);
        return 0;
      }
      for (i = 0; i < len; i++) {
        jobject obj = (*jenv)->NewObject(jenv, mpool_fstat_class,
          mpool_fstat_construct);
        if (obj == NULL) {
          __os_ufree(NULL, result);
          return 0; /* an exception is pending */
        }
        (*jenv)->SetObjectArrayElement(jenv, jresult, i, obj);
        __dbj_fill_mpool_fstat(jenv, obj, result[i]);
      }
      __os_ufree(NULL, result);
    }
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1memp_1sync(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  DB_LSN *arg2 = (DB_LSN *) 0 ;
  DB_LSN lsn2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg2 == NULL) {
    arg2 = NULL;
  } else {
    arg2 = &lsn2;
    arg2->file = (*jenv)->GetIntField(jenv, jarg2, dblsn_file_fid);
    arg2->offset = (*jenv)->GetIntField(jenv, jarg2,
      dblsn_offset_fid);
  }
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  
  errno = 0;
  result = (db_ret_t)DbEnv_memp_sync(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  
  if (jarg2 != NULL) {
    (*jenv)->SetIntField(jenv, jarg2, dblsn_file_fid, arg2->file);
    (*jenv)->SetIntField(jenv, jarg2,
      dblsn_offset_fid, arg2->offset);
  }
  
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1memp_1trickle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_memp_trickle(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1mutex_1get_1align(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_mutex_get_align(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1mutex_1get_1increment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_mutex_get_increment(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1mutex_1get_1init(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_mutex_get_init(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1mutex_1get_1max(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_mutex_get_max(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1mutex_1get_1tas_1spins(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_mutex_get_tas_spins(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1mutex_1set_1align(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_mutex_set_align(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1mutex_1set_1increment(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_mutex_set_increment(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1mutex_1set_1init(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_mutex_set_init(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1mutex_1set_1max(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_mutex_set_max(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1mutex_1set_1tas_1spins(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_mutex_set_tas_spins(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1mutex_1stat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobject jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  DB_MUTEX_STAT *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_MUTEX_STAT *)DbEnv_mutex_stat(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  
  if (result == NULL)
  jresult = NULL;
  else {
    jresult = (*jenv)->NewObject(jenv, mutex_stat_class, mutex_stat_construct);
    if (jresult != NULL)
    __dbj_fill_mutex_stat(jenv, jresult, result);
    __os_ufree(NULL, result);
  }
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1mutex_1stat_1print(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_mutex_stat_print(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1region_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (char *)DbEnv_get_region_dir(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  if (result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1region_1dir(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  errno = 0;
  result = (db_ret_t)DbEnv_set_region_dir(arg1,(char const *)arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1tx_1max(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_tx_max(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1tx_1timestamp(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  time_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = DbEnv_get_tx_timestamp(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1timeout(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_timeout_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (db_timeout_t)DbEnv_get_timeout(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1stat_1print(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_stat_print(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1txn_1applied(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3, jint jarg4) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  DB_TXN_TOKEN *arg2 = (DB_TXN_TOKEN *) 0 ;
  u_int32_t arg3 ;
  u_int32_t arg4 ;
  DB_TXN_TOKEN token2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg2 == NULL) {
    arg2 = NULL;
  } else {
    arg2 = &token2;
    (*jenv)->GetByteArrayRegion(jenv, (jbyteArray)jarg2, 0, DB_TXN_TOKEN_SIZE, (jbyte *)arg2->buf);
  }
  
  arg3 = (u_int32_t)jarg3; 
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  if (arg2 == NULL) {
    __dbj_throw(jenv, EINVAL, "null txn commit token", NULL, NULL);
    return 0;
  }
  
  
  result = (int)DbEnv_txn_applied(arg1,arg2,arg3,arg4);
  if (!DB_RETOK_TXNAPPLIED(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1txn_1begin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  u_int32_t arg3 ;
  DB_TXN *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_TXN *)DbEnv_txn_begin(arg1,arg2,arg3);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  *(DB_TXN **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1txn_1checkpoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  u_int32_t arg3 ;
  u_int32_t arg4 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  arg3 = (u_int32_t)jarg3; 
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_txn_checkpoint(arg1,arg2,arg3,arg4);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT jobjectArray JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1txn_1recover(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  jobjectArray jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  long arg2 ;
  long arg3 ;
  DB_PREPLIST *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (long)jarg2; 
  arg3 = (long)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_PREPLIST *)DbEnv_txn_recover(arg1,arg2,arg3);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  {
    int i, len;
    
    if (result == NULL)
    jresult = NULL;
    else {
      len = 0;
      while (result[len].txn != NULL)
      len++;
      jresult = (*jenv)->NewObjectArray(jenv, (jsize)len, dbpreplist_class,
        NULL);
      if (jresult == NULL)
      return 0; /* an exception is pending */
      for (i = 0; i < len; i++) {
        jobject jtxn = (*jenv)->NewObject(jenv, dbtxn_class,
          dbtxn_construct, result[i].txn, JNI_FALSE);
        jobject bytearr = (*jenv)->NewByteArray(jenv,
          (jsize)sizeof(result[i].gid));
        jobject obj = (*jenv)->NewObject(jenv, dbpreplist_class,
          dbpreplist_construct, jtxn, bytearr);
        
        if (jtxn == NULL || bytearr == NULL || obj == NULL)
        return 0; /* An exception is pending */
        
        (*jenv)->SetByteArrayRegion(jenv, bytearr, 0,
          (jsize)sizeof(result[i].gid), (jbyte *)result[i].gid);
        (*jenv)->SetObjectArrayElement(jenv, jresult, i, obj);
      }
      __os_ufree(NULL, result);
    }
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1txn_1stat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobject jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  DB_TXN_STAT *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_TXN_STAT *)DbEnv_txn_stat(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  {
    unsigned int i;
    jobjectArray actives;
    
    if (result == NULL)
    jresult = NULL;
    else {
      jresult = (*jenv)->NewObject(jenv, txn_stat_class, txn_stat_construct);
      if (jresult != NULL)
      __dbj_fill_txn_stat(jenv, jresult, result);
      
      actives = (*jenv)->NewObjectArray(jenv, (jsize)result->st_nactive,
        txn_active_class, 0);
      if (actives == NULL) {
        __os_ufree(NULL, result);
        return 0;
      }
      (*jenv)->SetObjectField(jenv, jresult,
        txn_stat_st_txnarray_fid, actives);
      for (i = 0; i < result->st_nactive; i++) {
        jobject obj = (*jenv)->NewObject(jenv, txn_active_class,
          txn_active_construct);
        if (obj == NULL) {
          __os_ufree(NULL, result);
          return 0; /* an exception is pending */
        }
        (*jenv)->SetObjectArrayElement(jenv, actives, (jsize)i, obj);
        __dbj_fill_txn_active(jenv, obj, &result->st_txnarray[i], arg1);
      }
      __os_ufree(NULL, result);
    }
  }
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1txn_1stat_1print(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_txn_stat_print(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1get_1limit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  jlong result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = DbEnv_rep_get_limit(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1elect(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jint jarg4) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  int arg3 ;
  u_int32_t arg4 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_rep_elect(arg1,arg2,arg3,arg4);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1process_1message(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jint jarg4, jobject jarg5) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  DBT *arg2 = (DBT *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  int arg4 ;
  DB_LSN *arg5 = (DB_LSN *) 0 ;
  DBT_LOCKED ldbt2 ;
  DBT_LOCKED ldbt3 ;
  DB_LSN lsn5 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt2, &arg2, jarg2, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  arg4 = (int)jarg4; 
  
  if (jarg5 == NULL) {
    arg5 = NULL;
  } else {
    arg5 = &lsn5;
    arg5->file = (*jenv)->GetIntField(jenv, jarg5, dblsn_file_fid);
    arg5->offset = (*jenv)->GetIntField(jenv, jarg5,
      dblsn_offset_fid);
  }
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  if (arg5 == NULL) {
    __dbj_throw(jenv, EINVAL, "null LogSequenceNumber", NULL, NULL);
    return 0;
  }
  
  
  result = (int)DbEnv_rep_process_message(arg1,arg2,arg3,arg4,arg5);
  if (!DB_RETOK_REPPMSG(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  __dbj_dbt_release(jenv, jarg2, arg2, &ldbt2); 
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
  
  if (jarg5 != NULL) {
    (*jenv)->SetIntField(jenv, jarg5, dblsn_file_fid, arg5->file);
    (*jenv)->SetIntField(jenv, jarg5,
      dblsn_offset_fid, arg5->offset);
  }
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1flush(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_rep_flush(arg1);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1set_1config(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  int_bool arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  arg3 = (jarg3 == JNI_TRUE); 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_rep_set_config(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1set_1clockskew(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_rep_set_clockskew(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1get_1clockskew_1fast(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_rep_get_clockskew_fast(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1get_1clockskew_1slow(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_rep_get_clockskew_slow(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1start(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  DBT *arg2 = (DBT *) 0 ;
  u_int32_t arg3 ;
  DBT_LOCKED ldbt2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt2, &arg2, jarg2, 1) != 0) {
    return ; /* An exception will be pending. */
  }
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_rep_start(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  __dbj_dbt_release(jenv, jarg2, arg2, &ldbt2); 
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1sync(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_rep_sync(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1get_1config(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  int_bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int_bool)DbEnv_rep_get_config(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (result) ? JNI_TRUE : JNI_FALSE; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1stat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobject jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  DB_REP_STAT *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_REP_STAT *)DbEnv_rep_stat(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  
  if (result == NULL)
  jresult = NULL;
  else {
    jresult = (*jenv)->NewObject(jenv, rep_stat_class, rep_stat_construct);
    if (jresult != NULL)
    __dbj_fill_rep_stat(jenv, jresult, result);
    __os_ufree(NULL, result);
  }
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1stat_1print(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_rep_stat_print(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1set_1limit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  jlong arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_rep_set_limit(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1get_1request_1min(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_rep_get_request_min(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1get_1request_1max(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_rep_get_request_max(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1repmgr_1channel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int arg2 ;
  u_int32_t arg3 ;
  DB_CHANNEL *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_CHANNEL *)DbEnv_repmgr_channel(arg1,arg2,arg3);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  *(DB_CHANNEL **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1set_1request(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_rep_set_request(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1set_1transport(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int arg2 ;
  int (*arg3)(DB_ENV *,DBT const *,DBT const *,DB_LSN const *,int,u_int32_t) = (int (*)(DB_ENV *,DBT const *,DBT const *,DB_LSN const *,int,u_int32_t)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (int)jarg2; 
  
  arg3 = (jarg3 == JNI_TRUE) ? __dbj_rep_transport : NULL;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_rep_set_transport(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1set_1view(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int (*arg2)(DB_ENV *,char const *,int *,u_int32_t) = (int (*)(DB_ENV *,char const *,int *,u_int32_t)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  arg2 = (jarg2 == JNI_TRUE) ? __dbj_rep_view : NULL;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_rep_set_view(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1get_1nsites(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_rep_get_nsites(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1get_1priority(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_rep_get_priority(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1get_1timeout(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int arg2 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_rep_get_timeout(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1set_1nsites(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_rep_set_nsites(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1set_1priority(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_rep_set_priority(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1rep_1set_1timeout(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int arg2 ;
  db_timeout_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (db_timeout_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_rep_set_timeout(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1repmgr_1get_1ack_1policy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_repmgr_get_ack_policy(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1repmgr_1get_1incoming_1queue_1max(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  jlong result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = DbEnv_repmgr_get_incoming_queue_max(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1repmgr_1local_1site(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  DB_SITE *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_SITE *)DbEnv_repmgr_local_site(arg1);
  if (!DB_RETOK_REPMGR_LOCALSITE(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  *(DB_SITE **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1repmgr_1set_1ack_1policy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_repmgr_set_ack_policy(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1repmgr_1set_1incoming_1queue_1max(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  jlong arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_repmgr_set_incoming_queue_max(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1repmgr_1site(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  u_int arg3 ;
  DB_SITE *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return 0;
  }
  
  arg3 = (u_int)jarg3;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_SITE *)DbEnv_repmgr_site(arg1,(char const *)arg2,arg3);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  *(DB_SITE **)&jresult = result; 
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1repmgr_1site_1by_1eid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int arg2 ;
  DB_SITE *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_SITE *)DbEnv_repmgr_site_by_eid(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  *(DB_SITE **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1repmgr_1set_1dispatch(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2, jint jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  void (*arg2)(DB_ENV *,DB_CHANNEL *,DBT *,u_int32_t,u_int32_t) = (void (*)(DB_ENV *,DB_CHANNEL *,DBT *,u_int32_t,u_int32_t)) 0 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  arg2 = (jarg2 == JNI_TRUE) ? __dbj_repmgr_msg_dispatch : NULL;
  
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  errno = 0;
  result = (db_ret_t)DbEnv_repmgr_set_dispatch(arg1,arg2,arg3);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT jobjectArray JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1repmgr_1site_1list(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobjectArray jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  struct __db_repmgr_sites result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = DbEnv_repmgr_site_list(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  {
    int i, len;
    jobject jrep_addr, jrep_info;
    
    len = (&result)->nsites;
    jresult = (*jenv)->NewObjectArray(jenv, (jsize)len, repmgr_siteinfo_class,
      NULL);
    if (jresult == NULL)
    return 0; /* an exception is pending */
    for (i = 0; i < len; i++) {
      jstring addr_host = (*jenv)->NewStringUTF(jenv, (&result)->sites[i].host);
      if (addr_host == NULL)
      return 0; /* An exception is pending */
      jrep_addr = (*jenv)->NewObject(jenv,
        rephost_class, rephost_construct, addr_host, (&result)->sites[i].port);
      if (jrep_addr == NULL)
      return 0; /* An exception is pending */
      
      jrep_info = (*jenv)->NewObject(jenv,
        repmgr_siteinfo_class, repmgr_siteinfo_construct, jrep_addr, (&result)->sites[i].eid);
      if (jrep_info == NULL)
      return 0; /* An exception is pending */
      (*jenv)->SetIntField(jenv, jrep_info, repmgr_siteinfo_flags_fid,
        (&result)->sites[i].flags);
      (*jenv)->SetIntField(jenv, jrep_info, repmgr_siteinfo_status_fid,
        (&result)->sites[i].status);
      
      (*jenv)->SetObjectArrayElement(jenv, jresult, i, jrep_info);
    }
    __os_ufree(NULL, (&result)->sites);
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1repmgr_1start(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int arg2 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_repmgr_start(arg1,arg2,arg3);
  if (!DB_RETOK_REPMGR_START(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1repmgr_1stat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobject jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  DB_REPMGR_STAT *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_REPMGR_STAT *)DbEnv_repmgr_stat(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  
  if (result == NULL)
  jresult = NULL;
  else {
    jresult = (*jenv)->NewObject(jenv, repmgr_stat_class, repmgr_stat_construct);
    if (jresult != NULL)
    __dbj_fill_repmgr_stat(jenv, jresult, result);
    __os_ufree(NULL, result);
  }
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1repmgr_1stat_1print(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbEnv_repmgr_stat_print(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1backup_1config(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbEnv_get_backup_config(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1backup(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_backup(arg1,(char const *)arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1dbbackup(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jint jarg4) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  u_int32_t arg4 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_dbbackup(arg1,(char const *)arg2,(char const *)arg3,arg4);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
  if (arg3) (*jenv)->ReleaseStringUTFChars(jenv, jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1backup_1callbacks(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2, jboolean jarg3, jboolean jarg4) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  int (*arg2)(DB_ENV *,char const *,char const *,void **) = (int (*)(DB_ENV *,char const *,char const *,void **)) 0 ;
  int (*arg3)(DB_ENV *,u_int32_t,u_int32_t,u_int32_t,u_int8_t *,void *) = (int (*)(DB_ENV *,u_int32_t,u_int32_t,u_int32_t,u_int8_t *,void *)) 0 ;
  int (*arg4)(DB_ENV *,char const *,void *) = (int (*)(DB_ENV *,char const *,void *)) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  
  arg2 = (jarg2 == JNI_TRUE) ? __dbj_backup_open : NULL;
  
  
  arg3 = (jarg3 == JNI_TRUE) ? __dbj_backup_write : NULL;
  
  
  arg4 = (jarg4 == JNI_TRUE) ? __dbj_backup_close : NULL;
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_backup_callbacks(arg1,arg2,arg3,arg4);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1set_1backup_1config(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  struct DbEnv *arg1 = (struct DbEnv *) 0 ;
  u_int32_t arg2 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbEnv **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbEnv_set_backup_config(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, JDBENV);
  }
  
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1strerror(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  int arg1 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (char *)DbEnv_strerror(arg1); 
  if (result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1version_1family(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)DbEnv_get_version_family(); 
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1version_1release(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)DbEnv_get_version_release(); 
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1version_1major(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)DbEnv_get_version_major(); 
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1version_1minor(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)DbEnv_get_version_minor(); 
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1version_1patch(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)DbEnv_get_version_patch(); 
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1version_1string(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)DbEnv_get_version_string(); 
  if (result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1get_1version_1full_1string(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (char *)DbEnv_get_version_full_string(); 
  if (result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbEnv_1slices_1enabled(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)DbEnv_slices_enabled(); 
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_delete_1DbLock(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  struct DbLock *arg1 = (struct DbLock *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(struct DbLock **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  delete_DbLock(arg1); 
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbLogc_1close0(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbLogc *arg1 = (struct DbLogc *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbLogc **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbLogc_close(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbLogc_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jobject jarg3, jint jarg4) {
  jint jresult = 0 ;
  struct DbLogc *arg1 = (struct DbLogc *) 0 ;
  DB_LSN *arg2 = (DB_LSN *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  u_int32_t arg4 ;
  DB_LSN lsn2 ;
  DBT_LOCKED ldbt3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbLogc **)&jarg1; 
  
  if (jarg2 == NULL) {
    arg2 = NULL;
  } else {
    arg2 = &lsn2;
    arg2->file = (*jenv)->GetIntField(jenv, jarg2, dblsn_file_fid);
    arg2->offset = (*jenv)->GetIntField(jenv, jarg2,
      dblsn_offset_fid);
  }
  
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  if (arg2 == NULL) {
    __dbj_throw(jenv, EINVAL, "null LogSequenceNumber", NULL, NULL);
    return 0;
  }
  
  
  result = (int)DbLogc_get(arg1,arg2,arg3,arg4);
  if (!DB_RETOK_LGGET(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
  jresult = (jint)result; 
  
  if (jarg2 != NULL) {
    (*jenv)->SetIntField(jenv, jarg2, dblsn_file_fid, arg2->file);
    (*jenv)->SetIntField(jenv, jarg2,
      dblsn_offset_fid, arg2->offset);
  }
  
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbLogc_1version(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  struct DbLogc *arg1 = (struct DbLogc *) 0 ;
  u_int32_t arg2 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbLogc **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbLogc_version(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbMpoolFile_1get_1priority(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbMpoolFile *arg1 = (struct DbMpoolFile *) 0 ;
  DB_CACHE_PRIORITY result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbMpoolFile **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_CACHE_PRIORITY)DbMpoolFile_get_priority(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbMpoolFile_1set_1priority(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbMpoolFile *arg1 = (struct DbMpoolFile *) 0 ;
  DB_CACHE_PRIORITY arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbMpoolFile **)&jarg1; 
  arg2 = (DB_CACHE_PRIORITY)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbMpoolFile_set_priority(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbMpoolFile_1get_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbMpoolFile *arg1 = (struct DbMpoolFile *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbMpoolFile **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbMpoolFile_get_flags(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbMpoolFile_1set_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  struct DbMpoolFile *arg1 = (struct DbMpoolFile *) 0 ;
  u_int32_t arg2 ;
  int_bool arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbMpoolFile **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  arg3 = (jarg3 == JNI_TRUE); 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbMpoolFile_set_flags(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbMpoolFile_1get_1maxsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  struct DbMpoolFile *arg1 = (struct DbMpoolFile *) 0 ;
  jlong result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbMpoolFile **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = DbMpoolFile_get_maxsize(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbMpoolFile_1set_1maxsize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  struct DbMpoolFile *arg1 = (struct DbMpoolFile *) 0 ;
  jlong arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbMpoolFile **)&jarg1; 
  arg2 = jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbMpoolFile_set_maxsize(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_new_1DbSequence(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  DB *arg1 = (DB *) 0 ;
  u_int32_t arg2 ;
  struct DbSequence *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(DB **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  errno = 0;
  result = (struct DbSequence *)new_DbSequence(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  *(struct DbSequence **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1close0(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbSequence **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbSequence_close(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1get(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  jlong jresult = 0 ;
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  u_int32_t arg3 ;
  u_int32_t arg4 ;
  db_seq_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(struct DbSequence **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  arg3 = (u_int32_t)jarg3; 
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (db_seq_t)DbSequence_get(arg1,arg2,arg3,arg4);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1get_1cachesize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbSequence **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbSequence_get_cachesize(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1get_1db(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  DB *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbSequence **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB *)DbSequence_get_db(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  *(DB **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1get_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbSequence **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbSequence_get_flags(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1get_1key(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  DBT *arg2 = (DBT *) 0 ;
  DBT_LOCKED ldbt2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbSequence **)&jarg1; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt2, &arg2, jarg2, 0) != 0) {
    return ; /* An exception will be pending. */
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbSequence_get_key(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
  __dbj_dbt_release(jenv, jarg2, arg2, &ldbt2); 
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1get_1range_1min(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  db_seq_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbSequence **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (db_seq_t)DbSequence_get_range_min(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1get_1range_1max(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  db_seq_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbSequence **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (db_seq_t)DbSequence_get_range_max(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1initial_1value(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  db_seq_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbSequence **)&jarg1; 
  arg2 = (db_seq_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbSequence_initial_value(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1open(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jint jarg4) {
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  DBT *arg3 = (DBT *) 0 ;
  u_int32_t arg4 ;
  DBT_LOCKED ldbt3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(struct DbSequence **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt3, &arg3, jarg3, 0) != 0) {
    return ; /* An exception will be pending. */
  }
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbSequence_open(arg1,arg2,arg3,arg4);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
  __dbj_dbt_release(jenv, jarg3, arg3, &ldbt3); 
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1remove0(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(struct DbSequence **)&jarg1; 
  arg2 = *(DB_TXN **)&jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbSequence_remove(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1set_1cachesize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbSequence **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbSequence_set_cachesize(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1set_1flags(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbSequence **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbSequence_set_flags(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1set_1range(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jlong jarg3) {
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  db_seq_t arg2 ;
  db_seq_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbSequence **)&jarg1; 
  arg2 = (db_seq_t)jarg2; 
  arg3 = (db_seq_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbSequence_set_range(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1stat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobject jresult = 0 ;
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  u_int32_t arg2 ;
  DB_SEQUENCE_STAT *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbSequence **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (DB_SEQUENCE_STAT *)DbSequence_stat(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  
  if (result == NULL)
  jresult = NULL;
  else {
    jresult = (*jenv)->NewObject(jenv, seq_stat_class, seq_stat_construct);
    if (jresult != NULL)
    __dbj_fill_seq_stat(jenv, jresult, result);
    __os_ufree(NULL, result);
  }
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSequence_1stat_1print(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  struct DbSequence *arg1 = (struct DbSequence *) 0 ;
  u_int32_t arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbSequence **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbSequence_stat_print(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSite_1close0(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  struct DbSite *arg1 = (struct DbSite *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbSite **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbSite_close(arg1);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSite_1get_1address(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  struct DbSite *arg1 = (struct DbSite *) 0 ;
  struct __db_repmgr_site_address result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbSite **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = DbSite_get_address(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  {
    jstring addr_host;
    if ((&result)->host == NULL)
    return 0;
    addr_host = (*jenv)->NewStringUTF(jenv, (&result)->host);
    if (addr_host == NULL)
    return 0; /* An exception is pending. */
    jresult = (*jenv)->NewObject(jenv,
      rephost_class, rephost_construct, addr_host, (&result)->port);
    if (jresult == NULL)
    return 0; /* An exception is pending */
  }
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSite_1get_1config(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  struct DbSite *arg1 = (struct DbSite *) 0 ;
  u_int32_t arg2 ;
  int_bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbSite **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int_bool)DbSite_get_config(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  jresult = (result) ? JNI_TRUE : JNI_FALSE; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSite_1get_1eid(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbSite *arg1 = (struct DbSite *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbSite **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (int)DbSite_get_eid(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSite_1remove0(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  struct DbSite *arg1 = (struct DbSite *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbSite **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbSite_remove(arg1);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbSite_1set_1config(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  struct DbSite *arg1 = (struct DbSite *) 0 ;
  u_int32_t arg2 ;
  int_bool arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbSite **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  arg3 = (jarg3 == JNI_TRUE); 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbSite_set_config(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbStream_1close0(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbStream *arg1 = (struct DbStream *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbStream **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbStream_close(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbStream_1read(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong jarg3, jint jarg4, jint jarg5) {
  jint jresult = 0 ;
  struct DbStream *arg1 = (struct DbStream *) 0 ;
  DBT *arg2 = (DBT *) 0 ;
  db_off_t arg3 ;
  u_int32_t arg4 ;
  u_int32_t arg5 ;
  DBT_LOCKED ldbt2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbStream **)&jarg1; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt2, &arg2, jarg2, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  arg3 = (db_off_t)jarg3; 
  arg4 = (u_int32_t)jarg4; 
  arg5 = (u_int32_t)jarg5; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  result = (int)DbStream_read(arg1,arg2,arg3,arg4,arg5);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
  jresult = (jint)result; 
  __dbj_dbt_release(jenv, jarg2, arg2, &ldbt2); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbStream_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  struct DbStream *arg1 = (struct DbStream *) 0 ;
  u_int32_t arg2 ;
  db_off_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbStream **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (db_off_t)DbStream_size(arg1,arg2);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, NULL);
  }
  
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbStream_1write(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong jarg3, jint jarg4) {
  jint jresult = 0 ;
  struct DbStream *arg1 = (struct DbStream *) 0 ;
  DBT *arg2 = (DBT *) 0 ;
  db_off_t arg3 ;
  u_int32_t arg4 ;
  DBT_LOCKED ldbt2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbStream **)&jarg1; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt2, &arg2, jarg2, 0) != 0) {
    return 0; /* An exception will be pending. */
  }
  arg3 = (db_off_t)jarg3; 
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  result = (int)DbStream_write(arg1,arg2,arg3,arg4);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
  jresult = (jint)result; 
  __dbj_dbt_release(jenv, jarg2, arg2, &ldbt2); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbTxn_1abort0(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  struct DbTxn *arg1 = (struct DbTxn *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbTxn **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbTxn_abort(arg1);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbTxn_1discard0(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbTxn *arg1 = (struct DbTxn *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbTxn **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbTxn_discard(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbTxn_1get_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  struct DbTxn *arg1 = (struct DbTxn *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbTxn **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (char *)DbTxn_get_name(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, TXN2JDBENV);
  }
  
  if (result) jresult = (*jenv)->NewStringUTF(jenv, (const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbTxn_1get_1priority(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbTxn *arg1 = (struct DbTxn *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbTxn **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  
  errno = 0;
  result = (u_int32_t)DbTxn_get_priority(arg1);
  if (!DB_RETOK_STD(errno)) {
    __dbj_throw(jenv, errno, NULL, NULL, TXN2JDBENV);
  }
  
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbTxn_1id(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  struct DbTxn *arg1 = (struct DbTxn *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbTxn **)&jarg1; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return 0;
  }
  result = (u_int32_t)DbTxn_id(arg1); 
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbTxn_1prepare(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2) {
  struct DbTxn *arg1 = (struct DbTxn *) 0 ;
  u_int8_t *arg2 = (u_int8_t *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbTxn **)&jarg1; 
  
  arg2 = (u_int8_t *)(*jenv)->GetByteArrayElements(jenv, jarg2, NULL);
  
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  if ((*jenv)->GetArrayLength(jenv, jarg2) < DB_GID_SIZE) {
    __dbj_throw(jenv, EINVAL,
      "DbTxn.prepare gid array must be >= 128 bytes", NULL,
      TXN2JDBENV);
    return ;
  }
  
  
  result = (db_ret_t)DbTxn_prepare(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, TXN2JDBENV);
  }
  
  
  (*jenv)->ReleaseByteArrayElements(jenv, jarg2, (jbyte *)arg2, 0);
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbTxn_1set_1timeout(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jint jarg3) {
  struct DbTxn *arg1 = (struct DbTxn *) 0 ;
  db_timeout_t arg2 ;
  u_int32_t arg3 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbTxn **)&jarg1; 
  arg2 = (db_timeout_t)jarg2; 
  arg3 = (u_int32_t)jarg3; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbTxn_set_timeout(arg1,arg2,arg3);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, TXN2JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbTxn_1set_1name(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  struct DbTxn *arg1 = (struct DbTxn *) 0 ;
  char *arg2 = (char *) 0 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbTxn **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)(*jenv)->GetStringUTFChars(jenv, jarg2, 0);
    if (!arg2) return ;
  }
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbTxn_set_name(arg1,(char const *)arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, TXN2JDBENV);
  }
  
  if (arg2) (*jenv)->ReleaseStringUTFChars(jenv, jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbTxn_1set_1priority(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbTxn *arg1 = (struct DbTxn *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbTxn **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbTxn_set_priority(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, TXN2JDBENV);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbChannel_1close0(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  struct DbChannel *arg1 = (struct DbChannel *) 0 ;
  u_int32_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbChannel **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbChannel_close(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbChannel_1send_1repmsg(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jint jarg3, jint jarg4) {
  struct DbChannel *arg1 = (struct DbChannel *) 0 ;
  DBT *arg2 = (DBT *) 0 ;
  u_int32_t arg3 ;
  u_int32_t arg4 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbChannel **)&jarg1; 
  {
    DBT_LOCKED lresult;
    int count, i, ret;
    
    count = (*jenv)->GetArrayLength(jenv, jarg2);
    if ((ret = __os_malloc(NULL, count * sizeof(DBT), &arg2)) != 0) {
      __dbj_throw(jenv, ret, NULL, NULL, NULL);
      return ;
    }
    memset(arg2, 0, count * sizeof(DBT));
    for (i = 0; i < count; i++) {
      jobject jresult = (*jenv)->GetObjectArrayElement(jenv, jarg2, i);
      if ((ret =
          __dbj_dbt_copyin(jenv, &lresult, NULL, jresult, 0)) != 0) {
        return ; /* An exception will be pending. */
      }
      if (lresult.dbt.size != 0) {
        /* If there's data, we need to take a copy of it.  */
        arg2[i].size = lresult.dbt.size;
        if ((ret = __os_malloc(
              NULL, arg2[i].size, arg2[i].data)) != 0) {
          __dbj_throw(jenv, ret, NULL, NULL, NULL);	
          return ;
        }
        
        if ((ret = __dbj_dbt_memcopy(&lresult.dbt, 0,
              arg2[i].data, arg2[i].size, DB_USERCOPY_GETDATA)) != 0) {
          __dbj_throw(jenv, ret, NULL, NULL, NULL);
          return ;
        }
        
        __dbj_dbt_release(jenv, jresult, &lresult.dbt, &lresult);
        (*jenv)->DeleteLocalRef(jenv, lresult.jarr);
      }
      (*jenv)->DeleteLocalRef(jenv, jresult);
    }
  }
  arg3 = (u_int32_t)jarg3; 
  arg4 = (u_int32_t)jarg4; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbChannel_send_repmsg(arg1,arg2,arg3,arg4);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
  
  {
    int count, i;
    
    count = (*jenv)->GetArrayLength(jenv, jarg2);
    for (i = 0; i < count; i++)
    __os_free(NULL, arg2[i].data);
    __os_free(NULL, arg2);
  }
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbChannel_1send_1request(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobjectArray jarg2, jint jarg3, jobject jarg4, jlong jarg5, jint jarg6) {
  struct DbChannel *arg1 = (struct DbChannel *) 0 ;
  DBT *arg2 = (DBT *) 0 ;
  u_int32_t arg3 ;
  DBT *arg4 = (DBT *) 0 ;
  db_timeout_t arg5 ;
  u_int32_t arg6 ;
  DBT_LOCKED ldbt4 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbChannel **)&jarg1; 
  {
    DBT_LOCKED lresult;
    int count, i, ret;
    
    count = (*jenv)->GetArrayLength(jenv, jarg2);
    if ((ret = __os_malloc(NULL, count * sizeof(DBT), &arg2)) != 0) {
      __dbj_throw(jenv, ret, NULL, NULL, NULL);
      return ;
    }
    memset(arg2, 0, count * sizeof(DBT));
    for (i = 0; i < count; i++) {
      jobject jresult = (*jenv)->GetObjectArrayElement(jenv, jarg2, i);
      if ((ret =
          __dbj_dbt_copyin(jenv, &lresult, NULL, jresult, 0)) != 0) {
        return ; /* An exception will be pending. */
      }
      if (lresult.dbt.size != 0) {
        /* If there's data, we need to take a copy of it.  */
        arg2[i].size = lresult.dbt.size;
        if ((ret = __os_malloc(
              NULL, arg2[i].size, arg2[i].data)) != 0) {
          __dbj_throw(jenv, ret, NULL, NULL, NULL);	
          return ;
        }
        
        if ((ret = __dbj_dbt_memcopy(&lresult.dbt, 0,
              arg2[i].data, arg2[i].size, DB_USERCOPY_GETDATA)) != 0) {
          __dbj_throw(jenv, ret, NULL, NULL, NULL);
          return ;
        }
        
        __dbj_dbt_release(jenv, jresult, &lresult.dbt, &lresult);
        (*jenv)->DeleteLocalRef(jenv, lresult.jarr);
      }
      (*jenv)->DeleteLocalRef(jenv, jresult);
    }
  }
  arg3 = (u_int32_t)jarg3; 
  
  if (__dbj_dbt_copyin(jenv, &ldbt4, &arg4, jarg4, 0) != 0) {
    return ; /* An exception will be pending. */
  }
  arg5 = (db_timeout_t)jarg5; 
  arg6 = (u_int32_t)jarg6; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbChannel_send_request(arg1,arg2,arg3,arg4,arg5,arg6);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
  
  {
    int count, i;
    
    count = (*jenv)->GetArrayLength(jenv, jarg2);
    for (i = 0; i < count; i++)
    __os_free(NULL, arg2[i].data);
    __os_free(NULL, arg2);
  }
  
  __dbj_dbt_release(jenv, jarg4, arg4, &ldbt4); 
}


SWIGEXPORT void JNICALL Java_com_sleepycat_db_internal_db_1javaJNI_DbChannel_1set_1timeout(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  struct DbChannel *arg1 = (struct DbChannel *) 0 ;
  db_timeout_t arg2 ;
  db_ret_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(struct DbChannel **)&jarg1; 
  arg2 = (db_timeout_t)jarg2; 
  
  if (jarg1 == 0) {
    __dbj_throw(jenv, EINVAL, "call on closed handle", NULL, NULL);
    return ;
  }
  
  result = (db_ret_t)DbChannel_set_timeout(arg1,arg2);
  if (!DB_RETOK_STD(result)) {
    __dbj_throw(jenv, result, NULL, NULL, NULL);
  }
  
}


#ifdef __cplusplus
}
#endif

