/*
 * Copyright (C) 2007 Alp Toker <alp@atoker.com>
 * Copyright (C) 2008 INdT - Instituto Nokia de Tecnologia
 * Copyright (C) 2009-2010 ProFUSION embedded systems
 * Copyright (C) 2009-2010 Samsung Electronics
 * Copyright (C) 2013 Apple Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "config.h"
#include "Logging.h"

#if !LOG_DISABLED

#include <wtf/text/WTFString.h>

namespace WebCore {

String logLevelString()
{
    char* logEnv = getenv("WEBKIT_DEBUG");
    if (!logEnv)
        return emptyString();

#if defined(NDEBUG)
    fprintf(stderr, "WEBKIT_DEBUG is not empty, but this is a release build. Notice that many log messages will only appear in a debug build.\n");
#endif

    // To disable logging notImplemented set the DISABLE_NI_WARNING environment variable to 1.
    String logLevel = "NotYetImplemented,";
    logLevel.append(logEnv);
    return logLevel;
}

}

#endif // !LOG_DISABLED
