/* valacompiler.c generated by valac, the Vala compiler
 * generated from valacompiler.vala, do not modify */

/* valacompiler.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 * Copyright (C) 1996-2002, 2004, 2005, 2006 Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <valacodegen.h>
#include <version.h>
#include <config.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <locale.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_COMPILER (vala_compiler_get_type ())
#define VALA_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMPILER, ValaCompiler))
#define VALA_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMPILER, ValaCompilerClass))
#define VALA_IS_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMPILER))
#define VALA_IS_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMPILER))
#define VALA_COMPILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMPILER, ValaCompilerClass))

typedef struct _ValaCompiler ValaCompiler;
typedef struct _ValaCompilerClass ValaCompilerClass;
typedef struct _ValaCompilerPrivate ValaCompilerPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_ccode_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_compiler_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_compiler_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _ValaParamSpecCompiler ValaParamSpecCompiler;

struct _ValaCompiler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCompilerPrivate * priv;
};

struct _ValaCompilerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCompiler *self);
};

struct _ValaCompilerPrivate {
	ValaCodeContext* context;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	gint child_status;
};

struct _ValaParamSpecCompiler {
	GParamSpec parent_instance;
};


static gpointer vala_compiler_parent_class = NULL;
static gchar* vala_compiler_basedir;
static gchar* vala_compiler_basedir = NULL;
static gchar* vala_compiler_directory;
static gchar* vala_compiler_directory = NULL;
static gboolean vala_compiler_version;
static gboolean vala_compiler_version = FALSE;
static gboolean vala_compiler_api_version;
static gboolean vala_compiler_api_version = FALSE;
static gchar** vala_compiler_sources;
static gchar** vala_compiler_sources = NULL;
static gchar** vala_compiler_vapi_directories;
static gchar** vala_compiler_vapi_directories = NULL;
static gchar** vala_compiler_gir_directories;
static gchar** vala_compiler_gir_directories = NULL;
static gchar** vala_compiler_metadata_directories;
static gchar** vala_compiler_metadata_directories = NULL;
static gchar* vala_compiler_vapi_filename;
static gchar* vala_compiler_vapi_filename = NULL;
static gchar* vala_compiler_library;
static gchar* vala_compiler_library = NULL;
static gchar* vala_compiler_gir;
static gchar* vala_compiler_gir = NULL;
static gchar** vala_compiler_packages;
static gchar** vala_compiler_packages = NULL;
static gchar** vala_compiler_fast_vapis;
static gchar** vala_compiler_fast_vapis = NULL;
static gchar* vala_compiler_target_glib;
static gchar* vala_compiler_target_glib = NULL;
static gchar** vala_compiler_gresources;
static gchar** vala_compiler_gresources = NULL;
static gboolean vala_compiler_ccode_only;
static gboolean vala_compiler_ccode_only = FALSE;
static gchar* vala_compiler_header_filename;
static gchar* vala_compiler_header_filename = NULL;
static gboolean vala_compiler_use_header;
static gboolean vala_compiler_use_header = FALSE;
static gchar* vala_compiler_internal_header_filename;
static gchar* vala_compiler_internal_header_filename = NULL;
static gchar* vala_compiler_internal_vapi_filename;
static gchar* vala_compiler_internal_vapi_filename = NULL;
static gchar* vala_compiler_fast_vapi_filename;
static gchar* vala_compiler_fast_vapi_filename = NULL;
static gchar* vala_compiler_symbols_filename;
static gchar* vala_compiler_symbols_filename = NULL;
static gchar* vala_compiler_includedir;
static gchar* vala_compiler_includedir = NULL;
static gboolean vala_compiler_compile_only;
static gboolean vala_compiler_compile_only = FALSE;
static gchar* vala_compiler_output;
static gchar* vala_compiler_output = NULL;
static gboolean vala_compiler_debug;
static gboolean vala_compiler_debug = FALSE;
static gboolean vala_compiler_thread;
static gboolean vala_compiler_thread = FALSE;
static gboolean vala_compiler_mem_profiler;
static gboolean vala_compiler_mem_profiler = FALSE;
static gboolean vala_compiler_disable_assert;
static gboolean vala_compiler_disable_assert = FALSE;
static gboolean vala_compiler_enable_checking;
static gboolean vala_compiler_enable_checking = FALSE;
static gboolean vala_compiler_deprecated;
static gboolean vala_compiler_deprecated = FALSE;
static gboolean vala_compiler_hide_internal;
static gboolean vala_compiler_hide_internal = FALSE;
static gboolean vala_compiler_experimental;
static gboolean vala_compiler_experimental = FALSE;
static gboolean vala_compiler_experimental_non_null;
static gboolean vala_compiler_experimental_non_null = FALSE;
static gboolean vala_compiler_gobject_tracing;
static gboolean vala_compiler_gobject_tracing = FALSE;
static gboolean vala_compiler_disable_warnings;
static gboolean vala_compiler_disable_warnings = FALSE;
static gchar* vala_compiler_cc_command;
static gchar* vala_compiler_cc_command = NULL;
static gchar** vala_compiler_cc_options;
static gchar** vala_compiler_cc_options = NULL;
static gchar* vala_compiler_pkg_config_command;
static gchar* vala_compiler_pkg_config_command = NULL;
static gchar* vala_compiler_dump_tree;
static gchar* vala_compiler_dump_tree = NULL;
static gboolean vala_compiler_save_temps;
static gboolean vala_compiler_save_temps = FALSE;
static gchar** vala_compiler_defines;
static gchar** vala_compiler_defines = NULL;
static gboolean vala_compiler_quiet_mode;
static gboolean vala_compiler_quiet_mode = FALSE;
static gboolean vala_compiler_verbose_mode;
static gboolean vala_compiler_verbose_mode = FALSE;
static gchar* vala_compiler_profile;
static gchar* vala_compiler_profile = NULL;
static gboolean vala_compiler_nostdpkg;
static gboolean vala_compiler_nostdpkg = FALSE;
static gboolean vala_compiler_enable_version_header;
static gboolean vala_compiler_enable_version_header = FALSE;
static gboolean vala_compiler_disable_version_header;
static gboolean vala_compiler_disable_version_header = FALSE;
static gboolean vala_compiler_fatal_warnings;
static gboolean vala_compiler_fatal_warnings = FALSE;
static gchar* vala_compiler_dependencies;
static gchar* vala_compiler_dependencies = NULL;
static gchar* vala_compiler_entry_point;
static gchar* vala_compiler_entry_point = NULL;
static gboolean vala_compiler_run_output;
static gboolean vala_compiler_run_output = FALSE;

gpointer vala_compiler_ref (gpointer instance);
void vala_compiler_unref (gpointer instance);
GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_compiler (GValue* value, gpointer v_object);
void vala_value_take_compiler (GValue* value, gpointer v_object);
gpointer vala_value_get_compiler (const GValue* value);
GType vala_compiler_get_type (void) G_GNUC_CONST;
#define VALA_COMPILER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_COMPILER, ValaCompilerPrivate))
enum  {
	VALA_COMPILER_DUMMY_PROPERTY
};
static gint vala_compiler_quit (ValaCompiler* self);
static gint vala_compiler_run (ValaCompiler* self);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gchar** _vala_array_dup4 (gchar** self, int length);
static gint vala_compiler_run_source (gchar** args, int args_length1);
ValaCompiler* vala_compiler_new (void);
ValaCompiler* vala_compiler_construct (GType object_type);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda4_ (Block1Data* _data1_, GPid pid, gint status);
static void ____lambda4__gchild_watch_func (GPid pid, gint status, gpointer self);
static gint vala_compiler_main (gchar** args, int args_length1);
static void vala_compiler_finalize (ValaCompiler* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_COMPILER_options[52] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_vapi_filename, "Output VAPI file name", "FILE"}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_library, "Library name", "NAME"}, {"gir", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_gir, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"basedir", 'b', 0, G_OPTION_ARG_FILENAME, &vala_compiler_basedir, "Base source directory", "DIRECTORY"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_compiler_directory, "Output directory", "DIRECTORY"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_version, "Display version number", NULL}, {"api-version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_api_version, "Display API version number", NULL}, {"ccode", 'C', 0, G_OPTION_ARG_NONE, &vala_compiler_ccode_only, "Output C code", NULL}, {"header", 'H', 0, G_OPTION_ARG_FILENAME, &vala_compiler_header_filename, "Output C header file", "FILE"}, {"use-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_use_header, "Use C header file", NULL}, {"includedir", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_includedir, "Directory used to include the C header file", "DIRECTORY"}, {"internal-header", 'h', 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_header_filename, "Output internal C header file", "FILE"}, {"internal-vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_vapi_filename, "Output vapi with internal api", "FILE"}, {"fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_fast_vapi_filename, "Output vapi without performing symbol resolution", NULL}, {"use-fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_fast_vapis, "Use --fast-vapi output during this compile", NULL}, {"deps", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_dependencies, "Write make-style dependency information to this file", NULL}, {"symbols", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_symbols_filename, "Output symbols file", "FILE"}, {"compile", 'c', 0, G_OPTION_ARG_NONE, &vala_compiler_compile_only, "Compile but do not link", NULL}, {"output", 'o', 0, G_OPTION_ARG_FILENAME, &vala_compiler_output, "Place output in file FILE", "FILE"}, {"debug", 'g', 0, G_OPTION_ARG_NONE, &vala_compiler_debug, "Produce debug information", NULL}, {"thread", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_thread, "Enable multithreading support", NULL}, {"enable-mem-profiler", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_mem_profiler, "Enable GLib memory profiler", NULL}, {"define", 'D', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_defines, "Define SYMBOL", "SYMBOL..."}, {"main", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_entry_point, "Use SYMBOL as entry point", "SYMBOL..."}, {"nostdpkg", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_nostdpkg, "Do not include standard packages", NULL}, {"disable-assert", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_assert, "Disable assertions", NULL}, {"enable-checking", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_checking, "Enable additional run-time checks", NULL}, {"enable-deprecated", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_deprecated, "Enable deprecated features", NULL}, {"hide-internal", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_hide_internal, "Hide symbols marked as internal", NULL}, {"enable-experimental", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental, "Enable experimental features", NULL}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_warnings, "Disable warnings", NULL}, {"fatal-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_fatal_warnings, "Treat warnings as fatal", NULL}, {"enable-experimental-non-null", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"enable-gobject-tracing", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_gobject_tracing, "Enable GObject creation tracing", NULL}, {"cc", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_cc_command, "Use COMMAND as C compiler command", "COMMAND"}, {"Xcc", 'X', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_cc_options, "Pass OPTION to the C compiler", "OPTION..."}, {"pkg-config", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_pkg_config_command, "Use COMMAND as pkg-config command", "COMMAND"}, {"dump-tree", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_dump_tree, "Write code tree to FILE", "FILE"}, {"save-temps", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_save_temps, "Keep temporary files", NULL}, {"profile", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_profile, "Use the given profile instead of the default", "PROFILE"}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_compiler_quiet_mode, "Do not print messages to the console", NULL}, {"verbose", 'v', 0, G_OPTION_ARG_NONE, &vala_compiler_verbose_mode, "Print additional messages to the console", NULL}, {"target-glib", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_target_glib, "Target version of glib for code generation", "MAJOR.MINOR"}, {"gresources", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_gresources, "XML of gresources", "FILE..."}, {"enable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_version_header, "Write vala build version in generated files", NULL}, {"disable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_version_header, "Do not write vala build version in generated files", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_sources, NULL, "FILE..."}, {NULL}};

static gint vala_compiler_quit (ValaCompiler* self) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	ValaCodeContext* _tmp1_ = NULL;
	ValaReport* _tmp2_ = NULL;
	ValaReport* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gboolean _tmp9_ = FALSE;
	ValaCodeContext* _tmp10_ = NULL;
	ValaReport* _tmp11_ = NULL;
	ValaReport* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->context;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_report_get_errors (_tmp3_);
	if (_tmp4_ == 0) {
		ValaCodeContext* _tmp5_ = NULL;
		ValaReport* _tmp6_ = NULL;
		ValaReport* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		_tmp5_ = self->priv->context;
		_tmp6_ = vala_code_context_get_report (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_report_get_warnings (_tmp7_);
		_tmp0_ = _tmp8_ == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	_tmp10_ = self->priv->context;
	_tmp11_ = vala_code_context_get_report (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_report_get_errors (_tmp12_);
	if (_tmp13_ == 0) {
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		_tmp15_ = vala_compiler_fatal_warnings;
		if (!_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			ValaCodeContext* _tmp16_ = NULL;
			ValaReport* _tmp17_ = NULL;
			ValaReport* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			_tmp16_ = self->priv->context;
			_tmp17_ = vala_code_context_get_report (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_report_get_warnings (_tmp18_);
			_tmp14_ = _tmp19_ == 0;
		}
		_tmp9_ = _tmp14_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gboolean _tmp20_ = FALSE;
		_tmp20_ = vala_compiler_quiet_mode;
		if (!_tmp20_) {
			FILE* _tmp21_ = NULL;
			ValaCodeContext* _tmp22_ = NULL;
			ValaReport* _tmp23_ = NULL;
			ValaReport* _tmp24_ = NULL;
			gint _tmp25_ = 0;
			_tmp21_ = stdout;
			_tmp22_ = self->priv->context;
			_tmp23_ = vala_code_context_get_report (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_report_get_warnings (_tmp24_);
			fprintf (_tmp21_, "Compilation succeeded - %d warning(s)\n", _tmp25_);
		}
		result = 0;
		return result;
	} else {
		gboolean _tmp26_ = FALSE;
		_tmp26_ = vala_compiler_quiet_mode;
		if (!_tmp26_) {
			FILE* _tmp27_ = NULL;
			ValaCodeContext* _tmp28_ = NULL;
			ValaReport* _tmp29_ = NULL;
			ValaReport* _tmp30_ = NULL;
			gint _tmp31_ = 0;
			ValaCodeContext* _tmp32_ = NULL;
			ValaReport* _tmp33_ = NULL;
			ValaReport* _tmp34_ = NULL;
			gint _tmp35_ = 0;
			_tmp27_ = stdout;
			_tmp28_ = self->priv->context;
			_tmp29_ = vala_code_context_get_report (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_report_get_errors (_tmp30_);
			_tmp32_ = self->priv->context;
			_tmp33_ = vala_code_context_get_report (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_report_get_warnings (_tmp34_);
			fprintf (_tmp27_, "Compilation failed: %d error(s), %d warning(s)\n", _tmp31_, _tmp35_);
		}
		result = 1;
		return result;
	}
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gint vala_compiler_run (ValaCompiler* self) {
	gint result = 0;
	ValaCodeContext* _tmp0_ = NULL;
	ValaCodeContext* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	ValaCodeContext* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	ValaCodeContext* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	ValaCodeContext* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	ValaCodeContext* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	ValaCodeContext* _tmp27_ = NULL;
	gboolean _tmp28_ = FALSE;
	ValaCodeContext* _tmp29_ = NULL;
	gboolean _tmp30_ = FALSE;
	ValaCodeContext* _tmp31_ = NULL;
	gboolean _tmp32_ = FALSE;
	ValaCodeContext* _tmp33_ = NULL;
	ValaReport* _tmp34_ = NULL;
	ValaReport* _tmp35_ = NULL;
	gboolean _tmp36_ = FALSE;
	ValaCodeContext* _tmp37_ = NULL;
	ValaReport* _tmp38_ = NULL;
	ValaReport* _tmp39_ = NULL;
	gboolean _tmp40_ = FALSE;
	ValaCodeContext* _tmp41_ = NULL;
	gboolean _tmp42_ = FALSE;
	ValaCodeContext* _tmp43_ = NULL;
	gboolean _tmp44_ = FALSE;
	ValaCodeContext* _tmp45_ = NULL;
	gboolean _tmp46_ = FALSE;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp48_ = FALSE;
	ValaCodeContext* _tmp50_ = NULL;
	gboolean _tmp51_ = FALSE;
	ValaCodeContext* _tmp52_ = NULL;
	const gchar* _tmp53_ = NULL;
	gboolean _tmp54_ = FALSE;
	const gchar* _tmp55_ = NULL;
	ValaCodeContext* _tmp57_ = NULL;
	gboolean _tmp58_ = FALSE;
	ValaCodeContext* _tmp59_ = NULL;
	const gchar* _tmp60_ = NULL;
	ValaCodeContext* _tmp61_ = NULL;
	const gchar* _tmp62_ = NULL;
	ValaCodeContext* _tmp63_ = NULL;
	const gchar* _tmp64_ = NULL;
	ValaCodeContext* _tmp65_ = NULL;
	const gchar* _tmp66_ = NULL;
	gboolean _tmp67_ = FALSE;
	const gchar* _tmp68_ = NULL;
	const gchar* _tmp70_ = NULL;
	const gchar* _tmp78_ = NULL;
	ValaCodeContext* _tmp87_ = NULL;
	gchar** _tmp88_ = NULL;
	gint _tmp88__length1 = 0;
	gchar** _tmp89_ = NULL;
	gint _tmp89__length1 = 0;
	ValaCodeContext* _tmp90_ = NULL;
	gchar** _tmp91_ = NULL;
	gint _tmp91__length1 = 0;
	gchar** _tmp92_ = NULL;
	gint _tmp92__length1 = 0;
	ValaCodeContext* _tmp93_ = NULL;
	gchar** _tmp94_ = NULL;
	gint _tmp94__length1 = 0;
	gchar** _tmp95_ = NULL;
	gint _tmp95__length1 = 0;
	ValaCodeContext* _tmp96_ = NULL;
	gboolean _tmp97_ = FALSE;
	ValaCodeContext* _tmp98_ = NULL;
	gboolean _tmp99_ = FALSE;
	ValaCodeContext* _tmp100_ = NULL;
	gboolean _tmp101_ = FALSE;
	ValaCodeContext* _tmp102_ = NULL;
	gboolean _tmp103_ = FALSE;
	gboolean _tmp104_ = FALSE;
	gboolean _tmp105_ = FALSE;
	gboolean _tmp107_ = FALSE;
	gboolean _tmp108_ = FALSE;
	const gchar* _tmp109_ = NULL;
	gboolean _tmp117_ = FALSE;
	const gchar* _tmp118_ = NULL;
	ValaCodeContext* _tmp119_ = NULL;
	gboolean _tmp120_ = FALSE;
	ValaCodeContext* _tmp121_ = NULL;
	const gchar* _tmp122_ = NULL;
	ValaCodeContext* _tmp123_ = NULL;
	gboolean _tmp124_ = FALSE;
	gchar** _tmp125_ = NULL;
	gint _tmp125__length1 = 0;
	gint glib_major = 0;
	gint glib_minor = 0;
	gboolean _tmp137_ = FALSE;
	const gchar* _tmp138_ = NULL;
	ValaCodeContext* _tmp141_ = NULL;
	gint _tmp142_ = 0;
	ValaCodeContext* _tmp143_ = NULL;
	gint _tmp144_ = 0;
	ValaCodeContext* _tmp145_ = NULL;
	gint _tmp146_ = 0;
	gint _tmp147_ = 0;
	gboolean _tmp156_ = FALSE;
	gchar** _tmp159_ = NULL;
	gint _tmp159__length1 = 0;
	gchar** _tmp164_ = NULL;
	gint _tmp164__length1 = 0;
	ValaCodeContext* _tmp175_ = NULL;
	gchar** _tmp176_ = NULL;
	gint _tmp176__length1 = 0;
	gchar** _tmp177_ = NULL;
	gint _tmp177__length1 = 0;
	gboolean _tmp178_ = FALSE;
	ValaCodeContext* _tmp179_ = NULL;
	ValaReport* _tmp180_ = NULL;
	ValaReport* _tmp181_ = NULL;
	gint _tmp182_ = 0;
	ValaCodeContext* _tmp190_ = NULL;
	ValaGDBusServerModule* _tmp191_ = NULL;
	ValaGDBusServerModule* _tmp192_ = NULL;
	gboolean has_c_files = FALSE;
	gboolean has_h_files = FALSE;
	gchar** _tmp193_ = NULL;
	gint _tmp193__length1 = 0;
	gboolean _tmp203_ = FALSE;
	gboolean _tmp204_ = FALSE;
	gboolean _tmp208_ = FALSE;
	ValaCodeContext* _tmp209_ = NULL;
	ValaReport* _tmp210_ = NULL;
	ValaReport* _tmp211_ = NULL;
	gint _tmp212_ = 0;
	ValaParser* parser = NULL;
	ValaParser* _tmp220_ = NULL;
	ValaParser* _tmp221_ = NULL;
	ValaCodeContext* _tmp222_ = NULL;
	ValaGenieParser* genie_parser = NULL;
	ValaGenieParser* _tmp223_ = NULL;
	ValaGenieParser* _tmp224_ = NULL;
	ValaCodeContext* _tmp225_ = NULL;
	ValaGirParser* gir_parser = NULL;
	ValaGirParser* _tmp226_ = NULL;
	ValaGirParser* _tmp227_ = NULL;
	ValaCodeContext* _tmp228_ = NULL;
	gboolean _tmp229_ = FALSE;
	ValaCodeContext* _tmp230_ = NULL;
	ValaReport* _tmp231_ = NULL;
	ValaReport* _tmp232_ = NULL;
	gint _tmp233_ = 0;
	const gchar* _tmp241_ = NULL;
	ValaCodeContext* _tmp247_ = NULL;
	gboolean _tmp248_ = FALSE;
	ValaCodeContext* _tmp249_ = NULL;
	ValaReport* _tmp250_ = NULL;
	ValaReport* _tmp251_ = NULL;
	gint _tmp252_ = 0;
	gboolean _tmp260_ = FALSE;
	gboolean _tmp261_ = FALSE;
	gboolean _tmp262_ = FALSE;
	const gchar* _tmp270_ = NULL;
	gboolean _tmp275_ = FALSE;
	ValaCodeContext* _tmp276_ = NULL;
	ValaReport* _tmp277_ = NULL;
	ValaReport* _tmp278_ = NULL;
	gint _tmp279_ = 0;
	ValaCodeContext* _tmp287_ = NULL;
	ValaCodeGenerator* _tmp288_ = NULL;
	ValaCodeGenerator* _tmp289_ = NULL;
	ValaCodeContext* _tmp290_ = NULL;
	gboolean _tmp291_ = FALSE;
	ValaCodeContext* _tmp292_ = NULL;
	ValaReport* _tmp293_ = NULL;
	ValaReport* _tmp294_ = NULL;
	gint _tmp295_ = 0;
	gboolean _tmp303_ = FALSE;
	const gchar* _tmp304_ = NULL;
	const gchar* _tmp308_ = NULL;
	const gchar* _tmp360_ = NULL;
	const gchar* _tmp374_ = NULL;
	const gchar* _tmp397_ = NULL;
	gboolean _tmp400_ = FALSE;
	gint _tmp424_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_push (_tmp1_);
	_tmp4_ = vala_compiler_ccode_only;
	if (!_tmp4_) {
		gboolean _tmp5_ = FALSE;
		_tmp5_ = vala_compiler_compile_only;
		_tmp3_ = !_tmp5_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		const gchar* _tmp6_ = NULL;
		_tmp6_ = vala_compiler_output;
		_tmp2_ = _tmp6_ == NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		const gchar* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		_tmp7_ = vala_compiler_sources;
		_tmp7__length1 = _vala_array_length (vala_compiler_sources);
		_tmp8_ = _tmp7_[0];
		_tmp9_ = string_last_index_of_char (_tmp8_, (gunichar) '.', 0);
		if (_tmp9_ != (-1)) {
			gint dot = 0;
			gchar** _tmp10_ = NULL;
			gint _tmp10__length1 = 0;
			const gchar* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gchar** _tmp13_ = NULL;
			gint _tmp13__length1 = 0;
			const gchar* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			_tmp10_ = vala_compiler_sources;
			_tmp10__length1 = _vala_array_length (vala_compiler_sources);
			_tmp11_ = _tmp10_[0];
			_tmp12_ = string_last_index_of_char (_tmp11_, (gunichar) '.', 0);
			dot = _tmp12_;
			_tmp13_ = vala_compiler_sources;
			_tmp13__length1 = _vala_array_length (vala_compiler_sources);
			_tmp14_ = _tmp13_[0];
			_tmp15_ = dot;
			_tmp16_ = string_substring (_tmp14_, (glong) 0, (glong) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_path_get_basename (_tmp17_);
			_g_free0 (vala_compiler_output);
			vala_compiler_output = _tmp18_;
			_g_free0 (_tmp17_);
		}
	}
	_tmp19_ = self->priv->context;
	_tmp20_ = vala_compiler_disable_assert;
	vala_code_context_set_assert (_tmp19_, !_tmp20_);
	_tmp21_ = self->priv->context;
	_tmp22_ = vala_compiler_enable_checking;
	vala_code_context_set_checking (_tmp21_, _tmp22_);
	_tmp23_ = self->priv->context;
	_tmp24_ = vala_compiler_deprecated;
	vala_code_context_set_deprecated (_tmp23_, _tmp24_);
	_tmp25_ = self->priv->context;
	_tmp26_ = vala_compiler_hide_internal;
	vala_code_context_set_hide_internal (_tmp25_, _tmp26_);
	_tmp27_ = self->priv->context;
	_tmp28_ = vala_compiler_experimental;
	vala_code_context_set_experimental (_tmp27_, _tmp28_);
	_tmp29_ = self->priv->context;
	_tmp30_ = vala_compiler_experimental_non_null;
	vala_code_context_set_experimental_non_null (_tmp29_, _tmp30_);
	_tmp31_ = self->priv->context;
	_tmp32_ = vala_compiler_gobject_tracing;
	vala_code_context_set_gobject_tracing (_tmp31_, _tmp32_);
	_tmp33_ = self->priv->context;
	_tmp34_ = vala_code_context_get_report (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_compiler_disable_warnings;
	vala_report_set_enable_warnings (_tmp35_, !_tmp36_);
	_tmp37_ = self->priv->context;
	_tmp38_ = vala_code_context_get_report (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_compiler_quiet_mode;
	vala_report_set_verbose_errors (_tmp39_, !_tmp40_);
	_tmp41_ = self->priv->context;
	_tmp42_ = vala_compiler_verbose_mode;
	vala_code_context_set_verbose_mode (_tmp41_, _tmp42_);
	_tmp43_ = self->priv->context;
	_tmp44_ = vala_compiler_disable_version_header;
	vala_code_context_set_version_header (_tmp43_, !_tmp44_);
	_tmp45_ = self->priv->context;
	_tmp46_ = vala_compiler_ccode_only;
	vala_code_context_set_ccode_only (_tmp45_, _tmp46_);
	_tmp48_ = vala_compiler_ccode_only;
	if (_tmp48_) {
		gchar** _tmp49_ = NULL;
		gint _tmp49__length1 = 0;
		_tmp49_ = vala_compiler_cc_options;
		_tmp49__length1 = _vala_array_length (vala_compiler_cc_options);
		_tmp47_ = _tmp49_ != NULL;
	} else {
		_tmp47_ = FALSE;
	}
	if (_tmp47_) {
		vala_report_warning (NULL, "-X has no effect when -C or --ccode is set");
	}
	_tmp50_ = self->priv->context;
	_tmp51_ = vala_compiler_compile_only;
	vala_code_context_set_compile_only (_tmp50_, _tmp51_);
	_tmp52_ = self->priv->context;
	_tmp53_ = vala_compiler_header_filename;
	vala_code_context_set_header_filename (_tmp52_, _tmp53_);
	_tmp55_ = vala_compiler_header_filename;
	if (_tmp55_ == NULL) {
		gboolean _tmp56_ = FALSE;
		_tmp56_ = vala_compiler_use_header;
		_tmp54_ = _tmp56_;
	} else {
		_tmp54_ = FALSE;
	}
	if (_tmp54_) {
		vala_report_error (NULL, "--use-header may only be used in combination with --header");
	}
	_tmp57_ = self->priv->context;
	_tmp58_ = vala_compiler_use_header;
	vala_code_context_set_use_header (_tmp57_, _tmp58_);
	_tmp59_ = self->priv->context;
	_tmp60_ = vala_compiler_internal_header_filename;
	vala_code_context_set_internal_header_filename (_tmp59_, _tmp60_);
	_tmp61_ = self->priv->context;
	_tmp62_ = vala_compiler_symbols_filename;
	vala_code_context_set_symbols_filename (_tmp61_, _tmp62_);
	_tmp63_ = self->priv->context;
	_tmp64_ = vala_compiler_includedir;
	vala_code_context_set_includedir (_tmp63_, _tmp64_);
	_tmp65_ = self->priv->context;
	_tmp66_ = vala_compiler_output;
	vala_code_context_set_output (_tmp65_, _tmp66_);
	_tmp68_ = vala_compiler_output;
	if (_tmp68_ != NULL) {
		gboolean _tmp69_ = FALSE;
		_tmp69_ = vala_compiler_ccode_only;
		_tmp67_ = _tmp69_;
	} else {
		_tmp67_ = FALSE;
	}
	if (_tmp67_) {
		vala_report_warning (NULL, "--output and -o have no effect when -C or --ccode is set");
	}
	_tmp70_ = vala_compiler_basedir;
	if (_tmp70_ == NULL) {
		ValaCodeContext* _tmp71_ = NULL;
		gchar* _tmp72_ = NULL;
		gchar* _tmp73_ = NULL;
		_tmp71_ = self->priv->context;
		_tmp72_ = vala_code_context_realpath (".");
		_tmp73_ = _tmp72_;
		vala_code_context_set_basedir (_tmp71_, _tmp73_);
		_g_free0 (_tmp73_);
	} else {
		ValaCodeContext* _tmp74_ = NULL;
		const gchar* _tmp75_ = NULL;
		gchar* _tmp76_ = NULL;
		gchar* _tmp77_ = NULL;
		_tmp74_ = self->priv->context;
		_tmp75_ = vala_compiler_basedir;
		_tmp76_ = vala_code_context_realpath (_tmp75_);
		_tmp77_ = _tmp76_;
		vala_code_context_set_basedir (_tmp74_, _tmp77_);
		_g_free0 (_tmp77_);
	}
	_tmp78_ = vala_compiler_directory;
	if (_tmp78_ != NULL) {
		ValaCodeContext* _tmp79_ = NULL;
		const gchar* _tmp80_ = NULL;
		gchar* _tmp81_ = NULL;
		gchar* _tmp82_ = NULL;
		_tmp79_ = self->priv->context;
		_tmp80_ = vala_compiler_directory;
		_tmp81_ = vala_code_context_realpath (_tmp80_);
		_tmp82_ = _tmp81_;
		vala_code_context_set_directory (_tmp79_, _tmp82_);
		_g_free0 (_tmp82_);
	} else {
		ValaCodeContext* _tmp83_ = NULL;
		ValaCodeContext* _tmp84_ = NULL;
		const gchar* _tmp85_ = NULL;
		const gchar* _tmp86_ = NULL;
		_tmp83_ = self->priv->context;
		_tmp84_ = self->priv->context;
		_tmp85_ = vala_code_context_get_basedir (_tmp84_);
		_tmp86_ = _tmp85_;
		vala_code_context_set_directory (_tmp83_, _tmp86_);
	}
	_tmp87_ = self->priv->context;
	_tmp88_ = vala_compiler_vapi_directories;
	_tmp88__length1 = _vala_array_length (vala_compiler_vapi_directories);
	_tmp89_ = (_tmp88_ != NULL) ? _vala_array_dup1 (_tmp88_, _tmp88__length1) : ((gpointer) _tmp88_);
	_tmp89__length1 = _tmp88__length1;
	_tmp87_->vapi_directories = (_vala_array_free (_tmp87_->vapi_directories, _tmp87_->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp87_->vapi_directories = _tmp89_;
	_tmp87_->vapi_directories_length1 = _tmp89__length1;
	_tmp90_ = self->priv->context;
	_tmp91_ = vala_compiler_gir_directories;
	_tmp91__length1 = _vala_array_length (vala_compiler_gir_directories);
	_tmp92_ = (_tmp91_ != NULL) ? _vala_array_dup2 (_tmp91_, _tmp91__length1) : ((gpointer) _tmp91_);
	_tmp92__length1 = _tmp91__length1;
	_tmp90_->gir_directories = (_vala_array_free (_tmp90_->gir_directories, _tmp90_->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp90_->gir_directories = _tmp92_;
	_tmp90_->gir_directories_length1 = _tmp92__length1;
	_tmp93_ = self->priv->context;
	_tmp94_ = vala_compiler_metadata_directories;
	_tmp94__length1 = _vala_array_length (vala_compiler_metadata_directories);
	_tmp95_ = (_tmp94_ != NULL) ? _vala_array_dup3 (_tmp94_, _tmp94__length1) : ((gpointer) _tmp94_);
	_tmp95__length1 = _tmp94__length1;
	_tmp93_->metadata_directories = (_vala_array_free (_tmp93_->metadata_directories, _tmp93_->metadata_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp93_->metadata_directories = _tmp95_;
	_tmp93_->metadata_directories_length1 = _tmp95__length1;
	_tmp96_ = self->priv->context;
	_tmp97_ = vala_compiler_debug;
	vala_code_context_set_debug (_tmp96_, _tmp97_);
	_tmp98_ = self->priv->context;
	_tmp99_ = vala_compiler_thread;
	vala_code_context_set_thread (_tmp98_, _tmp99_);
	_tmp100_ = self->priv->context;
	_tmp101_ = vala_compiler_mem_profiler;
	vala_code_context_set_mem_profiler (_tmp100_, _tmp101_);
	_tmp102_ = self->priv->context;
	_tmp103_ = vala_compiler_save_temps;
	vala_code_context_set_save_temps (_tmp102_, _tmp103_);
	_tmp105_ = vala_compiler_ccode_only;
	if (_tmp105_) {
		gboolean _tmp106_ = FALSE;
		_tmp106_ = vala_compiler_save_temps;
		_tmp104_ = _tmp106_;
	} else {
		_tmp104_ = FALSE;
	}
	if (_tmp104_) {
		vala_report_warning (NULL, "--save-temps has no effect when -C or --ccode is set");
	}
	_tmp109_ = vala_compiler_profile;
	if (g_strcmp0 (_tmp109_, "gobject-2.0") == 0) {
		_tmp108_ = TRUE;
	} else {
		const gchar* _tmp110_ = NULL;
		_tmp110_ = vala_compiler_profile;
		_tmp108_ = g_strcmp0 (_tmp110_, "gobject") == 0;
	}
	if (_tmp108_) {
		_tmp107_ = TRUE;
	} else {
		const gchar* _tmp111_ = NULL;
		_tmp111_ = vala_compiler_profile;
		_tmp107_ = _tmp111_ == NULL;
	}
	if (_tmp107_) {
		ValaCodeContext* _tmp112_ = NULL;
		ValaCodeContext* _tmp113_ = NULL;
		_tmp112_ = self->priv->context;
		vala_code_context_set_profile (_tmp112_, VALA_PROFILE_GOBJECT);
		_tmp113_ = self->priv->context;
		vala_code_context_add_define (_tmp113_, "GOBJECT");
	} else {
		const gchar* _tmp114_ = NULL;
		gchar* _tmp115_ = NULL;
		gchar* _tmp116_ = NULL;
		_tmp114_ = vala_compiler_profile;
		_tmp115_ = g_strdup_printf ("Unknown profile %s", _tmp114_);
		_tmp116_ = _tmp115_;
		vala_report_error (NULL, _tmp116_);
		_g_free0 (_tmp116_);
	}
	_tmp117_ = vala_compiler_nostdpkg;
	_tmp118_ = vala_compiler_fast_vapi_filename;
	vala_compiler_nostdpkg = _tmp117_ | (_tmp118_ != NULL);
	_tmp119_ = self->priv->context;
	_tmp120_ = vala_compiler_nostdpkg;
	vala_code_context_set_nostdpkg (_tmp119_, _tmp120_);
	_tmp121_ = self->priv->context;
	_tmp122_ = vala_compiler_entry_point;
	vala_code_context_set_entry_point_name (_tmp121_, _tmp122_);
	_tmp123_ = self->priv->context;
	_tmp124_ = vala_compiler_run_output;
	vala_code_context_set_run_output (_tmp123_, _tmp124_);
	_tmp125_ = vala_compiler_defines;
	_tmp125__length1 = _vala_array_length (vala_compiler_defines);
	if (_tmp125_ != NULL) {
		gchar** _tmp126_ = NULL;
		gint _tmp126__length1 = 0;
		_tmp126_ = vala_compiler_defines;
		_tmp126__length1 = _vala_array_length (vala_compiler_defines);
		{
			gchar** define_collection = NULL;
			gint define_collection_length1 = 0;
			gint _define_collection_size_ = 0;
			gint define_it = 0;
			define_collection = _tmp126_;
			define_collection_length1 = _tmp126__length1;
			for (define_it = 0; define_it < _tmp126__length1; define_it = define_it + 1) {
				gchar* _tmp127_ = NULL;
				gchar* define = NULL;
				_tmp127_ = g_strdup (define_collection[define_it]);
				define = _tmp127_;
				{
					ValaCodeContext* _tmp128_ = NULL;
					const gchar* _tmp129_ = NULL;
					_tmp128_ = self->priv->context;
					_tmp129_ = define;
					vala_code_context_add_define (_tmp128_, _tmp129_);
					_g_free0 (define);
				}
			}
		}
	}
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp130_ = FALSE;
			_tmp130_ = TRUE;
			while (TRUE) {
				gint _tmp132_ = 0;
				ValaCodeContext* _tmp133_ = NULL;
				gint _tmp134_ = 0;
				gchar* _tmp135_ = NULL;
				gchar* _tmp136_ = NULL;
				if (!_tmp130_) {
					gint _tmp131_ = 0;
					_tmp131_ = i;
					i = _tmp131_ + 2;
				}
				_tmp130_ = FALSE;
				_tmp132_ = i;
				if (!(_tmp132_ <= 26)) {
					break;
				}
				_tmp133_ = self->priv->context;
				_tmp134_ = i;
				_tmp135_ = g_strdup_printf ("VALA_0_%d", _tmp134_);
				_tmp136_ = _tmp135_;
				vala_code_context_add_define (_tmp133_, _tmp136_);
				_g_free0 (_tmp136_);
			}
		}
	}
	glib_major = 2;
	glib_minor = 18;
	_tmp138_ = vala_compiler_target_glib;
	if (_tmp138_ != NULL) {
		const gchar* _tmp139_ = NULL;
		gint _tmp140_ = 0;
		_tmp139_ = vala_compiler_target_glib;
		_tmp140_ = sscanf (_tmp139_, "%d.%d", &glib_major, &glib_minor);
		_tmp137_ = _tmp140_ != 2;
	} else {
		_tmp137_ = FALSE;
	}
	if (_tmp137_) {
		vala_report_error (NULL, "Invalid format for --target-glib");
	}
	_tmp141_ = self->priv->context;
	_tmp142_ = glib_major;
	vala_code_context_set_target_glib_major (_tmp141_, _tmp142_);
	_tmp143_ = self->priv->context;
	_tmp144_ = glib_minor;
	vala_code_context_set_target_glib_minor (_tmp143_, _tmp144_);
	_tmp145_ = self->priv->context;
	_tmp146_ = vala_code_context_get_target_glib_major (_tmp145_);
	_tmp147_ = _tmp146_;
	if (_tmp147_ != 2) {
		vala_report_error (NULL, "This version of valac only supports GLib 2");
	}
	{
		gint i = 0;
		i = 16;
		{
			gboolean _tmp148_ = FALSE;
			_tmp148_ = TRUE;
			while (TRUE) {
				gint _tmp150_ = 0;
				gint _tmp151_ = 0;
				ValaCodeContext* _tmp152_ = NULL;
				gint _tmp153_ = 0;
				gchar* _tmp154_ = NULL;
				gchar* _tmp155_ = NULL;
				if (!_tmp148_) {
					gint _tmp149_ = 0;
					_tmp149_ = i;
					i = _tmp149_ + 2;
				}
				_tmp148_ = FALSE;
				_tmp150_ = i;
				_tmp151_ = glib_minor;
				if (!(_tmp150_ <= _tmp151_)) {
					break;
				}
				_tmp152_ = self->priv->context;
				_tmp153_ = i;
				_tmp154_ = g_strdup_printf ("GLIB_2_%d", _tmp153_);
				_tmp155_ = _tmp154_;
				vala_code_context_add_define (_tmp152_, _tmp155_);
				_g_free0 (_tmp155_);
			}
		}
	}
	_tmp156_ = vala_compiler_nostdpkg;
	if (!_tmp156_) {
		ValaCodeContext* _tmp157_ = NULL;
		ValaCodeContext* _tmp158_ = NULL;
		_tmp157_ = self->priv->context;
		vala_code_context_add_external_package (_tmp157_, "glib-2.0");
		_tmp158_ = self->priv->context;
		vala_code_context_add_external_package (_tmp158_, "gobject-2.0");
	}
	_tmp159_ = vala_compiler_packages;
	_tmp159__length1 = _vala_array_length (vala_compiler_packages);
	if (_tmp159_ != NULL) {
		gchar** _tmp160_ = NULL;
		gint _tmp160__length1 = 0;
		_tmp160_ = vala_compiler_packages;
		_tmp160__length1 = _vala_array_length (vala_compiler_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp160_;
			package_collection_length1 = _tmp160__length1;
			for (package_it = 0; package_it < _tmp160__length1; package_it = package_it + 1) {
				gchar* _tmp161_ = NULL;
				gchar* package = NULL;
				_tmp161_ = g_strdup (package_collection[package_it]);
				package = _tmp161_;
				{
					ValaCodeContext* _tmp162_ = NULL;
					const gchar* _tmp163_ = NULL;
					_tmp162_ = self->priv->context;
					_tmp163_ = package;
					vala_code_context_add_external_package (_tmp162_, _tmp163_);
					_g_free0 (package);
				}
			}
		}
		vala_compiler_packages = (_vala_array_free (vala_compiler_packages, _vala_array_length (vala_compiler_packages), (GDestroyNotify) g_free), NULL);
		vala_compiler_packages = NULL;
	}
	_tmp164_ = vala_compiler_fast_vapis;
	_tmp164__length1 = _vala_array_length (vala_compiler_fast_vapis);
	if (_tmp164_ != NULL) {
		gchar** _tmp165_ = NULL;
		gint _tmp165__length1 = 0;
		ValaCodeContext* _tmp174_ = NULL;
		_tmp165_ = vala_compiler_fast_vapis;
		_tmp165__length1 = _vala_array_length (vala_compiler_fast_vapis);
		{
			gchar** vapi_collection = NULL;
			gint vapi_collection_length1 = 0;
			gint _vapi_collection_size_ = 0;
			gint vapi_it = 0;
			vapi_collection = _tmp165_;
			vapi_collection_length1 = _tmp165__length1;
			for (vapi_it = 0; vapi_it < _tmp165__length1; vapi_it = vapi_it + 1) {
				gchar* _tmp166_ = NULL;
				gchar* vapi = NULL;
				_tmp166_ = g_strdup (vapi_collection[vapi_it]);
				vapi = _tmp166_;
				{
					gchar* rpath = NULL;
					const gchar* _tmp167_ = NULL;
					gchar* _tmp168_ = NULL;
					ValaSourceFile* source_file = NULL;
					ValaCodeContext* _tmp169_ = NULL;
					const gchar* _tmp170_ = NULL;
					ValaSourceFile* _tmp171_ = NULL;
					ValaCodeContext* _tmp172_ = NULL;
					ValaSourceFile* _tmp173_ = NULL;
					_tmp167_ = vapi;
					_tmp168_ = vala_code_context_realpath (_tmp167_);
					rpath = _tmp168_;
					_tmp169_ = self->priv->context;
					_tmp170_ = rpath;
					_tmp171_ = vala_source_file_new (_tmp169_, VALA_SOURCE_FILE_TYPE_FAST, _tmp170_, NULL, FALSE);
					source_file = _tmp171_;
					_tmp172_ = self->priv->context;
					_tmp173_ = source_file;
					vala_code_context_add_source_file (_tmp172_, _tmp173_);
					_vala_source_file_unref0 (source_file);
					_g_free0 (rpath);
					_g_free0 (vapi);
				}
			}
		}
		_tmp174_ = self->priv->context;
		vala_code_context_set_use_fast_vapi (_tmp174_, TRUE);
	}
	_tmp175_ = self->priv->context;
	_tmp176_ = vala_compiler_gresources;
	_tmp176__length1 = _vala_array_length (vala_compiler_gresources);
	_tmp177_ = (_tmp176_ != NULL) ? _vala_array_dup4 (_tmp176_, _tmp176__length1) : ((gpointer) _tmp176_);
	_tmp177__length1 = _tmp176__length1;
	_tmp175_->gresources = (_vala_array_free (_tmp175_->gresources, _tmp175_->gresources_length1, (GDestroyNotify) g_free), NULL);
	_tmp175_->gresources = _tmp177_;
	_tmp175_->gresources_length1 = _tmp177__length1;
	_tmp179_ = self->priv->context;
	_tmp180_ = vala_code_context_get_report (_tmp179_);
	_tmp181_ = _tmp180_;
	_tmp182_ = vala_report_get_errors (_tmp181_);
	if (_tmp182_ > 0) {
		_tmp178_ = TRUE;
	} else {
		gboolean _tmp183_ = FALSE;
		gboolean _tmp184_ = FALSE;
		_tmp184_ = vala_compiler_fatal_warnings;
		if (_tmp184_) {
			ValaCodeContext* _tmp185_ = NULL;
			ValaReport* _tmp186_ = NULL;
			ValaReport* _tmp187_ = NULL;
			gint _tmp188_ = 0;
			_tmp185_ = self->priv->context;
			_tmp186_ = vala_code_context_get_report (_tmp185_);
			_tmp187_ = _tmp186_;
			_tmp188_ = vala_report_get_warnings (_tmp187_);
			_tmp183_ = _tmp188_ > 0;
		} else {
			_tmp183_ = FALSE;
		}
		_tmp178_ = _tmp183_;
	}
	if (_tmp178_) {
		gint _tmp189_ = 0;
		_tmp189_ = vala_compiler_quit (self);
		result = _tmp189_;
		return result;
	}
	_tmp190_ = self->priv->context;
	_tmp191_ = vala_gd_bus_server_module_new ();
	_tmp192_ = _tmp191_;
	vala_code_context_set_codegen (_tmp190_, (ValaCodeGenerator*) _tmp192_);
	_vala_code_visitor_unref0 (_tmp192_);
	has_c_files = FALSE;
	has_h_files = FALSE;
	_tmp193_ = vala_compiler_sources;
	_tmp193__length1 = _vala_array_length (vala_compiler_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp193_;
		source_collection_length1 = _tmp193__length1;
		for (source_it = 0; source_it < _tmp193__length1; source_it = source_it + 1) {
			gchar* _tmp194_ = NULL;
			gchar* source = NULL;
			_tmp194_ = g_strdup (source_collection[source_it]);
			source = _tmp194_;
			{
				ValaCodeContext* _tmp195_ = NULL;
				const gchar* _tmp196_ = NULL;
				gboolean _tmp197_ = FALSE;
				gboolean _tmp198_ = FALSE;
				_tmp195_ = self->priv->context;
				_tmp196_ = source;
				_tmp197_ = vala_compiler_run_output;
				_tmp198_ = vala_code_context_add_source_filename (_tmp195_, _tmp196_, _tmp197_, TRUE);
				if (_tmp198_) {
					const gchar* _tmp199_ = NULL;
					gboolean _tmp200_ = FALSE;
					_tmp199_ = source;
					_tmp200_ = g_str_has_suffix (_tmp199_, ".c");
					if (_tmp200_) {
						has_c_files = TRUE;
					} else {
						const gchar* _tmp201_ = NULL;
						gboolean _tmp202_ = FALSE;
						_tmp201_ = source;
						_tmp202_ = g_str_has_suffix (_tmp201_, ".h");
						if (_tmp202_) {
							has_h_files = TRUE;
						}
					}
				}
				_g_free0 (source);
			}
		}
	}
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = NULL;
	_tmp204_ = vala_compiler_ccode_only;
	if (_tmp204_) {
		gboolean _tmp205_ = FALSE;
		gboolean _tmp206_ = FALSE;
		_tmp206_ = has_c_files;
		if (_tmp206_) {
			_tmp205_ = TRUE;
		} else {
			gboolean _tmp207_ = FALSE;
			_tmp207_ = has_h_files;
			_tmp205_ = _tmp207_;
		}
		_tmp203_ = _tmp205_;
	} else {
		_tmp203_ = FALSE;
	}
	if (_tmp203_) {
		vala_report_warning (NULL, "C header and source files are ignored when -C or --ccode is set");
	}
	_tmp209_ = self->priv->context;
	_tmp210_ = vala_code_context_get_report (_tmp209_);
	_tmp211_ = _tmp210_;
	_tmp212_ = vala_report_get_errors (_tmp211_);
	if (_tmp212_ > 0) {
		_tmp208_ = TRUE;
	} else {
		gboolean _tmp213_ = FALSE;
		gboolean _tmp214_ = FALSE;
		_tmp214_ = vala_compiler_fatal_warnings;
		if (_tmp214_) {
			ValaCodeContext* _tmp215_ = NULL;
			ValaReport* _tmp216_ = NULL;
			ValaReport* _tmp217_ = NULL;
			gint _tmp218_ = 0;
			_tmp215_ = self->priv->context;
			_tmp216_ = vala_code_context_get_report (_tmp215_);
			_tmp217_ = _tmp216_;
			_tmp218_ = vala_report_get_warnings (_tmp217_);
			_tmp213_ = _tmp218_ > 0;
		} else {
			_tmp213_ = FALSE;
		}
		_tmp208_ = _tmp213_;
	}
	if (_tmp208_) {
		gint _tmp219_ = 0;
		_tmp219_ = vala_compiler_quit (self);
		result = _tmp219_;
		return result;
	}
	_tmp220_ = vala_parser_new ();
	parser = _tmp220_;
	_tmp221_ = parser;
	_tmp222_ = self->priv->context;
	vala_parser_parse (_tmp221_, _tmp222_);
	_tmp223_ = vala_genie_parser_new ();
	genie_parser = _tmp223_;
	_tmp224_ = genie_parser;
	_tmp225_ = self->priv->context;
	vala_genie_parser_parse (_tmp224_, _tmp225_);
	_tmp226_ = vala_gir_parser_new ();
	gir_parser = _tmp226_;
	_tmp227_ = gir_parser;
	_tmp228_ = self->priv->context;
	vala_gir_parser_parse (_tmp227_, _tmp228_);
	_tmp230_ = self->priv->context;
	_tmp231_ = vala_code_context_get_report (_tmp230_);
	_tmp232_ = _tmp231_;
	_tmp233_ = vala_report_get_errors (_tmp232_);
	if (_tmp233_ > 0) {
		_tmp229_ = TRUE;
	} else {
		gboolean _tmp234_ = FALSE;
		gboolean _tmp235_ = FALSE;
		_tmp235_ = vala_compiler_fatal_warnings;
		if (_tmp235_) {
			ValaCodeContext* _tmp236_ = NULL;
			ValaReport* _tmp237_ = NULL;
			ValaReport* _tmp238_ = NULL;
			gint _tmp239_ = 0;
			_tmp236_ = self->priv->context;
			_tmp237_ = vala_code_context_get_report (_tmp236_);
			_tmp238_ = _tmp237_;
			_tmp239_ = vala_report_get_warnings (_tmp238_);
			_tmp234_ = _tmp239_ > 0;
		} else {
			_tmp234_ = FALSE;
		}
		_tmp229_ = _tmp234_;
	}
	if (_tmp229_) {
		gint _tmp240_ = 0;
		_tmp240_ = vala_compiler_quit (self);
		result = _tmp240_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp241_ = vala_compiler_fast_vapi_filename;
	if (_tmp241_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp242_ = NULL;
		ValaCodeWriter* _tmp243_ = NULL;
		ValaCodeContext* _tmp244_ = NULL;
		const gchar* _tmp245_ = NULL;
		gint _tmp246_ = 0;
		_tmp242_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_FAST);
		interface_writer = _tmp242_;
		_tmp243_ = interface_writer;
		_tmp244_ = self->priv->context;
		_tmp245_ = vala_compiler_fast_vapi_filename;
		vala_code_writer_write_file (_tmp243_, _tmp244_, _tmp245_);
		_tmp246_ = vala_compiler_quit (self);
		result = _tmp246_;
		_vala_code_visitor_unref0 (interface_writer);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp247_ = self->priv->context;
	vala_code_context_check (_tmp247_);
	_tmp249_ = self->priv->context;
	_tmp250_ = vala_code_context_get_report (_tmp249_);
	_tmp251_ = _tmp250_;
	_tmp252_ = vala_report_get_errors (_tmp251_);
	if (_tmp252_ > 0) {
		_tmp248_ = TRUE;
	} else {
		gboolean _tmp253_ = FALSE;
		gboolean _tmp254_ = FALSE;
		_tmp254_ = vala_compiler_fatal_warnings;
		if (_tmp254_) {
			ValaCodeContext* _tmp255_ = NULL;
			ValaReport* _tmp256_ = NULL;
			ValaReport* _tmp257_ = NULL;
			gint _tmp258_ = 0;
			_tmp255_ = self->priv->context;
			_tmp256_ = vala_code_context_get_report (_tmp255_);
			_tmp257_ = _tmp256_;
			_tmp258_ = vala_report_get_warnings (_tmp257_);
			_tmp253_ = _tmp258_ > 0;
		} else {
			_tmp253_ = FALSE;
		}
		_tmp248_ = _tmp253_;
	}
	if (_tmp248_) {
		gint _tmp259_ = 0;
		_tmp259_ = vala_compiler_quit (self);
		result = _tmp259_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp262_ = vala_compiler_ccode_only;
	if (!_tmp262_) {
		gboolean _tmp263_ = FALSE;
		_tmp263_ = vala_compiler_compile_only;
		_tmp261_ = !_tmp263_;
	} else {
		_tmp261_ = FALSE;
	}
	if (_tmp261_) {
		const gchar* _tmp264_ = NULL;
		_tmp264_ = vala_compiler_library;
		_tmp260_ = _tmp264_ == NULL;
	} else {
		_tmp260_ = FALSE;
	}
	if (_tmp260_) {
		gboolean _tmp265_ = FALSE;
		gboolean _tmp266_ = FALSE;
		_tmp266_ = has_c_files;
		if (!_tmp266_) {
			ValaCodeContext* _tmp267_ = NULL;
			ValaMethod* _tmp268_ = NULL;
			ValaMethod* _tmp269_ = NULL;
			_tmp267_ = self->priv->context;
			_tmp268_ = vala_code_context_get_entry_point (_tmp267_);
			_tmp269_ = _tmp268_;
			_tmp265_ = _tmp269_ == NULL;
		} else {
			_tmp265_ = FALSE;
		}
		if (_tmp265_) {
			vala_report_error (NULL, "program does not contain a static `main' method");
		}
	}
	_tmp270_ = vala_compiler_dump_tree;
	if (_tmp270_ != NULL) {
		ValaCodeWriter* code_writer = NULL;
		ValaCodeWriter* _tmp271_ = NULL;
		ValaCodeWriter* _tmp272_ = NULL;
		ValaCodeContext* _tmp273_ = NULL;
		const gchar* _tmp274_ = NULL;
		_tmp271_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_DUMP);
		code_writer = _tmp271_;
		_tmp272_ = code_writer;
		_tmp273_ = self->priv->context;
		_tmp274_ = vala_compiler_dump_tree;
		vala_code_writer_write_file (_tmp272_, _tmp273_, _tmp274_);
		_vala_code_visitor_unref0 (code_writer);
	}
	_tmp276_ = self->priv->context;
	_tmp277_ = vala_code_context_get_report (_tmp276_);
	_tmp278_ = _tmp277_;
	_tmp279_ = vala_report_get_errors (_tmp278_);
	if (_tmp279_ > 0) {
		_tmp275_ = TRUE;
	} else {
		gboolean _tmp280_ = FALSE;
		gboolean _tmp281_ = FALSE;
		_tmp281_ = vala_compiler_fatal_warnings;
		if (_tmp281_) {
			ValaCodeContext* _tmp282_ = NULL;
			ValaReport* _tmp283_ = NULL;
			ValaReport* _tmp284_ = NULL;
			gint _tmp285_ = 0;
			_tmp282_ = self->priv->context;
			_tmp283_ = vala_code_context_get_report (_tmp282_);
			_tmp284_ = _tmp283_;
			_tmp285_ = vala_report_get_warnings (_tmp284_);
			_tmp280_ = _tmp285_ > 0;
		} else {
			_tmp280_ = FALSE;
		}
		_tmp275_ = _tmp280_;
	}
	if (_tmp275_) {
		gint _tmp286_ = 0;
		_tmp286_ = vala_compiler_quit (self);
		result = _tmp286_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp287_ = self->priv->context;
	_tmp288_ = vala_code_context_get_codegen (_tmp287_);
	_tmp289_ = _tmp288_;
	_tmp290_ = self->priv->context;
	vala_code_generator_emit (_tmp289_, _tmp290_);
	_tmp292_ = self->priv->context;
	_tmp293_ = vala_code_context_get_report (_tmp292_);
	_tmp294_ = _tmp293_;
	_tmp295_ = vala_report_get_errors (_tmp294_);
	if (_tmp295_ > 0) {
		_tmp291_ = TRUE;
	} else {
		gboolean _tmp296_ = FALSE;
		gboolean _tmp297_ = FALSE;
		_tmp297_ = vala_compiler_fatal_warnings;
		if (_tmp297_) {
			ValaCodeContext* _tmp298_ = NULL;
			ValaReport* _tmp299_ = NULL;
			ValaReport* _tmp300_ = NULL;
			gint _tmp301_ = 0;
			_tmp298_ = self->priv->context;
			_tmp299_ = vala_code_context_get_report (_tmp298_);
			_tmp300_ = _tmp299_;
			_tmp301_ = vala_report_get_warnings (_tmp300_);
			_tmp296_ = _tmp301_ > 0;
		} else {
			_tmp296_ = FALSE;
		}
		_tmp291_ = _tmp296_;
	}
	if (_tmp291_) {
		gint _tmp302_ = 0;
		_tmp302_ = vala_compiler_quit (self);
		result = _tmp302_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp304_ = vala_compiler_vapi_filename;
	if (_tmp304_ == NULL) {
		const gchar* _tmp305_ = NULL;
		_tmp305_ = vala_compiler_library;
		_tmp303_ = _tmp305_ != NULL;
	} else {
		_tmp303_ = FALSE;
	}
	if (_tmp303_) {
		const gchar* _tmp306_ = NULL;
		gchar* _tmp307_ = NULL;
		_tmp306_ = vala_compiler_library;
		_tmp307_ = g_strdup_printf ("%s.vapi", _tmp306_);
		_g_free0 (vala_compiler_vapi_filename);
		vala_compiler_vapi_filename = _tmp307_;
	}
	_tmp308_ = vala_compiler_library;
	if (_tmp308_ != NULL) {
		const gchar* _tmp309_ = NULL;
		_tmp309_ = vala_compiler_gir;
		if (_tmp309_ != NULL) {
			gchar* gir_base = NULL;
			const gchar* _tmp310_ = NULL;
			gchar* _tmp311_ = NULL;
			glong gir_len = 0L;
			const gchar* _tmp312_ = NULL;
			gint _tmp313_ = 0;
			gint _tmp314_ = 0;
			gint last_hyphen = 0;
			const gchar* _tmp315_ = NULL;
			gint _tmp316_ = 0;
			gboolean _tmp317_ = FALSE;
			gint _tmp318_ = 0;
			_tmp310_ = vala_compiler_gir;
			_tmp311_ = g_path_get_basename (_tmp310_);
			gir_base = _tmp311_;
			_tmp312_ = gir_base;
			_tmp313_ = strlen (_tmp312_);
			_tmp314_ = _tmp313_;
			gir_len = (glong) _tmp314_;
			_tmp315_ = gir_base;
			_tmp316_ = string_last_index_of_char (_tmp315_, (gunichar) '-', 0);
			last_hyphen = _tmp316_;
			_tmp318_ = last_hyphen;
			if (_tmp318_ == (-1)) {
				_tmp317_ = TRUE;
			} else {
				const gchar* _tmp319_ = NULL;
				gboolean _tmp320_ = FALSE;
				_tmp319_ = gir_base;
				_tmp320_ = g_str_has_suffix (_tmp319_, ".gir");
				_tmp317_ = !_tmp320_;
			}
			if (_tmp317_) {
				const gchar* _tmp321_ = NULL;
				gchar* _tmp322_ = NULL;
				gchar* _tmp323_ = NULL;
				_tmp321_ = vala_compiler_gir;
				_tmp322_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp321_);
				_tmp323_ = _tmp322_;
				vala_report_error (NULL, _tmp323_);
				_g_free0 (_tmp323_);
			} else {
				gchar* gir_namespace = NULL;
				const gchar* _tmp324_ = NULL;
				gint _tmp325_ = 0;
				gchar* _tmp326_ = NULL;
				gchar* gir_version = NULL;
				const gchar* _tmp327_ = NULL;
				gint _tmp328_ = 0;
				glong _tmp329_ = 0L;
				gint _tmp330_ = 0;
				gchar* _tmp331_ = NULL;
				const gchar* _tmp332_ = NULL;
				gboolean _tmp333_ = FALSE;
				gboolean _tmp334_ = FALSE;
				gboolean _tmp335_ = FALSE;
				const gchar* _tmp336_ = NULL;
				_tmp324_ = gir_base;
				_tmp325_ = last_hyphen;
				_tmp326_ = string_substring (_tmp324_, (glong) 0, (glong) _tmp325_);
				gir_namespace = _tmp326_;
				_tmp327_ = gir_base;
				_tmp328_ = last_hyphen;
				_tmp329_ = gir_len;
				_tmp330_ = last_hyphen;
				_tmp331_ = string_substring (_tmp327_, (glong) (_tmp328_ + 1), (_tmp329_ - _tmp330_) - 5);
				gir_version = _tmp331_;
				_tmp332_ = gir_version;
				g_strcanon (_tmp332_, "0123456789.", '?');
				_tmp336_ = gir_namespace;
				if (g_strcmp0 (_tmp336_, "") == 0) {
					_tmp335_ = TRUE;
				} else {
					const gchar* _tmp337_ = NULL;
					_tmp337_ = gir_version;
					_tmp335_ = g_strcmp0 (_tmp337_, "") == 0;
				}
				if (_tmp335_) {
					_tmp334_ = TRUE;
				} else {
					const gchar* _tmp338_ = NULL;
					gchar _tmp339_ = '\0';
					gboolean _tmp340_ = FALSE;
					_tmp338_ = gir_version;
					_tmp339_ = string_get (_tmp338_, (glong) 0);
					_tmp340_ = g_ascii_isdigit (_tmp339_);
					_tmp334_ = !_tmp340_;
				}
				if (_tmp334_) {
					_tmp333_ = TRUE;
				} else {
					const gchar* _tmp341_ = NULL;
					gboolean _tmp342_ = FALSE;
					_tmp341_ = gir_version;
					_tmp342_ = string_contains (_tmp341_, "?");
					_tmp333_ = _tmp342_;
				}
				if (_tmp333_) {
					const gchar* _tmp343_ = NULL;
					gchar* _tmp344_ = NULL;
					gchar* _tmp345_ = NULL;
					_tmp343_ = vala_compiler_gir;
					_tmp344_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp343_);
					_tmp345_ = _tmp344_;
					vala_report_error (NULL, _tmp345_);
					_g_free0 (_tmp345_);
				} else {
					ValaGIRWriter* gir_writer = NULL;
					ValaGIRWriter* _tmp346_ = NULL;
					gchar* gir_directory = NULL;
					gchar* _tmp347_ = NULL;
					const gchar* _tmp348_ = NULL;
					ValaGIRWriter* _tmp353_ = NULL;
					ValaCodeContext* _tmp354_ = NULL;
					const gchar* _tmp355_ = NULL;
					const gchar* _tmp356_ = NULL;
					const gchar* _tmp357_ = NULL;
					const gchar* _tmp358_ = NULL;
					const gchar* _tmp359_ = NULL;
					_tmp346_ = vala_gir_writer_new ();
					gir_writer = _tmp346_;
					_tmp347_ = g_strdup (".");
					gir_directory = _tmp347_;
					_tmp348_ = vala_compiler_directory;
					if (_tmp348_ != NULL) {
						ValaCodeContext* _tmp349_ = NULL;
						const gchar* _tmp350_ = NULL;
						const gchar* _tmp351_ = NULL;
						gchar* _tmp352_ = NULL;
						_tmp349_ = self->priv->context;
						_tmp350_ = vala_code_context_get_directory (_tmp349_);
						_tmp351_ = _tmp350_;
						_tmp352_ = g_strdup (_tmp351_);
						_g_free0 (gir_directory);
						gir_directory = _tmp352_;
					}
					_tmp353_ = gir_writer;
					_tmp354_ = self->priv->context;
					_tmp355_ = gir_directory;
					_tmp356_ = vala_compiler_gir;
					_tmp357_ = gir_namespace;
					_tmp358_ = gir_version;
					_tmp359_ = vala_compiler_library;
					vala_gir_writer_write_file (_tmp353_, _tmp354_, _tmp355_, _tmp356_, _tmp357_, _tmp358_, _tmp359_);
					_g_free0 (gir_directory);
					_vala_code_visitor_unref0 (gir_writer);
				}
				_g_free0 (gir_version);
				_g_free0 (gir_namespace);
			}
			_g_free0 (vala_compiler_gir);
			vala_compiler_gir = NULL;
			_g_free0 (gir_base);
		}
		_g_free0 (vala_compiler_library);
		vala_compiler_library = NULL;
	}
	_tmp360_ = vala_compiler_vapi_filename;
	if (_tmp360_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp361_ = NULL;
		gboolean _tmp362_ = FALSE;
		const gchar* _tmp363_ = NULL;
		ValaCodeWriter* _tmp371_ = NULL;
		ValaCodeContext* _tmp372_ = NULL;
		const gchar* _tmp373_ = NULL;
		_tmp361_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_EXTERNAL);
		interface_writer = _tmp361_;
		_tmp363_ = vala_compiler_directory;
		if (_tmp363_ != NULL) {
			const gchar* _tmp364_ = NULL;
			gboolean _tmp365_ = FALSE;
			_tmp364_ = vala_compiler_vapi_filename;
			_tmp365_ = g_path_is_absolute (_tmp364_);
			_tmp362_ = !_tmp365_;
		} else {
			_tmp362_ = FALSE;
		}
		if (_tmp362_) {
			ValaCodeContext* _tmp366_ = NULL;
			const gchar* _tmp367_ = NULL;
			const gchar* _tmp368_ = NULL;
			const gchar* _tmp369_ = NULL;
			gchar* _tmp370_ = NULL;
			_tmp366_ = self->priv->context;
			_tmp367_ = vala_code_context_get_directory (_tmp366_);
			_tmp368_ = _tmp367_;
			_tmp369_ = vala_compiler_vapi_filename;
			_tmp370_ = g_strdup_printf ("%s%c%s", _tmp368_, (gint) G_DIR_SEPARATOR, _tmp369_);
			_g_free0 (vala_compiler_vapi_filename);
			vala_compiler_vapi_filename = _tmp370_;
		}
		_tmp371_ = interface_writer;
		_tmp372_ = self->priv->context;
		_tmp373_ = vala_compiler_vapi_filename;
		vala_code_writer_write_file (_tmp371_, _tmp372_, _tmp373_);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp374_ = vala_compiler_internal_vapi_filename;
	if (_tmp374_ != NULL) {
		gboolean _tmp375_ = FALSE;
		const gchar* _tmp376_ = NULL;
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp379_ = NULL;
		ValaCodeWriter* _tmp380_ = NULL;
		const gchar* _tmp381_ = NULL;
		const gchar* _tmp382_ = NULL;
		gchar* vapi_filename = NULL;
		const gchar* _tmp383_ = NULL;
		gchar* _tmp384_ = NULL;
		gboolean _tmp385_ = FALSE;
		const gchar* _tmp386_ = NULL;
		ValaCodeWriter* _tmp394_ = NULL;
		ValaCodeContext* _tmp395_ = NULL;
		const gchar* _tmp396_ = NULL;
		_tmp376_ = vala_compiler_internal_header_filename;
		if (_tmp376_ == NULL) {
			_tmp375_ = TRUE;
		} else {
			const gchar* _tmp377_ = NULL;
			_tmp377_ = vala_compiler_header_filename;
			_tmp375_ = _tmp377_ == NULL;
		}
		if (_tmp375_) {
			gint _tmp378_ = 0;
			vala_report_error (NULL, "--internal-vapi may only be used in combination with --header and --in" \
"ternal-header");
			_tmp378_ = vala_compiler_quit (self);
			result = _tmp378_;
			_vala_code_visitor_unref0 (gir_parser);
			_vala_code_visitor_unref0 (genie_parser);
			_vala_code_visitor_unref0 (parser);
			return result;
		}
		_tmp379_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_INTERNAL);
		interface_writer = _tmp379_;
		_tmp380_ = interface_writer;
		_tmp381_ = vala_compiler_header_filename;
		_tmp382_ = vala_compiler_internal_header_filename;
		vala_code_writer_set_cheader_override (_tmp380_, _tmp381_, _tmp382_);
		_tmp383_ = vala_compiler_internal_vapi_filename;
		_tmp384_ = g_strdup (_tmp383_);
		vapi_filename = _tmp384_;
		_tmp386_ = vala_compiler_directory;
		if (_tmp386_ != NULL) {
			const gchar* _tmp387_ = NULL;
			gboolean _tmp388_ = FALSE;
			_tmp387_ = vapi_filename;
			_tmp388_ = g_path_is_absolute (_tmp387_);
			_tmp385_ = !_tmp388_;
		} else {
			_tmp385_ = FALSE;
		}
		if (_tmp385_) {
			ValaCodeContext* _tmp389_ = NULL;
			const gchar* _tmp390_ = NULL;
			const gchar* _tmp391_ = NULL;
			const gchar* _tmp392_ = NULL;
			gchar* _tmp393_ = NULL;
			_tmp389_ = self->priv->context;
			_tmp390_ = vala_code_context_get_directory (_tmp389_);
			_tmp391_ = _tmp390_;
			_tmp392_ = vapi_filename;
			_tmp393_ = g_strdup_printf ("%s%c%s", _tmp391_, (gint) G_DIR_SEPARATOR, _tmp392_);
			_g_free0 (vapi_filename);
			vapi_filename = _tmp393_;
		}
		_tmp394_ = interface_writer;
		_tmp395_ = self->priv->context;
		_tmp396_ = vapi_filename;
		vala_code_writer_write_file (_tmp394_, _tmp395_, _tmp396_);
		_g_free0 (vala_compiler_internal_vapi_filename);
		vala_compiler_internal_vapi_filename = NULL;
		_g_free0 (vapi_filename);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp397_ = vala_compiler_dependencies;
	if (_tmp397_ != NULL) {
		ValaCodeContext* _tmp398_ = NULL;
		const gchar* _tmp399_ = NULL;
		_tmp398_ = self->priv->context;
		_tmp399_ = vala_compiler_dependencies;
		vala_code_context_write_dependencies (_tmp398_, _tmp399_);
	}
	_tmp400_ = vala_compiler_ccode_only;
	if (!_tmp400_) {
		ValaCCodeCompiler* ccompiler = NULL;
		ValaCCodeCompiler* _tmp401_ = NULL;
		gboolean _tmp402_ = FALSE;
		const gchar* _tmp403_ = NULL;
		gboolean _tmp407_ = FALSE;
		const gchar* _tmp408_ = NULL;
		gchar** _tmp412_ = NULL;
		gint _tmp412__length1 = 0;
		_tmp401_ = vala_ccode_compiler_new ();
		ccompiler = _tmp401_;
		_tmp403_ = vala_compiler_cc_command;
		if (_tmp403_ == NULL) {
			const gchar* _tmp404_ = NULL;
			_tmp404_ = g_getenv ("CC");
			_tmp402_ = _tmp404_ != NULL;
		} else {
			_tmp402_ = FALSE;
		}
		if (_tmp402_) {
			const gchar* _tmp405_ = NULL;
			gchar* _tmp406_ = NULL;
			_tmp405_ = g_getenv ("CC");
			_tmp406_ = g_strdup (_tmp405_);
			_g_free0 (vala_compiler_cc_command);
			vala_compiler_cc_command = _tmp406_;
		}
		_tmp408_ = vala_compiler_pkg_config_command;
		if (_tmp408_ == NULL) {
			const gchar* _tmp409_ = NULL;
			_tmp409_ = g_getenv ("PKG_CONFIG");
			_tmp407_ = _tmp409_ != NULL;
		} else {
			_tmp407_ = FALSE;
		}
		if (_tmp407_) {
			const gchar* _tmp410_ = NULL;
			gchar* _tmp411_ = NULL;
			_tmp410_ = g_getenv ("PKG_CONFIG");
			_tmp411_ = g_strdup (_tmp410_);
			_g_free0 (vala_compiler_pkg_config_command);
			vala_compiler_pkg_config_command = _tmp411_;
		}
		_tmp412_ = vala_compiler_cc_options;
		_tmp412__length1 = _vala_array_length (vala_compiler_cc_options);
		if (_tmp412_ == NULL) {
			ValaCCodeCompiler* _tmp413_ = NULL;
			ValaCodeContext* _tmp414_ = NULL;
			const gchar* _tmp415_ = NULL;
			gchar** _tmp416_ = NULL;
			gchar** _tmp417_ = NULL;
			gint _tmp417__length1 = 0;
			const gchar* _tmp418_ = NULL;
			_tmp413_ = ccompiler;
			_tmp414_ = self->priv->context;
			_tmp415_ = vala_compiler_cc_command;
			_tmp416_ = g_new0 (gchar*, 0 + 1);
			_tmp417_ = _tmp416_;
			_tmp417__length1 = 0;
			_tmp418_ = vala_compiler_pkg_config_command;
			vala_ccode_compiler_compile (_tmp413_, _tmp414_, _tmp415_, _tmp417_, 0, _tmp418_);
			_tmp417_ = (_vala_array_free (_tmp417_, _tmp417__length1, (GDestroyNotify) g_free), NULL);
		} else {
			ValaCCodeCompiler* _tmp419_ = NULL;
			ValaCodeContext* _tmp420_ = NULL;
			const gchar* _tmp421_ = NULL;
			gchar** _tmp422_ = NULL;
			gint _tmp422__length1 = 0;
			const gchar* _tmp423_ = NULL;
			_tmp419_ = ccompiler;
			_tmp420_ = self->priv->context;
			_tmp421_ = vala_compiler_cc_command;
			_tmp422_ = vala_compiler_cc_options;
			_tmp422__length1 = _vala_array_length (vala_compiler_cc_options);
			_tmp423_ = vala_compiler_pkg_config_command;
			vala_ccode_compiler_compile (_tmp419_, _tmp420_, _tmp421_, _tmp422_, _tmp422__length1, _tmp423_);
		}
		_vala_ccode_compiler_unref0 (ccompiler);
	}
	_tmp424_ = vala_compiler_quit (self);
	result = _tmp424_;
	_vala_code_visitor_unref0 (gir_parser);
	_vala_code_visitor_unref0 (genie_parser);
	_vala_code_visitor_unref0 (parser);
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static void ___lambda4_ (Block1Data* _data1_, GPid pid, gint status) {
	gint _tmp0_ = 0;
	GMainLoop* _tmp1_ = NULL;
	_tmp0_ = status;
	_data1_->child_status = (_tmp0_ & 0xff00) >> 8;
	_tmp1_ = _data1_->loop;
	g_main_loop_quit (_tmp1_);
}


static void ____lambda4__gchild_watch_func (GPid pid, gint status, gpointer self) {
	___lambda4_ (self, pid, status);
}


static gint vala_compiler_run_source (gchar** args, int args_length1) {
	gint result = 0;
	gint i = 0;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp29_ = FALSE;
	gchar** _tmp35_ = NULL;
	gint _tmp35__length1 = 0;
	gint _tmp36_ = 0;
	const gchar* _tmp37_ = NULL;
	gchar** _tmp39_ = NULL;
	gint _tmp39__length1 = 0;
	gint _tmp40_ = 0;
	const gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar** _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	gchar** _tmp45_ = NULL;
	gint _tmp45__length1 = 0;
	gint _tmp46_ = 0;
	const gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	gint outputfd = 0;
	const gchar* _tmp51_ = NULL;
	gint _tmp52_ = 0;
	gint _tmp53_ = 0;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp54_ = NULL;
	gint ret = 0;
	ValaCompiler* _tmp55_ = NULL;
	gint _tmp56_ = 0;
	gint _tmp57_ = 0;
	gint _tmp58_ = 0;
	const gchar* _tmp59_ = NULL;
	gint _tmp60_ = 0;
	gchar** target_args = NULL;
	const gchar* _tmp62_ = NULL;
	gchar* _tmp63_ = NULL;
	gchar** _tmp64_ = NULL;
	gint target_args_length1 = 0;
	gint _target_args_size_ = 0;
	GError * _inner_error_ = NULL;
	i = 1;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = i;
	_tmp3_ = _tmp1_[_tmp2_];
	if (_tmp3_ != NULL) {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		gint _tmp5_ = 0;
		const gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp4_ = args;
		_tmp4__length1 = args_length1;
		_tmp5_ = i;
		_tmp6_ = _tmp4_[_tmp5_];
		_tmp7_ = g_str_has_prefix (_tmp6_, "-");
		_tmp0_ = _tmp7_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp28_ = 0;
		{
			gchar** compile_args = NULL;
			gint compile_args_length1 = 0;
			gint _compile_args_size_ = 0;
			gchar** _tmp8_ = NULL;
			gint _tmp8__length1 = 0;
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar** _tmp12_ = NULL;
			gint _tmp13_ = 0;
			GOptionContext* opt_context = NULL;
			GOptionContext* _tmp14_ = NULL;
			GOptionContext* _tmp15_ = NULL;
			GOptionContext* _tmp16_ = NULL;
			gchar** temp_args = NULL;
			gchar** _tmp17_ = NULL;
			gint _tmp17__length1 = 0;
			gint temp_args_length1 = 0;
			gint _temp_args_size_ = 0;
			GOptionContext* _tmp18_ = NULL;
			_tmp8_ = args;
			_tmp8__length1 = args_length1;
			_tmp9_ = _tmp8_[1];
			_tmp10_ = g_strconcat ("valac ", _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			g_shell_parse_argv (_tmp11_, &_tmp13_, &_tmp12_, &_inner_error_);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
			compile_args = _tmp12_;
			compile_args_length1 = _tmp13_;
			_compile_args_size_ = compile_args_length1;
			_g_free0 (_tmp11_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == G_SHELL_ERROR) {
					goto __catch0_g_shell_error;
				}
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch0_g_option_error;
				}
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			_tmp14_ = g_option_context_new ("- Vala");
			opt_context = _tmp14_;
			_tmp15_ = opt_context;
			g_option_context_set_help_enabled (_tmp15_, TRUE);
			_tmp16_ = opt_context;
			g_option_context_add_main_entries (_tmp16_, VALA_COMPILER_options, NULL);
			_tmp17_ = compile_args;
			_tmp17__length1 = compile_args_length1;
			temp_args = _tmp17_;
			temp_args_length1 = _tmp17__length1;
			_temp_args_size_ = temp_args_length1;
			_tmp18_ = opt_context;
			g_option_context_parse (_tmp18_, &temp_args_length1, &temp_args, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == G_SHELL_ERROR) {
					goto __catch0_g_shell_error;
				}
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch0_g_option_error;
				}
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			_g_option_context_free0 (opt_context);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
		}
		goto __finally0;
		__catch0_g_shell_error:
		{
			GError* e = NULL;
			FILE* _tmp19_ = NULL;
			GError* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp19_ = stdout;
			_tmp20_ = e;
			_tmp21_ = _tmp20_->message;
			fprintf (_tmp19_, "%s\n", _tmp21_);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		goto __finally0;
		__catch0_g_option_error:
		{
			GError* e = NULL;
			FILE* _tmp22_ = NULL;
			GError* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			FILE* _tmp25_ = NULL;
			gchar** _tmp26_ = NULL;
			gint _tmp26__length1 = 0;
			const gchar* _tmp27_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp22_ = stdout;
			_tmp23_ = e;
			_tmp24_ = _tmp23_->message;
			fprintf (_tmp22_, "%s\n", _tmp24_);
			_tmp25_ = stdout;
			_tmp26_ = args;
			_tmp26__length1 = args_length1;
			_tmp27_ = _tmp26_[0];
			fprintf (_tmp25_, "Run '%s --help' to see a full list of available command line options.\n", _tmp27_);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp28_ = i;
		i = _tmp28_ + 1;
	}
	_tmp29_ = vala_compiler_version;
	if (_tmp29_) {
		FILE* _tmp30_ = NULL;
		_tmp30_ = stdout;
		fprintf (_tmp30_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	} else {
		gboolean _tmp31_ = FALSE;
		_tmp31_ = vala_compiler_api_version;
		if (_tmp31_) {
			FILE* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			gchar* _tmp34_ = NULL;
			_tmp32_ = stdout;
			_tmp33_ = string_substring (PACKAGE_SUFFIX, (glong) 1, (glong) (-1));
			_tmp34_ = _tmp33_;
			fprintf (_tmp32_, "%s\n", _tmp34_);
			_g_free0 (_tmp34_);
			result = 0;
			return result;
		}
	}
	_tmp35_ = args;
	_tmp35__length1 = args_length1;
	_tmp36_ = i;
	_tmp37_ = _tmp35_[_tmp36_];
	if (_tmp37_ == NULL) {
		FILE* _tmp38_ = NULL;
		_tmp38_ = stderr;
		fprintf (_tmp38_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp39_ = args;
	_tmp39__length1 = args_length1;
	_tmp40_ = i;
	_tmp41_ = _tmp39_[_tmp40_];
	_tmp42_ = g_strdup (_tmp41_);
	_tmp43_ = g_new0 (gchar*, 1 + 1);
	_tmp43_[0] = _tmp42_;
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = _tmp43_;
	_tmp44_ = g_get_tmp_dir ();
	_tmp45_ = args;
	_tmp45__length1 = args_length1;
	_tmp46_ = i;
	_tmp47_ = _tmp45_[_tmp46_];
	_tmp48_ = g_path_get_basename (_tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = g_strdup_printf ("%s/%s.XXXXXX", _tmp44_, _tmp49_);
	_g_free0 (vala_compiler_output);
	vala_compiler_output = _tmp50_;
	_g_free0 (_tmp49_);
	_tmp51_ = vala_compiler_output;
	_tmp52_ = g_mkstemp (_tmp51_);
	outputfd = _tmp52_;
	_tmp53_ = outputfd;
	if (_tmp53_ < 0) {
		result = 1;
		return result;
	}
	vala_compiler_run_output = TRUE;
	vala_compiler_disable_warnings = TRUE;
	vala_compiler_quiet_mode = TRUE;
	_tmp54_ = vala_compiler_new ();
	compiler = _tmp54_;
	_tmp55_ = compiler;
	_tmp56_ = vala_compiler_run (_tmp55_);
	ret = _tmp56_;
	_tmp57_ = ret;
	if (_tmp57_ != 0) {
		result = ret;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp58_ = outputfd;
	close (_tmp58_);
	_tmp59_ = vala_compiler_output;
	_tmp60_ = g_chmod (_tmp59_, 0700);
	if (_tmp60_ != 0) {
		const gchar* _tmp61_ = NULL;
		_tmp61_ = vala_compiler_output;
		g_unlink (_tmp61_);
		result = 1;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp62_ = vala_compiler_output;
	_tmp63_ = g_strdup (_tmp62_);
	_tmp64_ = g_new0 (gchar*, 1 + 1);
	_tmp64_[0] = _tmp63_;
	target_args = _tmp64_;
	target_args_length1 = 1;
	_target_args_size_ = target_args_length1;
	while (TRUE) {
		gint _tmp65_ = 0;
		gchar** _tmp66_ = NULL;
		gint _tmp66__length1 = 0;
		gchar** _tmp67_ = NULL;
		gint _tmp67__length1 = 0;
		gchar** _tmp68_ = NULL;
		gint _tmp68__length1 = 0;
		gint _tmp69_ = 0;
		const gchar* _tmp70_ = NULL;
		gchar* _tmp71_ = NULL;
		gint _tmp72_ = 0;
		_tmp65_ = i;
		_tmp66_ = args;
		_tmp66__length1 = args_length1;
		if (!(_tmp65_ < _tmp66__length1)) {
			break;
		}
		_tmp67_ = target_args;
		_tmp67__length1 = target_args_length1;
		_tmp68_ = args;
		_tmp68__length1 = args_length1;
		_tmp69_ = i;
		_tmp70_ = _tmp68_[_tmp69_];
		_tmp71_ = g_strdup (_tmp70_);
		_vala_array_add1 (&target_args, &target_args_length1, &_target_args_size_, _tmp71_);
		_tmp72_ = i;
		i = _tmp72_ + 1;
	}
	{
		Block1Data* _data1_;
		GPid pid = 0;
		GMainLoop* _tmp73_ = NULL;
		gchar** _tmp74_ = NULL;
		gint _tmp74__length1 = 0;
		GPid _tmp75_ = 0;
		const gchar* _tmp76_ = NULL;
		GPid _tmp77_ = 0;
		GMainLoop* _tmp78_ = NULL;
		gint _tmp79_ = 0;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_tmp73_ = g_main_loop_new (NULL, FALSE);
		_data1_->loop = _tmp73_;
		_data1_->child_status = 0;
		_tmp74_ = target_args;
		_tmp74__length1 = target_args_length1;
		g_spawn_async (NULL, _tmp74_, NULL, (G_SPAWN_CHILD_INHERITS_STDIN | G_SPAWN_DO_NOT_REAP_CHILD) | G_SPAWN_FILE_AND_ARGV_ZERO, NULL, NULL, &_tmp75_, &_inner_error_);
		pid = _tmp75_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			block1_data_unref (_data1_);
			_data1_ = NULL;
			target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
			_vala_compiler_unref0 (compiler);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp76_ = vala_compiler_output;
		g_unlink (_tmp76_);
		_tmp77_ = pid;
		g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp77_, ____lambda4__gchild_watch_func, block1_data_ref (_data1_), block1_data_unref);
		_tmp78_ = _data1_->loop;
		g_main_loop_run (_tmp78_);
		_tmp79_ = _data1_->child_status;
		result = _tmp79_;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp80_ = NULL;
		GError* _tmp81_ = NULL;
		const gchar* _tmp82_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp80_ = stdout;
		_tmp81_ = e;
		_tmp82_ = _tmp81_->message;
		fprintf (_tmp80_, "%s\n", _tmp82_);
		result = 1;
		_g_error_free0 (e);
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	__finally1:
	target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
	_vala_compiler_unref0 (compiler);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


static gint vala_compiler_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gchar** _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp32_ = NULL;
	ValaCompiler* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = _tmp1_[0];
	_tmp3_ = g_path_get_basename (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "vala") == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		_tmp0_ = TRUE;
	} else {
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp6_ = args;
		_tmp6__length1 = args_length1;
		_tmp7_ = _tmp6_[0];
		_tmp8_ = g_path_get_basename (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = g_strcmp0 (_tmp9_, "vala" PACKAGE_SUFFIX) == 0;
		_g_free0 (_tmp9_);
	}
	if (_tmp0_) {
		gchar** _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		gint _tmp11_ = 0;
		_tmp10_ = args;
		_tmp10__length1 = args_length1;
		_tmp11_ = vala_compiler_run_source (_tmp10_, _tmp10__length1);
		result = _tmp11_;
		return result;
	}
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp12_ = NULL;
		GOptionContext* _tmp13_ = NULL;
		GOptionContext* _tmp14_ = NULL;
		GOptionContext* _tmp15_ = NULL;
		_tmp12_ = g_option_context_new ("- Vala Compiler");
		opt_context = _tmp12_;
		_tmp13_ = opt_context;
		g_option_context_set_help_enabled (_tmp13_, TRUE);
		_tmp14_ = opt_context;
		g_option_context_add_main_entries (_tmp14_, VALA_COMPILER_options, NULL);
		_tmp15_ = opt_context;
		g_option_context_parse (_tmp15_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch2_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally2;
	__catch2_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp16_ = NULL;
		GError* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		FILE* _tmp19_ = NULL;
		gchar** _tmp20_ = NULL;
		gint _tmp20__length1 = 0;
		const gchar* _tmp21_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = stdout;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		fprintf (_tmp16_, "%s\n", _tmp18_);
		_tmp19_ = stdout;
		_tmp20_ = args;
		_tmp20__length1 = args_length1;
		_tmp21_ = _tmp20_[0];
		fprintf (_tmp19_, "Run '%s --help' to see a full list of available command line options.\n", _tmp21_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp22_ = vala_compiler_version;
	if (_tmp22_) {
		FILE* _tmp23_ = NULL;
		_tmp23_ = stdout;
		fprintf (_tmp23_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	} else {
		gboolean _tmp24_ = FALSE;
		_tmp24_ = vala_compiler_api_version;
		if (_tmp24_) {
			FILE* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			_tmp25_ = stdout;
			_tmp26_ = string_substring (PACKAGE_SUFFIX, (glong) 1, (glong) (-1));
			_tmp27_ = _tmp26_;
			fprintf (_tmp25_, "%s\n", _tmp27_);
			_g_free0 (_tmp27_);
			result = 0;
			return result;
		}
	}
	_tmp29_ = vala_compiler_sources;
	_tmp29__length1 = _vala_array_length (vala_compiler_sources);
	if (_tmp29_ == NULL) {
		gchar** _tmp30_ = NULL;
		gint _tmp30__length1 = 0;
		_tmp30_ = vala_compiler_fast_vapis;
		_tmp30__length1 = _vala_array_length (vala_compiler_fast_vapis);
		_tmp28_ = _tmp30_ == NULL;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		FILE* _tmp31_ = NULL;
		_tmp31_ = stderr;
		fprintf (_tmp31_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp32_ = vala_compiler_new ();
	compiler = _tmp32_;
	_tmp33_ = compiler;
	_tmp34_ = vala_compiler_run (_tmp33_);
	result = _tmp34_;
	_vala_compiler_unref0 (compiler);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return vala_compiler_main (argv, argc);
}


ValaCompiler* vala_compiler_construct (GType object_type) {
	ValaCompiler* self = NULL;
	self = (ValaCompiler*) g_type_create_instance (object_type);
	return self;
}


ValaCompiler* vala_compiler_new (void) {
	return vala_compiler_construct (VALA_TYPE_COMPILER);
}


static void vala_value_compiler_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_compiler_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_compiler_unref (value->data[0].v_pointer);
	}
}


static void vala_value_compiler_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_compiler_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_compiler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCompiler* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_compiler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCompiler** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_compiler (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_compiler (GValue* value, gpointer v_object) {
	ValaCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


void vala_value_take_compiler (GValue* value, gpointer v_object) {
	ValaCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


static void vala_compiler_class_init (ValaCompilerClass * klass) {
	vala_compiler_parent_class = g_type_class_peek_parent (klass);
	((ValaCompilerClass *) klass)->finalize = vala_compiler_finalize;
	g_type_class_add_private (klass, sizeof (ValaCompilerPrivate));
}


static void vala_compiler_instance_init (ValaCompiler * self) {
	self->priv = VALA_COMPILER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_compiler_finalize (ValaCompiler* obj) {
	ValaCompiler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_COMPILER, ValaCompiler);
	g_signal_handlers_destroy (self);
	_vala_code_context_unref0 (self->priv->context);
}


GType vala_compiler_get_type (void) {
	static volatile gsize vala_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_compiler_init, vala_value_compiler_free_value, vala_value_compiler_copy_value, vala_value_compiler_peek_pointer, "p", vala_value_compiler_collect_value, "p", vala_value_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCompiler), 0, (GInstanceInitFunc) vala_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_compiler_type_id;
		vala_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_compiler_type_id__volatile, vala_compiler_type_id);
	}
	return vala_compiler_type_id__volatile;
}


gpointer vala_compiler_ref (gpointer instance) {
	ValaCompiler* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_compiler_unref (gpointer instance) {
	ValaCompiler* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



