// My File Manager (MFM).
//
// Copyright 2005-2006 by Stefano Gatti.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.
//
//=====================================================================

#ifndef mfmmount_ui_h
#define mfmmount_ui_h

#include "mfmmount_ui_fluid.hxx"
#include "table.hxx"

class class_mount_table : public class_table {

public:

  void *class_mfm_mount_ptr;

  class_mount_table(int x, int y, int w, int h);
  
private:  

  void double_click_cb(int row);
  void button_3_cb(int row);
 
};


class class_mfmmount : public class_mfmmount_fluid {

public:

  class_mfmmount();

  void find_mounted(); 
  
  class_mount_table *mfmmount_table;

  Fl_Color mounted_color;
  Fl_Color unmounted_color;
  
  void mfmmount_loadcfg();

  void mfmmount_mount_callback();
  void mfmmount_open_callback();
  void mfmmount_temp_callback();  
  void mfmmount_umount_callback();
// Added:
  void mfmmount_refresh_callback();
  void mfmmount_exit_callback();
  void mfmmount_help_callback();  
  
};


#endif

