// My File Manager (MFM).
//
// Copyright 2005-2006 by Stefano Gatti.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.
//
//=====================================================================

#ifndef mfm_main_ui_h
#define mfm_main_ui_h

#include "mfm_main_table.hxx"
#include "mfm_main_ui_fluid.hxx"

#include <FL/Fl_File_Chooser.H>

#define MODE  "Mode"
#define M     "M"
// Changed to owner for consistency
//#define USER  "User"
#define USER  "Owner"
#define GROUP "Group"
#define SIZE  "Size"
#define DATE  "Date"
#define NAME  "Filename"

#define SORT_NONE  0
#define SORT_MODE  1
#define SORT_USER  2
#define SORT_GROUP 3
#define SORT_SIZE  4
#define SORT_DATE  5
#define SORT_NAME  6
#define SORT_EXT   7

Fl_Color get_color(char *name);

char* get_prog(char *name);
void refresh_dir(char *path, bool force);

class class_mfm_window : public class_mfm_window_fluid {

private:

  long int popup_row;
  char open_mode; // m = mount / t = mount temporary / n = normal
  
public:

  char *path,
       *open_dir,
       permission,
       owner,
       size,
       age,
       *str_options;       
       
  bool show_dir,
       show_hidden,
       show_color,
       sort_case_sensitive,
       sort_inverse,
       sort_directory,
       localized_date,
       right_filename,
			 verbose,
       overwrite;
       
  int sort;
  
  int col_mode,
      col_user,
      col_group,
      col_size,
      col_date,
      col_name,
      w_window,
      h_window,
      scroll_speed;
      
  Fl_Menu_Button *popup;

  time_t dir_time;
  
  class_mfm_main_table *mfm_window_table;
  
public:

  int menu_offset;  
  
  class_mfm_window(char *dir);

  void open_file_default();
  void open_file_menu();
  void open_popup_menu();
  virtual void load_dir(bool flag_header);
  char* get_list_file(bool absolute);
  time_t get_dir_time(char* file);
   
  void load_vars();
  long int file_list(long int num_files, dirent ***files);
  bool is_dir(char* file);
  void write_header();
  void write_table(long int num_files, dirent ***files);
  void set_dir(char *dir);
  void cdup();
  long int  filename_list(dirent ***files);
  void save_vars();
  void set_str_options();

  void mfm_window_callback();
  void mfm_menu_new_callback();
  void mfm_menu_new_actual_callback();
  void mfm_menu_new_home_callback();
  void mfm_menu_new_launch_callback();
  void mfm_menu_new_select_dir_callback();
  void mfm_menu_new_trash_callback();
  void mfm_menu_new_tree_callback();   
  void mfm_menu_new_dir_callback();
  void mfm_menu_new_file_callback();
  void mfm_menu_new_terminal_callback();
// Added root terminal button in MFMR menubar
  void mfm_menu_root_terminal_callback();	
  void mfm_menu_chdir_callback();
  void mfm_menu_chdir_up_callback();
  void mfm_menu_chdir_root_callback();
  void mfm_menu_chdir_home_callback();
// Added change directory /opt menubar button
  void mfm_menu_chdir_opt_callback();
  void mfm_menu_chdir_launch_callback();
  void mfm_menu_chdir_open_callback();
  void mfm_menu_chdir_select_dir_callback();
  void mfm_menu_chdir_trash_callback();
  void mfm_menu_chdir_reload_callback();
  void mfm_menu_select_callback();
  void mfm_menu_select_all_callback();
  void mfm_menu_select_all_files_callback();
  void mfm_menu_select_none_callback();
  void mfm_menu_select_wildcard_callback();
  void mfm_menu_files_callback();
  void mfm_menu_files_copy_callback();
  void mfm_menu_files_move_callback();
  void mfm_menu_files_soft_link_callback();
  void mfm_menu_files_hard_link_callback();	
  void mfm_menu_files_open_default_callback();
  void mfm_menu_files_open_menu_callback();
  void mfm_menu_files_open_with_callback();
  void mfm_menu_files_open_editor_callback();
  void mfm_menu_files_open_popup_callback();
  void mfm_menu_files_rename_callback();
  void mfm_menu_files_stat_callback();
  void mfm_menu_files_attributes_callback();
  void mfm_menu_files_find_callback();	
  void mfm_menu_files_compress_callback();
  void mfm_menu_files_burn_callback();
  void mfm_menu_files_trash_callback();
  void mfm_menu_files_empity_trash_callback();
  void mfm_menu_files_delete_callback();
  void mfm_menu_sort_callback();
  void mfm_menu_sort_mode_callback();
  void mfm_menu_sort_user_callback();
  void mfm_menu_sort_group_callback();
  void mfm_menu_sort_size_callback();
  void mfm_menu_sort_date_callback();
  void mfm_menu_sort_name_callback();
  void mfm_menu_sort_ext_callback();
  void mfm_menu_sort_none_callback();
  void mfm_menu_sort_case_sensitive_callback();
  void mfm_menu_sort_inverse_callback();
  void mfm_menu_sort_directory_callback();
  void mfm_menu_view_callback();
  void mfm_menu_view_permission_all_callback();
  void mfm_menu_view_permission_user_callback();
  void mfm_menu_view_permission_none_callback();
  void mfm_menu_view_owner_usergroup_callback();
  void mfm_menu_view_owner_user_callback();
  void mfm_menu_view_owner_none_callback();
  void mfm_menu_view_size_bytes_callback();
  void mfm_menu_view_size_kbytes_callback();
  void mfm_menu_view_size_compact_callback();
  void mfm_menu_view_size_none_callback();
  void mfm_menu_view_age_datetime_callback();
  void mfm_menu_view_age_date_callback();
  void mfm_menu_view_age_none_callback();
// Removed from MFMR, duplication and rarely used
//void mfm_menu_view_permission_toggle_callback();	
//void mfm_menu_view_owner_toggle_callback();
//void mfm_menu_view_size_toggle_callback();		
//void mfm_menu_view_age_toggle_callback();
  void mfm_menu_view_show_dir_callback();
  void mfm_menu_view_show_hidden_callback();
  void mfm_menu_view_show_color_callback();
  void mfm_menu_view_localized_callback();
  void mfm_menu_view_right_callback();    
  void mfm_menu_opt_callback(); 
  void mfm_menu_opt_verbose_callback();
  void mfm_menu_opt_overwrite_callback();  
  void mfm_menu_opt_wheel_callback();  
  void mfm_menu_opt_mount_callback();	
  void mfm_menu_opt_zip_callback();	  
  void mfm_menu_opt_config_callback();
  void mfm_menu_opt_save_callback();
  void mfm_menu_quit_callback();
  virtual void mfm_menu_quit_window_callback();
  void mfm_menu_quit_all_callback();
  void mfm_menu_help_callback();
// Added mfmr_history_select_button:
  void mfmr_history_select_callback();
// Added mfmr_menu_clear_history_callback button:
  void mfmr_menu_clear_history_callback();
// Added remove_history_item:
  void remove_history_item();
  void mfm_popup_copy_callback();
  void mfm_popup_move_callback();
  void mfm_popup_open_default_callback();
  void mfm_popup_open_menu_callback();
  void mfm_popup_open_with_callback();
  void mfm_popup_open_editor_callback();
  void mfm_popup_open_popup_callback();	
  void mfm_popup_rename_callback();
  void mfm_popup_attributes_callback();
// Added statistics to right-click popup menu:
  void mfm_popup_stat_callback();
  void mfm_popup_compress_callback();
  void mfm_popup_trash_callback();
  void mfm_popup_delete_callback();
  void mfm_popup_new_dir_callback();
  void mfm_popup_new_file_callback();
  void mfm_popup_new_terminal_callback();
  void mfm_popup_chdir_up_callback();
  void mfm_popup_select_all_callback();    

};

#endif
