// My File Manager (MFM).
//
// Copyright 2005-2006 by Stefano Gatti.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.
//
//=====================================================================

#include <time.h>
#include <locale.h>

#include <FL/Fl.H>

#include "mfm_main_table.hxx"
#include "mfm_main_ui.hxx"
#include "mfm_get_path_ui.hxx"
#include "mfm_util.hxx"
#include "mfm_dnd.hxx"
#include "file_info.hxx"


class_mfm_main_table *ptr_mfm_main_table = NULL;


/**************************************************************************
* Class_mfm_main_table methods
****************************************************************************/

/**************************************************************************
*
* Constructor
*
****************************************************************************/

class_mfm_main_table::class_mfm_main_table(int x, int y, int w, int h, char *label, void *ptr) : class_table(x, y, w, h, label) {

  ptr_class_mfm_window = ptr;

}


/*********************************************************************
*
* sort_func
*
* Performing sort
*
*********************************************************************/

void class_mfm_main_table::sort_func(int col, bool dir_up){

  char *label_str = header_label(col);

  if (strncmp(label_str, MODE, strlen(MODE)) == 0 || strncmp(label_str, M, strlen(M)) == 0) {

    ((class_mfm_window *) ptr_class_mfm_window)->mfm_menu_sort_mode->setonly();

    ((class_mfm_window *) ptr_class_mfm_window)->sort = SORT_MODE;

  }

  else if (strncmp(label_str, USER, strlen(USER)) == 0) {

    ((class_mfm_window *) ptr_class_mfm_window)->mfm_menu_sort_user->setonly();

    ((class_mfm_window *) ptr_class_mfm_window)->sort = SORT_USER;

  }

  else if (strncmp(label_str, GROUP, strlen(GROUP)) == 0) {

    ((class_mfm_window *) ptr_class_mfm_window)->mfm_menu_sort_group->setonly();

    ((class_mfm_window *) ptr_class_mfm_window)->sort = SORT_GROUP;

  }

  else if (strncmp(label_str, SIZE, strlen(SIZE)) == 0) {

    ((class_mfm_window *) ptr_class_mfm_window)->mfm_menu_sort_size->setonly();

    ((class_mfm_window *) ptr_class_mfm_window)->sort = SORT_SIZE;

  }

  else if (strncmp(label_str, DATE, strlen(DATE)) == 0) {

    ((class_mfm_window *) ptr_class_mfm_window)->mfm_menu_sort_date->setonly();

    ((class_mfm_window *) ptr_class_mfm_window)->sort = SORT_DATE;

  }

  else if (strncmp(label_str, NAME, strlen(NAME)) == 0) {

    ((class_mfm_window *) ptr_class_mfm_window)->mfm_menu_sort_name->setonly();

    ((class_mfm_window *) ptr_class_mfm_window)->sort = SORT_NAME;

  }

  if (dir_up) {

    ((class_mfm_window *) ptr_class_mfm_window)->mfm_menu_sort_inverse->clear();

    ((class_mfm_window *) ptr_class_mfm_window)->sort_inverse = false;

  }

  else {

    ((class_mfm_window *) ptr_class_mfm_window)->mfm_menu_sort_inverse->set();

    ((class_mfm_window *) ptr_class_mfm_window)->sort_inverse = true;

  }

  ((class_mfm_window *) ptr_class_mfm_window)->load_dir(false);

} // sort_func


/**************************************************************************
*
* double_click_cb
*
* Double click callback
*
****************************************************************************/

void class_mfm_main_table::double_click_cb(int row) {

  ((class_mfm_window *) ptr_class_mfm_window)->open_file_default();

} // double_click_cb


/**************************************************************************
*
* button_2_cb
*
* Click on button 2 callback
*
****************************************************************************/

void class_mfm_main_table::button_2_cb(int row) {

  select_row(false);
  select_row(row, true);

  ((class_mfm_window *) ptr_class_mfm_window)->open_file_menu();

} // button_2_cb


/**************************************************************************
*
* button_3_cb
*
* Click on button 3 callback
*
****************************************************************************/

void class_mfm_main_table::button_3_cb(int row) {

  ptr_mfm_main_table = this;
  
  if (!row_selected(row)) {
	
    select_row(false);
    select_row(row, true);
			
  }  

} // button_3_cb


/**************************************************************************
*
* button_3_drag_cb
*
* Drag button 3 callback
*
****************************************************************************/

void class_mfm_main_table::button_3_drag_cb(int row) {

  char *list_string;

  drag_source_ptr = ptr_class_mfm_window;
  
  drag_source = 1;
  
  if (Fl::event_ctrl())
  
    asprintf(&list_string, "%s", ((class_mfm_window *) ptr_class_mfm_window)->get_list_file(true));  
    
  else  
  
    asprintf(&list_string, "%s", ((class_mfm_window *) ptr_class_mfm_window)->get_list_file(false));  

  Fl::copy(list_string, strlen(list_string), 0);  
  
  free(list_string);

  Fl::dnd();    

}


/**************************************************************************
*
* button_3_release_cb
*
* Release button 3 callback
*
****************************************************************************/

void class_mfm_main_table::button_3_release_cb(int row) {

  ((class_mfm_window *) ptr_class_mfm_window)->open_popup_menu();

} //button_3_release_cb


/**************************************************************************
*
* handle
*
****************************************************************************/

int class_mfm_main_table::handle(int event) {

  int ret=0;  

  if (event == FL_DND_RELEASE) { 
  
    drag_target_ptr = (void *) ((class_mfm_window *) ptr_class_mfm_window);
  
    drag_target = 1;  
    
    dnd_cb();
    
  }
  
	else {
  
    if (event == FL_SHORTCUT)		
				
		  ret = ((class_mfm_window *)((class_mfm_main_table *)Fl::focus())->ptr_class_mfm_window)->mfm_menu->handle(event);		
      

    if (event == FL_MOUSEWHEEL) {
    
// Scroll on X when using scroll wheel together Ctrl key    

      if (Fl::event_ctrl()) {

        Fl::e_dx = Fl::e_dy;
        Fl::e_dy = 0;

      }  

// Variable wheel scroll speed
  
      else  

        Fl::e_dy = Fl::e_dy*((class_mfm_window *) ptr_class_mfm_window)->scroll_speed;   

    }                     
				
  	if (ret == 0)
	
      ret = class_table::handle(event);		
      
  }       

  return ret;		
		
} // handle
