// My File Manager (MFM).
//
// Copyright 2005-2006 by Stefano Gatti.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.
//
//=====================================================================

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <FL/Fl.H>
#include <FL/Fl_File_Chooser.H>
#include <FL/Fl_Output.H>
#include <FL/filename.H>

#include "mfm.hxx"
#include "mfm_util.hxx"
#include "mfm_main_scattered_ui.hxx"
#include "mfm_get_path_ui.hxx"


#ifdef DEBUGGING

  #include <mcheck.h>
	
#endif


/****************************************************************************
* Function: main
*
* Parameters: int argc : number of command line arguments
*             char **argv : command line arguments
*
* Return: error code
*
****************************************************************************/

int main(int argc, char **argv) {

  char *fifo_str;

  int fifo_fd, ret;

  init();

  asprintf(&fifo_str, "%s/.mfm/mfm.fifo", HOMEDIR);

  fifo_fd = open(fifo_str, O_WRONLY + O_NONBLOCK);

  if (fifo_fd > 0) {

    fifo = fdopen(fifo_fd, "w");

    if (argc == 1)

//  Changed so MFMR opens to HOMEDIR, not LAUNCHDIR
//  Note: For Tiny Core LAUNCHDIR changed to /etc/sysconfig/tcedir/
//  fprintf(fifo, "OPEN %s\n", LAUNCHDIR);
    fprintf(fifo, "OPEN %s\n", HOMEDIR);

    else  if (strncmp(argv[1], "-s", 2) == 0)  {

      fprintf(fifo, "OPENS %i\n", argc);

      for (int i = 0; i < argc; i++)

        fprintf(fifo, "%s\n", argv[i]);

    }

    else

      for (int i = 1; i < argc; i++)

        fprintf(fifo, "OPEN %s\n", argv[i]);

    fclose(fifo);

    close(fifo_fd);

    ret = 0;

  }

  else {  
  
    mkfifo(fifo_str, S_IRUSR+S_IWUSR); 
    
    fifo_fd = open (fifo_str, O_RDONLY + O_NONBLOCK);
 
    if (fifo_fd > 0) {
    
      fifo = fdopen(fifo_fd, "r");

      load_config();

      mfm_window_index.init();

      if (argc == 1)
  
//  Changed so MFMR opens to HOMEDIR, not LAUNCHDIR
//  Note: For Tiny Core LAUNCHDIR changed to /etc/sysconfig/tcedir/
//      new class_mfm_window(LAUNCHDIR);
        new class_mfm_window(HOMEDIR);
    
      else  if (strncmp(argv[1], "-s", 2) == 0)
        
        new class_mfm_window_scattered(argc, argv);
            
      else       
        
        for (int i = 1; i < argc; i++)  
        
          new class_mfm_window(argv[i]);    
          
      start_timeout();

      ret = Fl::run(); 

      fclose(fifo);
    
      close(fifo_fd);
        
    }   
  
    else 
    
      ret = -1000;      
      
    unlink(fifo_str);                        
  
  }   
  
  free(fifo_str);            
    
  return ret;        
  
} // main
