// My File Manager (MFM).
//
// Copyright 2005-2006 by Stefano Gatti.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.
//
//=====================================================================

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <pwd.h>
#include <grp.h>

#include "file_info.hxx"

char *buffer = NULL;


/**************************************************************************
* Metodi di file_info
**************************************************************************/

/**************************************************************************
* Funzione: set_file
*
* Imposta il file da analizzare
****************************************************************************/

void file_info::set_file(char* path, char* name) {

  char *file_name;
  
  int lun;
	
	path_info = path;
	name_info = name;

  asprintf(&file_name, "%s%s", path, name);

  lun = strlen(file_name);

  if (file_name[lun-1] == '/')
  
    file_name[lun-1] = 0;

  lstat(file_name, &stat_buffer);

  if (file_name != NULL)
	
    free(file_name);

} /* set_file */


/**************************************************************************
* Funzione: is_dir
*
* Ritorna se il file è una directory
****************************************************************************/

bool file_info::is_dir() {	
	
	 if (S_ISDIR(stat_buffer.st_mode) != 0) 
		
    return true;

  else

    return false;

} // is_dir


/**************************************************************************
* Funzione: get_mode
*
* Ritorna la lista delle permission
****************************************************************************/

char* file_info::get_mode() {

// Fixed Mode not displaying permissions properly
//strcpy(file_mode, "----------");
  strcpy(file_mode, " --- --- ---");

			
	if (S_ISLNK(stat_buffer.st_mode) != 0) {	
	
	  struct stat stat_link;
		
    char *file_name;
	
    asprintf(&file_name, "%s%s", path_info, name_info);		

    stat(file_name, &stat_link);		
	
		free(file_name);

    if (S_ISDIR(stat_link.st_mode) != 0) file_mode[0] = 'D';
    else if (S_ISCHR(stat_link.st_mode) != 0) file_mode[0] = 'C';			
    else if (S_ISBLK(stat_link.st_mode) != 0) file_mode[0] = 'B';			
    else if (S_ISFIFO(stat_link.st_mode) != 0) file_mode[0] = 'P';		
    else if (S_ISSOCK(stat_link.st_mode) != 0) file_mode[0] = 'S';								 		
    else file_mode[0] = 'l';			
		
	}	
		
	else	
		
    if (S_ISDIR(stat_buffer.st_mode) != 0) file_mode[0] = 'd';
    else if (S_ISCHR(stat_buffer.st_mode) != 0) file_mode[0] = 'c';			
    else if (S_ISBLK(stat_buffer.st_mode) != 0) file_mode[0] = 'b';			
    else if (S_ISFIFO(stat_buffer.st_mode) != 0) file_mode[0] = 'p';			
    else if (S_ISSOCK(stat_buffer.st_mode) != 0) file_mode[0] = 's';								 				

  if ((S_IRUSR & stat_buffer.st_mode) != 0) file_mode[1] = 'r';
  if ((S_IWUSR & stat_buffer.st_mode) != 0) file_mode[2] = 'w';
	
  if ((S_ISUID & stat_buffer.st_mode) != 0)
	
    if ((S_IXUSR & stat_buffer.st_mode) != 0) 
		
		  file_mode[3] = 's';
				
  	else		
	
  	  file_mode[3] = 'S';
			
	else if ((S_IXUSR & stat_buffer.st_mode) != 0) 
	
    file_mode[3] = 'x';

//if ((S_IRGRP & stat_buffer.st_mode) != 0) file_mode[4] = 'r';
  if ((S_IRGRP & stat_buffer.st_mode) != 0) file_mode[5] = 'r';

//if ((S_IWGRP & stat_buffer.st_mode) != 0) file_mode[5] = 'w';
  if ((S_IWGRP & stat_buffer.st_mode) != 0) file_mode[6] = 'w';

  if ((S_ISGID & stat_buffer.st_mode) != 0)
	
    if ((S_IXGRP & stat_buffer.st_mode) != 0) 

//                file_mode[6] = 's';
		  file_mode[7] = 's';

  	else		
	
//	  file_mode[6] = 'S';
  	  file_mode[7] = 'S';

			
	else if ((S_IXGRP & stat_buffer.st_mode) != 0) 
	
//        file_mode[6] = 'x';
	  file_mode[7] = 'x';
			
//if ((S_IROTH & stat_buffer.st_mode) != 0) file_mode[7] = 'r';
  if ((S_IROTH & stat_buffer.st_mode) != 0) file_mode[9] = 'r';

//if ((S_IWOTH & stat_buffer.st_mode) != 0) file_mode[8] = 'w';
  if ((S_IWOTH & stat_buffer.st_mode) != 0) file_mode[10] = 'w';
	
  if ((S_ISVTX & stat_buffer.st_mode) != 0)
	
    if ((S_IXOTH & stat_buffer.st_mode) != 0) 
		
//                file_mode[9] = 't';
		  file_mode[11] = 't';
				
  	else		
	
// 	  file_mode[9] = 'T';
  	  file_mode[11] = 'T';
			
	else if ((S_IXOTH & stat_buffer.st_mode) != 0) 
	
//	  file_mode[9] = 'x';
	  file_mode[11] = 'x';

  return (char*) &file_mode;

} /* get_mode */

/**************************************************************************
* Funzione: get_user
*
* Ritorna l'utente proprietario del file
****************************************************************************/

char* file_info::get_user() {

  struct passwd *pwd; 

  pwd = getpwuid (stat_buffer.st_uid);
	
	if (pwd != NULL)

    return (char*) pwd->pw_name;
		
	else {
	
	  if (buffer == NULL)
		
		  free(buffer);
			
		asprintf(&buffer, "%i", stat_buffer.st_uid);
		
		return buffer;
			
  }

} /* get_user */


/**************************************************************************
* Funzione: get_group
*
* Ritorna il gruppo dell'utente proprietario del file
****************************************************************************/

char* file_info::get_group() {

  struct group *grp;
 
  grp = getgrgid (stat_buffer.st_gid);
	
	if (grp != NULL)	

    return (char*) grp->gr_name;	

	else {
	
	  if (buffer == NULL)
		
		  free(buffer);
			
		asprintf(&buffer, "%i", stat_buffer.st_gid);
		
		return buffer;
			
  }

} /* get_group */


/**************************************************************************
* Funzione: get_uid
*
* Ritorna l'uid dell'utente proprietario del file
****************************************************************************/

uid_t file_info::get_uid() {
  
  return  stat_buffer.st_uid;

} /* get_uid */


/**************************************************************************
* Funzione: get_gid
*
* Ritorna il gid dell'utente proprietario del file
****************************************************************************/

gid_t file_info::get_gid() {
  
  return  stat_buffer.st_gid;

} // get_gid 


/**************************************************************************
* Funzione: get_size
*
* Ritorna le dimensioni del file
****************************************************************************/

long long int file_info::get_size() {

  return stat_buffer.st_size;

} /* get_size */

/**************************************************************************
* Funzione: get_time
*
* Ritorna data ed ora dell'ultima modifica del file
****************************************************************************/

time_t file_info::get_time() {
  
  return stat_buffer.st_mtime;

} /* get_time */

/**************************************************************************
* Fine dei metodi di file_info
**************************************************************************/
