// My File Manager (MFM).
//
// Copyright 2005-2006 by Stefano Gatti.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.
//
//=====================================================================

#ifndef table_h

#define table_h
  
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include <FL/Fl.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Scroll.H>
#include <FL/Fl_Tile.H>
#include <FL/Enumerations.H>
#include <FL/Fl_Button.H>
#include <FL/fl_draw.H>
  
#define SELECT_MODE_OFF 0
#define SELECT_MODE_SINGLE 1
#define SELECT_MODE_MULTI 2
  
class class_table : Fl_Group {

  public:
  
    int ncols,
        nrows,
        hrows,
        wheader_min,
        hheader,
        selected_single_row,
        select_mode,
        sort_col;
        
    bool cols_resizable,
         up_dir,
         label_header_copy,
         label_copy,
         exist_header,
         exist_table;
    
    Fl_Color header_bg_color,
             header_color,
             bg_color,
             select_color,
             color;
        
    struct struct_cell {

      Fl_Box *box;

    };

    struct struct_row {
    
      struct_cell *cell;
      bool selected;
      Fl_Color color;
      void *data;

    };
    
    struct_row *table;
    
    struct struct_button {

      Fl_Button *button;
      int width;

    };
    
    struct_button *header;
    
  public:
  
    char *old_label, *new_label;  

  public:

    Fl_Scroll* group_header;
    Fl_Scroll* group_table;

  public:
  
	  class_table(int x, int y, int w, int h, char *label);

	public:
	
    int get_resize_col(int x, int y);

    virtual int handle(int event);
    
    void change_row_bg_color(int row, Fl_Color color);
    int get_select_row(int x, int y);
    virtual void double_click_cb(int row);
    virtual void button_2_cb(int row);
    virtual void button_3_cb(int row);
    virtual void button_2_drag_cb(int row);
    virtual void button_3_drag_cb(int row);
    virtual void button_2_release_cb(int row);
    virtual void button_3_release_cb(int row);

    static void hscrollbar_cb(Fl_Widget*, void*);
    
    void header_cb(int col);

    virtual bool compare(int col, int row1, int row2);

  public:
  
    void create_header(int nc, bool lcopy);
    void create_table(int nr, bool lcopy);
    void sort_table(int col, bool dir_up);
    void sort_table_header(int col, bool dir_up);
    virtual void sort_func(int col, bool dir_up);
    void set_table_bg_color(Fl_Color color);
    void set_table_bg_select_color(Fl_Color color);

    void col_width(int col, int width);
    int  col_width(int col);
    void col_width_all(int width);
    
    void set_cols_resizable(bool mode);
    
    void set_col_align(int col, Fl_Align align);
    
    void set_row_color(int row, Fl_Color color);
    
    void set_header_bg_color(Fl_Color color);
    void set_header_color(Fl_Color color);
    
    void select_row(int row);
    void select_row(int row, bool select);
    void select_row(bool select);		
    
    int row_selected();
    bool row_selected(int row);

    void row_select_mode(int mode);
    int row_select_mode();

    void row_data(int row, void *data);
    void* row_data(int row);
    void header_label(int col, char *label);
    char* header_label(int col);
    void cell_label(int col, int row, char *label);
    char* cell_label(int col, int row);
    int get_pointed_row();
    int get_selected_rows();
    
    int get_rows();
    int get_cols();
		
		void row_visible(int row);
    
};


#endif
