// My File Manager (MFM).
//
// Copyright 2005-2006 by Stefano Gatti.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.
//
//=====================================================================

#include <locale.h>
#include <stdio.h>
#include <malloc.h>
#include <stdlib.h>

#include "mfmexec_ui.hxx"

#define MAXSIZE 1000

class_mfmexec *ptr_mfmexec;

char *line = NULL;
	
size_t dim_line = 0;


/**************************************************************************
*
* Function: idle_function
*
* function to call during idle
*
****************************************************************************/

void idle_function(void *) {

  if (getline(&line, &dim_line, ptr_mfmexec->stream)>0) { 
	
  	if (ptr_mfmexec->iconized) {
	  
      ptr_mfmexec->mfmexec->show();
			
			ptr_mfmexec->iconized = false;
			
    }							
		
    ptr_mfmexec->mfmexec_browser->add(line);
		
    if (ptr_mfmexec->mfmexec_browser->size() > MAXSIZE)
		
      ptr_mfmexec->mfmexec_browser->remove(1);		
		
		ptr_mfmexec->mfmexec_browser->bottomline(ptr_mfmexec->mfmexec_browser->size());
		
  }			
		
  else {							
      
    pclose(ptr_mfmexec->stream);
		
		Fl::remove_idle(idle_function);
				
  	if (ptr_mfmexec->iconized) {
		
      exit(0);

    }			
		
    else {			

	    ptr_mfmexec->mfmexec_ok->activate();		
		
      ptr_mfmexec->mfmexec_cancel->deactivate();				
		
		  Fl::redraw();
		
    }								
		
  }		
	
}


/**************************************************************************
* Metodi di class_mfmexec
****************************************************************************/

/**************************************************************************
* Costruttore
****************************************************************************/

class_mfmexec::class_mfmexec(char *title, char *command) : class_mfmexec_fluid() {

  stream = popen(command,"r");

  mfmexec->label(title);	

  mfmexec->iconize();		
	
	iconized = true;
	
	mfmexec_ok->deactivate();
	
	ptr_mfmexec = this;
	
  Fl::add_idle(idle_function);
	
} // class_mfmexec


/**************************************************************************
* Callback dei widget dell'interfaccia
****************************************************************************/

void class_mfmexec::mfmexec_callback() {

  exit(0);

} // mfmexec_callback


void class_mfmexec::mfmexec_cancel_callback() {

  exit(0);

} // mfmexec_cancel_callback


void class_mfmexec::mfmexec_ok_callback() {

  exit(0);

} // mfmexec_ok_callback


void class_mfmexec::mfmexec_help_callback() {

  system("mfmhelp /usr/local/share/doc/mfm.html#menu_exec &");

} // mfmexec_help_callback


