// My File Manager (MFM).
//
// Copyright 2005-2006 by Stefano Gatti.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.
//
//=====================================================================

#include "mfm_main_ui.hxx"
#include "mfm_main_scattered_ui.hxx"


/**************************************************************************
* Metodi di class_mfm_window_scattered
****************************************************************************/

/****************************************************************************
* Costruttore
****************************************************************************/

class_mfm_window_scattered::class_mfm_window_scattered(int argc, char **argv) : class_mfm_window("*"){

  path = NULL;

  num_files = argc - 2;

  ptrfiles = argv + 2;

  if (strlen(argv[1]) > 3)

    mfm_window->label(argv[1] + 3);

  (mfm_menu_new_actual + menu_offset)->deactivate();
  (mfm_menu_new_dir + menu_offset)->deactivate();
  (mfm_menu_new_file + menu_offset)->deactivate();
  (mfm_menu_new_terminal + menu_offset)->deactivate();
  (mfm_menu_chdir + menu_offset)->deactivate();
  (mfm_menu_chdir_up + menu_offset)->deactivate();  
  (mfm_menu_chdir_home + menu_offset)->deactivate();  
  (mfm_menu_chdir_launch + menu_offset)->deactivate();  
  (mfm_menu_chdir_open + menu_offset)->deactivate();  
  (mfm_menu_chdir_select_dir + menu_offset)->deactivate();  
  (mfm_menu_chdir_trash + menu_offset)->deactivate();            
  (mfm_menu_chdir_reload + menu_offset)->deactivate();              
  (mfm_menu_sort + menu_offset)->deactivate();
  mfm_popup_new_dir->deactivate();  
  mfm_popup_new_file->deactivate();    
  mfm_popup_new_terminal->deactivate();      
  mfm_popup_chdir_up->deactivate();      
      
  load_dir(false);

} //class_mfm_window_scattered::class_mfm_window_scattered


/****************************************************************************
* Carica la directory
****************************************************************************/

void class_mfm_window_scattered::load_dir(bool flag_header) {

	int ncol;
  
  dirent  **files;  
  	
  ncol = 0;
  
  if (!right_filename) {

    col_name = ncol;

    ncol++;

  }   

  if (permission < 2) {

    col_mode = ncol;

    ncol++;

  }

  else

   col_mode = -1;

  if (owner == 0) {

    col_user = ncol;
    col_group = ncol + 1;

    ncol=ncol+2;

  }

  else if (owner == 1) {

    col_user = ncol;
    col_group = -1;

    ncol++;

  }

  else

    col_user = col_group = -1;

  if (size < 3) {

    col_size = ncol;

    ncol++;

  }

  else

    col_size = -1;

  if (age <= 1) {

    col_date = ncol;

    ncol++;

  }

  else

    col_date = -1;
    
  if (right_filename) {

    col_name = ncol;

    ncol++;

  }       
  
  if (flag_header) {

    mfm_window_table->create_header(ncol, true);

    write_header();
    
  }

  mfm_window_table->create_table(num_files, true);
  
  files = (dirent **) malloc(sizeof(dirent *)*num_files);
  
  for (long int i = 0; i<num_files; i++) {
  
    files[i] = (dirent *) malloc(sizeof(dirent));

    sprintf(files[i]->d_name, ptrfiles[i]);
   
  }  
  
  write_table(num_files, &files);

  for (long int i = 0; i<num_files; i++)

    free(files[i]);

	if (num_files>0)	

    free(files);
  
  return;

} // class_mfm_window_scattered::load_dir
