// My File Manager (MFM).
//
// Copyright 2005-2006 by Stefano Gatti.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.
//
//=====================================================================

#include <locale.h>
#include <stdio.h>
#include <stdlib.h>

#include <FL/fl_draw.H>

#include "mfm_input_ui.hxx"

/**************************************************************************
*
* get_input
*
* Create an input line
*
****************************************************************************/

char* get_input(char* label, char* proposed) {

  class_mfm_input *input_line;
	
	char *ret;

  input_line = new class_mfm_input(label, proposed);

  while (!input_line->end_input)

    Fl::wait();

	ret = input_line->value;	

  delete input_line->mfm_input;
  delete input_line;

  return ret;

} // get_input


/**************************************************************************
* Metodi di class_mfm_input
****************************************************************************/

/**************************************************************************
* Costruttore
****************************************************************************/

class_mfm_input::class_mfm_input(char* label, char* proposed) : class_mfm_input_fluid() {

  end_input = false;

  mfm_input->label(label);

  mfm_input_line->value(proposed);

  mfm_input->show();
	
  value = NULL;

} // class_mfm_input

/**************************************************************************
* Return input line
****************************************************************************/

const char* class_mfm_input::mfm_input_get() {
   
  return mfm_input_line->value();

}

/**************************************************************************
* Callback dei widget dell'interfaccia
****************************************************************************/


void class_mfm_input::mfm_input_ok_callback() {

  if (mfm_input_get() == NULL) {

    value= (char *) malloc(1);

    value[0] = 0;

  }
    
  else

    asprintf(&value, "%s", mfm_input_get());

  end_input = true;

} // mfm_input_ok_callback


void class_mfm_input::mfm_input_cancel_callback() {

	value = NULL;

  end_input = true;

} // mfm_input_cancel_callback


