// My File Manager (MFM).
//
// Copyright 2005-2006 by Stefano Gatti.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.
//
//=====================================================================

#include <locale.h>

#include "mfm_get_path_ui.hxx"
#include "mfm_util.hxx"

class_mfm_window_index mfm_window_index;
class_mfm_get_path *ptr_mfm_get_path;

/**************************************************************************
*
* get_path
*
* Select and return a path
*
****************************************************************************/

char* get_path(char* label, char* path) {

  class_mfm_get_path *ptr_get_path;

  char *ret_path = NULL,
	     *value = NULL;
			 
  int count, lun;			 

  ptr_get_path = new class_mfm_get_path(label, &value, path);

  while (ptr_get_path->mfm_get_path != NULL)

    Fl::wait();
		
	delete ptr_get_path;	
  
  if (value != NULL) {
	
    count = lun = strlen(value);					
				
    for (int j=0; j<lun; j++)
			
	    if (value[j] == ' ')
				
		    count++;
					
  	ret_path = (char *) xmalloc(count+1);

	  for (int j=lun; j>=0; j--) {

	    ret_path[count--] = value[j];
				
      if (value[j] == ' ')
				
  	    ret_path[count--] = '\\' ;
					
    }		
    
	  xfree(&value);	
    
    return ret_path;

  }	
  
  else
  
    return NULL;				

} // get_path


/**************************************************************************
* Metodi di class_mfm_window_index
****************************************************************************/

/**************************************************************************
*
* init
*
* Initialize window index
*
****************************************************************************/

void class_mfm_window_index::init() {

  num_window_index = 0;
  
} // init()


/**************************************************************************
*
* add
*
* Add a window in the index
*
****************************************************************************/

void class_mfm_window_index::add(type_class_mfm_window win_ptr) {

  if (win_ptr->path[0] != '*') {

    type_class_mfm_window *ptr;
  
    ptr = new type_class_mfm_window[num_window_index+1];
  
    for (int i=0; i<num_window_index; i++)

      ptr[i] = ptr_window_index[i];
    
    ptr[num_window_index] = win_ptr;
  
    num_window_index++;

    delete [] ptr_window_index;
  
    ptr_window_index = ptr;
    
  }  

} // add


/**************************************************************************
*
* del
*
* Delete a window in the index
*
****************************************************************************/
void class_mfm_window_index::del(type_class_mfm_window win_ptr) {

  int j=0;

  type_class_mfm_window *ptr;

  ptr = new type_class_mfm_window[num_window_index-1];

  for (int i=0; i<num_window_index; i++)
  
    if (ptr_window_index[i] != win_ptr) {

     ptr[j] = ptr_window_index[i];
     
     j++;

    }

  num_window_index--;

  delete [] ptr_window_index;

  ptr_window_index = ptr;

} // del


/**************************************************************************
* Metodi di class_mfm_get_path
****************************************************************************/

/**************************************************************************
* Costruttore
****************************************************************************/

class_mfm_get_path::class_mfm_get_path(char *title, char** value, char *path) : class_mfm_get_path_fluid() {

  value_ptr = value;
  
  mfm_get_path_browser->label("Active windows");
  
  for (int i=0; i<mfm_window_index.num_window_index; i++)

    mfm_get_path_browser->add(mfm_window_index.ptr_window_index[i]->path);

  mfm_get_path->label(title);
  
  mfm_get_path_input->value(path);

  mfm_get_path->show();

} // class_mfm_get_path::class_mfm_get_path


/**************************************************************************
* Callback dei widget dell'interfaccia
****************************************************************************/

void class_mfm_get_path::mfm_get_path_browser_callback() {

  mfm_get_path_input->value(mfm_get_path_browser->text(mfm_get_path_browser->value()));

}


void class_mfm_get_path::mfm_get_path_button_browse_callback() {

  mfm_get_path_input->value(fl_dir_chooser("Select dir ...", mfm_get_path_input->value()));

}


void class_mfm_get_path::mfm_get_path_button_ok_callback() {

  asprintf(value_ptr, "%s", mfm_get_path_input->value());

  delete mfm_get_path;
  
	mfm_get_path = NULL;
	

}


void class_mfm_get_path::mfm_get_path_button_cancel_callback() {

  value_ptr = NULL;

  delete mfm_get_path;
  
	mfm_get_path = NULL;
  
}


void class_mfm_get_path::mfm_get_path_button_help_callback() {

  system("mfmhelp /usr/local/share/doc/mfm.html#menu_get_path &");

} 


