/* getdelim.c --- Implementation of replacement getdelim function.
   Copyright (C) 1994, 1996, 1997, 1998, 2001, 2003, 2005 Free
   Software Foundation, Inc.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
   02110-1301, USA.  */

/* Ported from glibc by Simon Josefsson. */


/* Modified by Stefano Gatti to have a getline function that use as terminator 
 either new line character or carriage return character */


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdlib.h>
#include <errno.h>
#include <stdio.h>


ssize_t getline2 (char **lineptr, size_t *n, FILE *fp)
{
  int result = 0;
  ssize_t cur_len = 0;

  if (lineptr == NULL || n == NULL || fp == NULL)
    {
      errno = EINVAL;
      return -1;
    }

  flockfile (fp);

  if (*lineptr == NULL || *n == 0)
    {
      *n = 120;
      *lineptr = (char *) malloc (*n);
      if (*lineptr == NULL)
	{
	  result = -1;
	  goto unlock_return;
	}
    }

  for (;;)
    {

      int i;

      i = getc (fp);
      if (i == EOF)
      {
	result = -1;
	break;
      }
			
			if (i == 13 || (i == 8 && cur_len > 0))
			
			  i = 10;		
								
			if (i > 20 || i == 10)	{

      /* Make enough space for len+1 (for final NUL) bytes.  */
      if (cur_len + 1 >= (ssize_t) *n)
	{
	  size_t needed = 2 * (cur_len + 1) + 1;   /* Be generous. */
	  char *new_lineptr;

	  if ((ssize_t) needed < cur_len)
	    {
	      result = -1;
	      goto unlock_return;
	    }

	  new_lineptr = (char *) realloc (*lineptr, needed);
	  if (new_lineptr == NULL)
	    {
	      result = -1;
	      goto unlock_return;
	    }

	  *lineptr = new_lineptr;
	  *n = needed;
	}

      (*lineptr)[cur_len] = i;
      cur_len++;
			
			
	}

      if (i == 10)

	break;
    }
  (*lineptr)[cur_len] = '\0';
  result = cur_len ? cur_len : result;

 unlock_return:
  funlockfile (fp);
  return result;
	
}




