// My File Manager (MFM).
//
// Copyright 2005-2006 by Stefano Gatti.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.
//
//=====================================================================

#include <FL/filename.H>
#include <string.h>
#include <stdio.h>
#include "file_info.hxx"
#include "fl_file_sort.hxx"
#include "mfm_util.hxx"

char *PATH = NULL;


/**************************************************************************
* Funzione per ordinare prima le directory
****************************************************************************/

int fl_sort_dir(struct dirent **a, struct dirent **b) {

  file_info file_stat;
  
  char mode_a, mode_b;
	
	int value = 0;

  file_stat.set_file(PATH, (*a)->d_name);

  mode_a = (char) *file_stat.get_mode();
  
  file_stat.set_file(PATH, (*b)->d_name);

  mode_b = (char) *file_stat.get_mode();
	
	if (mode_a == 'd' || mode_a == 'D') value--;
		
	if (mode_b == 'd' || mode_b == 'D') value++;	
  
  return value;

}



/**************************************************************************
* Funzione per non ordinare
****************************************************************************/

int fl_unsort(struct dirent **a, struct dirent **b) {

  return 0;
  
}


/**************************************************************************
* Funzione di confronto per l'ordinamento per estensione case sensitive
****************************************************************************/

int fl_extsort(struct dirent **a, struct dirent **b) {

	return strcmp(fl_filename_ext((*a)->d_name), fl_filename_ext((*b)->d_name));

}


/**************************************************************************
* Funzione di confronto per l'ordinamento per estensione case insensitive
****************************************************************************/

int fl_caseextsort(struct dirent **a, struct dirent **b) {
	
  return strcasecmp(fl_filename_ext((*a)->d_name), fl_filename_ext((*b)->d_name));

}


/**************************************************************************
* Funzione di confronto per l'ordinamento per dimensione
****************************************************************************/

int fl_sizesort(struct dirent **a, struct dirent **b) {

  file_info file_stat;
  
  long int size_a, size_b;

  file_stat.set_file(PATH, (*a)->d_name);
  
  size_a = file_stat.get_size();
  
  file_stat.set_file(PATH, (*b)->d_name);

  size_b = file_stat.get_size();
  
  return size_a > size_b ? 1 : -1;

}


/**************************************************************************
* Funzione di confronto per l'ordinamento per data
****************************************************************************/

int fl_datesort(struct dirent **a, struct dirent **b) {

  file_info file_stat;

  time_t time_a, time_b;

  file_stat.set_file(PATH, (*a)->d_name);

  time_a = file_stat.get_time();

  file_stat.set_file(PATH, (*b)->d_name);

  time_b = file_stat.get_time();

  return time_a > time_b ? 1 : -1;
  
}


/**************************************************************************
* Funzione di confronto per l'ordinamento per permission
****************************************************************************/

int fl_modesort(struct dirent **a, struct dirent **b) {

  file_info file_stat;
  
  char *mode_a, *mode_b;
  
  int ret;

  file_stat.set_file(PATH, (*a)->d_name);

  asprintf(&mode_a, "%s", file_stat.get_mode());

  file_stat.set_file(PATH, (*b)->d_name);

  asprintf(&mode_b, "%s", file_stat.get_mode());
  
  ret = strcmp(mode_a, mode_b);
  
  xfree(&mode_a);
  xfree(&mode_b);
  
	return ret;

}


/**************************************************************************
* Funzione di confronto per l'ordinamento per user
****************************************************************************/

int fl_usersort(struct dirent **a, struct dirent **b) {

  file_info file_stat;

  char *user_a, *user_b;
  
  int ret;

  file_stat.set_file(PATH, (*a)->d_name);

  asprintf(&user_a, "%s", file_stat.get_user());

  file_stat.set_file(PATH, (*b)->d_name);

  asprintf(&user_b, "%s", file_stat.get_user());

	ret = strcmp(user_a, user_b);
	
  xfree(&user_a);
  xfree(&user_b);
	
	return ret;

}


/**************************************************************************
* Funzione di confronto per l'ordinamento per group
****************************************************************************/

int fl_groupsort(struct dirent **a, struct dirent **b) {

  file_info file_stat;

  char *group_a, *group_b;
  
  int ret;

  file_stat.set_file(PATH, (*a)->d_name);

  asprintf(&group_a, "%s", file_stat.get_user());

  file_stat.set_file(PATH, (*b)->d_name);

  asprintf(&group_b, "%s", file_stat.get_user());

	ret = strcmp(group_a, group_b);

  xfree(&group_a);
  xfree(&group_b);

	return ret;

}


/**************************************************************************
* Funzione di confronto per l'ordinamento inverso per nome case sensitive
****************************************************************************/

int fl_invalphasort(struct dirent **a, struct dirent **b) {

  return fl_alphasort(b, a);
  
}


/**************************************************************************
* Funzione di confronto per l'ordinamento inverso per nome case insensitive
****************************************************************************/

int fl_invcasealphasort(struct dirent **a, struct dirent **b) {

  return fl_casealphasort(b, a);
   
}


/**************************************************************************
* Funzione di confronto per l'ordinamento inverso per estensione case sensitive
****************************************************************************/

int fl_invextsort(struct dirent **a, struct dirent **b) {

  return fl_extsort(b, a);

}


/**************************************************************************
* Funzione di confronto per l'ordinamento inverso per estensione case insensitive
****************************************************************************/

int fl_invcaseextsort(struct dirent **a, struct dirent **b) {
	
  return fl_caseextsort(b, a);
  
}


/**************************************************************************
* Funzione di confronto per l'ordinamento inverso per dimensione
****************************************************************************/

int fl_invsizesort(struct dirent **a, struct dirent **b) {

  return fl_sizesort(b, a);
  
}


/**************************************************************************
* Funzione di confronto per l'ordinamento inverso per data
***************************************************************************/

int fl_invdatesort(struct dirent **a, struct dirent **b) {

  return fl_datesort(b, a);
  
}


/**************************************************************************
* Funzione di confronto per l'ordinamento inverso per permission
***************************************************************************/

int fl_invmodesort(struct dirent **a, struct dirent **b) {

  return fl_modesort(b, a);

}


/**************************************************************************
* Funzione di confronto per l'ordinamento inverso per user
***************************************************************************/

int fl_invusersort(struct dirent **a, struct dirent **b) {

  return fl_usersort(b, a);

}


/**************************************************************************
* Funzione di confronto per l'ordinamento inverso per group
***************************************************************************/

int fl_invgroupsort(struct dirent **a, struct dirent **b) {

  return fl_groupsort(b, a);

}


/**************************************************************************
* Funzione per non ordinare, prima le directory
****************************************************************************/

int fl_dirunsort(struct dirent **a, struct dirent **b) {

  int value = fl_sort_dir(a, b);
	
	if (value == 0)
	
	  return 0;
		
	else
	
	  return value;

}


/**************************************************************************
* Funzione di confronto per l'ordinamento per nome case sensitive, prima le directory
****************************************************************************/

int fl_diralphasort(struct dirent **a, struct dirent **b) {

  int value = fl_sort_dir(a, b);
	
	if (value == 0)
	
	  return fl_alphasort(a, b);
		
	else
	
	  return value;
  
}
  

/**************************************************************************
* Funzione di confronto per l'ordinamento per nome case insensitive, prima le directory
****************************************************************************/

int fl_dircasealphasort(struct dirent **a, struct dirent **b) {

  int value = fl_sort_dir(a, b);
	
	if (value == 0)
	
    return fl_casealphasort(a, b);
		
	else
	
	  return value;	  
  
}


/**************************************************************************
* Funzione di confronto per l'ordinamento per estensione case sensitive, prima le directory
****************************************************************************/

int fl_dirextsort(struct dirent **a, struct dirent **b) {

  int value = fl_sort_dir(a, b);
	
	if (value == 0)
	
    return fl_extsort(a, b);
		
	else
	
	  return value; 
  
}


/**************************************************************************
* Funzione di confronto per l'ordinamento per estensione case insensitive, prima le directory
****************************************************************************/

int fl_dircaseextsort(struct dirent **a, struct dirent **b) {

  int value = fl_sort_dir(a, b);
	
	if (value == 0)
	
    return fl_caseextsort(a, b);
		
	else
	
	  return value;
	    
}


/**************************************************************************
* Funzione di confronto per l'ordinamento per dimensioni, prima le directory
****************************************************************************/

int fl_dirsizesort(struct dirent **a, struct dirent **b) {

  int value = fl_sort_dir(a, b);
	
	if (value == 0)
	
    return fl_sizesort(a, b);
		
	else
	
	  return value;  
  
}


/**************************************************************************
* Funzione di confronto per l'ordinamento per data, prima le directory
****************************************************************************/

int fl_dirdatesort(struct dirent **a, struct dirent **b) {

  int value = fl_sort_dir(a, b);
	
	if (value == 0)
	
    return fl_datesort(a, b);
		
	else
	
	  return value; 
  
}


/**************************************************************************
* Funzione di confronto per l'ordinamento per permission, prima le directory
****************************************************************************/

int fl_dirmodesort(struct dirent **a, struct dirent **b) {

  int value = fl_sort_dir(a, b);
	
	if (value == 0)
	
    return fl_modesort(a, b);
		
	else
	
	  return value;

}


/**************************************************************************
* Funzione di confronto per l'ordinamento per user, prima le directory
****************************************************************************/

int fl_dirusersort(struct dirent **a, struct dirent **b) {

  int value = fl_sort_dir(a, b);
	
	if (value == 0)
	
    return fl_usersort(a, b);
		
	else
	
	  return value;

}


/**************************************************************************
* Funzione di confronto per l'ordinamento per group, prima le directory
****************************************************************************/

int fl_dirgroupsort(struct dirent **a, struct dirent **b) {

  int value = fl_sort_dir(a, b);
	
	if (value == 0)
	
    return fl_groupsort(a, b);
		
	else
	
	  return value;

}


/**************************************************************************
* Funzione di confronto per l'ordinamento inverso per nome case sensitive, prima le directory
****************************************************************************/

int fl_dirinvalphasort(struct dirent **a, struct dirent **b) {

  int value = fl_sort_dir(a, b);
	
	if (value == 0)
	
    return fl_alphasort(b, a);
		
	else
	
	  return value;
	  

  
}
  

/**************************************************************************
* Funzione di confronto per l'ordinamento inverso per nome case insensitive, prima le directory
****************************************************************************/

int fl_dirinvcasealphasort(struct dirent **a, struct dirent **b) {

  int value = fl_sort_dir(a, b);
	
	if (value == 0)
	
    return fl_casealphasort(b, a);
		
	else
	
	  return value;  
  
}
  

/**************************************************************************
* Funzione di confronto per l'ordinamento inverso per estensione case sensitive, prima le directory
****************************************************************************/

int fl_dirinvextsort(struct dirent **a, struct dirent **b) {

  int value = fl_sort_dir(a, b);
	
	if (value == 0)
	
    return fl_extsort(b, a);
		
	else
	
	  return value;

}


/**************************************************************************
* Funzione di confronto per l'ordinamento inverso per estensione case insensitive, prima le directory
****************************************************************************/

int fl_dirinvcaseextsort(struct dirent **a, struct dirent **b) {

  int value = fl_sort_dir(a, b);
	
	if (value == 0)
	
    return fl_caseextsort(b, a);
		
	else
	
	  return value;  
  
}


/**************************************************************************
* Funzione di confronto per l'ordinamento inverso per dimensioni, prima le directory
****************************************************************************/

int fl_dirinvsizesort(struct dirent **a, struct dirent **b) {

  int value = fl_sort_dir(a, b);
	
	if (value == 0)
	
    return fl_sizesort(b, a);
		
	else
	
	  return value;	  
  
}


/**************************************************************************
* Funzione di confronto per l'ordinamento inverso per data, prima le directory
****************************************************************************/

int fl_dirinvdatesort(struct dirent **a, struct dirent **b) {

  int value = fl_sort_dir(a, b);
	
	if (value == 0)
	
    return fl_datesort(b, a);
		
	else
	
	  return value;	  
  
}


/**************************************************************************
* Funzione di confronto per l'ordinamento inverso per permission, prima le directory
****************************************************************************/

int fl_dirinvmodesort(struct dirent **a, struct dirent **b) {

  int value = fl_sort_dir(a, b);
	
	if (value == 0)
	
    return fl_modesort(b, a);
		
	else
	
	  return value;

}


/**************************************************************************
* Funzione di confronto per l'ordinamento inverso per user, prima le directory
****************************************************************************/

int fl_dirinvusersort(struct dirent **a, struct dirent **b) {

  int value = fl_sort_dir(a, b);
	
	if (value == 0)
	
    return fl_usersort(b, a);
		
	else
	
	  return value;

}


/**************************************************************************
* Funzione di confronto per l'ordinamento inverso per group, prima le directory
****************************************************************************/

int fl_dirinvgroupsort(struct dirent **a, struct dirent **b) {

  int value = fl_sort_dir(a, b);
	
	if (value == 0)
	
    return fl_groupsort(b, a);
		
	else
	
	  return value;

}
