/* config.c generated by valac 0.16.1, the Vala compiler
 * generated from config.vala, do not modify */

/*

This file is part of Auditive.

Copyright 2010-2012 Graeme Sheppard.

Auditive is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Auditive is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Auditive. If not, see <http://www.gnu.org/licenses/>.

*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define TYPE_WORLD_WIDE (world_wide_get_type ())
#define WORLD_WIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORLD_WIDE, world_wide))
#define WORLD_WIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORLD_WIDE, world_wideClass))
#define IS_WORLD_WIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORLD_WIDE))
#define IS_WORLD_WIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORLD_WIDE))
#define WORLD_WIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORLD_WIDE, world_wideClass))

typedef struct _world_wide world_wide;
typedef struct _world_wideClass world_wideClass;
typedef struct _world_widePrivate world_widePrivate;

#define TYPE_CONSOLE (console_get_type ())
#define CONSOLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONSOLE, console))
#define CONSOLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONSOLE, consoleClass))
#define IS_CONSOLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONSOLE))
#define IS_CONSOLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONSOLE))
#define CONSOLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONSOLE, consoleClass))

typedef struct _console console;
typedef struct _consoleClass consoleClass;

#define TYPE_KEY_MAPS (key_maps_get_type ())
#define KEY_MAPS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY_MAPS, key_maps))
#define KEY_MAPS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY_MAPS, key_mapsClass))
#define IS_KEY_MAPS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY_MAPS))
#define IS_KEY_MAPS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY_MAPS))
#define KEY_MAPS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY_MAPS, key_mapsClass))

typedef struct _key_maps key_maps;
typedef struct _key_mapsClass key_mapsClass;

#define TYPE_AUDITIVE (auditive_get_type ())
#define AUDITIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUDITIVE, auditive))
#define AUDITIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AUDITIVE, auditiveClass))
#define IS_AUDITIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUDITIVE))
#define IS_AUDITIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AUDITIVE))
#define AUDITIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AUDITIVE, auditiveClass))

typedef struct _auditive auditive;
typedef struct _auditiveClass auditiveClass;

#define TYPE_SCREEN (screen_get_type ())
#define SCREEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCREEN, screen))
#define SCREEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCREEN, screenClass))
#define IS_SCREEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCREEN))
#define IS_SCREEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCREEN))
#define SCREEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCREEN, screenClass))

typedef struct _screen screen;
typedef struct _screenClass screenClass;

#define TYPE_PLAYLIST (playlist_get_type ())
#define PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYLIST, playlist))
#define PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYLIST, playlistClass))
#define IS_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYLIST))
#define IS_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYLIST))
#define PLAYLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYLIST, playlistClass))

typedef struct _playlist playlist;
typedef struct _playlistClass playlistClass;

#define TYPE_VIEWLIST (viewlist_get_type ())
#define VIEWLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEWLIST, viewlist))
#define VIEWLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEWLIST, viewlistClass))
#define IS_VIEWLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEWLIST))
#define IS_VIEWLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEWLIST))
#define VIEWLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEWLIST, viewlistClass))

typedef struct _viewlist viewlist;
typedef struct _viewlistClass viewlistClass;

#define TYPE_EXTERNAL (external_get_type ())
#define EXTERNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXTERNAL, external))
#define EXTERNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXTERNAL, externalClass))
#define IS_EXTERNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXTERNAL))
#define IS_EXTERNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXTERNAL))
#define EXTERNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXTERNAL, externalClass))

typedef struct _external external;
typedef struct _externalClass externalClass;

#define TYPE_DBG (dbg_get_type ())
#define DBG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DBG, dbg))
#define DBG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DBG, dbgClass))
#define IS_DBG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DBG))
#define IS_DBG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DBG))
#define DBG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DBG, dbgClass))

typedef struct _dbg dbg;
typedef struct _dbgClass dbgClass;

#define TYPE_HELP (help_get_type ())
#define HELP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HELP, help))
#define HELP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HELP, helpClass))
#define IS_HELP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HELP))
#define IS_HELP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HELP))
#define HELP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HELP, helpClass))

typedef struct _help help;
typedef struct _helpClass helpClass;

#define TYPE_FILES (files_get_type ())
#define FILES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILES, files))
#define FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILES, filesClass))
#define IS_FILES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILES))
#define IS_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILES))
#define FILES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILES, filesClass))

typedef struct _files files;
typedef struct _filesClass filesClass;

#define TYPE_METHOD (method_get_type ())
#define METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METHOD, method))
#define METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METHOD, methodClass))
#define IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METHOD))
#define IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METHOD))
#define METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METHOD, methodClass))

typedef struct _method method;
typedef struct _methodClass methodClass;

#define WORLD_WIDE_TYPE_SCREEN_TYPE (world_wide_screen_type_get_type ())

#define WORLD_WIDE_TYPE_PLAYING_TYPE (world_wide_playing_type_get_type ())
#define __g_list_free__method_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__method_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	WORLD_WIDE_SCREEN_TYPE_none,
	WORLD_WIDE_SCREEN_TYPE_file_list,
	WORLD_WIDE_SCREEN_TYPE_view_list,
	WORLD_WIDE_SCREEN_TYPE_play_list,
	WORLD_WIDE_SCREEN_TYPE_ext_list,
	WORLD_WIDE_SCREEN_TYPE_debug,
	WORLD_WIDE_SCREEN_TYPE_help
} world_widescreen_type;

typedef enum  {
	WORLD_WIDE_PLAYING_TYPE_stop,
	WORLD_WIDE_PLAYING_TYPE_play,
	WORLD_WIDE_PLAYING_TYPE_pause
} world_wideplaying_type;

struct _world_wide {
	GTypeInstance parent_instance;
	volatile int ref_count;
	world_widePrivate * priv;
	console* con;
	key_maps* keys;
	auditive* player;
	playlist* play_screen;
	viewlist* view_screen;
	external* ext_screen;
	dbg* debug;
	help* help_screen;
	GList* files_array;
	GList* keys_array;
	world_widescreen_type screen_current;
	world_wideplaying_type playing_state;
	gint screen_files;
	gboolean play_advance;
	screen* playing_screen;
	gint playlist_position;
};

struct _world_wideClass {
	GTypeClass parent_class;
	void (*finalize) (world_wide *self);
};



gpointer world_wide_ref (gpointer instance);
void world_wide_unref (gpointer instance);
GParamSpec* param_spec_world_wide (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_world_wide (GValue* value, gpointer v_object);
void value_take_world_wide (GValue* value, gpointer v_object);
gpointer value_get_world_wide (const GValue* value);
GType world_wide_get_type (void) G_GNUC_CONST;
void config_setup (world_wide* world);
gpointer console_ref (gpointer instance);
void console_unref (gpointer instance);
GParamSpec* param_spec_console (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_console (GValue* value, gpointer v_object);
void value_take_console (GValue* value, gpointer v_object);
gpointer value_get_console (const GValue* value);
GType console_get_type (void) G_GNUC_CONST;
gpointer key_maps_ref (gpointer instance);
void key_maps_unref (gpointer instance);
GParamSpec* param_spec_key_maps (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_key_maps (GValue* value, gpointer v_object);
void value_take_key_maps (GValue* value, gpointer v_object);
gpointer value_get_key_maps (const GValue* value);
GType key_maps_get_type (void) G_GNUC_CONST;
gpointer auditive_ref (gpointer instance);
void auditive_unref (gpointer instance);
GParamSpec* param_spec_auditive (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_auditive (GValue* value, gpointer v_object);
void value_take_auditive (GValue* value, gpointer v_object);
gpointer value_get_auditive (const GValue* value);
GType auditive_get_type (void) G_GNUC_CONST;
gpointer screen_ref (gpointer instance);
void screen_unref (gpointer instance);
GParamSpec* param_spec_screen (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_screen (GValue* value, gpointer v_object);
void value_take_screen (GValue* value, gpointer v_object);
gpointer value_get_screen (const GValue* value);
GType screen_get_type (void) G_GNUC_CONST;
GType playlist_get_type (void) G_GNUC_CONST;
GType viewlist_get_type (void) G_GNUC_CONST;
GType external_get_type (void) G_GNUC_CONST;
GType dbg_get_type (void) G_GNUC_CONST;
GType help_get_type (void) G_GNUC_CONST;
GType files_get_type (void) G_GNUC_CONST;
gpointer method_ref (gpointer instance);
void method_unref (gpointer instance);
GParamSpec* param_spec_method (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_method (GValue* value, gpointer v_object);
void value_take_method (GValue* value, gpointer v_object);
gpointer value_get_method (const GValue* value);
GType method_get_type (void) G_GNUC_CONST;
GType world_wide_screen_type_get_type (void) G_GNUC_CONST;
GType world_wide_playing_type_get_type (void) G_GNUC_CONST;
static void _method_unref0_ (gpointer var);
static void _g_list_free__method_unref0_ (GList* self);
void dbg_add (dbg* self, const gchar* text);
gint console_lookup_key (console* self, gint key_num);
method* method_new (gint k, const gchar* n, const gchar* c);
method* method_construct (GType object_type, gint k, const gchar* n, const gchar* c);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _method_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (method_unref (var), NULL));
}


static void _g_list_free__method_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _method_unref0_, NULL);
	g_list_free (self);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


void config_setup (world_wide* world) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* cfg_file;
	world_wide* _tmp2_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_strconcat (_tmp0_, "/.auditive", NULL);
	cfg_file = _tmp1_;
	_tmp2_ = world;
	__g_list_free__method_unref0_0 (_tmp2_->keys_array);
	_tmp2_->keys_array = NULL;
	{
		gchar* line = NULL;
		gchar* line_start = NULL;
		const gchar* _tmp3_;
		GFile* _tmp4_ = NULL;
		GFile* file;
		GFile* _tmp5_;
		gboolean _tmp6_ = FALSE;
		world_wide* _tmp12_;
		dbg* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GFile* _tmp17_;
		GFileInputStream* _tmp18_ = NULL;
		GFileInputStream* _tmp19_;
		GFileInputStream* _tmp20_;
		GDataInputStream* _tmp21_;
		GDataInputStream* _tmp22_;
		GDataInputStream* in_stream;
		gint count;
		gboolean good = FALSE;
		_tmp3_ = cfg_file;
		_tmp4_ = g_file_new_for_path (_tmp3_);
		file = _tmp4_;
		_tmp5_ = file;
		_tmp6_ = g_file_query_exists (_tmp5_, NULL);
		if (!_tmp6_) {
			world_wide* _tmp7_;
			dbg* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp7_ = world;
			_tmp8_ = _tmp7_->debug;
			_tmp9_ = cfg_file;
			_tmp10_ = g_strconcat ("aside notice: no cfg ", _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			dbg_add (_tmp8_, _tmp11_);
			_g_free0 (_tmp11_);
			_g_object_unref0 (file);
			_g_free0 (line_start);
			_g_free0 (line);
			_g_free0 (cfg_file);
			return;
		}
		_tmp12_ = world;
		_tmp13_ = _tmp12_->debug;
		_tmp14_ = cfg_file;
		_tmp15_ = g_strconcat ("reading ", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		dbg_add (_tmp13_, _tmp16_);
		_g_free0 (_tmp16_);
		_tmp17_ = file;
		_tmp18_ = g_file_read (_tmp17_, NULL, &_inner_error_);
		_tmp19_ = _tmp18_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file);
			_g_free0 (line_start);
			_g_free0 (line);
			goto __catch0_g_error;
		}
		_tmp20_ = _tmp19_;
		_tmp21_ = g_data_input_stream_new ((GInputStream*) _tmp20_);
		_tmp22_ = _tmp21_;
		_g_object_unref0 (_tmp20_);
		in_stream = _tmp22_;
		count = 0;
		while (TRUE) {
			GDataInputStream* _tmp23_;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_;
			const gchar* _tmp26_;
			gint _tmp27_;
			gboolean _tmp28_ = FALSE;
			const gchar* _tmp29_;
			gboolean _tmp32_;
			gboolean empty;
			gboolean _tmp48_;
			gboolean _tmp109_;
			_tmp23_ = in_stream;
			_tmp24_ = g_data_input_stream_read_line (_tmp23_, NULL, NULL, &_inner_error_);
			_tmp25_ = _tmp24_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (in_stream);
				_g_object_unref0 (file);
				_g_free0 (line_start);
				_g_free0 (line);
				goto __catch0_g_error;
			}
			_g_free0 (line);
			line = _tmp25_;
			_tmp26_ = line;
			if (!(_tmp26_ != NULL)) {
				break;
			}
			_tmp27_ = count;
			count = _tmp27_ + 1;
			_tmp29_ = line;
			if (g_strcmp0 (_tmp29_, "") == 0) {
				_tmp28_ = TRUE;
			} else {
				const gchar* _tmp30_;
				gchar _tmp31_ = '\0';
				_tmp30_ = line;
				_tmp31_ = string_get (_tmp30_, (glong) 0);
				_tmp28_ = _tmp31_ == '#';
			}
			_tmp32_ = _tmp28_;
			if (_tmp32_) {
				continue;
			}
			empty = TRUE;
			{
				gint index;
				index = 0;
				{
					gboolean _tmp33_;
					_tmp33_ = TRUE;
					while (TRUE) {
						gboolean _tmp34_;
						gint _tmp36_;
						const gchar* _tmp37_;
						gint _tmp38_;
						gint _tmp39_;
						gboolean _tmp40_ = FALSE;
						const gchar* _tmp41_;
						gint _tmp42_;
						gchar _tmp43_ = '\0';
						gboolean _tmp47_;
						_tmp34_ = _tmp33_;
						if (!_tmp34_) {
							gint _tmp35_;
							_tmp35_ = index;
							index = _tmp35_ + 1;
						}
						_tmp33_ = FALSE;
						_tmp36_ = index;
						_tmp37_ = line;
						_tmp38_ = strlen (_tmp37_);
						_tmp39_ = _tmp38_;
						if (!(_tmp36_ < _tmp39_)) {
							break;
						}
						_tmp41_ = line;
						_tmp42_ = index;
						_tmp43_ = string_get (_tmp41_, (glong) _tmp42_);
						if (_tmp43_ != ' ') {
							const gchar* _tmp44_;
							gint _tmp45_;
							gchar _tmp46_ = '\0';
							_tmp44_ = line;
							_tmp45_ = index;
							_tmp46_ = string_get (_tmp44_, (glong) _tmp45_);
							_tmp40_ = _tmp46_ != '\t';
						} else {
							_tmp40_ = FALSE;
						}
						_tmp47_ = _tmp40_;
						if (_tmp47_) {
							empty = FALSE;
							break;
						}
					}
				}
			}
			_tmp48_ = empty;
			if (_tmp48_) {
				continue;
			}
			good = FALSE;
			while (TRUE) {
				const gchar* _tmp49_;
				const gchar* _tmp51_;
				const gchar* _tmp53_;
				gchar* _tmp54_ = NULL;
				gboolean _tmp55_ = FALSE;
				const gchar* _tmp56_;
				gboolean _tmp58_;
				const gchar* _tmp59_;
				gchar* _tmp60_ = NULL;
				gchar* _tmp61_;
				gchar** _tmp62_;
				gchar** _tmp63_ = NULL;
				gchar** _tmp64_;
				gint _tmp64__length1;
				gchar** bits;
				gint bits_length1;
				gint _bits_size_;
				gchar** _tmp65_;
				gint _tmp65__length1;
				gboolean _tmp66_ = FALSE;
				gchar** _tmp67_;
				gint _tmp67__length1;
				const gchar* _tmp68_;
				gboolean _tmp71_;
				gint keystroke = 0;
				gchar** _tmp72_;
				gint _tmp72__length1;
				const gchar* _tmp73_;
				world_wide* _tmp93_;
				console* _tmp94_;
				gint _tmp95_;
				gint _tmp96_ = 0;
				world_wide* _tmp102_;
				gint _tmp103_;
				gchar** _tmp104_;
				gint _tmp104__length1;
				const gchar* _tmp105_;
				gchar** _tmp106_;
				gint _tmp106__length1;
				const gchar* _tmp107_;
				method* _tmp108_;
				_tmp49_ = line;
				if (g_strcmp0 (_tmp49_, "advance=y") == 0) {
					world_wide* _tmp50_;
					_tmp50_ = world;
					_tmp50_->play_advance = TRUE;
					good = TRUE;
					break;
				}
				_tmp51_ = line;
				if (g_strcmp0 (_tmp51_, "advance=n") == 0) {
					world_wide* _tmp52_;
					_tmp52_ = world;
					_tmp52_->play_advance = FALSE;
					good = TRUE;
					break;
				}
				_tmp53_ = line;
				_tmp54_ = string_slice (_tmp53_, (glong) 0, (glong) 4);
				_g_free0 (line_start);
				line_start = _tmp54_;
				_tmp56_ = line_start;
				if (g_strcmp0 (_tmp56_, "ext=") == 0) {
					_tmp55_ = TRUE;
				} else {
					const gchar* _tmp57_;
					_tmp57_ = line_start;
					_tmp55_ = g_strcmp0 (_tmp57_, "key=") == 0;
				}
				_tmp58_ = _tmp55_;
				if (!_tmp58_) {
					break;
				}
				_tmp59_ = line;
				_tmp60_ = string_substring (_tmp59_, (glong) 4, (glong) (-1));
				_tmp61_ = _tmp60_;
				_tmp63_ = _tmp62_ = g_strsplit (_tmp61_, ",", 3);
				_tmp64_ = _tmp63_;
				_tmp64__length1 = _vala_array_length (_tmp62_);
				_g_free0 (_tmp61_);
				bits = _tmp64_;
				bits_length1 = _tmp64__length1;
				_bits_size_ = bits_length1;
				_tmp65_ = bits;
				_tmp65__length1 = bits_length1;
				if (_tmp65__length1 != 3) {
					bits = (_vala_array_free (bits, bits_length1, (GDestroyNotify) g_free), NULL);
					break;
				}
				_tmp67_ = bits;
				_tmp67__length1 = bits_length1;
				_tmp68_ = _tmp67_[1];
				if (g_strcmp0 (_tmp68_, "") == 0) {
					_tmp66_ = TRUE;
				} else {
					gchar** _tmp69_;
					gint _tmp69__length1;
					const gchar* _tmp70_;
					_tmp69_ = bits;
					_tmp69__length1 = bits_length1;
					_tmp70_ = _tmp69_[2];
					_tmp66_ = g_strcmp0 (_tmp70_, "") == 0;
				}
				_tmp71_ = _tmp66_;
				if (_tmp71_) {
					bits = (_vala_array_free (bits, bits_length1, (GDestroyNotify) g_free), NULL);
					break;
				}
				_tmp72_ = bits;
				_tmp72__length1 = bits_length1;
				_tmp73_ = _tmp72_[0];
				if (g_strcmp0 (_tmp73_, "") == 0) {
					keystroke = 0;
				} else {
					gchar** _tmp74_;
					gint _tmp74__length1;
					const gchar* _tmp75_;
					gchar _tmp76_ = '\0';
					_tmp74_ = bits;
					_tmp74__length1 = bits_length1;
					_tmp75_ = _tmp74_[0];
					_tmp76_ = string_get (_tmp75_, (glong) 0);
					if (_tmp76_ == '"') {
						gboolean _tmp77_ = FALSE;
						gchar** _tmp78_;
						gint _tmp78__length1;
						const gchar* _tmp79_;
						gint _tmp80_;
						gint _tmp81_;
						gboolean _tmp85_;
						gchar** _tmp86_;
						gint _tmp86__length1;
						const gchar* _tmp87_;
						gchar _tmp88_ = '\0';
						_tmp78_ = bits;
						_tmp78__length1 = bits_length1;
						_tmp79_ = _tmp78_[0];
						_tmp80_ = strlen (_tmp79_);
						_tmp81_ = _tmp80_;
						if (_tmp81_ != 3) {
							_tmp77_ = TRUE;
						} else {
							gchar** _tmp82_;
							gint _tmp82__length1;
							const gchar* _tmp83_;
							gchar _tmp84_ = '\0';
							_tmp82_ = bits;
							_tmp82__length1 = bits_length1;
							_tmp83_ = _tmp82_[0];
							_tmp84_ = string_get (_tmp83_, (glong) 2);
							_tmp77_ = _tmp84_ != '"';
						}
						_tmp85_ = _tmp77_;
						if (_tmp85_) {
							bits = (_vala_array_free (bits, bits_length1, (GDestroyNotify) g_free), NULL);
							break;
						}
						_tmp86_ = bits;
						_tmp86__length1 = bits_length1;
						_tmp87_ = _tmp86_[0];
						_tmp88_ = string_get (_tmp87_, (glong) 1);
						keystroke = (gint) ((gchar) _tmp88_);
					} else {
						gchar** _tmp89_;
						gint _tmp89__length1;
						const gchar* _tmp90_;
						gint _tmp91_ = 0;
						gint _tmp92_;
						_tmp89_ = bits;
						_tmp89__length1 = bits_length1;
						_tmp90_ = _tmp89_[0];
						_tmp91_ = atoi (_tmp90_);
						keystroke = _tmp91_;
						_tmp92_ = keystroke;
						if (_tmp92_ == 0) {
							bits = (_vala_array_free (bits, bits_length1, (GDestroyNotify) g_free), NULL);
							break;
						}
					}
				}
				_tmp93_ = world;
				_tmp94_ = _tmp93_->con;
				_tmp95_ = keystroke;
				_tmp96_ = console_lookup_key (_tmp94_, _tmp95_);
				if (_tmp96_ >= 0) {
					world_wide* _tmp97_;
					dbg* _tmp98_;
					gint _tmp99_;
					gchar* _tmp100_ = NULL;
					gchar* _tmp101_;
					_tmp97_ = world;
					_tmp98_ = _tmp97_->debug;
					_tmp99_ = keystroke;
					_tmp100_ = g_strdup_printf ("an entry already exists for key: %c", _tmp99_);
					_tmp101_ = _tmp100_;
					dbg_add (_tmp98_, _tmp101_);
					_g_free0 (_tmp101_);
					bits = (_vala_array_free (bits, bits_length1, (GDestroyNotify) g_free), NULL);
					break;
				}
				_tmp102_ = world;
				_tmp103_ = keystroke;
				_tmp104_ = bits;
				_tmp104__length1 = bits_length1;
				_tmp105_ = _tmp104_[1];
				_tmp106_ = bits;
				_tmp106__length1 = bits_length1;
				_tmp107_ = _tmp106_[2];
				_tmp108_ = method_new (_tmp103_, _tmp105_, _tmp107_);
				_tmp102_->keys_array = g_list_append (_tmp102_->keys_array, _tmp108_);
				good = TRUE;
				bits = (_vala_array_free (bits, bits_length1, (GDestroyNotify) g_free), NULL);
				break;
			}
			_tmp109_ = good;
			if (!_tmp109_) {
				world_wide* _tmp110_;
				dbg* _tmp111_;
				gint _tmp112_;
				gchar* _tmp113_ = NULL;
				gchar* _tmp114_;
				gchar* _tmp115_;
				gchar* _tmp116_;
				world_wide* _tmp117_;
				dbg* _tmp118_;
				gint _tmp119_;
				gchar* _tmp120_ = NULL;
				gchar* _tmp121_;
				gchar* _tmp122_;
				gchar* _tmp123_;
				const gchar* _tmp124_;
				gchar* _tmp125_;
				gchar* _tmp126_;
				_tmp110_ = world;
				_tmp111_ = _tmp110_->debug;
				_tmp112_ = count;
				_tmp113_ = g_strdup_printf ("%i", _tmp112_);
				_tmp114_ = _tmp113_;
				_tmp115_ = g_strconcat ("bad cfg at line ", _tmp114_, NULL);
				_tmp116_ = _tmp115_;
				dbg_add (_tmp111_, _tmp116_);
				_g_free0 (_tmp116_);
				_g_free0 (_tmp114_);
				_tmp117_ = world;
				_tmp118_ = _tmp117_->debug;
				_tmp119_ = count;
				_tmp120_ = g_strdup_printf ("%i", _tmp119_);
				_tmp121_ = _tmp120_;
				_tmp122_ = g_strconcat (_tmp121_, ": ", NULL);
				_tmp123_ = _tmp122_;
				_tmp124_ = line;
				_tmp125_ = g_strconcat (_tmp123_, _tmp124_, NULL);
				_tmp126_ = _tmp125_;
				dbg_add (_tmp118_, _tmp126_);
				_g_free0 (_tmp126_);
				_g_free0 (_tmp123_);
				_g_free0 (_tmp121_);
			}
		}
		_g_object_unref0 (in_stream);
		_g_object_unref0 (file);
		_g_free0 (line_start);
		_g_free0 (line);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		world_wide* _tmp127_;
		dbg* _tmp128_;
		const gchar* _tmp129_;
		gchar* _tmp130_;
		gchar* _tmp131_;
		GError* _tmp132_;
		const gchar* _tmp133_;
		gchar* _tmp134_;
		gchar* _tmp135_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp127_ = world;
		_tmp128_ = _tmp127_->debug;
		_tmp129_ = cfg_file;
		_tmp130_ = g_strconcat (_tmp129_, ": ", NULL);
		_tmp131_ = _tmp130_;
		_tmp132_ = err;
		_tmp133_ = _tmp132_->message;
		_tmp134_ = g_strconcat (_tmp131_, _tmp133_, NULL);
		_tmp135_ = _tmp134_;
		dbg_add (_tmp128_, _tmp135_);
		_g_free0 (_tmp135_);
		_g_free0 (_tmp131_);
		_g_error_free0 (err);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_free0 (cfg_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (cfg_file);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



