#ifndef __SGMIXER_H__
#define __SGMIXER_H__
/* 
 *  sgmixer.h - part from sGmixer
 *
 *  sGmixer - simple GTK2 audio mixer by mironcho
 *  (c) Miroslav Yordanov 2003  <miordanov@i-space.org>
 *				<mironcholinux@mail.bg>
 *
 *  Thanks to Robert Homann for his patch.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.*
 */

#include "about.h"

#define MIXER		"/dev/mixer"
#define CONF_FILE	"/.sgmixer"
#define POLL_INTERVALL	1000


gint get_mixer_param( gint mdev );

void set_mixer_param( gint mdev, 
		gint val );

void set_new_param( GtkWidget *widget, 
		gpointer data );

void mute_all( GtkWidget *widget, 
		gpointer data );

void mute_only( GtkWidget *widget,
		gpointer data );

gboolean save_to_file( void );

gboolean load_from_file( void );

static void set_adjustment_and_value(gint i);

static gboolean read_mixer_channels(gpointer data);

static void usage(const char *progname);


#endif  //  __SGMIXER_H__
