/* 
 *  about.c - part from sGmixer
 *
 *  sGmixer - simple GTK2 audio mixer by mironcho
 *  (c) Miroslav Yordanov 2003  <miordanov@i-space.org>
 *				<mironcholinux@mail.bg>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.*
 */

#include <gtk/gtk.h>
#include "about.h"
#include "version.h"


void about_dialog( GtkWidget *widget,
		gpointer data ) 
{
	GtkWidget *dlg, *lbl, *btn; // shortly from dialog, label and button
	GString *str;

	str = g_string_new ("");
	g_string_sprintf ( str,
			"\n\t\t  %s %s \t\n\n" \
			"\t  simple GTK2 audio mixer  \t\n\n" \
			"\tauthor: Miroslav Yordanov  \n" \
			"\t  miordanov@i-space.org  \n",
			PROGNAME, PROGVERSION );


	dlg = gtk_dialog_new ();

	btn = gtk_button_new_with_label ("Close");
	g_signal_connect ( G_OBJECT (btn), "clicked", 
			G_CALLBACK (destroy_dlg),
			GTK_WIDGET (dlg) );
	gtk_box_pack_start_defaults ( GTK_BOX (GTK_DIALOG (dlg)->action_area), btn);
	gtk_widget_show ( btn );

	lbl = gtk_label_new ( str->str );
	gtk_box_pack_start_defaults ( GTK_BOX (GTK_DIALOG (dlg)->vbox), lbl);
	gtk_widget_show ( lbl );

	gtk_widget_show ( dlg );
}


void destroy_dlg( GtkWidget *widget,
		gpointer data )
{
	gtk_widget_destroy ( data );
}
