/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "xmlstuff.h"

#include "glade_support.h"
#include "main.h"

#include <string.h>

void close_xml_tag(GtkTextBuffer *buffer, GtkWidget *text_view)
{
    GtkTextMark *insert_mark;
    GtkTextIter iter, old_iter;
    enum my_mode_t { normal_mode, quot_mode, apos_mode } mode;
    gboolean was_greater = FALSE, was_empty_tag_or_comment = FALSE;
    gboolean is_less = FALSE, is_greater = FALSE, is_close_tag = FALSE;
    GSList *tags_list = NULL;

    insert_mark = gtk_text_buffer_get_insert(buffer);
    gtk_text_buffer_get_iter_at_mark(buffer, &iter, insert_mark);
    mode = normal_mode;
    for(;;) {
        gchar *symb;

        old_iter = iter;
        if(!gtk_text_iter_backward_char(&iter)) {
            alarm_message(my_gtk_widget_get_toplevel(text_view),
                          _("No open tag!"));
            break;
        }
        symb = gtk_text_iter_get_text(&iter, &old_iter);
        if(tags_list) {
            gboolean is_quot, is_apos;

            is_quot = !strcmp(symb, N_("\""));
            is_apos = !strcmp(symb, N_("'"));
            switch(mode) {
                case quot_mode:
                    if(is_quot) mode = normal_mode;
                    g_free(symb);
                    continue;
                case apos_mode:
                    if(is_apos) mode = normal_mode;
                    g_free(symb);
                    continue;
                case normal_mode:
                    if(is_quot)
                        mode = quot_mode;
                    else if(is_apos)
                        mode = apos_mode;
                    break;
            }
        }
        /* is_greater from the previous loop iteration */
        if(is_greater && (!strcmp(symb, N_("/")) || !strcmp(symb, N_("-"))))
            was_empty_tag_or_comment = TRUE;
        /* TODO: a better way to check with comment to not miss with silly <a href=-> */
        is_less    = !strcmp(symb, N_("<"));
        is_greater = !strcmp(symb, N_(">"));
        if(is_greater) {
            if(was_greater) {
                alarm_message(my_gtk_widget_get_toplevel(text_view),
                              _("Wrong tag!"));
                break;
            } else
                was_greater = TRUE;
        }
        g_free(symb);
        if(is_less && was_empty_tag_or_comment)
            was_greater = was_empty_tag_or_comment = FALSE;
        else if(is_less && !was_empty_tag_or_comment) {
            gchar *name, *new_name;
            gunichar uc;
            GtkTextIter name_iter;

            name_iter = iter;
            name = g_malloc(1);
            *name = N_('\0');
            (void)gtk_text_iter_forward_char(&name_iter);
            is_close_tag = FALSE;
            for(;;) {
                old_iter = name_iter;
                if(!gtk_text_iter_forward_char(&name_iter)) break;
                symb = gtk_text_iter_get_text(&old_iter, &name_iter);
                uc = g_utf8_get_char(symb);
                /* TODO: missing combining chars and extenders (see XML spec) */
                if(!*name && uc == N_('/'))
                    is_close_tag = TRUE;
                else if(g_unichar_isalnum(uc) ||
                        uc == N_('_') || uc == N_(':') || uc == N_('.') || uc == N_('-'))
                {
                    new_name = g_strconcat(name, symb, NULL);
                    g_free(name);
                    g_free(symb);
                    name = new_name;
                } else {
                    g_free(symb);
                    break;
                }
            }
            if(!was_greater)
                alarm_message(my_gtk_widget_get_toplevel(text_view),
                              _("Tag not closed!"));
            else if(!strlen(name))
                alarm_message(my_gtk_widget_get_toplevel(text_view),
                              _("No open tag!"));
            else {
                was_greater = FALSE; /* done with this tag */
                was_empty_tag_or_comment = FALSE;
                if(is_close_tag) {
                    tags_list = g_slist_prepend(tags_list, name);
                    name = NULL;
                    continue;
                } else {
                    if(tags_list && !strcmp(name, tags_list->data)) {
                        g_free(tags_list->data);
                        tags_list = g_slist_delete_link(tags_list, tags_list);
                        continue;
                    } else {
                        gchar *close_str;

                        close_str = g_strconcat(N_("</"), name, N_(">"), NULL);
                        gtk_text_buffer_insert_interactive_at_cursor(buffer, close_str, -1,
                            gtk_text_view_get_editable(GTK_TEXT_VIEW(text_view)));
                        g_free(close_str);
                    }
                }
            }
            g_free(name);
            break;
        }
    }
    /* block */ {
        GSList *elem = tags_list;

        while(elem) {
            g_free(elem->data);
            elem = g_slist_next(elem);
        }
    }
    g_slist_free(tags_list);
}
