/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef SEARCH_H_
#define SEARCH_H_

#include <string.h>
#include <gtk/gtk.h>

typedef struct SearchData_
{
    const gchar *str, *replacement;
    guint str_len, replacement_len;
    GtkWidget *find_dialog, *replace_dialog;
    GtkWidget *window, *text_view;
    gboolean case_sensitive :1, whole_word :1, backward :1;
} SearchData;

void initialize_search(SearchData *search_data, GtkWidget *text_view);
void destroy_search   (SearchData *search_data);

typedef gboolean (*find_predicate_t)(GtkTextIter *start,
                                     GtkTextIter *end,
                                     void *data);

gboolean simple_find_predicate(GtkTextIter *start,
                               GtkTextIter *end,
                               void *data);

gboolean find_text(GtkTextIter *iter,
                   GtkTextIter *end,
                   find_predicate_t predicate,
                   void *data);

int replace_all(find_predicate_t predicate,
                gboolean in_sel_only,
                void *data);

void accomplish_find   (SearchData *search_data);
void accomplish_replace(SearchData *search_data);
void accomplish_replace_all(SearchData *search_data,
                            gboolean in_sel_only);

void call_find_dialog(SearchData *search_data);

void call_replace_dialog(SearchData *search_data);

void find_next(SearchData *search_data);

#endif /* SEARCH_H_ */
