/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef PREFS_H_
#define PREFS_H_

#include <glib-2.0/glib.h>

#include "inisettings.h"

IniSettingsFile *main_ini_file;

void preferences_init(void);

/*void preferences_reload(void);*/

gboolean preferences_get_boolean(const gchar *name);
void     preferences_set_boolean(const gchar *name, gboolean value);

gboolean preferences_get_is_first_run(void);
void     preferences_set_is_first_run(gboolean value);

gboolean preferences_get_autoindent(void);

void   preferences_history_add(const gchar *file_name, gpointer format_str);
gint   preferences_history_count(void);
gchar *preferences_history_get(int i);
gchar *preferences_history_get_format(int i);

#ifdef LIMITED_VERSION
gchar *preferences_get_user_name(void);
gint preferences_get_user_code(void);
#endif /* LIMITED_VERSION */

#endif /* PREFS_H_ */
