/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under NU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef MAINWIN_H_
#define MAINWIN_H_

#include <gtk/gtk.h>

#include "document.h"
#include "textstore.h"
#include "textundo.h"
#include "search.h"

typedef struct MainwinData_
{
    GtkWidget *mainwin;

    GtkTextBuffer *thebuffer;
    TextUndoData *undo_data;

    GtkWidget *thetext;
    GtkWidget *statusbar, *modified_label, *coord_label, *encoding_label;
    GtkWidget *title_label, *title_label_box, *title_ellipses, *title_event_box;

    /*GtkWidget *file_menu;*/
    GtkWidget *copy_button, *cut_button;
    GtkMenuItem *before_history_item, *after_history_item,
                *make_uppercase_menu_item, *make_lowercase_menu_item,
                *copy_menu_item, *cut_menu_item,
                *revert_menu_item;
    GtkMenuItem *unlock_menu_item;
    FileDocument *file_document;
    /*TextFileFormat file_format;*/
    guint the_line_height; /* TODO: Should be global (in prefs.c) */
    SearchData search_data;
    
    gulong wrap_text_sig, text_font_sig;
} MainwinData;

extern guint16 mainwin_windows_count;

GtkWidget *mainwin_new(void);
void mainwin_destroy(MainwinData *win_data);

MainwinData *mainwin_get_data(GtkWidget *mainwin);
MainwinData *mainwin_get_data_by_widget(GtkWidget *widget);

void my_text_view_upper_or_lower_case(GtkTextBuffer *buffer, gboolean need_upper);

void my_text_view_scroll_lines(const MainwinData *win_data, gdouble lines);

void mainwin_set_text_font(MainwinData *win_data, PangoFontDescription *font);
void mainwin_set_text_font_by_name(MainwinData *win_data, const gchar *fontname);

void mainwin_goto_line_dialog(const MainwinData *win_data);

gboolean mainwin_ask_encoding(MainwinData *win_data);

void mainwin_insert_file_at_cursor_dialog(MainwinData *win_data);

void mainwin_on_file_menu_open(GtkMenuItem *menuitem);

#endif /* MAINWIN_H_ */
