/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "dnd.h"

#include "config.h"

#include <glib-2.0/glib.h>

#if GETHOSTNAME_IN_UNISTD
#  include <unistd.h>
#else
#  ifdef G_OS_WIN32
#    include <winsock2.h>
#  endif /*  G_OS_WIN32 */
#endif /* GETHOSTNAME_IN_UNISTD */
#include <gtk/gtk.h>

#include "glade_support.h"
#include "main.h"
#include "mainwin.h"

/* Some code borrowed from gtkfilesel.c from GTK+ 2.0.6 distribution. */

enum { TARGET_URILIST };

/* We don't actually try to validate the URI according to RFC
 * 2396, or even check for allowed characters - we just ignore
 * comments and trim whitespace off the ends.  We also
 * allow LF delimination as well as the specified CRLF.
 *
 * We do allow comments like specified in RFC 2483. */
static gchar *uri_list_extract_first_uri(const gchar* uri_list)
{
    const gchar *p, *q;

    g_return_val_if_fail(uri_list != NULL, NULL);
    p = uri_list;
    while(p) {
        if(*p != '#') {
            while (g_ascii_isspace(*p)) p++;
            q = p;
            while(*q && (*q != '\n') && (*q != '\r')) q++;
            if (q>p) {
                q--;
                while (q > p && g_ascii_isspace (*q)) q--;
                if (q > p) return g_strndup (p, q - p + 1);
            }
        }
        p = strchr (p, '\n');
        if(p) p++;
    }
    return NULL;
}

static void filenames_dropped(GtkWidget        *widget,
                              GdkDragContext   *context,
                              gint              x,
                              gint              y,
                              GtkSelectionData *selection_data,
                              guint             info,
                              guint             time)
{
    char *uri = NULL;
    char *hostname;
    int res;
    GError *error = NULL;
    gchar *filename;
    MainwinData *win_data;

    if(!selection_data->data) return;
    uri = uri_list_extract_first_uri((char*)selection_data->data); /* TODO: deal with multiple URIs dropped. */
    if(!uri) return;
    filename = g_filename_from_uri(uri, &hostname, &error);
    g_free(uri);
    if(!filename) {
        g_warning(N_("Error getting dropped filename: %s\n"),
                  error->message);
        g_error_free(error);
        return;
    }

    win_data = mainwin_get_data_by_widget(widget);

#if 0
    /* Conversion back to UTF-8 should always succeed for the result of g_filename_from_uri(). */
    filename = g_filename_to_utf8(filename, -1, NULL, NULL, NULL);
    g_assert(filename);
#endif /* 0 */

    if(!hostname) {
        file_document_do_load_file(win_data->file_document, filename, NULL); /* TODO: Wha should be format here? */
        return;
    } else {
        char this_hostname[257];

        res = gethostname(this_hostname, 256);
        this_hostname[256] = 0;
        if( !res && (!strcmp(hostname, this_hostname) || !strcmp(hostname, N_("localhost"))) )
            file_document_do_load_file(win_data->file_document, filename, NULL); /* TODO: Wha should be format here? */
        else {
            GtkWidget *non_local_dlg;

            non_local_dlg = gtk_message_dialog_new(GTK_WINDOW(widget),
                                                   GTK_DIALOG_DESTROY_WITH_PARENT,
                                                   GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
                                                   _("Cannot open file \"%s\" residing on another machine (called %s)."),
                                                   filename, hostname);
            my_disable_window_resize(GTK_WINDOW(non_local_dlg));
            g_free(filename);
            (void)gtk_dialog_run(GTK_DIALOG(non_local_dlg));
            gtk_widget_destroy(non_local_dlg);
        }
    }

    g_free(hostname);
    g_free(filename);
}

void setup_dnd(GtkWidget *widget)
{
    static GtkTargetEntry drop_types[] = {
        { N_("text/uri-list"), 0, TARGET_URILIST }
    };
    const gint n_drop_types = sizeof(drop_types)/sizeof(drop_types[0]);

    gtk_drag_dest_set(widget,
                      GTK_DEST_DEFAULT_ALL & ~GTK_DEST_DEFAULT_HIGHLIGHT,
                      drop_types, n_drop_types,
                      GDK_ACTION_COPY);
    g_signal_connect(GTK_OBJECT(widget), N_("drag-data-received"),
                     G_CALLBACK(filenames_dropped), NULL);
}
