/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef BIND_PROPS_H_
#define BIND_PROPS_H_

/* Tested only my_glib_bind_properties_ring() (and my_glib_bind_properties_one_way()) */

#include <glib-object.h>

typedef struct MyGLibBindProperties_ {
    GObject    *object;
    const char *property;
} MyGLibBindProperties;

/* Is this needed at all, isn't it superceded by my_glib_bind_properties_ring. */
void my_glib_bind_properties         (GObject              *obj,
                                      const char           *prop,
                                      MyGLibBindProperties data[],
                                      guint                number,
                                      gboolean             strict_validation);

void my_glib_bind_properties_one_way (GObject              *src_obj,
                                      const char           *src_prop,
                                      MyGLibBindProperties  dst_data[],
                                      guint                 dst_number,
                                      gboolean              strict_validation);

void my_glib_bind_properties_ring    (MyGLibBindProperties data[],
                                      guint                number,
                                      gboolean             strict_validation);

void my_glib_bind_properties2        (GObject    *obj1,
                                      const char *prop1,
                                      GObject    *obj2,
                                      const char *prop2,
                                      gboolean    strict_validation);

void my_glib_bind_properties2_one_way(GObject    *src_obj,
                                      const char *src_prop,
                                      GObject    *dst_obj,
                                      const char *dst_prop,
                                      gboolean    strict_validation);

/* TODO: unbind. */

#endif /* BIND_PROPS_H_ */
