/*
** 1998-05-17 -	I just have to build an Opus-look-alike GTK GUI! :)
** 1998-09-11 -	Er, it like, grew, or something.
*/

#include "gentoo.h"

#include <dlfcn.h>
#include <signal.h>
#include <stdlib.h>
#include <time.h>
#include <sys/wait.h>

#include "errors.h"
#include "configure.h"
#include "dirpane.h"
#include "dialog.h"
#include "userinfo.h"
#include "file.h"
#include "fileutil.h"
#include "gfam.h"
#include "xmlutil.h"
#include "strutil.h"
#include "types.h"
#include "styles.h"
#include "sizeutil.h"
#include "buttons.h"
#include "buttonlayout.h"
#include "queue.h"
#include "cmdseq.h"
#include "children.h"
#include "dpformat.h"
#include "mount.h"
#include "keyboard.h"
#include "controls.h"
#include "iconutil.h"
#include "cmdseq_config.h"
#include "menus.h"

#include "odlabel.h"

#include "cfg_module.h"
#include "cfg_windows.h"

#include "graphics/icon_iconify.xpm"

/* ----------------------------------------------------------------------------------------- */

/* 1998-05-18 -	Filter out files the user really doesn't want to see, and that recursive
**		directory traversing code really, really, REALLY, doesn't.
*/
static gboolean dir_filter(const gchar *name)
{
	if((strcmp(name, ".") == 0) || (strcmp(name, "..") == 0))
		return FALSE;
	return TRUE;
}

/* ----------------------------------------------------------------------------------------- */

/* 1998-10-11 -	This is called as GTK+ quits. Very handy. */
static gint quit_handler(gpointer user)
{
	chd_kill_children();

	return TRUE;
}

/* ----------------------------------------------------------------------------------------- */

/* 2000-03-18 -	User clicked close button on window. Just react as if the Quit command was run. */
static gboolean evt_main_delete(GtkWidget *wid, GdkEventAny *evt, gpointer user)
{
	MainInfo	*min = user;

	csq_execute(min, "Quit");

	return TRUE;
}

/* 1998-10-26 -	Initialize some fields in the dp structure. */
static void init_pane(DirPane *dp, gint index)
{
	dp->index = index;
	dp->complete.list = NULL;
	dp->complete.iter = NULL;
	dp->dir.row = NULL;
	dp->dir.row_alloc = 0;
	dp->dir.num_rows  = 0;
	dp->dir.name = NULL;
	dp->dir.name_alloc = 0;
	dp->dir.name_use   = 0;
	dp->dir.stat = NULL;
	dp->dir.stat_alloc = 0;
	dp->dir.stat_use   = 0;
	dp->hist = dph_dirhistory_new();
	dp->dir.path[0] = '\0';
}

static void evt_pane_sizealloc(GtkWidget *wid, GtkAllocation *alloc, gpointer user)
{
	MainInfo	*min = user;
	gint		pos, ww;
	gdouble		old;

	pos = alloc->width;
	gdk_window_get_size(((MainInfo *) user)->gui->window->window, &ww, NULL);
	old = min->cfg.dp_paning.value;
	switch(min->cfg.dp_paning.mode)
	{
		case DPSPLIT_FREE:
			break;
		case DPSPLIT_RATIO:
			min->cfg.dp_paning.value = (gdouble) pos / ww;
			break;
		case DPSPLIT_ABS_LEFT:
			min->cfg.dp_paning.value = pos;
			break;
		case DPSPLIT_ABS_RIGHT:
			min->cfg.dp_paning.value = ww - pos;
			break;
	}
	gtk_signal_handler_block(GTK_OBJECT(min->gui->pane[0].vbox), min->gui->sig_left_sizealloc);
	if(min->cfg.dp_paning.value != old)
		cfg_modified_set(min);
}

/* 2001-08-04 -	Track release of GtkPaned handle, and react according to current mode. */
static gboolean evt_paned_buttonrelease(GtkWidget *wid, GdkEventButton *evt, gpointer user)
{
	if(evt->window == GTK_PANED(wid)->handle)
	{
		MainInfo	*min = user;

		gtk_signal_handler_unblock(GTK_OBJECT(min->gui->pane[0].vbox), min->gui->sig_left_sizealloc);
		return TRUE;
	}
	return FALSE;
}

/* 1998-05-17 -	Build a couple of dir-panes.
** 1998-05-18 -	Now also puts the panes in a horizontally paned window, for extra Opusity. ;^)
** 1998-08-02 -	Fixed *huge* bug where pane 1 (the right) was built using pane 0's format!!
*/
static GtkWidget * build_dirpanes(MainInfo *min)
{
	GtkWidget	*pane;
	GuiInfo		*gui;

	gui = min->gui;

	gui->panes = min->cfg.dp_paning.orientation == DPORIENT_HORIZ ? gtk_hpaned_new() : gtk_vpaned_new();
	gtk_signal_connect(GTK_OBJECT(gui->panes), "button_release_event", GTK_SIGNAL_FUNC(evt_paned_buttonrelease), min);
	init_pane(&gui->pane[0], 0);
	pane = dp_build(min, &min->cfg.dp_format[0], &gui->pane[0]);
	gtk_paned_add1(GTK_PANED(gui->panes), pane);
	init_pane(&gui->pane[1], 1);
	pane = dp_build(min, &min->cfg.dp_format[1], &gui->pane[1]);
	gtk_paned_add2(GTK_PANED(gui->panes), pane);
	gtk_paned_set_handle_size(GTK_PANED(gui->panes), 10);
	gtk_paned_set_gutter_size(GTK_PANED(gui->panes), 10);
	gtk_widget_show(gui->panes);

	return gui->panes;
}

/* 1998-05-19 -	Create the top widgetry, returning something the caller can just add to a box. Sets the
**		<label> pointer to a GtkLabel which can be used later to display funny messages and stuff.
**		The label is internally wrapped in a GtkEventbox, which makes updating it possible without
**		causing instant epilepsy in everyone watching. GTK+ really is smooth.
** 1998-11-26 -	Made the label focusable (?), in order to *finally* have somewhere safe to put the focus
**		when I don't want it on path entry widgets. Nice.
*/
static GtkWidget * build_top(GtkWidget **label)
{
	GtkWidget	*top, *lab, *hbox;

	top = gtk_event_box_new();
	hbox = gtk_hbox_new(FALSE, 0);
	lab = od_label_new("");
	gtk_widget_set_name(lab, "mainStatus");
	GTK_WIDGET_SET_FLAGS(GTK_WIDGET(lab), GTK_CAN_FOCUS);
	gtk_box_pack_start(GTK_BOX(hbox), lab, TRUE, TRUE, 0);
	gtk_container_add(GTK_CONTAINER(top), hbox);
	gtk_widget_show_all(top);
	if(label != NULL)
		*label = lab;
	return top;
}

/* 2002-05-31 -	Rewritten yet again, now using the first weak version of a specialized button layout module. */
static GtkWidget * build_bottom(MainInfo *min)
{
	GtkWidget	*hbox, *sb, *cb;

	if((sb = btn_buttonsheet_build(min, &min->cfg.buttons, "Shortcuts", FALSE, NULL, NULL)) != NULL)
		btn_buttonsheet_built_add_keys(min, GTK_CONTAINER(sb), NULL);
	if((cb = btn_buttonsheet_build(min, &min->cfg.buttons, NULL, FALSE, NULL, min)) != NULL)
		btn_buttonsheet_built_add_keys(min, GTK_CONTAINER(cb), NULL);
	if((hbox = btl_buttonlayout_pack(min->cfg.buttonlayout, cb, sb)) != NULL)
		gtk_widget_show_all(hbox);

	return hbox;
}

/* 1998-10-26 -	Rebuild the middle part of the GUI, i.e. the panes. */
void rebuild_middle(MainInfo *min)
{
	GtkWidget	*left, *right;

	gtk_container_remove(GTK_CONTAINER(min->gui->panes), min->gui->pane[0].vbox);
	gtk_container_remove(GTK_CONTAINER(min->gui->panes), min->gui->pane[1].vbox);
	gtk_widget_destroy(min->gui->panes);
	min->gui->panes = min->cfg.dp_paning.orientation == DPORIENT_HORIZ ? gtk_hpaned_new() : gtk_vpaned_new();
	gtk_box_pack_start(GTK_BOX(min->gui->vbox), min->gui->panes, TRUE, TRUE, 0);
	gtk_box_reorder_child(GTK_BOX(min->gui->vbox), min->gui->panes, 1);
	if((left = dp_build(min, &min->cfg.dp_format[0], &min->gui->pane[0])) != NULL)
	{
		min->gui->sig_left_sizealloc = gtk_signal_connect(GTK_OBJECT(left), "size_allocate", GTK_SIGNAL_FUNC(evt_pane_sizealloc), min);
		gtk_signal_handler_block(GTK_OBJECT(left), min->gui->sig_left_sizealloc);
		gtk_paned_add1(GTK_PANED(min->gui->panes), left);
	}	
	if((right = dp_build(min, &min->cfg.dp_format[1], &min->gui->pane[1])) != NULL)
		gtk_paned_add2(GTK_PANED(min->gui->panes), right);
	gtk_widget_show(min->gui->panes);
}

/* 1998-07-14 -	Rebuild the bottom part of the GUI, whose main responsibility is to contain
**		the button bank(s).
*/
void rebuild_bottom(MainInfo *min)
{
	gtk_widget_destroy(min->gui->bottom);
	min->gui->bottom = build_bottom(min);
	gtk_box_pack_start(GTK_BOX(min->gui->vbox), min->gui->bottom, FALSE, FALSE, 0);
	gtk_widget_show(min->gui->bottom);
}

/* 1999-03-26 -	Set icon for when gentoo gets iconified. Neato.
** 2002-08-10 -	It seems gdk_window_set_icon_name() has problems when the locale gets set to
**		something more interesting than "C". So we work around that.
*/
static void window_set_icon(GtkWidget *win)
{
	GdkPixmap	*pmap;
	GdkBitmap	*bmap;

	if((pmap = gdk_pixmap_create_from_xpm_d(win->window, &bmap, NULL, icon_iconify_xpm)) != NULL)
	{
		const gchar	*op;
		gchar		old[256];

		gdk_window_set_icon(win->window, NULL, pmap, bmap);
#if defined ENABLE_NLS
		if((op = setlocale(LC_ALL, NULL)) != NULL)
		{
			g_snprintf(old, sizeof old, "%s", op);
			setlocale(LC_ALL, "C");
		}
#endif
		gdk_window_set_icon_name(win->window, PACKAGE);
#if defined ENABLE_NLS
		if(op != NULL)
			setlocale(LC_ALL, old);
#endif
		gdk_window_set_group(win->window, win->window);
	}
}

/* 2001-08-04 -	Update GtkHPaned handle position to maintain the configured split. */
static void evt_main_sizealloc(GtkWidget *wid, GtkAllocation *alloc, gpointer user)
{
	MainInfo	*min = user;
	gint		pos = -1;

	switch(min->cfg.dp_paning.mode)
	{
		case DPSPLIT_FREE:
			return;
		case DPSPLIT_RATIO:
			pos = alloc->width * min->cfg.dp_paning.value;
			break;
		case DPSPLIT_ABS_LEFT:
			pos = min->cfg.dp_paning.value;
			break;
		case DPSPLIT_ABS_RIGHT:
			pos = alloc->width - min->cfg.dp_paning.value;
			break;
	}
	if(pos > 0)
		gtk_paned_set_position(GTK_PANED(min->gui->panes), pos);
}

static GtkWidget * build_gui(MainInfo *min)
{
	GtkWidget	*top, *panes, *bottom;

	min->gui = g_malloc(sizeof *min->gui);
	min->gui->window = NULL;
	min->gui->window = win_window_open(min->cfg.wininfo, WIN_MAIN);
	gtk_object_set_user_data(GTK_OBJECT(min->gui->window), min);
	gtk_signal_connect(GTK_OBJECT(min->gui->window), "size_allocate", GTK_SIGNAL_FUNC(evt_main_sizealloc), min);
	min->gui->pane[0].main = min->gui->pane[1].main = min;
	min->gui->pane[0].list = min->gui->pane[1].list = NULL;
	min->gui->vbox = gtk_vbox_new(FALSE, 0);
	min->gui->main_tt = gtk_tooltips_new();
	min->gui->kbd_ctx = kbd_context_new(min);
	min->gui->sig_left_sizealloc = 0U;

	top = build_top(&min->gui->top);
	if((panes = build_dirpanes(min)) != NULL)
	{
		bottom = build_bottom(min);
		gtk_box_pack_start(GTK_BOX(min->gui->vbox), top,    FALSE, FALSE, 0);
		gtk_box_pack_start(GTK_BOX(min->gui->vbox), panes,  TRUE,  TRUE,  0);
		gtk_box_pack_start(GTK_BOX(min->gui->vbox), bottom, FALSE, FALSE, 0);
		gtk_widget_show(bottom);
		gtk_widget_show(min->gui->vbox);
		min->gui->middle = panes;
		min->gui->bottom = bottom;
		min->gui->cur_pane = &min->gui->pane[0];
		gtk_tooltips_enable(min->gui->main_tt);
		kbd_context_attach(min->gui->kbd_ctx, GTK_WINDOW(min->gui->window));
		ctrl_keys_install(min->cfg.ctrlinfo, min->gui->kbd_ctx);
		return min->gui->vbox;
	}
	gtk_widget_destroy(top);
	gtk_widget_destroy(min->gui->vbox);

	return NULL;
}

/* 1998-08-23 -	Initialize the paths config data. */
static void init_paths(CfgInfo *cfg)
{
	cfg->path.path[PTID_ICON]  = g_string_new(PATH_ICN);
	cfg->path.path[PTID_GTKRC] = g_string_new(PATH_GRC);
	cfg->path.path[PTID_FSTAB] = g_string_new("/etc/fstab");
	cfg->path.path[PTID_MTAB]  = g_string_new("/proc/mounts");

	cfg->path.hideinfo.mode = HIDE_NONE;
	cfg->path.hideinfo.hide_re_src[0] = '\0';
	cfg->path.hideinfo.hide_re = NULL;
}

/* ----------------------------------------------------------------------------------------- */

/* 1998-11-29 -	Load the GTK+ RC file, allowing users to configure gentoo's looks. The
**		file is always named ".gentoogtkrc" (too long, I know) but you can put
**		it anywhere as long as you given gentoo the path (in the config).
** 2001-08-12 -	The dot is now optional, but is given priority if found.
*/
static void load_gtk_rc(MainInfo *min)
{
	const gchar	*name;

	if((name = fut_locate(min->cfg.path.path[PTID_GTKRC]->str, ".gentoogtkrc")) != NULL)
		gtk_rc_parse(name);
	else if((name = fut_locate(min->cfg.path.path[PTID_GTKRC]->str, "gentoogtkrc")) != NULL)
		gtk_rc_parse(name);
}

/* 1999-04-04 -	Initialize default (er, and non-configurable) command options. I'll
**		build a GUI for this stuff real soon now.
*/
static void init_cmd_options(CfgInfo *cfg)
{
	cfg->opt_overwrite.show_info = TRUE;
	stu_strncpy(cfg->opt_overwrite.datefmt, "%Y-%m-%d %H:%M.%S", sizeof cfg->opt_overwrite.datefmt);
}

#if 0
/* 1999-05-10 -	This is for temporary key checks during development. Simpler to get a trigger this way
**		than to hack the controls and/or keyboard modules. Is that a sign of bad code there? Naah. :)
*/
#include <gdk/gdkkeysyms.h>
static void evt_key_press(GtkWidget *wid, GdkEventKey *evt, gpointer user)
{
	MainInfo	*min = user;

	printf("Someone pressed %d ('%c'), state=%04X\n", evt->keyval, evt->keyval, evt->state);

	if(evt->keyval == GDK_v)
	{
		GtkAdjustment	*adj;

		if((adj = gtk_scrolled_window_get_vadjustment(GTK_SCROLLED_WINDOW(min->gui->cur_pane->scwin))) != NULL)
			printf("Adj: lower=%g upper=%g value=%g\n", adj->lower, adj->upper, adj->value);
	}
	else if((evt->keyval == GDK_s))
		dp_focus(min->gui->cur_pane, 3);
	else if(evt->keyval == GDK_x)
		dp_focus(min->gui->cur_pane, 8);
	else if(evt->keyval == GDK_z)
		dp_unfocus(min->gui->cur_pane);
	else if(evt->keyval == GDK_d)
	{
		Dialog	*dlg;
		gint	ret;

		dlg = dlg_dialog_sync_new(NULL, "Hello", "_A|_B");
		ret = dlg_dialog_sync_wait(dlg);
		dlg_dialog_sync_destroy(dlg);
	}
	else if(evt->keyval == GDK_1)
	{
		min->cfg.dp_paning.mode++;
		if(min->cfg.dp_paning.mode > DPSPLIT_ABS_RIGHT)
			min->cfg.dp_paning.mode = DPSPLIT_FREE;
	}
	else if(evt->keyval == GDK_0)
		gtk_widget_hide(min->gui->pane[0].scwin);
	else if(evt->keyval == GDK_plus)
		gtk_widget_show(min->gui->pane[0].scwin);
}
#endif

/* 2002-02-19 -	Resolve what the initial directory is going to be, and go there. */
static void enter_initial_dirs(MainInfo *min, const gchar *dirleft, const gchar *dirright)
{
	const gchar	*dir;
	const gchar	*odir[2];
	const gchar	*cmd[] = { "ActivateLeft", "ActivateRight" };
	gint		i;

	odir[0] = dirleft;
	odir[1] = dirright;
	for(i = sizeof cmd / sizeof *cmd - 1; i >= 0; i--)
	{
		if((dir = odir[i]) == NULL)
		{
			dir = min->cfg.dp_format[i].def_path;
			if(!dir[0])
			{
				dir = dph_history_get_first(&min->gui->pane[i]);
				if(dir == NULL)
					dir = ".";
			}
		}
		if(dir && *dir)
		{
			csq_execute(min, cmd[i]);
			csq_execute_format(min, "DirEnter 'dir=%s'", stu_escape(dir));
		}
	}
}

/* 2003-11-25 -	An idle handler that should only trigger once, to run commands from command line. */
static gint evt_idle_run(gpointer user)
{
	MainInfo	*min = user;
	const GList	*list;

	for(list = opt_arg_get("run", min->opt, min->opt_num); list != NULL; list = g_list_next(list))
		csq_execute(min, list->data);
	return FALSE;		/* Causes the handler to be removed, once really is enough. */
}

int main(int argc, char *argv[])
{
	enum { OPT_VERSION = 1 << 0, OPT_LOCALEINFO = 1 << 1, OPT_ROOTOK = 1 << 2,
		OPT_NORC = 1 << 3, OPT_NOGTKRC = 1 << 4, OPT_NOFAM = 1 << 5 };
	OptDesc	od[] = { { '\0', "version",  OPT_ARG_NONE, OPT_VERSION,	N_("Report the version to standard output, and exit.") },
#if defined ENABLE_NLS
			 { '\0', "locale-info", OPT_ARG_NONE, OPT_LOCALEINFO, N_("Report internal locale details, and exit.") },
#endif
			 { '\0', "root-ok",  OPT_ARG_NONE, OPT_ROOTOK,	N_("Allows gentoo to be run by the root user. Could be dangerous.") },
			 { '\0', "no-rc",    OPT_ARG_NONE, OPT_NORC,	N_("Do not load the ~/.gentoorc configuration file; instead, use default values.") },
			 { '\0', "no-gtkrc", OPT_ARG_NONE, OPT_NOGTKRC,	N_("Do not load the ~/.gentoogtkrc GTK+ configuration file; instead, use system defaults.") },
#if defined HAVE_FAM
			 { '\0', "no-fam",   OPT_ARG_NONE, OPT_NOFAM,	N_("Do not use FAM to automatically detect changes in viewed directories.") },
#endif
			 { '1',  "left",     OPT_ARG_REQ,      0U, N_("Use ARG as path for the left directory pane. Overrides default (and history).") },
			 { '2',  "right",    OPT_ARG_REQ,      0U, N_("Use ARG as path for the right directory pane. Overrides default (and history).") },
			 { 'r',  "run",	     OPT_ARG_REQ_LIST, 0U, N_("Run ARG, a gentoo command. Done before user interaction allowed, but after configuration "
								      "file has been read in. Can be used many times to run several commands in sequence.") }
			};
	guint32		opt_flags, cfg_flags = 0U;
	GtkWidget	*box;
	static MainInfo	min = { 0 };

	/* Make options available to idle callback that runs commands from invocation. A bit ugly. */
	min.opt     = od;
	min.opt_num = sizeof od / sizeof *od;
	
#if defined ENABLE_NLS
	setlocale(LC_ALL, "");
	if(bindtextdomain(PACKAGE, LOCALEDIR) == NULL)
	{
		fprintf(stderr, _("%s: Couldn't set text domain to \"%s\"\n"), argv[0], LOCALEDIR);
		return EXIT_FAILURE;
	}
	textdomain(PACKAGE);
	for(opt_flags = 0; opt_flags < sizeof od / sizeof *od; opt_flags++)
		od[opt_flags].help = _(od[opt_flags].help);
	gtk_set_locale();
#endif

	/* First, let GTK+ eat any options it feels an urge for. */
	gtk_init(&argc, &argv);

	/* Then, do our own options parsing. */
	opt_flags = opt_parse(&argc, argv, od, sizeof od / sizeof *od);
	if(argc < 1)
		return argc < -1 ? EXIT_FAILURE : EXIT_SUCCESS;
	if(opt_flags & OPT_VERSION)
	{
		puts(VERSION);
		return EXIT_SUCCESS;
	}
#if defined ENABLE_NLS
	if(opt_flags & OPT_LOCALEINFO)
	{
		printf("PACKAGE=\"%s\"\n", PACKAGE);
		printf("LOCALEDIR=\"%s\"\n", LOCALEDIR);
		return EXIT_SUCCESS;
	}
#endif
	if(geteuid() == 0 && !(opt_flags & OPT_ROOTOK))
	{
		fprintf(stderr, _("%s: To run as root, envoke with the '--root-ok' option\n"), argv[0]);
		return EXIT_FAILURE;
	}

	/* Must be run early, before anyone changes the directory. */
	fut_initialize();

	gtk_quit_add(1, quit_handler, &min);

	dp_initialize();
	dpf_initialize();
	sze_initialize();
	mnu_initialize();

	min.cfg.flags = 0;
	dpf_init_defaults(&min.cfg);
	csq_init_commands(&min);
	mnt_init_defaults(&min.cfg);
	min.cfg.menus = mnu_menuinfo_new_default(&min);
	btn_buttoninfo_new_default(&min, &min.cfg.buttons);
	min.cfg.buttonlayout = btl_buttonlayout_new();
	init_paths(&min.cfg);
	min.cfg.style = stl_styleinfo_default();
	typ_init(&min.cfg);
	min.cfg.wininfo	 = win_wininfo_new_default(&min);
	min.cfg.ctrlinfo = ctrl_new_default(&min);
	min.cfg.errors.dialog = FALSE;
	min.cfg.dir_filter = dir_filter;
	chd_initialize(&min);
	min.que = que_initialize();
	
	ctrl_general_set_cmdseq(min.cfg.ctrlinfo, CTRL_GENERAL_PATH_RMB, "About");

	min.ico = ico_initialize(&min);

	if(!(opt_flags & OPT_NORC))
		cfg_flags = cfg_load_config(&min);
	if(!usr_init())
		g_warning(_("Couldn't initialize userinfo module - username resolving won't work"));
	if(!(opt_flags & OPT_NOGTKRC))
		load_gtk_rc(&min);

	if((min.cfg.mount.mode != MNT_NEVER) && (!mnt_init(&min)))
		g_warning(_("Couldn't initialize mount data - automounting won't work"));

	if(!(opt_flags & OPT_NOFAM))
		fam_initialize(&min);

	if((box = build_gui(&min)) != NULL)
	{
		gchar	welcome[128];

		dlg_group_set(min.gui->window->window);
		dlg_position_set(min.cfg.dialogs.pos);
		min.gui->win_del_evt = gtk_signal_connect(GTK_OBJECT(min.gui->window), "delete_event", GTK_SIGNAL_FUNC(evt_main_delete), &min);
#if 0
		gtk_signal_connect(GTK_OBJECT(min.gui->window), "key_press_event", GTK_SIGNAL_FUNC(evt_key_press), &min);
#endif
		min.cfg.flags = 0;
		init_cmd_options(&min.cfg);		

		gtk_container_add(GTK_CONTAINER(min.gui->window), box);

		dph_history_load(&min, min.gui->pane, sizeof min.gui->pane / sizeof *min.gui->pane);

		gtk_window_set_policy(GTK_WINDOW(min.gui->window), TRUE, TRUE, FALSE);

		csq_execute(&min, "DpRecenter");

		window_set_icon(min.gui->window);
		win_window_show(min.gui->window);

		min.gui->sig_left_sizealloc = gtk_signal_connect(GTK_OBJECT(min.gui->pane[0].vbox), "size_allocate",
								GTK_SIGNAL_FUNC(evt_pane_sizealloc), &min);
		gtk_signal_handler_block(GTK_OBJECT(min.gui->pane[0].vbox), min.gui->sig_left_sizealloc);

		enter_initial_dirs(&min, opt_arg_get("left", od, sizeof od / sizeof *od), opt_arg_get("right", od, sizeof od / sizeof *od));

		g_snprintf(welcome, sizeof welcome, _("gentoo v%s by Emil Brink <emil@obsession.se>"), VERSION);
		gtk_label_set_text(GTK_LABEL(min.gui->top), welcome);

		gtk_idle_add(evt_idle_run, &min);
		gtk_main();
	}
	fam_shutdown(&min);
	mnt_shutdown(&min);
	fut_finalize();

	return EXIT_SUCCESS;
}
