# Copyright 1999-2012 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/x11-misc/okindd/okindd-0.6.0.ebuild,v 1.2 2012/02/14 17:20:36 tove Exp $

EAPI="4"

inherit qt4-r2

MY_P="${P}-49-20110113"

DESCRIPTION="On Screen Display (OSD) for KDE 4.x - works on any qt desktop"
HOMEPAGE="http://sites.kochkin.org/okindd/Home"
SRC_URI="http://sites.kochkin.org/okindd/Home/development/${MY_P}.tar.bz2"

LICENSE="GPL-3"
KEYWORDS="~amd64 ~x86"
SLOT="0"
IUSE="debug"

DEPEND="x11-libs/qt-gui:4
	x11-libs/qt-dbus:4"
RDEPEND="${DEPEND}"

S="${WORKDIR}/${PN}"

src_configure() {
	eqmake4 okindd.pro
}

DOCS=( changelog )
src_install() {
	qt4-r2_src_install
	docinto examples
	dodoc scripts/*
	dodoc conf/okinddrc.example

	elog "You can find an example configuration file at"
	elog "	/usr/share/doc/okindd/examples/okinddrc.example"
	elog "It should be placed in \${HOME}/.okindd/"
}
