# Copyright 1999-2013 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/sys-auth/libfprint/libfprint-0.5.0.ebuild,v 1.3 2013/01/08 21:46:16 mr_bones_ Exp $

EAPI=4

inherit autotools eutils udev vcs-snapshot

MY_PV="v_${PV//./_}"
DESCRIPTION="library to add support for consumer fingerprint readers"
HOMEPAGE="http://cgit.freedesktop.org/libfprint/libfprint/"
SRC_URI="http://cgit.freedesktop.org/${PN}/${PN}/snapshot/${MY_PV}.tar.bz2 -> ${P}.tar.bz2"

LICENSE="LGPL-2.1"
SLOT="0"
KEYWORDS="~alpha ~amd64 ~ia64 ~ppc ~ppc64 ~x86"
IUSE="debug static-libs"

RDEPEND="virtual/libusb:1
	dev-libs/nss
	|| ( media-gfx/imagemagick media-gfx/graphicsmagick[imagemagick] x11-libs/gdk-pixbuf )"
DEPEND="${RDEPEND}
	virtual/pkgconfig"

src_prepare() {
	eautoreconf
}

src_configure() {
	econf \
		--with-drivers=all \
		$(use_enable debug debug-log) \
		$(use_enable static-libs static) \
		-enable-udev-rules \
		--with-udev-rules-dir=$(udev_get_udevdir)/rules.d
	# --disable-udev-rules fails https://bugs.freedesktop.org/show_bug.cgi?id=59076
	# $(use_enable udev udev-rules) \
}

src_install() {
	emake DESTDIR="${D}" install

	prune_libtool_files

	dodoc AUTHORS HACKING NEWS README THANKS TODO
}
