# Copyright 1999-2012 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/sec-policy/selinux-base/selinux-base-9999.ebuild,v 1.3 2012/12/11 10:52:53 ssuominen Exp $
EAPI="4"

inherit eutils git-2

IUSE="+peer_perms +open_perms +ubac unconfined doc"

DESCRIPTION="Gentoo base policy for SELinux"
HOMEPAGE="http://www.gentoo.org/proj/en/hardened/selinux/"
EGIT_REPO_URI="git://git.overlays.gentoo.org/proj/hardened-refpolicy.git"
EGIT_SOURCEDIR="${WORKDIR}/refpolicy"
LICENSE="GPL-2"
SLOT="0"

KEYWORDS=""

RDEPEND=">=sys-apps/policycoreutils-2.1.10
	virtual/udev
	!<=sec-policy/selinux-base-policy-2.20120725"
DEPEND="${RDEPEND}
	sys-devel/m4
	>=sys-apps/checkpolicy-2.1.8"

S=${WORKDIR}/

src_unpack() {
	git-2_src_unpack
}

src_prepare() {
	cd "${S}/refpolicy"
	# Fix bug 257111 - Correct the initial sid for cron-started jobs in the
	# system_r role
	sed -i -e 's:system_crond_t:system_cronjob_t:g' \
		"${S}/refpolicy/config/appconfig-standard/default_contexts"
	sed -i -e 's|system_r:cronjob_t|system_r:system_cronjob_t|g' \
		"${S}/refpolicy/config/appconfig-mls/default_contexts"
	sed -i -e 's|system_r:cronjob_t|system_r:system_cronjob_t|g' \
		"${S}/refpolicy/config/appconfig-mcs/default_contexts"
}

src_configure() {
	[ -z "${POLICY_TYPES}" ] && local POLICY_TYPES="targeted strict mls mcs"

	# Update the SELinux refpolicy capabilities based on the users' USE flags.

	if ! use peer_perms; then
		sed -i -e '/network_peer_controls/d' \
			"${S}/refpolicy/policy/policy_capabilities"
	fi

	if ! use open_perms; then
		sed -i -e '/open_perms/d' \
			"${S}/refpolicy/policy/policy_capabilities"
	fi

	if ! use ubac; then
		sed -i -e '/^UBAC/s/y/n/' "${S}/refpolicy/build.conf" \
			|| die "Failed to disable User Based Access Control"
	fi

	echo "DISTRO = gentoo" >> "${S}/refpolicy/build.conf"

	# Prepare initial configuration
	cd "${S}/refpolicy";
	make conf || die "Make conf failed"

	# Setup the policies based on the types delivered by the end user.
	# These types can be "targeted", "strict", "mcs" and "mls".
	for i in ${POLICY_TYPES}; do
		cp -a "${S}/refpolicy" "${S}/${i}"
		cd "${S}/${i}";

		#cp "${FILESDIR}/modules-2.20120215.conf" "${S}/${i}/policy/modules.conf"
		sed -i -e "/= module/d" "${S}/${i}/policy/modules.conf"

		sed -i -e '/^QUIET/s/n/y/' -e "/^NAME/s/refpolicy/$i/" \
			"${S}/${i}/build.conf" || die "build.conf setup failed."

		if [[ "${i}" == "mls" ]] || [[ "${i}" == "mcs" ]];
		then
			# MCS/MLS require additional settings
			sed -i -e "/^TYPE/s/standard/${i}/" "${S}/${i}/build.conf" \
				|| die "failed to set type to mls"
		fi

		if [ "${i}" == "targeted" ]; then
			sed -i -e '/root/d' -e 's/user_u/unconfined_u/' \
			"${S}/${i}/config/appconfig-standard/seusers" \
			|| die "targeted seusers setup failed."
		fi

		if [ "${i}" != "targeted" ] && [ "${i}" != "strict" ] && use unconfined; then
			sed -i -e '/root/d' -e 's/user_u/unconfined_u/' \
			"${S}/${i}/config/appconfig-${i}/seusers" \
			|| die "policy seusers setup failed."
		fi
	done
}

src_compile() {
	[ -z "${POLICY_TYPES}" ] && local POLICY_TYPES="targeted strict mls mcs"

	for i in ${POLICY_TYPES}; do
		cd "${S}/${i}"
		make base || die "${i} compile failed"
		if use doc; then
			make html || die
		fi
	done
}

src_install() {
	[ -z "${POLICY_TYPES}" ] && local POLICY_TYPES="targeted strict mls mcs"

	for i in ${POLICY_TYPES}; do
		cd "${S}/${i}"

		make DESTDIR="${D}" install \
			|| die "${i} install failed."

		make DESTDIR="${D}" install-headers \
			|| die "${i} headers install failed."

		echo "run_init_t" > "${D}/etc/selinux/${i}/contexts/run_init_type"

		echo "textrel_shlib_t" >> "${D}/etc/selinux/${i}/contexts/customizable_types"

		# libsemanage won't make this on its own
		keepdir "/etc/selinux/${i}/policy"

		if use doc; then
			dohtml doc/html/*;
		fi

		insinto /usr/share/selinux/devel;
		doins doc/policy.xml;

	done

	dodoc doc/Makefile.example doc/example.{te,fc,if}

	insinto /etc/selinux
	doins "${FILESDIR}/config"
}

pkg_preinst() {
	has_version "<${CATEGORY}/${PN}-2.20101213-r13"
	previous_less_than_r13=$?
}
