# Copyright 1999-2012 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/dev-embedded/dfu-programmer/dfu-programmer-0.5.4-r1.ebuild,v 1.2 2012/12/11 09:37:32 ssuominen Exp $

EAPI=4
inherit autotools base udev

DESCRIPTION="A Device Firmware Update based USB programmer for Atmel chips"
HOMEPAGE="http://dfu-programmer.sourceforge.net"
SRC_URI="mirror://sourceforge/${PN}/${P}.tar.gz"
LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~amd64"
IUSE=""

RDEPEND="virtual/libusb:1
	virtual/udev"
DEPEND="${RDEPEND}"
PATCHES=( "${FILESDIR}/${PV}-as-needed.patch" )

src_prepare() {
	base_src_prepare
	eautoreconf
}

src_install() {
	emake DESTDIR="${D}" install || die "make install failed"
	ebegin "Generating UDEV rules..."
	UDEV_RULES="$(udev_get_udevdir)/rules.d/70-dfu-programmer.rules"
	mkdir -p "${D}"/${UDEV_RULES%/*}
	echo -e "#\n# do not edit this file, it will be overwritten on update\n#" \
		> "${D}"/${UDEV_RULES}
	for prodid in "2ffa" "2ffb" "2ff9" "2ff7" "2ff4" "2ff3" ;
	do
		echo "SUBSYSTEM==\"usb\", ACTION==\"add\", ATTRS{idVendor}==\"03eb\", \
		ATTRS{idProduct}==\"${prodid}\", MODE=\"660\", GROUP=\"plugdev\", \
		SYMLINK+=\"dfu-%n\"" >> "${D}"${UDEV_RULES}
	done
	eend $?
}
