# Copyright 1999-2013 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/app-backup/duplicity/duplicity-0.6.21.ebuild,v 1.1 2013/01/24 03:08:18 radhermit Exp $

EAPI=5
PYTHON_COMPAT=( python{2_6,2_7} )

inherit distutils-r1

DESCRIPTION="Secure backup system using gnupg to encrypt data"
HOMEPAGE="http://www.nongnu.org/duplicity/"
SRC_URI="http://code.launchpad.net/${PN}/0.6-series/${PV}/+download/${P}.tar.gz"

LICENSE="GPL-3"
SLOT="0"
KEYWORDS="~amd64 ~ppc ~sparc ~x86 ~amd64-linux ~x86-linux ~x64-macos ~x86-macos"
IUSE="s3"

DEPEND="
	net-libs/librsync
	app-crypt/gnupg
"
RDEPEND="${DEPEND}
	dev-python/paramiko
	>=dev-python/pexpect-2.1[${PYTHON_USEDEP}]
	>=dev-python/py-gnupg-0.3.2
	s3? ( dev-python/boto )
"

python_prepare_all() {
	sed -i "s/'COPYING',//" setup.py || die "Couldn't remove unnecessary COPYING file."
}
