# Copyright 1999-2012 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/app-admin/bcfg2/bcfg2-1.2.2-r1.ebuild,v 1.1 2012/06/29 06:28:40 xmw Exp $

EAPI="4"

PYTHON_DEPEND="2:2.6"
SUPPORT_PYTHON_ABIS="1"
# ssl module required.
RESTRICT_PYTHON_ABIS="2.4 2.5 3.*"

inherit distutils eutils

DESCRIPTION="configuration management tool"
HOMEPAGE="http://bcfg2.org"
SRC_URI="ftp://ftp.mcs.anl.gov/pub/bcfg/${P}.tar.gz"

LICENSE="BSD"
SLOT="0"
KEYWORDS="~amd64 ~x86 ~amd64-linux ~x86-linux ~x64-solaris"
IUSE="doc cheetah genshi server"

DEPEND="dev-python/setuptools
	doc? ( dev-python/sphinx )"
RDEPEND="app-portage/gentoolkit
	cheetah? ( dev-python/cheetah )
	genshi? ( dev-python/genshi )
	server? (
		virtual/fam
		dev-python/lxml
		dev-libs/libgamin[python] )"

PYTHON_MODNAME="Bcfg2"

distutils_src_install_post_hook() {
	if ! use server; then
		rm -f "$(distutils_get_intermediate_installation_image)${EPREFIX}/usr/sbin/bcfg2-"*
	fi
}

src_prepare() {
	epatch "${FILESDIR}"/${P}-CVE-2012-3366-Trigger-plugin.patch
	distutils_src_prepare
}

src_compile() {
	distutils_src_compile

	if use doc; then
		einfo "Building Bcfg2 documentation"
		PYTHONPATH="build-$(PYTHON -f --ABI)" \
			sphinx-build doc doc_output || die
	fi
}

src_install() {
	distutils_src_install --record=PY_SERVER_LIBS --install-scripts "${EPREFIX}/usr/sbin"

	if ! use server; then
		rm -rf "${ED}usr/share/bcfg2" || die
		rm -rf "${ED}usr/share/man/man8" || die
	else
		newinitd "${FILESDIR}/${PN}-server-1.2.0.rc" bcfg2-server
	fi

	insinto /etc
	doins examples/bcfg2.conf

	if use doc; then
		pushd doc_output > /dev/null
		insinto /usr/share/doc/${PF}/html
		doins -r [a-z]* _images _static || die "Failed to install documentation"
		popd > /dev/null
	fi
}

pkg_postinst () {
	distutils_pkg_postinst

	if use server; then
		einfo "If this is a new installation, you probably need to run:"
		einfo "    bcfg2-admin init"
	fi
}
