# -----------------------------------------------------------------------------
#
# (c) 2009 The University of Glasgow
#
# This file is part of the GHC build system.
#
# To understand how the build system works and how to modify it, see
#      http://hackage.haskell.org/trac/ghc/wiki/Building/Architecture
#      http://hackage.haskell.org/trac/ghc/wiki/Building/Modifying
#
# -----------------------------------------------------------------------------

docs/users_guide_DOCBOOK_SOURCES := \
    $(wildcard docs/users_guide/*.xml) \
    $(basename $(wildcard docs/users_guide/*.xml.in))

$(eval $(call docbook,docs/users_guide,users_guide))

# Hack: dblatex normalises the name of the input file using
# os.path.realpath, which means that if we're in a linked build tree,
# it won't be able to find ug-book.xml which is in the build tree but
# not in the source tree.  Hence, we copy ug-book.xml to the source
# tree.  This is a horrible hack, but I can't find a better way to do
# it --SDM (2009-05-11)

build_ug_book = docs/users_guide/ug-book.xml
src_ug_book  = $(dir $(realpath $(dir $(build_ug_book))/ug-book.xml.in))ug-book.xml

# ... and similarly for ug-ent.xml, which is now generated by configure from
# ug-ent.xml.in --SDM (2010-02-25)

build_ug_ent = docs/users_guide/ug-ent.xml
src_ug_ent  = $(dir $(realpath $(dir $(build_ug_ent))/ug-ent.xml.in))ug-ent.xml

html_docs/users_guide : docs/users_guide/users_guide/prof_scc.png

docs/users_guide/users_guide/prof_scc.png : \
		docs/users_guide/prof_scc.png \
		docs/users_guide/users_guide/index.html
	$(CP) $< $@
# dep. on d/u/u/index.html is to make sure that the d/u/u dir is created first

ifneq "$(build_ug_book)" "$(src_ug_book)"
$(src_ug_book) : $(build_ug_book)
	"$(CP)" $< $@
ifneq "$(BINDIST)" "YES"
docs/users_guide/users_guide.pdf docs/users_guide/users_guide.ps: $(src_ug_book)
endif
endif

ifneq "$(build_ug_ent)" "$(src_ug_ent)"
$(src_ug_ent) : $(build_ug_ent)
	"$(CP)" $< $@
ifneq "$(BINDIST)" "YES"
docs/users_guide/users_guide.pdf docs/users_guide/users_guide.ps: $(src_ug_ent)
endif
endif

