//class iso2disc : public flburn
//{
	iso2disc::iso2disc()
	{
		strcpy(this->last_input_dir,getenv("HOME"));
		this->in_start = false;
	}
	
	iso2disc::~iso2disc()
	{
		
	}
	
	void iso2disc::show_win()
	{
		this->window = new Fl_Window( (int)(screen.w-400)/2 , (int)(screen.h-120)/2 , 400 , 120 , "FlBurn" );
		this->window->color(fl_rgb_color(237,236,235));
		this->window->begin();
			
			this->progress=new Fl_Progress(10,10,253,20,"");
			this->progress->minimum(0.0);
			this->progress->maximum(100.0);
			this->progress->value(0.0);
			this->progress->selection_color( fl_rgb_color(118,158,207) );
			
			this->elapsed_time_box = new Fl_Box(FL_DOWN_BOX,264,10,126,20,"");
			this->elapsed_time_box->color(fl_rgb_color(214,212,210));
			
			this->path_input=new Fl_Output(10,50,253,20);
			this->path_input->color(fl_rgb_color(214,212,210));
			this->path_input->selection_color(fl_rgb_color(103,145,198));
			
			this->in_file_button=new Fl_Button(264,48,126,24,"Select iso file");
			this->in_file_button->labelcolor(fl_rgb_color(255,255,255));
			this->in_file_button->callback(in_file_cb,this);
			
			this->device_choice=new Fl_Choice(10,90,170,20);
			this->device_choice->selection_color(fl_rgb_color(103,145,198));
			unsigned int i;
			for(i=0;i<drives.drive_count;i++)
			{
				char choice_string[30];
				
				strcpy(choice_string,drives.drive_list[i].vendor);
				strcat(choice_string," ");
				strcat(choice_string,drives.drive_list[i].product);
				
				this->device_choice->add(choice_string);
			}
			if(drives.drive_count > 0)
			{
				this->device_choice->value(0);
			}
			
			this->speed_choice=new Fl_Choice(181,90,82,20);
			this->speed_choice->selection_color(fl_rgb_color(103,145,198));
			this->speed_choice->add("Min Speed");
			this->speed_choice->add("Max Speed");
			this->speed_choice->add("Custom");
			this->speed_choice->value(0);
			
			
			this->stop_button=new Fl_Button(264,90,61,20,"Stop");
			this->stop_button->labelcolor(fl_rgb_color(255,255,255));
			this->stop_button->callback(stop_cb,this);
			this->stop_button->deactivate();
			
			this->start_button=new Fl_Button(329,90,61,20,"Start");
			this->start_button->labelcolor(fl_rgb_color(255,255,255));
			this->start_button->callback(start_cb,this);
			
		this->window->end();
		this->window->show();
		this->window->callback(window_close_cb,this);
	}
	
	void iso2disc::hide_win()
	{
		Fl::delete_widget( (Fl_Widget*)this->window );
	}
	
	void iso2disc::window_close_cb(Fl_Widget* w, void* iso2disc_object)
	{
		iso2disc *iso2disc_ob=(iso2disc*)iso2disc_object;
		if(Fl::event()==FL_CLOSE)
		{
			if(!iso2disc_ob->in_start)
			{
				iso2disc_ob->hide_win();
				flburn_launcher.show_win();
			}
			else
			{
				fl_alert("An operation is still in progress.");
			}
		}
	};
	
	void iso2disc::start_cb(Fl_Widget* w, void* iso2disc_object)
	{
		iso2disc *iso2disc_ob=(iso2disc*)iso2disc_object;
		iso2disc_ob->start();
	};
	
	void iso2disc::start()
	{
		this->in_start = true;
		time_t sleep_start;
		
		if(drives.drive_count > 0)
		{
			const char *path_input = this->path_input->value();//input file
			
			struct stat64 infile_buf_var;
			if(strcmp(path_input,"")!=0 && stat64(path_input,&infile_buf_var)==0 && access(path_input,R_OK)==0)
			{
				
				this->target_drive = drives.drive_list[ this->device_choice->value() ].drive;//struct drive
				
				try_umount();//this will try to unmount cd/dvd drives if any
				if( burn_drive_grab(this->target_drive, 1) == 1 )
				{
					if( burn_disc_get_status(this->target_drive) == BURN_DISC_BLANK || (burn_disc_erasable(this->target_drive) && fl_choice("The disc must be erased","Abort","Erase",NULL)==1) )
					{
						if(burn_disc_erasable(this->target_drive) && burn_disc_get_status(this->target_drive) != BURN_DISC_BLANK)
						{
							sleep_start = time(NULL);
							while( difftime(time(NULL),sleep_start) < 1 )
							{
								Fl::flush();
								Fl::check();
								usleep(300000);
							}
							this->erase(this->target_drive);
							usleep(300000);
						}
						
						off_t free_space = burn_disc_available_space(this->target_drive,NULL);
						if(infile_buf_var.st_size < free_space)
						{
						
							burn_source *source_var=burn_file_source_new(path_input, NULL);
							
							if(source_var!=NULL)
							{
								this->aborted = false;//process is started
								
								this->make_widgets_busy();
								
								burn_disc *disc_var = burn_disc_create();//burn disc
								
								burn_session *session_var = burn_session_create();//burn session
								burn_disc_add_session(disc_var, session_var, BURN_POS_END);//add session to disc
								
								burn_track *track_var = burn_track_create();//burn track
								burn_session_add_track(session_var,track_var, BURN_POS_END);//add track to session
								
								burn_source *fifo_source = burn_fifo_source_new(source_var,2048,2048,0);
								burn_track_set_source(track_var,fifo_source);//add source to track
								
								bool speed_error = false;
								if( this->speed_choice->value()==0 )//setting write speed min or max
								{
									burn_drive_set_speed(this->target_drive, 0, -1);
								}
								else if( this->speed_choice->value()==1 )
								{
									burn_drive_set_speed(this->target_drive, 0, 0);
								}
								else
								{
									unsigned int custom_speed = this->prompt_speed(this->target_drive);
									if(custom_speed==0)
									{
										speed_error = true;
									}
									else
									{
										burn_drive_set_speed(this->target_drive, custom_speed, custom_speed);
										std::cout << "Custom speed: " << custom_speed << "\n";
									}
								}
								
								if(!speed_error)
								{
									burn_write_opts *write_opts = burn_write_opts_new(this->target_drive);//write opts
									burn_write_opts_set_underrun_proof(write_opts,1);//turning on buffer underrun protection
									burn_write_opts_set_perform_opc(write_opts,0);
									
									struct burn_progress* progress=(burn_progress*)malloc(sizeof(struct burn_progress)+1);
									bool mode_error=false;
									char reasons[BURN_REASONS_LEN];
									if(burn_write_opts_auto_write_type(write_opts,disc_var,reasons,0)!=BURN_WRITE_NONE)
									{
									
										burn_disc_write(write_opts, disc_var);
										
										time_t start_time = time(NULL);
										time_t current_time;
										
										char time_str[20];
										
										while (burn_drive_get_status(this->target_drive, NULL) == BURN_DRIVE_SPAWNING)
										{
											current_time = time(NULL);
											this->get_formatted_elapsed_time( difftime(current_time,start_time) , time_str );
											this->elapsed_time_box->copy_label(time_str);
											
											Fl::flush();
											Fl::check();
											usleep(300000);
										}
										
										int total_sectors = infile_buf_var.st_size / 2048;
										float percent;
										char percent_str[5];
										
										while(burn_drive_get_status(this->target_drive, progress)!=BURN_DRIVE_IDLE)
										{
											current_time = time(NULL);
											this->get_formatted_elapsed_time( difftime(current_time,start_time) , time_str );
											this->elapsed_time_box->copy_label(time_str);
											
											if(progress->sector > 0 && progress->sector <= total_sectors)
											{
												percent = progress->sector * 100 / total_sectors;
												this->progress->value(percent);
												sprintf(percent_str,"%d%%",(int)percent);
												this->progress->copy_label(percent_str);
											}
											
											Fl::flush();
											Fl::check();
											usleep(300000);
										}
										
										sleep_start = time(NULL);
										while( difftime(time(NULL),sleep_start) < 5 )
										{
											current_time = time(NULL);
											this->get_formatted_elapsed_time( difftime(current_time,start_time) , time_str );
											this->elapsed_time_box->copy_label(time_str);
											
											Fl::flush();
											Fl::check();
											usleep(300000);
										}
										
									}
									else
									{
										mode_error=true;
									}
									
									burn_drive_release(this->target_drive,1);
									
									this->reset_widgets();
									
									burn_source_free(source_var);
									burn_source_free(fifo_source);
									burn_track_free(track_var);
									burn_session_free(session_var);
									burn_disc_free(disc_var);
									
									burn_write_opts_free(write_opts);
									
									free(progress);
									
									if(mode_error)
									{
										fl_message("No suitable mode for writing was found.");
									}
									else if(this->aborted)
									{
										fl_message("Operation aborted by user.");
									}
									else if(!burn_drive_wrote_well(this->target_drive))
									{
										fl_message("Writing errors. Operation failed.");
									}
									else
									{
										fl_message("Operation completed successfully.");
									}	
								}
								else
								{
									burn_drive_release(this->target_drive,0);
									
									this->reset_widgets();
									
									burn_source_free(source_var);
									burn_source_free(fifo_source);
									burn_track_free(track_var);
									burn_session_free(session_var);
									burn_disc_free(disc_var);
									//no message
									std::cout << "No speed was choosen\n";
								}
							}
							else
							{
								burn_drive_release(this->target_drive,0);
								fl_message("Invalid ISO file");
							}
						}
						else
						{
							burn_drive_release(this->target_drive,0);
							
							int free_space_m = floor(free_space / 1024 / 1024);
							char mes[ 14 + this->count_int(free_space_m) + 20 + 1 ];
							sprintf(mes,"There is only %d MB space available.",free_space_m);
							fl_alert(mes);
						}
					}
					else
					{
						burn_drive_release(this->target_drive,0);
						fl_alert("The disc is not blank or there is no disk in drive.");
					}
				}
				else
				{
					fl_alert("Error. Drive is mounted. Please, unmount it.");
				}
			}
			else
			{
				if(strcmp(path_input,"")==0)
				{
					fl_alert("Please, specify a source for iso file.");
				}
				else if(stat64(path_input,&infile_buf_var)!=0)
				{
					fl_alert("Invalid iso file source. Please, specify another source for iso file.");
				}
				else if(access(path_input,R_OK)!=0)
				{
					fl_alert("Permission denied. Select another iso file.");
				}
			}
		}
		else
		{
			fl_alert("No suitable optical drive was found.");
		}
		
		this->target_drive = NULL;
		this->in_start = false;
	};
	
	void iso2disc::make_widgets_busy()
	{
		this->stop_button->activate();
		
		this->in_file_button->deactivate();
		this->start_button->deactivate();
		this->device_choice->deactivate();
		this->speed_choice->deactivate();
	};
	
	void iso2disc::reset_widgets()
	{
		this->stop_button->deactivate();
		
		this->in_file_button->activate();
		this->start_button->activate();
		this->device_choice->activate();
		this->speed_choice->activate();
		
		this->progress->value(0.0);
		this->progress->copy_label("");
	};
	
	void iso2disc::stop_cb(Fl_Widget* w, void* iso2disc_object)
	{
		iso2disc *iso2disc_ob=(iso2disc*)iso2disc_object;
		iso2disc_ob->stop();
	};
	
	void iso2disc::stop()
	{
		this->aborted = true;
		burn_drive_cancel(this->target_drive);
		sleep(1);
		burn_drive_cancel(this->target_drive);
	}
	
	void iso2disc::in_file_cb(Fl_Widget* w, void* iso2disc_object)
	{
		iso2disc *iso2disc_ob=(iso2disc*)iso2disc_object;
		iso2disc_ob->in_file_chooser();
	};
	
	void iso2disc::in_file_chooser()
	{
		Fl_File_Chooser *chooser = new Fl_File_Chooser(".","(*.iso)",Fl_File_Chooser::SINGLE,"Select *.iso file");
		chooser->directory(this->last_input_dir);
		chooser->preview(0);
		chooser->show();
	
		while(chooser->shown())
		{
			Fl::wait();
		}
		
		if(chooser->value() != NULL)
		{
			if( strlen(chooser->directory()) < 100 )
			{
				strcpy(this->last_input_dir,chooser->directory());
			}
			
			const char *filename = chooser->value();
			
			char full_in_path[strlen(filename)+1];
			
			strcpy(full_in_path,filename);
			
			this->path_input->value(filename);
		}
		chooser->~Fl_File_Chooser();
	};
	
	unsigned int iso2disc::prompt_speed(struct burn_drive* drive)
	{
		unsigned int speed = 0;
		
		Fl_Window *speed_win = new Fl_Window( (int)(screen.w-320)/2 , (int)(screen.h-65)/2 , 320 , 65 , "Select write speed" );
		speed_win->set_modal();
		speed_win->begin();
		
			Fl_Choice* speed_choice=new Fl_Choice(174,8,82,20,"Select write speed");
			speed_choice->selection_color(fl_rgb_color(103,145,198));
			char tmp_str[10];
		
			char profile_name[80];
			int profile_number;
			double divider;
			
			burn_disc_get_profile(drive, &profile_number, profile_name);
			
			if( profile_number==0x09 || profile_number==0x0a )
			{
				divider=176.4;
			}
			else
			{
				divider=1385;
			}
			
			burn_disc_read_atip(drive);//I'm not sure about this
			
			struct burn_speed_descriptor *speed_list;
			burn_drive_get_speedlist(drive,&speed_list);
			
			struct burn_speed_descriptor *iter_list;
			for( iter_list=speed_list ; iter_list->next!=NULL ; iter_list=iter_list->next )
			{
				
			}
			
			struct burn_speed_descriptor *last_speed_list = iter_list;
			
			int min_speed = last_speed_list->write_speed;
			
			sprintf( tmp_str , "%gx" , this->another_round( (float)min_speed/divider ) );
			speed_choice->add(tmp_str);
			
			for( iter_list=last_speed_list->prev ; iter_list!=NULL ; iter_list=iter_list->prev )
			{
				
				if( iter_list->write_speed==min_speed || iter_list->write_speed==min_speed+1 || iter_list->write_speed==min_speed-1 )
				{
					break;
				}
				else
				{
					sprintf( tmp_str , "%gx" , this->another_round( (float)iter_list->write_speed / divider ) );
					speed_choice->add(tmp_str);
				}
			}
			
			speed_choice->value(0);
			
			Fl_Button* continue_button=new Fl_Button(20,35,126,24,"Continue");
			continue_button->labelcolor(fl_rgb_color(255,255,255));
			
			Fl_Button* cancel_button=new Fl_Button(172,35,126,24,"Cancel");
			cancel_button->labelcolor(fl_rgb_color(255,255,255));
			
		speed_win->end();
		speed_win->show();
		
		for(;;)
		{
			Fl_Widget *w = Fl::readqueue();
			
			if(!w)
			{
				Fl::wait();
			}
			else if(w == continue_button)
			{
				int iter = 0;
				for( iter_list=last_speed_list ; iter_list!=NULL ; iter_list=iter_list->prev )
				{
					
					if(iter==speed_choice->value())
					{
						speed = iter_list->write_speed;
						break;
					}
					iter++;
				}
				break;
			}
			else if(w == cancel_button)
			{
				break;
			}
			else if(w == speed_win)
			{
				break;
			}
			else
			{
				Fl::wait();
			}
		}
		
		Fl::delete_widget(speed_win);
		burn_drive_free_speedlist(&speed_list);
		
		return speed;
	};
//};
