struct drives_struct
{
	struct burn_drive_info* drive_list;
	unsigned int drive_count;
};

struct screen_struct
{
	int x;
	int y;
	int w;
	int h;
};

class flburn
{
	protected: static void get_formatted_elapsed_time(double elapsed,char* time_str);
	protected: static void erase(struct burn_drive *drive);
	protected: static void erase_win_close_cb(Fl_Widget* w, void* data=NULL);
	protected: static int count_int(unsigned int number);
	protected: static float another_round(float number);
};

class launcher : public flburn
{
	private: Fl_Window *mainwin;
	public: launcher();
	public: ~launcher();
	
	public: void show_win();
	public: void hide_win();
	
	public: static void erase_button_cb(Fl_Widget* w, void* launcher_object);
	public: static void help_button_cb(Fl_Widget* w, void* launcher_object);
	public: static void about_button_cb(Fl_Widget* w, void* launcher_object);
	
	public: static void disc2iso_button_cb(Fl_Widget* w, void* launcher_object);
	public: static void iso2disc_button_cb(Fl_Widget* w, void* launcher_object);
	public: static void files2iso_button_cb(Fl_Widget* w, void* launcher_object);
	public: static void files2disc_button_cb(Fl_Widget* w, void* launcher_object);
	
	public: static void window_close_cb(Fl_Widget* w, void* launcher_object);
};

class files2iso : public flburn
{
	private: Fl_Window *window;
	private: Fl_Progress *progress;
	private: Fl_Multi_Browser *list;
	private: Fl_Input *vol_label_input;
	private: Fl_Output *path_output;
	private: Fl_Button *out_file_button;
	private: Fl_Box *elapsed_time_box;
	private: Fl_Box *iso_size_box;
	private: Fl_Button *add_file_button;
	private: Fl_Button *add_folder_button;
	private: Fl_Button *stop_button;
	private: Fl_Button *start_button;
	
	private: struct burn_drive *target_drive;
	
	public: files2iso();
	public: ~files2iso();
	
	public: void show_win();
	public: void hide_win();
	
	public: static void window_close_cb(Fl_Widget* w, void* files2iso_object);
	
	public: void add_file_folder_chooser(Fl_Widget* w);
	public: static void add_file_folder_cb(Fl_Widget* w, void* files2iso_object);
	
	public: void out_file_chooser();
	public: static void out_file_cb(Fl_Widget* w, void* files2iso_object);
	
	public: static void start_cb(Fl_Widget* w, void* files2iso_object);
	public: void start();
	
	public: static void stop_cb(Fl_Widget* w, void* files2iso_object);
	public: void stop();
	
	private: char last_input_dir[100];
	private: char last_output_dir[100];
	
	private: void make_widgets_busy();
	private: void reset_widgets();
	
	public: static void del_from_list_cb(Fl_Widget* w, void* files2iso_object);
	public: static void clear_list_cb(Fl_Widget* w, void* files2iso_object);
	public: static void menu_on_list_cb(Fl_Widget* w, void* files2iso_object);
	
	private: bool aborted;
	
	private: void count_iso_size(int index,short increase);
	private: off_t iso_size;
	
	private: short check_already_in_list(const char* name);
	
	private: bool in_start;
};


class disc2iso : public flburn
{
	private: Fl_Window *window;
	private: Fl_Choice *device_choice;
	private: Fl_Progress *progress;
	private: Fl_Output *path_output;
	private: Fl_Button *out_file_button;
	private: Fl_Button *stop_button;
	private: Fl_Button *start_button;
	private: Fl_Box *elapsed_time_box;
	
	public: disc2iso();
	public: ~disc2iso();
	
	public: void show_win();
	public: void hide_win();
	public: static void window_close_cb(Fl_Widget* w, void* disc2iso_object);
	
	public: static void out_file_cb(Fl_Widget* w, void* disc2iso_object);
	public: void out_file_chooser();
	
	public: static void start_cb(Fl_Widget* w, void* disc2iso_object);
	public: void start();
	
	public: static void stop_cb(Fl_Widget* w, void* files2iso_object);
	public: void stop();
	
	private: struct burn_drive *source_drive;
	private: struct burn_drive *target_drive;
	
	private: char last_output_dir[100];
	
	private: void make_widgets_busy();
	private: void reset_widgets();
	
	private: bool aborted;
	
	private: bool in_start;
};


class files2disc : public flburn
{
	private: Fl_Window *window;
	private: Fl_Progress *progress;
	private: Fl_Multi_Browser *list;
	private: Fl_Input *vol_label_input;
	private: Fl_Box *elapsed_time_box;
	private: Fl_Box *iso_size_box;
	private: Fl_Button *add_file_button;
	private: Fl_Button *add_folder_button;
	private: Fl_Button *stop_button;
	private: Fl_Button *start_button;
	
	private: Fl_Choice *device_choice;
	private: Fl_Choice *speed_choice;
	
	private: struct burn_drive *target_drive;
	
	public: files2disc();
	public: ~files2disc();
	
	public: void show_win();
	public: void hide_win();
	
	public: static void window_close_cb(Fl_Widget* w, void* files2disc_object);
	
	public: void add_file_folder_chooser(Fl_Widget* w);
	public: static void add_file_folder_cb(Fl_Widget* w, void* files2disc_object);
	
	public: static void start_cb(Fl_Widget* w, void* files2disc_object);
	public: void start();
	
	public: static void stop_cb(Fl_Widget* w, void* files2disc_object);
	public: void stop();
	
	private: unsigned int prompt_speed(struct burn_drive* drive);
	
	private: char last_input_dir[100];
	
	private: void make_widgets_busy();
	private: void reset_widgets();
	
	public: static void del_from_list_cb(Fl_Widget* w, void* files2disc_object);
	public: static void clear_list_cb(Fl_Widget* w, void* files2disc_object);
	public: static void menu_on_list_cb(Fl_Widget* w, void* files2disc_object);
	
	private: bool aborted;
	
	private: void count_iso_size(int index,short increase);
	private: off_t iso_size;
	
	private: short check_already_in_list(const char* name);
	
	private: bool in_start;
};

class iso2disc : public flburn
{
	private: Fl_Window *window;
	private: Fl_Progress *progress;
	private: Fl_Box *elapsed_time_box;
	private: Fl_Button *stop_button;
	private: Fl_Button *start_button;
	private: Fl_Output *path_input;
	private: Fl_Button *in_file_button;
	
	private: Fl_Choice *device_choice;
	private: Fl_Choice *speed_choice;
	
	private: struct burn_drive *target_drive;
	
	public: iso2disc();
	public: ~iso2disc();
	
	public: void show_win();
	public: void hide_win();
	
	public: static void window_close_cb(Fl_Widget* w, void* iso2disc_object);
	
	public: static void start_cb(Fl_Widget* w, void* iso2disc_object);
	public: void start();
	
	public: static void stop_cb(Fl_Widget* w, void* iso2disc_object);
	public: void stop();
	
	private: unsigned int prompt_speed(struct burn_drive* drive);
	
	public: static void in_file_cb(Fl_Widget* w, void* disc2iso_object);
	public: void in_file_chooser();
	
	private: char last_input_dir[100];
	
	private: void make_widgets_busy();
	private: void reset_widgets();
	
	private: bool aborted;
	
	private: bool in_start;
};
