void flburn::get_formatted_elapsed_time(double elapsed,char* time_str)
{
	short e_hours=floor(elapsed/3600);
	short e_minutes=floor(elapsed/60)-60*e_hours;
	short e_seconds=floor(elapsed-e_hours*3600-e_minutes*60);
	sprintf(time_str,"Elapsed %dh:%dm:%ds",e_hours,e_minutes,e_seconds);
}

float flburn::another_round(float number)
{
	unsigned int rounded_number=round(number);
	float remainder = number - rounded_number;
	remainder = remainder * 10;
	unsigned int rounded_remainder = round(remainder);
	remainder = (float)rounded_remainder / 10;
	return rounded_number + (float)remainder;
}

void flburn::erase(struct burn_drive *erase_drive)
{
	
	Fl_Window *erase_win = new Fl_Window( (int)(screen.w-320)/2 , (int)(screen.h-60)/2 , 320 , 60 , "Erasing" );
	erase_win->set_modal();
	erase_win->callback(erase_win_close_cb,NULL);
	erase_win->begin();
		Fl_Progress *flprogress = new Fl_Progress(10,20,300,20,"");
		flprogress->maximum(100.0);
		flprogress->minimum(0.0);
		flprogress->selection_color( fl_rgb_color(118,158,207) );
	erase_win->end();
	erase_win->show();
	
	burn_disc_erase(erase_drive, 1);
	
	usleep(300000);
	
	struct burn_progress* progress=(burn_progress*)malloc(sizeof(struct burn_progress)+1);
	float percent;
	
	char percent_str[5];
	
	while (burn_drive_get_status(erase_drive, progress) != BURN_DRIVE_IDLE)
	{
		if(progress->sectors > 0 && progress->sector > 0 && progress->sector <= progress->sectors)
		{
			percent = progress->sector * 100 / progress->sectors;
			flprogress->value(percent);
			sprintf(percent_str,"%d%%",(int)percent);
			flprogress->copy_label(percent_str);
			
			Fl::flush();
			Fl::check();
		}
		usleep(300000);
	}
	
	Fl::delete_widget(erase_win);
	free(progress);
}

void flburn::erase_win_close_cb(Fl_Widget* w, void* data)
{
	return;
}

int flburn::count_int(unsigned int number)
{
	double work_number=(double)number;
	unsigned int counter=0;
	while(work_number >= 1)
	{
		work_number=work_number/10;
		counter++;
	}
	return counter;
}
