//class files2iso : public flburn
//{
	files2iso::files2iso()
	{
		strcpy(this->last_input_dir,getenv("HOME"));
		strcpy(this->last_output_dir,getenv("HOME"));
		this->iso_size = 0;
		this->in_start = false;
	}
	
	files2iso::~files2iso()
	{
		
	}
	
	void files2iso::show_win()
	{
		this->window = new Fl_Window( (int)(screen.w-800)/2 , (int)(screen.h-480)/2 , 800 , 480 , "FlBurn" );
		this->window->color(fl_rgb_color(237,236,235));

		this->window->begin();
			
			this->list = new Fl_Multi_Browser(10,10,640,330);
			this->list->callback(menu_on_list_cb,this);
			this->list->selection_color(fl_rgb_color(139,175,220));
			
			int widths[] = {200,400,0};
			this->list->column_widths(widths);
			this->list->add("@B727291136@C255NAME\t@B727291136@C255PATH");
			
			this->add_file_button=new Fl_Button(660,10,130,40,"Add files");
			this->add_file_button->labelcolor(fl_rgb_color(255,255,255));
			this->add_file_button->callback(add_file_folder_cb,this);
			
			this->add_folder_button=new Fl_Button(660,60,130,40,"Add folders");
			this->add_folder_button->labelcolor(fl_rgb_color(255,255,255));
			this->add_folder_button->callback(add_file_folder_cb,this);
			
			this->vol_label_input=new Fl_Input(660,110,130,20);
			this->vol_label_input->value("VOLUME LABEL");
			this->vol_label_input->selection_color(fl_rgb_color(103,145,198));
			
			this->progress=new Fl_Progress(10,380,780,20);
			this->progress->minimum(0.0);
			this->progress->maximum(100.0);
			this->progress->value(0.0);
			this->progress->selection_color( fl_rgb_color(118,158,207) );
			
			this->iso_size_box = new Fl_Box(FL_DOWN_BOX,10,350,130,20,"");
			this->iso_size_box->color(fl_rgb_color(214,212,210));
			
			this->elapsed_time_box = new Fl_Box(FL_DOWN_BOX,660,350,130,20,"");
			this->elapsed_time_box->color(fl_rgb_color(214,212,210));
			
			this->path_output=new Fl_Output(10,450,300,20);
			this->path_output->color(fl_rgb_color(214,212,210));
			this->path_output->selection_color(fl_rgb_color(103,145,198));
			
			this->out_file_button=new Fl_Button(311,448,125,24,"Select output file");
			this->out_file_button->labelcolor(fl_rgb_color(255,255,255));
			this->out_file_button->callback(out_file_cb,this);
			
			this->stop_button=new Fl_Button(580,440,100,30,"Stop");
			this->stop_button->labelcolor(fl_rgb_color(255,255,255));
			this->stop_button->deactivate();
			this->stop_button->callback(stop_cb,this);
			
			this->start_button=new Fl_Button(690,440,100,30,"Start");
			this->start_button->labelcolor(fl_rgb_color(255,255,255));
			this->start_button->callback(start_cb,this);
		
		this->window->end();
		this->window->show();
		this->window->callback(window_close_cb,this);
		Fl::run();
	}
	
	void files2iso::hide_win()
	{
		this->iso_size = 0;
		Fl::delete_widget( (Fl_Widget*)this->window );
	}
	
	void files2iso::window_close_cb(Fl_Widget* w, void* files2iso_object)
	{
		files2iso *files2iso_ob=(files2iso*)files2iso_object;
		if(Fl::event()==FL_CLOSE)
		{
			if(!files2iso_ob->in_start)
			{
				files2iso_ob->hide_win();
				flburn_launcher.show_win();
			}
			else
			{
				fl_alert("An operation is still in progress.");
			}
		}
	};
	
	void files2iso::menu_on_list_cb(Fl_Widget* w, void* files2iso_object)
	{
		if(Fl::event()==FL_RELEASE && Fl::event_button()==FL_RIGHT_MOUSE)
		{
			Fl_Menu_Item del_sel = {"Remove the selected item from the list",0,del_from_list_cb,files2iso_object};
			Fl_Menu_Item del_all = {"Clear thr list",0,clear_list_cb,files2iso_object};
			
			Fl_Menu_Item popup_menu[] = {del_sel,del_all,{0}};
			const Fl_Menu_Item *m = popup_menu->popup(Fl::event_x(), Fl::event_y(), 0, 0, 0);
			if(m)
			{
				m->do_callback(w,m->user_data());
			}
		}
	};
	
	void files2iso::del_from_list_cb(Fl_Widget* w, void* files2iso_object)
	{
		files2iso *files2iso_ob=(files2iso*)files2iso_object;
		int list_length = files2iso_ob->list->size();
		for( int iter=list_length ; iter >=2  ; iter-- )
		{
			if(files2iso_ob->list->selected(iter))
			{
				files2iso_ob->count_iso_size(iter,0);
				files2iso_ob->list->remove(iter);
				iter--;
			}
		}
	};
	
	void files2iso::clear_list_cb(Fl_Widget* w, void* files2iso_object)
	{
		files2iso *files2iso_ob=(files2iso*)files2iso_object;
		int list_length = files2iso_ob->list->size();
		for( int iter=list_length ; iter >=2  ; iter-- )
		{
			files2iso_ob->count_iso_size(iter,0);
			files2iso_ob->list->remove(iter);
		}
	};
	
	void files2iso::start_cb(Fl_Widget* w, void* files2iso_object)
	{
		files2iso *files2iso_ob=(files2iso*)files2iso_object;
		files2iso_ob->start();
	};
	
	void files2iso::start()
	{
		this->in_start = true;
		int list_size = this->list->size();//size of list
		if(list_size > 1)
		{
			const char *path_output = this->path_output->value();//out file
			
			struct stat64 outfile_buf_var;
			if( strcmp(path_output,"")!=0 && stat64(path_output,&outfile_buf_var)!=0 && access(this->last_output_dir,W_OK)==0 )
			{
				char out_file[ 7 + strlen(path_output) + 1 ];
				strcpy(out_file,"stdio:/");
				strcat(out_file,path_output);
				
				struct burn_drive_info* stdio_drive_list;
				if( burn_drive_scan_and_grab(&stdio_drive_list,out_file, 0) == 1 )
				{
					this->aborted = false;//process is started
					
					this->make_widgets_busy();
					
					this->target_drive = stdio_drive_list[0].drive;//for aborting message
					
					burn_disc *disc_var = burn_disc_create();//burn disc
					
					burn_session *session_var = burn_session_create();//burn session
					burn_disc_add_session(disc_var, session_var, BURN_POS_END);//add session to disc
					
					burn_track *track_var = burn_track_create();//burn track
					burn_session_add_track(session_var,track_var, BURN_POS_END);//add track to session
					
					
					IsoImage* image_var;
					iso_image_new( this->vol_label_input->value() , &image_var );//create image
					iso_image_set_system_id(image_var,"LINUX");
					iso_image_set_application_id(image_var,"FLBURN");
					
					IsoDir* root_dir=iso_image_get_root(image_var);//getting root dir
					
					for(int iter=2 ; iter<=list_size ; iter++)
					{
						char source_text[ strlen(this->list->text(iter)) + 1 ];
						strcpy( source_text , this->list->text(iter) );
						
						char* pch;
						
						pch = strtok( source_text,"\t" );
						char name[ strlen(pch) + 1 ];
						strcpy( name , pch );
						
						pch = strtok( NULL,"\t" );
						char path[ strlen(pch) + 1 ];
						strcpy( path , pch );
						
						struct stat64 buf_var;
						
						if( stat64(path,&buf_var)==0 )
						{
							if( S_ISDIR(buf_var.st_mode) )
							{
								IsoDir* new_dir;
								iso_tree_add_new_dir(root_dir, name, &new_dir);
								iso_tree_add_dir_rec(image_var, new_dir, path);
							}
							else if( S_ISREG(buf_var.st_mode) || S_ISLNK(buf_var.st_mode) )
							{
								iso_tree_add_node(image_var, root_dir, path, NULL);
							}
						}
					}
					
					
					burn_source *source_var;//burn source for new iso
					
					
					IsoWriteOpts* opts_var;
					iso_write_opts_new(&opts_var, 2);
					iso_write_opts_set_iso_level(opts_var,3);
					
					iso_image_create_burn_source(image_var, opts_var, &source_var);
					
					burn_track_set_source(track_var,source_var);//add source to track
					
					burn_write_opts *write_opts = burn_write_opts_new(stdio_drive_list[0].drive);//write opts
					burn_write_opts_set_stream_recording(write_opts,0);
					burn_disc_write(write_opts, disc_var);
					
					time_t start_time = time(NULL);
					time_t current_time;
					
					char time_str[20];
					
					while (burn_drive_get_status(stdio_drive_list[0].drive, NULL) == BURN_DRIVE_SPAWNING)
					{
						current_time = time(NULL);
						this->get_formatted_elapsed_time( difftime(current_time,start_time) , time_str );
						this->elapsed_time_box->copy_label(time_str);
						
						Fl::flush();
						Fl::check();
						usleep(300000);
					}
					
					struct burn_progress* progress=(burn_progress*)malloc(sizeof(struct burn_progress)+1);
					
					int total_sectors = (float)source_var->get_size(source_var) / 2048;
					float percent;
					char percent_str[5];
					
					while(burn_drive_get_status(stdio_drive_list[0].drive, progress)!=BURN_DRIVE_IDLE)
					{
						current_time = time(NULL);
						this->get_formatted_elapsed_time( difftime(current_time,start_time) , time_str );
						this->elapsed_time_box->copy_label(time_str);
						
						if(progress->sector > 0 && progress->sector <= total_sectors)
						{
							percent = progress->sector * 100 / total_sectors;
							this->progress->value(percent);
							sprintf(percent_str,"%d%%",(int)percent);
							this->progress->copy_label(percent_str);
						}
						
						Fl::flush();
						Fl::check();
						usleep(300000);
					}
					
					burn_drive_release(this->target_drive,0);
					
					this->reset_widgets();
					
					burn_source_free(source_var);
					burn_track_free(track_var);
					burn_session_free(session_var);
					burn_disc_free(disc_var);
					
					burn_write_opts_free(write_opts);
					
					iso_write_opts_free(opts_var);
					iso_image_unref(image_var);
					
					free(progress);
					
					if(!this->aborted)
					{
						fl_message("Operation completed successfully.");
					}
					else
					{
						fl_message("Operation aborted by user.");
					}
				}
				else
				{
					fl_alert("Error. Try another output file.");
				}
			}
			else
			{
				if(strcmp(path_output,"")==0)
				{
					fl_alert("Please specify a name for iso file.");
				}
				else if(access(this->last_output_dir,W_OK)!=0)
				{
					fl_alert("Permission denied. Select another folder for writing.");
				}
				else if(stat64(path_output,&outfile_buf_var)==0)
				{
					fl_alert("The file already exists. Please, specify another name for iso file.");
				}
			}
		}
		else
		{
			fl_alert("The list is empty.");
		}
		
		this->target_drive = NULL;
		this->in_start = false;
	};
	
	void files2iso::add_file_folder_cb(Fl_Widget* w, void* files2iso_object)
	{
		files2iso *files2iso_ob=(files2iso*)files2iso_object;
		files2iso_ob->add_file_folder_chooser(w);
	};
	
	void files2iso::add_file_folder_chooser(Fl_Widget* w)
	{
		Fl_File_Chooser *chooser;
		
		if(w==this->add_file_button)
		{
			chooser = new Fl_File_Chooser(".","*",Fl_File_Chooser::MULTI,"Add files");
		}
		else
		{
			chooser = new Fl_File_Chooser(".","*",Fl_File_Chooser::DIRECTORY | Fl_File_Chooser::MULTI,"Add folders");
		}
		
		chooser->directory(this->last_input_dir);
		chooser->preview(0);
		chooser->show();
	
		while(chooser->shown())
		{
			Fl::wait();
		}
		
		if(chooser->value() != NULL)
		{
			if( strlen(chooser->directory()) < 100 )
			{
				strcpy(this->last_input_dir,chooser->directory());
			}
			
			for(int iter=1; iter<=chooser->count(); iter++ )
			{
				const char *filename = chooser->value(iter);
				
				char value[ strlen(filename) + 1 ];
				strcpy(value,filename);
				
				char * segment;
				char * last_segment;
				
				segment = strtok(value,"/");
				while(segment != NULL)
				{
					last_segment=segment;
					segment = strtok(NULL,"/");
				}
				
				if(!this->check_already_in_list(last_segment))
				{
					char list_string[ strlen(filename) + strlen(last_segment) + 2 ];
					strcpy(list_string,last_segment);
					strcat(list_string,"\t");
					strcat(list_string,filename);
					
					this->list->add(list_string);
					
					this->count_iso_size(this->list->size(),1);
				}
			}
			
		}
		chooser->~Fl_File_Chooser();
	};
		
	void files2iso::out_file_cb(Fl_Widget* w, void* files2iso_object)
	{
		files2iso *files2iso_ob=(files2iso*)files2iso_object;
		files2iso_ob->out_file_chooser();
	};
	
	void files2iso::out_file_chooser()
	{
		Fl_File_Chooser *chooser = new Fl_File_Chooser(".","*",Fl_File_Chooser::CREATE,"Select base name for *.iso file");
		chooser->directory(this->last_output_dir);
		chooser->preview(0);
		chooser->show();
	
		while(chooser->shown())
		{
			Fl::wait();
		}
		
		if(chooser->value() != NULL)
		{
			if( strlen(chooser->directory()) < 100 )
			{
				strcpy(this->last_output_dir,chooser->directory());
			}
			
			const char *filename = chooser->value();
			
			char full_out_path[strlen(filename)+1+4];
			
			strcpy(full_out_path,filename);
			
			strcat(full_out_path,".iso");
			
			this->path_output->value(full_out_path);
		}
		chooser->~Fl_File_Chooser();
	};
	
	void files2iso::make_widgets_busy()
	{
		this->stop_button->activate();
		
		this->start_button->deactivate();
		this->list->deactivate();
		this->add_file_button->deactivate();
		this->add_folder_button->deactivate();
		this->out_file_button->deactivate();
		this->vol_label_input->deactivate();
	};
	
	void files2iso::reset_widgets()
	{
		this->stop_button->deactivate();
		
		this->start_button->activate();
		this->list->activate();
		this->add_file_button->activate();
		this->add_folder_button->activate();
		this->out_file_button->activate();
		this->vol_label_input->activate();
		
		this->progress->value(0.0);
		this->progress->copy_label("");
	};
	
	void files2iso::stop_cb(Fl_Widget* w, void* files2iso_object)
	{
		files2iso *files2iso_ob=(files2iso*)files2iso_object;
		files2iso_ob->stop();
	};
	
	void files2iso::stop()
	{
		this->aborted = true;
		burn_drive_cancel(this->target_drive);
	}
	
	void files2iso::count_iso_size(int index,short increase)
	{
		int list_size = this->list->size();//size of list
		if(list_size > 1 && index > 1 && index <= list_size)
		{
			IsoImage* image_var;
			iso_image_new("" , &image_var);//create image
			
			IsoDir* root_dir=iso_image_get_root(image_var);//getting root dir
			
			char source_text[ strlen(this->list->text(index)) + 1 ];
			strcpy( source_text , this->list->text(index) );
			
			char* pch;
			
			pch = strtok( source_text,"\t" );
			char name[ strlen(pch) + 1 ];
			strcpy( name , pch );
			
			pch = strtok( NULL,"\t" );
			char path[ strlen(pch) + 1 ];
			strcpy( path , pch );
			
			struct stat64 buf_var;
			
			if( stat64(path,&buf_var)==0 )
			{
				if( S_ISDIR(buf_var.st_mode) )
				{
					IsoDir* new_dir;
					iso_tree_add_new_dir(root_dir, name, &new_dir);
					iso_tree_add_dir_rec(image_var, new_dir, path);
				}
				else if( S_ISREG(buf_var.st_mode) || S_ISLNK(buf_var.st_mode) )
				{
					iso_tree_add_node(image_var, root_dir, path, NULL);
				}
			}
			
			burn_source *source_var;//burn source for new iso
			
			IsoWriteOpts* opts_var;
			iso_write_opts_new(&opts_var, 2);
			iso_write_opts_set_iso_level(opts_var,3);
			
			iso_image_create_burn_source(image_var, opts_var, &source_var);//we have burn source
			
			if(increase)
			{
				this->iso_size = this->iso_size + source_var->get_size(source_var);
			}
			else
			{
				this->iso_size = this->iso_size - source_var->get_size(source_var);
			}
			
			if(this->iso_size < 0)
			{
				this->iso_size = 0;
			}
			
			int size = ceil( (double) this->iso_size / 1048576 );//megabites
			
			char size_str[ 6 + this->count_int(size) + 3 + 1 ];
			sprintf(size_str,"Size: %d MB",size);
			
			this->iso_size_box->copy_label(size_str);
			
			iso_write_opts_free(opts_var);
			iso_image_unref(image_var);
			burn_source_free(source_var);
		}
	}
	
	short files2iso::check_already_in_list(const char* name)
	{
		int list_size = this->list->size();
		for(int iter=2 ; iter<=list_size ; iter++)
		{
			char source_text[ strlen(this->list->text(iter)) + 1 ];
			strcpy( source_text , this->list->text(iter) );
			
			char* pch;
			
			pch = strtok( source_text,"\t" );
			
			std::cout << name << ":" << pch << "\n";
			
			if(strcmp(name,pch)==0)
			{
				return 1;
			}
		}
		return 0;
	}
//};
