//class files2disc : public flburn
//{
	files2disc::files2disc()
	{
		strcpy(this->last_input_dir,getenv("HOME"));
		this->iso_size = 0;
		this->in_start = false;
	}
	
	files2disc::~files2disc()
	{
		
	}
	
	void files2disc::show_win()
	{
		this->window = new Fl_Window( (int)(screen.w-800)/2 , (int)(screen.h-480)/2 , 800 , 480 , "FlBurn" );
		this->window->color(fl_rgb_color(237,236,235));

		this->window->begin();
			
			this->list = new Fl_Multi_Browser(10,10,640,330);
			this->list->callback(menu_on_list_cb,this);
			this->list->selection_color(fl_rgb_color(139,175,220));
			
			int widths[] = {200,400,0};
			this->list->column_widths(widths);
			this->list->add("@B727291136@C255NAME\t@B727291136@C255PATH");
			
			this->add_file_button=new Fl_Button(660,10,130,40,"Add files");
			this->add_file_button->labelcolor(fl_rgb_color(255,255,255));
			this->add_file_button->callback(add_file_folder_cb,this);
			
			this->add_folder_button=new Fl_Button(660,60,130,40,"Add folders");
			this->add_folder_button->labelcolor(fl_rgb_color(255,255,255));
			this->add_folder_button->callback(add_file_folder_cb,this);
			
			this->vol_label_input=new Fl_Input(660,110,130,20);
			this->vol_label_input->value("VOLUME LABEL");
			this->vol_label_input->selection_color(fl_rgb_color(103,145,198));
			
			this->progress=new Fl_Progress(10,380,780,20);
			this->progress->minimum(0.0);
			this->progress->maximum(100.0);
			this->progress->value(0.0);
			this->progress->selection_color( fl_rgb_color(118,158,207) );
			
			this->iso_size_box = new Fl_Box(FL_DOWN_BOX,10,350,130,20,"");
			this->iso_size_box->color(fl_rgb_color(214,212,210));
			
			this->elapsed_time_box = new Fl_Box(FL_DOWN_BOX,660,350,130,20,"");
			this->elapsed_time_box->color(fl_rgb_color(214,212,210));
			
			this->device_choice=new Fl_Choice(70,450,190,20,"Recorder");
			this->device_choice->selection_color(fl_rgb_color(103,145,198));
			unsigned int i;
			for(i=0;i<drives.drive_count;i++)
			{
				char choice_string[30];
				
				strcpy(choice_string,drives.drive_list[i].vendor);
				strcat(choice_string," ");
				strcat(choice_string,drives.drive_list[i].product);
				
				this->device_choice->add(choice_string);
			}
			if(drives.drive_count > 0)
			{
				this->device_choice->value(0);
			}
			
			this->speed_choice=new Fl_Choice(310,450,95,20,"Speed");
			this->speed_choice->selection_color(fl_rgb_color(103,145,198));
			this->speed_choice->add("Min");
			this->speed_choice->add("Max");
			this->speed_choice->add("Custom");
			this->speed_choice->value(0);
			
			this->stop_button=new Fl_Button(580,440,100,30,"Stop");
			this->stop_button->labelcolor(fl_rgb_color(255,255,255));
			this->stop_button->deactivate();
			this->stop_button->callback(stop_cb,this);
			
			this->start_button=new Fl_Button(690,440,100,30,"Start");
			this->start_button->labelcolor(fl_rgb_color(255,255,255));
			this->start_button->callback(start_cb,this);
		
		this->window->end();
		this->window->show();
		this->window->callback(window_close_cb,this);
		Fl::run();
	}
	
	void files2disc::hide_win()
	{
		this->iso_size = 0;
		Fl::delete_widget( (Fl_Widget*)this->window );
	}
	
	void files2disc::window_close_cb(Fl_Widget* w, void* files2disc_object)
	{
		files2disc *files2disc_ob=(files2disc*)files2disc_object;
		if(Fl::event()==FL_CLOSE)
		{
			if(!files2disc_ob->in_start)
			{
				files2disc_ob->hide_win();
				flburn_launcher.show_win();
			}
			else
			{
				fl_alert("An operation is still in progress.");
			}
		}
	};
	
	void files2disc::menu_on_list_cb(Fl_Widget* w, void* files2disc_object)
	{
		if(Fl::event()==FL_RELEASE && Fl::event_button()==FL_RIGHT_MOUSE)
		{
			Fl_Menu_Item del_sel = {"Remove the selected item from the list",0,del_from_list_cb,files2disc_object};
			Fl_Menu_Item del_all = {"Clear the list",0,clear_list_cb,files2disc_object};
			
			Fl_Menu_Item popup_menu[] = {del_sel,del_all,{0}};
			const Fl_Menu_Item *m = popup_menu->popup(Fl::event_x(), Fl::event_y(), 0, 0, 0);
			if(m)
			{
				m->do_callback(w,m->user_data());
			}
		}
	};
	
	void files2disc::del_from_list_cb(Fl_Widget* w, void* files2disc_object)
	{
		files2disc *files2disc_ob=(files2disc*)files2disc_object;
		int list_length = files2disc_ob->list->size();
		for( int iter=list_length ; iter >=2  ; iter-- )
		{
			if(files2disc_ob->list->selected(iter))
			{
				files2disc_ob->count_iso_size(iter,0);
				files2disc_ob->list->remove(iter);
				iter--;
			}
		}
	};
	
	void files2disc::clear_list_cb(Fl_Widget* w, void* files2disc_object)
	{
		files2disc *files2disc_ob=(files2disc*)files2disc_object;
		int list_length = files2disc_ob->list->size();
		for( int iter=list_length ; iter >=2  ; iter-- )
		{
			files2disc_ob->count_iso_size(iter,0);
			files2disc_ob->list->remove(iter);
		}
	};
	
	void files2disc::start_cb(Fl_Widget* w, void* files2disc_object)
	{
		files2disc *files2disc_ob=(files2disc*)files2disc_object;
		files2disc_ob->start();
	};
	
	void files2disc::start()
	{
		this->in_start = true;
		time_t sleep_start;
		
		if(drives.drive_count > 0)
		{
			int list_size = this->list->size();//size of list
			if( list_size > 1 )
			{
				this->target_drive = drives.drive_list[ this->device_choice->value() ].drive;//struct drive
				
				try_umount();//this will try to unmount cd/dvd drives if any
				if( burn_drive_grab(this->target_drive, 1) == 1 )
				{
					if( burn_disc_get_status(this->target_drive) == BURN_DISC_BLANK || (burn_disc_erasable(this->target_drive) && fl_choice("The disc must be erased","Abort","Erase",NULL)==1) )
					{
						if(burn_disc_erasable(this->target_drive) && burn_disc_get_status(this->target_drive) != BURN_DISC_BLANK)
						{
							sleep_start = time(NULL);
							while( difftime(time(NULL),sleep_start) < 1 )
							{
								Fl::flush();
								Fl::check();
								usleep(300000);
							}
							this->erase(this->target_drive);
							usleep(300000);
						}
						
						
						IsoImage* image_var;
						iso_image_new( this->vol_label_input->value() , &image_var );//create image
						
						IsoDir* root_dir=iso_image_get_root(image_var);//getting root dir
						
						for(int iter=2 ; iter<=list_size ; iter++)
						{
							char source_text[ strlen(this->list->text(iter)) + 1 ];
							strcpy( source_text , this->list->text(iter) );
							
							char* pch;
							
							pch = strtok( source_text,"\t" );
							char name[ strlen(pch) + 1 ];
							strcpy( name , pch );
							
							pch = strtok( NULL,"\t" );
							char path[ strlen(pch) + 1 ];
							strcpy( path , pch );
							
							struct stat64 buf_var;
							
							if( stat64(path,&buf_var)==0 )
							{
								if( S_ISDIR(buf_var.st_mode) )
								{
									IsoDir* new_dir;
									iso_tree_add_new_dir(root_dir, name, &new_dir);
									iso_tree_add_dir_rec(image_var, new_dir, path);
									//std::cout << name << ": dir :" << path << "\n";
								}
								else if( S_ISREG(buf_var.st_mode) || S_ISLNK(buf_var.st_mode) )
								{
									iso_tree_add_node(image_var, root_dir, path, NULL);
									//std::cout << name << ":  file :" << path << "\n";
								}
							}
						}
						
						
						burn_source *source_var;//burn source for new iso
						
						IsoWriteOpts* opts_var;
						iso_write_opts_new(&opts_var, 2);
						iso_write_opts_set_iso_level(opts_var,3);
						
						iso_image_create_burn_source(image_var, opts_var, &source_var);
						
						this->iso_size = source_var->get_size(source_var);
						
						off_t free_space = burn_disc_available_space(this->target_drive,NULL);
						if(this->iso_size < free_space)
						{
							this->aborted = false;//process is started
							
							this->make_widgets_busy();
							
							burn_disc *disc_var = burn_disc_create();//burn disc
							
							burn_session *session_var = burn_session_create();//burn session
							burn_disc_add_session(disc_var, session_var, BURN_POS_END);//add session to disc
							
							burn_track *track_var = burn_track_create();//burn track
							burn_session_add_track(session_var,track_var, BURN_POS_END);//add track to session
							
							burn_track_set_source(track_var,source_var);//add source to track
							
							bool speed_error = false;
							if( this->speed_choice->value()==0 )//setting write speed min or max
							{
								burn_drive_set_speed(this->target_drive, 0, -1);
							}
							else if( this->speed_choice->value()==1 )
							{
								burn_drive_set_speed(this->target_drive, 0, 0);
							}
							else
							{
								unsigned int custom_speed = this->prompt_speed(this->target_drive);
								if(custom_speed==0)
								{
									speed_error = true;
								}
								else
								{
									burn_drive_set_speed(this->target_drive, custom_speed, custom_speed);
									std::cout << "Custom speed: " << custom_speed << "\n";
								}
							}
							
							if(!speed_error)
							{
								burn_write_opts *write_opts = burn_write_opts_new(this->target_drive);//write opts for new stdio drive
								burn_write_opts_set_underrun_proof(write_opts,1);//turning on buffer underrun protection
								burn_write_opts_set_perform_opc(write_opts,0);
								
								struct burn_progress* progress=(burn_progress*)malloc(sizeof(struct burn_progress)+1);
								bool mode_error=false;
								char reasons[BURN_REASONS_LEN];
								if(burn_write_opts_auto_write_type(write_opts,disc_var,reasons,0)!=BURN_WRITE_NONE)
								{
								
									burn_disc_write(write_opts, disc_var);
									
									time_t start_time = time(NULL);
									time_t current_time;
									
									char time_str[20];
									
									while (burn_drive_get_status(this->target_drive, NULL) == BURN_DRIVE_SPAWNING)
									{
										current_time = time(NULL);
										this->get_formatted_elapsed_time( difftime(current_time,start_time) , time_str );
										this->elapsed_time_box->copy_label(time_str);
										
										Fl::flush();
										Fl::check();
										usleep(300000);
									}
									
									int total_sectors = this->iso_size / 2048;
									float percent;
									char percent_str[5];
									
									while(burn_drive_get_status(this->target_drive, progress)!=BURN_DRIVE_IDLE)
									{
										current_time = time(NULL);
										this->get_formatted_elapsed_time( difftime(current_time,start_time) , time_str );
										this->elapsed_time_box->copy_label(time_str);
										
										if(progress->sector > 0 && progress->sector <= total_sectors)
										{
											percent = progress->sector * 100 / total_sectors;
											this->progress->value(percent);
											sprintf(percent_str,"%d%%",(int)percent);
											this->progress->copy_label(percent_str);
										}
										
										Fl::flush();
										Fl::check();
										usleep(300000);
									}
									
									sleep_start = time(NULL);
									while( difftime(time(NULL),sleep_start) < 5 )
									{
										current_time = time(NULL);
										this->get_formatted_elapsed_time( difftime(current_time,start_time) , time_str );
										this->elapsed_time_box->copy_label(time_str);
										
										Fl::flush();
										Fl::check();
										usleep(300000);
									}
									
								}
								else
								{
									mode_error=true;
								}
								
								burn_drive_release(this->target_drive,1);
								
								this->reset_widgets();
								
								burn_source_free(source_var);
								burn_track_free(track_var);
								burn_session_free(session_var);
								burn_disc_free(disc_var);
								
								burn_write_opts_free(write_opts);
								
								iso_write_opts_free(opts_var);
								iso_image_unref(image_var);
								
								free(progress);
								
								if(mode_error)
								{
									fl_message("No suitable mode for writing was found.");
								}
								else if(this->aborted)
								{
									fl_message("Operation aborted by user.");
								}
								else if(!burn_drive_wrote_well(this->target_drive))
								{
									fl_message("Writing errors. Operation failed.");
								}
								else
								{
									fl_message("Operation completed successfully.");
								}
							}
							else
							{
								burn_drive_release(this->target_drive,0);
								
								this->reset_widgets();
								
								burn_source_free(source_var);
								burn_track_free(track_var);
								burn_session_free(session_var);
								burn_disc_free(disc_var);
								
								iso_write_opts_free(opts_var);
								iso_image_unref(image_var);
								//no message
								std::cout << "No speed was choosen\n";
							}
						}
						else
						{
							burn_drive_release(this->target_drive,0);
							
							burn_source_free(source_var);
							
							iso_write_opts_free(opts_var);
							iso_image_unref(image_var);
							
							int free_space_m = floor(free_space / 1024 / 1024);
							char mes[ 14 + this->count_int(free_space_m) + 20 + 1 ];
							sprintf(mes,"There is only %d MB space available.",free_space_m);
							fl_alert(mes);
						}
					}
					else
					{
						burn_drive_release(this->target_drive,0);
						fl_alert("The disc is not blank or there is no disk in drive.");
					}
				}
				else
				{
					fl_alert("Error. Drive is mounted. Please, unmount it.");
				}
			}
			else
			{
				fl_alert("The list is empty.");
			}
		}
		else
		{
			fl_alert("No suitable optical drive was found.");
		}
		
		this->target_drive = NULL;
		this->in_start = false;
	};
	
	void files2disc::add_file_folder_cb(Fl_Widget* w, void* files2disc_object)
	{
		files2disc *files2disc_ob=(files2disc*)files2disc_object;
		files2disc_ob->add_file_folder_chooser(w);
	};
	
	void files2disc::add_file_folder_chooser(Fl_Widget* w)
	{
		Fl_File_Chooser *chooser;
		
		if(w==this->add_file_button)
		{
			chooser = new Fl_File_Chooser(".","*",Fl_File_Chooser::MULTI,"Add files");
		}
		else
		{
			chooser = new Fl_File_Chooser(".","*",Fl_File_Chooser::DIRECTORY | Fl_File_Chooser::MULTI,"Add folders");
		}
		
		chooser->directory(this->last_input_dir);
		chooser->preview(0);
		chooser->show();
	
		while(chooser->shown())
		{
			Fl::wait();
		}
		
		if(chooser->value() != NULL)
		{
			if( strlen(chooser->directory()) < 100 )
			{
				strcpy(this->last_input_dir,chooser->directory());
			}
			
			for(int iter=1; iter<=chooser->count(); iter++ )
			{
				const char *filename = chooser->value(iter);
				
				char value[ strlen(filename) + 1 ];
				strcpy(value,filename);
				
				char * segment;
				char * last_segment;
				
				segment = strtok(value,"/");
				while(segment != NULL)
				{
					last_segment=segment;
					segment = strtok(NULL,"/");
				}
				
				if(!this->check_already_in_list(last_segment))
				{
					char list_string[ strlen(filename) + strlen(last_segment) + 2 ];
					strcpy(list_string,last_segment);
					strcat(list_string,"\t");
					strcat(list_string,filename);
					
					this->list->add(list_string);
					
					this->count_iso_size(this->list->size(),1);
				}
			}
			
		}
		chooser->~Fl_File_Chooser();
	};
	
	void files2disc::make_widgets_busy()
	{
		this->stop_button->activate();
		
		this->start_button->deactivate();
		this->list->deactivate();
		this->add_file_button->deactivate();
		this->add_folder_button->deactivate();
		this->device_choice->deactivate();
		this->speed_choice->deactivate();
		this->vol_label_input->deactivate();
	};
	
	void files2disc::reset_widgets()
	{
		this->stop_button->deactivate();
		
		this->start_button->activate();
		this->list->activate();
		this->add_file_button->activate();
		this->add_folder_button->activate();
		this->device_choice->activate();
		this->speed_choice->activate();
		this->vol_label_input->activate();
		
		this->progress->value(0.0);
		this->progress->copy_label("");
	};
	
	void files2disc::stop_cb(Fl_Widget* w, void* files2disc_object)
	{
		files2disc *files2disc_ob=(files2disc*)files2disc_object;
		files2disc_ob->stop();
	};
	
	void files2disc::stop()
	{
		this->aborted = true;
		burn_drive_cancel(this->target_drive);
		sleep(1);
		burn_drive_cancel(this->target_drive);
	}
	
	void files2disc::count_iso_size(int index,short increase)
	{
		int list_size = this->list->size();//size of list
		if(list_size > 1 && index > 1 && index <= list_size)
		{
			IsoImage* image_var;
			iso_image_new("" , &image_var);//create image
			
			IsoDir* root_dir=iso_image_get_root(image_var);//getting root dir
			
			char source_text[ strlen(this->list->text(index)) + 1 ];
			strcpy( source_text , this->list->text(index) );
			
			char* pch;
			
			pch = strtok( source_text,"\t" );
			char name[ strlen(pch) + 1 ];
			strcpy( name , pch );
			
			pch = strtok( NULL,"\t" );
			char path[ strlen(pch) + 1 ];
			strcpy( path , pch );
			
			struct stat64 buf_var;
			
			if( stat64(path,&buf_var)==0 )
			{
				if( S_ISDIR(buf_var.st_mode) )
				{
					IsoDir* new_dir;
					iso_tree_add_new_dir(root_dir, name, &new_dir);
					iso_tree_add_dir_rec(image_var, new_dir, path);
				}
				else if( S_ISREG(buf_var.st_mode) || S_ISLNK(buf_var.st_mode) )
				{
					iso_tree_add_node(image_var, root_dir, path, NULL);
				}
			}
			
			burn_source *source_var;//burn source for new iso
			
			IsoWriteOpts* opts_var;
			iso_write_opts_new(&opts_var, 2);
			iso_write_opts_set_iso_level(opts_var,3);
			
			iso_image_create_burn_source(image_var, opts_var, &source_var);//we have burn source
			
			if(increase)
			{
				this->iso_size = this->iso_size + source_var->get_size(source_var);
			}
			else
			{
				this->iso_size = this->iso_size - source_var->get_size(source_var);
			}
			
			if(this->iso_size < 0)
			{
				this->iso_size = 0;
			}
			
			int size = ceil( (double) this->iso_size / 1048576 );//megabites
			
			char size_str[ 6 + this->count_int(size) + 3 + 1 ];
			sprintf(size_str,"Size: %d MB",size);
			
			this->iso_size_box->copy_label(size_str);
			
			iso_write_opts_free(opts_var);
			iso_image_unref(image_var);
			burn_source_free(source_var);
		}
	}
	
	short files2disc::check_already_in_list(const char* name)
	{
		int list_size = this->list->size();
		for(int iter=2 ; iter<=list_size ; iter++)
		{
			char source_text[ strlen(this->list->text(iter)) + 1 ];
			strcpy( source_text , this->list->text(iter) );
			
			char* pch;
			
			pch = strtok( source_text,"\t" );
			
			std::cout << name << ":" << pch << "\n";
			
			if(strcmp(name,pch)==0)
			{
				return 1;
			}
		}
		return 0;
	}
	
	unsigned int files2disc::prompt_speed(struct burn_drive* drive)
	{
		unsigned int speed = 0;
		
		Fl_Window *speed_win = new Fl_Window( (int)(screen.w-320)/2 , (int)(screen.h-65)/2 , 320 , 65 , "Select write speed" );
		speed_win->set_modal();
		speed_win->begin();
		
			Fl_Choice* speed_choice=new Fl_Choice(174,8,82,20,"Select write speed");
			speed_choice->selection_color(fl_rgb_color(103,145,198));
			char tmp_str[10];
		
			char profile_name[80];
			int profile_number;
			double divider;
			
			burn_disc_get_profile(drive, &profile_number, profile_name);
			
			if( profile_number==0x09 || profile_number==0x0a )
			{
				divider=176.4;
			}
			else
			{
				divider=1385;
			}
			
			burn_disc_read_atip(drive);//I'm not sure about this
			
			struct burn_speed_descriptor *speed_list;
			burn_drive_get_speedlist(drive,&speed_list);
			
			struct burn_speed_descriptor *iter_list;
			for( iter_list=speed_list ; iter_list->next!=NULL ; iter_list=iter_list->next )
			{
				
			}
			
			struct burn_speed_descriptor *last_speed_list = iter_list;
			
			int min_speed = last_speed_list->write_speed;
			
			sprintf( tmp_str , "%gx" , this->another_round( (float)min_speed/divider ) );
			speed_choice->add(tmp_str);
			
			for( iter_list=last_speed_list->prev ; iter_list!=NULL ; iter_list=iter_list->prev )
			{
				
				if( iter_list->write_speed==min_speed || iter_list->write_speed==min_speed+1 || iter_list->write_speed==min_speed-1 )
				{
					break;
				}
				else
				{
					sprintf( tmp_str , "%gx" , this->another_round( (float)iter_list->write_speed / divider ) );
					speed_choice->add(tmp_str);
				}
			}
			
			speed_choice->value(0);
			
			Fl_Button* continue_button=new Fl_Button(20,35,126,24,"Continue");
			continue_button->labelcolor(fl_rgb_color(255,255,255));
			
			Fl_Button* cancel_button=new Fl_Button(172,35,126,24,"Cancel");
			cancel_button->labelcolor(fl_rgb_color(255,255,255));
			
		speed_win->end();
		speed_win->show();
		
		for(;;)
		{
			Fl_Widget *w = Fl::readqueue();
			
			if(!w)
			{
				Fl::wait();
			}
			else if(w == continue_button)
			{
				int iter = 0;
				for( iter_list=last_speed_list ; iter_list!=NULL ; iter_list=iter_list->prev )
				{
					
					if(iter==speed_choice->value())
					{
						speed = iter_list->write_speed;
						break;
					}
					iter++;
				}
				break;
			}
			else if(w == cancel_button)
			{
				break;
			}
			else if(w == speed_win)
			{
				break;
			}
			else
			{
				Fl::wait();
			}
		}
		
		Fl::delete_widget(speed_win);
		burn_drive_free_speedlist(&speed_list);
		
		return speed;
	};
//};
