//class disc2iso : public flburn
//{
	disc2iso::disc2iso()
	{
		strcpy(this->last_output_dir,getenv("HOME"));
		this->in_start = false;
	}
	
	disc2iso::~disc2iso()
	{
		
	}
	
	void disc2iso::show_win()
	{
		this->window = new Fl_Window( (int)(screen.w-400)/2 , (int)(screen.h-120)/2 , 400 , 120 , "FlBurn" );
		this->window->color(fl_rgb_color(237,236,235));
		this->window->begin();
			
			this->progress=new Fl_Progress(10,10,253,20,"");
			this->progress->minimum(0.0);
			this->progress->maximum(100.0);
			this->progress->value(0.0);
			this->progress->selection_color( fl_rgb_color(118,158,207) );
			
			this->elapsed_time_box = new Fl_Box(FL_DOWN_BOX,264,10,126,20,"");
			this->elapsed_time_box->color(fl_rgb_color(214,212,210));
			
			this->path_output=new Fl_Output(10,50,253,20);
			this->path_output->color(fl_rgb_color(214,212,210));
			this->path_output->selection_color(fl_rgb_color(103,145,198));
			
			this->out_file_button=new Fl_Button(264,48,126,24,"Select output file");
			this->out_file_button->labelcolor(fl_rgb_color(255,255,255));
			this->out_file_button->callback(out_file_cb,this);
			
			this->device_choice=new Fl_Choice(10,90,253,20);
			this->device_choice->selection_color(fl_rgb_color(103,145,198));
			unsigned int i;
			for(i=0;i<drives.drive_count;i++)
			{
				char choice_string[30];
				
				strcpy(choice_string,drives.drive_list[i].vendor);
				strcat(choice_string," ");
				strcat(choice_string,drives.drive_list[i].product);
				
				this->device_choice->add(choice_string);
			}
			if(drives.drive_count > 0)
			{
				this->device_choice->value(0);
			}
			
			this->stop_button=new Fl_Button(264,90,61,20,"Stop");
			this->stop_button->labelcolor(fl_rgb_color(255,255,255));
			this->stop_button->callback(stop_cb,this);
			this->stop_button->deactivate();
			
			this->start_button=new Fl_Button(329,90,61,20,"Start");
			this->start_button->labelcolor(fl_rgb_color(255,255,255));
			this->start_button->callback(start_cb,this);
			
		this->window->end();
		this->window->show();
		this->window->callback(window_close_cb,this);
	}
	
	void disc2iso::hide_win()
	{
		Fl::delete_widget( (Fl_Widget*)this->window );
	}
	
	void disc2iso::window_close_cb(Fl_Widget* w, void* disc2iso_object)
	{
		disc2iso *disc2iso_ob=(disc2iso*)disc2iso_object;
		if(Fl::event()==FL_CLOSE)
		{
			if(!disc2iso_ob->in_start)
			{
				disc2iso_ob->hide_win();
				flburn_launcher.show_win();
			}
			else
			{
				fl_alert("An operation is still in progress.");
			}
		}
	};
	
	void disc2iso::start_cb(Fl_Widget* w, void* disc2iso_object)
	{
		disc2iso *disc2iso_ob=(disc2iso*)disc2iso_object;
		disc2iso_ob->start();
	};
	
	void disc2iso::start()
	{
		this->in_start = true;
		if(drives.drive_count > 0)
		{
			const char *path_output = this->path_output->value();//out file
			
			struct stat64 outfile_buf_var;
			
			if( strcmp(path_output,"")!=0 && stat64(path_output,&outfile_buf_var)!=0 && access(this->last_output_dir,W_OK)==0 )
			{
				this->source_drive = drives.drive_list[ this->device_choice->value() ].drive;//struct drive
				
				try_umount();//this will try to unmount cd/dvd drives if any
				if( burn_drive_grab(this->source_drive, 1) == 1 )
				{
					burn_drive_release(this->source_drive,0);
					sleep(1);
					burn_drive_grab(this->source_drive, 1);
					
					if( burn_disc_get_status(this->source_drive)!=BURN_DISC_UNSUITABLE && burn_disc_get_status(this->source_drive)!=BURN_DISC_UNGRABBED && burn_disc_get_status(this->source_drive)!=BURN_DISC_EMPTY && burn_disc_get_status(this->source_drive)!=BURN_DISC_UNREADY)
					{
						char out_file[ 7 + strlen(path_output) + 1 ];
						strcpy(out_file,"stdio:/");
						strcat(out_file,path_output);
						
						struct burn_drive_info* stdio_drive_list;
						
						if( burn_drive_scan_and_grab(&stdio_drive_list,out_file, 0) == 1 )
						{
							this->aborted = false;//Operation is started
							
							this->make_widgets_busy();//change GUI
							
							this->target_drive = stdio_drive_list[0].drive;//for aborting message
							
							burn_disc *disc_var = burn_disc_create();//burn disc
							
							burn_session *session_var = burn_session_create();//burn session for disc
							burn_disc_add_session(disc_var, session_var, BURN_POS_END);//add session to disc
							
							burn_track *track_var = burn_track_create();//burn track for session
							burn_session_add_track(session_var,track_var, BURN_POS_END);//add track to session
							
							char source_address[BURN_DRIVE_ADR_LEN];
							burn_drive_d_get_adr(this->source_drive,source_address);
							
							burn_source *source_var = burn_file_source_new(source_address, NULL);//burn source for track
							burn_track_set_source(track_var,source_var);//add source to track
							
							burn_write_opts *write_opts = burn_write_opts_new(this->target_drive);//write opts
							burn_disc_write(write_opts, disc_var);//start write iso
							
							time_t start_time = time(NULL);
							time_t current_time;
							
							char time_str[20];
							
							while (burn_drive_get_status(this->target_drive, NULL) == BURN_DRIVE_SPAWNING)
							{
								current_time = time(NULL);
								this->get_formatted_elapsed_time( difftime(current_time,start_time) , time_str );
								this->elapsed_time_box->copy_label(time_str);
								
								Fl::flush();
								Fl::check();
								usleep(300000);
							}
							
							struct burn_progress* progress=(burn_progress*)malloc(sizeof(struct burn_progress)+1);
							
							int total_sectors=0;
							burn_get_read_capacity(this->source_drive,&total_sectors,0);
							
							float percent;
							char percent_str[5];
							
							while(burn_drive_get_status(this->target_drive, progress)!=BURN_DRIVE_IDLE)
							{
								current_time = time(NULL);
								this->get_formatted_elapsed_time( difftime(current_time,start_time) , time_str );
								this->elapsed_time_box->copy_label(time_str);
								
								if(progress->sector > 0 && progress->sector <= total_sectors)
								{
									percent = progress->sector * 100 / total_sectors;
									this->progress->value(percent);
									sprintf(percent_str,"%d%%",(int)percent);
									this->progress->copy_label(percent_str);
								}
								
								Fl::flush();
								Fl::check();
								usleep(300000);
							}
							
							burn_drive_release(this->target_drive,0);
							burn_drive_release(this->source_drive,1);
							
							this->reset_widgets();//reset GUI
							
							burn_source_free(source_var);
							burn_track_free(track_var);
							burn_session_free(session_var);
							burn_disc_free(disc_var);
							
							burn_write_opts_free(write_opts);
							
							free(progress);
							
							//Operation completed. How?
							
							int out_file_sectors=0;
							if(stat64(path_output,&outfile_buf_var)==0)
							{
								out_file_sectors = outfile_buf_var.st_size / 2048;//getting size of output file
							}
							
							if(this->aborted)
							{
								fl_message("Operation aborted by user.");
							}
							else if(total_sectors != out_file_sectors || out_file_sectors==0)
							{
								std::cout << "FlBurn : DEBUG : " << total_sectors << ":" << out_file_sectors << "\n";
								fl_message("Reading errors. Operation failed.");
							}
							else
							{
								fl_message("Operation completed successfully.");
							}
						}
						else
						{
							fl_alert("Error. Try another output file.");
						}
					}
					else
					{
						burn_drive_release(this->source_drive,0);
						fl_alert("The disc is empty.");
					}
				}
				else
				{
					fl_alert("Error. The drive is mounted. Please, unmount it.");
				}
			}
			else
			{
				if(strcmp(path_output,"")==0)
				{
					fl_alert("Please, specify a name for iso file.");
				}
				else if(access(this->last_output_dir,W_OK)!=0)
				{
					fl_alert("Permission denied. Select another folder for writing.");
				}
				else if(stat64(path_output,&outfile_buf_var)==0)
				{
					fl_alert("The file already exists. Please, specify another name for iso file.");
				}
			}
		}
		else
		{
			fl_alert("No suitable optical drive was found.");
		}
		
		this->source_drive = NULL;
		this->target_drive = NULL;
		this->in_start = false;
	};
	
	
	void disc2iso::out_file_cb(Fl_Widget* w, void* disc2iso_object)
	{
		disc2iso *disc2iso_ob=(disc2iso*)disc2iso_object;
		disc2iso_ob->out_file_chooser();
	};
	
	void disc2iso::out_file_chooser()
	{
		Fl_File_Chooser *chooser = new Fl_File_Chooser(".","*",Fl_File_Chooser::CREATE,"Select base name for *.iso file.");
		chooser->directory(this->last_output_dir);
		chooser->preview(0);
		chooser->show();
	
		while(chooser->shown())
		{
			Fl::wait();
		}
		
		if(chooser->value() != NULL)
		{
			if( strlen(chooser->directory()) < 100 )
			{
				strcpy(this->last_output_dir,chooser->directory());
			}
			
			const char *filename = chooser->value();
			
			char full_out_path[strlen(filename)+1+4];
			
			strcpy(full_out_path,filename);
			
			strcat(full_out_path,".iso");
			
			this->path_output->value(full_out_path);
		}
		
		chooser->~Fl_File_Chooser();
	};
	
	void disc2iso::make_widgets_busy()
	{
		this->stop_button->activate();
		
		this->start_button->deactivate();
		this->out_file_button->deactivate();
		this->device_choice->deactivate();
	};
	
	void disc2iso::reset_widgets()
	{
		this->stop_button->deactivate();
		
		this->start_button->activate();
		this->out_file_button->activate();
		this->device_choice->activate();
		
		this->progress->value(0.0);
		this->progress->copy_label("");
	};

	void disc2iso::stop_cb(Fl_Widget* w, void* disc2iso_object)
	{
		disc2iso *disc2iso_ob=(disc2iso*)disc2iso_object;
		disc2iso_ob->stop();
	};
	
	void disc2iso::stop()
	{
		this->aborted = true;
		burn_drive_cancel(this->target_drive);
	}
	
//};
