#define _LARGEFILE_SOURCE
#define _FILE_OFFSET_BITS 64

#include <iostream>

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <fcntl.h>
#include <time.h>
#include <math.h>
#include <errno.h>

#include <sys/stat.h>
#include <sys/mount.h>

#include <paths.h>
#include <mntent.h>
#include <dirent.h>

#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Clock.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_File_Chooser.H>
#include <FL/Fl_Progress.H>
#include <FL/Fl_Multi_Browser.H>
#include <FL/Fl_Input.H>
#include <FL/Fl_Output.H>
#include <FL/Fl_Menu_Item.H>
#include <FL/Fl_Box.H>

#define DOXYGEN 0

extern "C"
{
#include <libburn/libburn.h>
#include <libisofs/libisofs.h>
}
#include "include/headers.h"
#include "include/mount.cpp"

drives_struct drives;
screen_struct screen;

launcher flburn_launcher;
disc2iso flburn_disc2iso;
iso2disc flburn_iso2disc;
files2iso flburn_files2iso;
files2disc flburn_files2disc;

int main(int argc, char **argv)
{
	Fl::background(103,145,198);
	Fl::foreground(84,21,21);
	
	Fl::screen_xywh(screen.x,screen.y,screen.w,screen.h);
	
	Fl_Window *scan_window = new Fl_Window( (int)(screen.w-350)/2 , (int)(screen.h-125)/2 , 350 , 125,"FlBurn" );
	scan_window->color(fl_rgb_color(237,236,235));
	scan_window->begin();
		Fl_Clock *scan_clock=new Fl_Clock(135,10,80,80,"\n Scanning for devices");
		scan_clock->color(fl_rgb_color(255,255,255));
	scan_window->end();
	scan_window->show();
	
	burn_initialize();
	iso_init();
	
	char param_1[]="ALL";
	char param_2[]="ALL";
	char param_3[]="libburner : ";
	burn_msgs_set_severities(param_1, param_2, param_3);
	
	char param_4[]="ALL";
	char param_5[]="ALL";
	char param_6[]="libisofs : ";
	iso_set_msgs_severities(param_4, param_5, param_6);
	
	
	try_umount();//this will try to unmount cd/dvd drives if any
	
	while(burn_drive_scan(&drives.drive_list,&drives.drive_count)==0)
	{
		Fl::check();
		usleep(100002);
	}
	
	Fl::delete_widget( (Fl_Widget*)scan_window );
	
	flburn_launcher.show_win();
	
	return 	Fl::run();
}

#include "include/flburn_class.cpp"
#include "include/disc2iso.cpp"
#include "include/iso2disc.cpp"
#include "include/files2iso.cpp"
#include "include/files2disc.cpp"
#include "include/launcher.cpp"
