/*
 *	TwoLAME: an optimized MPEG Audio Layer Two encoder
 *
 *	Copyright (C) 2001-2004 Michael Cheng
 *	Copyright (C) 2004-2006 The TwoLAME Project
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License as published by the Free Software Foundation; either
 *	version 2.1 of the License, or (at your option) any later version.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  $Id: psycho_2_absthr.h,v 1.3 2008-02-01 19:44:34 richardash1981 Exp $
 *
 */


#ifndef _ABSTHR_H_
#define _ABSTHR_H_

static const FLOAT absthr_table[4][HBLKSIZE] = {
	{
	10156347392.00,
	33708348.00,
	3987838.75,
	1269806.88,
	614805.19,
	372166.75,
	256884.33,
	192636.06,
	153016.27,
	126980.66,
	108576.95,
	95003.05,
	84671.56,
	76513.41,
	70103.16,
	64824.27,
	60358.38,
	56720.18,
	53424.14,
	50668.45,
	48276.70,
	46103.89,
	44232.10,
	42534.13,
	40995.63,
	39603.86,
	38347.55,
	37131.08,
	36036.08,
	35054.00,
	34098.68,
	33169.40,
	32339.82,
	31530.99,
	30742.39,
	29973.51,
	29291.23,
	28624.48,
	27972.91,
	27336.16,
	26652.48,
	26045.79,
	25452.92,
	24873.54,
	24307.35,
	23754.04,
	23159.95,
	22632.76,
	21514.81,
	21514.81,
	20452.08,
	20452.08,
	19397.13,
	19397.13,
	18354.29,
	18354.29,
	17327.57,
	17327.57,
	16320.66,
	16320.66,
	15336.90,
	15336.90,
	14412.44,
	14412.44,
	13481.48,
	13481.48,
	12610.65,
	12610.65,
	11796.08,
	11796.08,
	10983.42,
	10983.42,
	10250.32,
	10250.32,
	9544.16,
	9544.16,
	8907.13,
	8907.13,
	8312.61,
	8312.61,
	7775.67,
	7775.67,
	7273.40,
	7273.40,
	6834.99,
	6834.99,
	6452.64,
	6452.64,
	6105.73,
	6105.73,
	5804.14,
	5804.14,
	5542.91,
	5542.91,
	5330.13,
	5330.13,
	5031.96,
	5031.96,
	5031.96,
	5031.96,
	4872.34,
	4872.34,
	4872.34,
	4872.34,
	4861.13,
	4861.13,
	4861.13,
	4861.13,
	4985.83,
	4985.83,
	4985.83,
	4985.83,
	5257.00,
	5257.00,
	5257.00,
	5257.00,
	5685.09,
	5685.09,
	5685.09,
	5685.09,
	6262.35,
	6262.35,
	6262.35,
	6262.35,
	6994.19,
	6994.19,
	6994.19,
	6994.19,
	7902.01,
	7902.01,
	7902.01,
	7902.01,
	8968.87,
	8968.87,
	8968.87,
	8968.87,
	10156.35,
	10156.35,
	10156.35,
	10156.35,
	11474.60,
	11474.60,
	11474.60,
	11474.60,
	12874.71,
	12874.71,
	12874.71,
	12874.71,
	14280.31,
	14280.31,
	14280.31,
	14280.31,
	15694.14,
	15694.14,
	15694.14,
	15694.14,
	17050.52,
	17050.52,
	17050.52,
	17050.52,
	18312.08,
	18312.08,
	18312.08,
	18312.08,
	19486.67,
	19486.67,
	19486.67,
	19486.67,
	20546.49,
	20546.49,
	20546.49,
	20546.49,
	21514.81,
	21514.81,
	21514.81,
	21514.81,
	22373.69,
	22373.69,
	22373.69,
	22373.69,
	23159.95,
	23159.95,
	23159.95,
	23159.95,
	23918.70,
	23918.70,
	23918.70,
	23918.70,
	24645.50,
	24645.50,
	24645.50,
	24645.50,
	26105.83,
	26105.83,
	26105.83,
	26105.83,
	26105.83,
	26105.83,
	26105.83,
	26105.83,
	27716.45,
	27716.45,
	27716.45,
	27716.45,
	27716.45,
	27716.45,
	27716.45,
	27716.45,
	29494.26,
	29494.26,
	29494.26,
	29494.26,
	29494.26,
	29494.26,
	29494.26,
	29494.26,
	31676.53,
	31676.53,
	31676.53,
	31676.53,
	31676.53,
	31676.53,
	31676.53,
	31676.53,
	34256.07,
	34256.07,
	34256.07,
	34256.07,
	34256.07,
	34256.07,
	34256.07,
	34256.07,
	37388.46,
	37388.46,
	37388.46,
	37388.46,
	37388.46,
	37388.46,
	37388.46,
	37388.46,
	41184.86,
	41184.86,
	41184.86,
	41184.86,
	41184.86,
	41184.86,
	41184.86,
	41184.86,
	45997.86,
	45997.86,
	45997.86,
	45997.86,
	45997.86,
	45997.86,
	45997.86,
	45997.86,
	51848.66,
	51848.66,
	51848.66,
	51848.66,
	51848.66,
	51848.66,
	51848.66,
	51848.66,
	59120.43,
	59120.43,
	59120.43,
	59120.43,
	59120.43,
	59120.43,
	59120.43,
	59120.43,
	68192.65,
	68192.65,
	68192.65,
	68192.65,
	68192.65,
	68192.65,
	68192.65,
	68192.65,
	79935.11,
	79935.11,
	79935.11,
	79935.11,
	79935.11,
	79935.11,
	79935.11,
	79935.11,
	94784.55,
	94784.55,
	94784.55,
	94784.55,
	94784.55,
	94784.55,
	94784.55,
	94784.55,
	114482.10,
	114482.10,
	114482.10,
	114482.10,
	114482.10,
	114482.10,
	114482.10,
	114482.10,
	140196.64,
	140196.64,
	140196.64,
	140196.64,
	140196.64,
	140196.64,
	140196.64,
	140196.64,
	174476.75,
	174476.75,
	174476.75,
	174476.75,
	174476.75,
	174476.75,
	174476.75,
	174476.75,
	220667.11,
	220667.11,
	220667.11,
	220667.11,
	220667.11,
	220667.11,
	220667.11,
	220667.11,
	284929.63,
	284929.63,
	284929.63,
	284929.63,
	284929.63,
	284929.63,
	284929.63,
	284929.63,
	374746.47,
	374746.47,
	374746.47,
	374746.47,
	374746.47,
	374746.47,
	374746.47,
	374746.47,
	503196.50,
	503196.50,
	503196.50,
	503196.50,
	503196.50,
	503196.50,
	503196.50,
	503196.50,
	688236.44,
	688236.44,
	688236.44,
	688236.44,
	688236.44,
	688236.44,
	688236.44,
	688236.44,
	965467.38,
	965467.38,
	965467.38,
	965467.38,
	965467.38,
	965467.38,
	965467.38,
	965467.38,
	1382730.50,
	1382730.50,
	1382730.50,
	1382730.50,
	1382730.50,
	1382730.50,
	1382730.50,
	1382730.50,
	2026457.63,
	2026457.63,
	2026457.63,
	2026457.63,
	2026457.63,
	2026457.63,
	2026457.63,
	2026457.63,
	3053076.00,
	3053076.00,
	3053076.00,
	3053076.00,
	3053076.00,
	3053076.00,
	3053076.00,
	3053076.00,
	4717778.50,
	4717778.50,
	4717778.50,
	4717778.50,
	4717778.50,
	4717778.50,
	4717778.50,
	4717778.50,
	7477175.00,
	7477175.00,
	7477175.00,
	7477175.00,
	7477175.00,
	7477175.00,
	7477175.00,
	7477175.00,
	12210618.00,
	12210618.00,
	12210618.00,
	12210618.00,
	12210618.00,
	12210618.00,
	12210618.00,
	12210618.00,
	20499234.00,
	20499234.00,
	20499234.00,
	20499234.00,
	20499234.00,
	20499234.00,
	20499234.00,
	20499234.00,
	35541636.00,
	35541636.00,
	35541636.00,
	35541636.00,
	35541636.00,
	35541636.00,
	35541636.00,
	35541636.00,
	63494696.00,
	63494696.00,
	63494696.00,
	63494696.00,
	63494696.00,
	63494696.00,
	63494696.00,
	63494696.00,
	117418800.00,
	117418800.00,
	117418800.00,
	117418800.00,
	117418800.00,
	117418800.00,
	117418800.00,
	117418800.00,
	224252560.00,
	224252560.00,
	224252560.00,
	224252560.00,
	224252560.00,
	224252560.00,
	224252560.00,
	224252560.00,
	443340800.00,
	443340800.00,
	443340800.00,
	443340800.00,
	443340800.00,
	443340800.00,
	443340800.00,
	443340800.00,
	911459584.00,
	911459584.00,
	911459584.00,
	911459584.00,
	911459584.00,
	911459584.00,
	911459584.00,
	911459584.00,
	1935251712.00,
	1935251712.00,
	1935251712.00,
	1935251712.00,
	1935251712.00,
	1935251712.00,
	1935251712.00,
	1935251712.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00
},{	
	488357088.00,
	5898447.00,
	1131716.50,
	466377.53,
	265911.78,
	180192.88,
	135125.59,
	108078.07,
	90518.55,
	78295.64,
	69141.30,
	62335.81,
	56981.98,
	52569.95,
	49061.14,
	45997.86,
	43524.88,
	41279.80,
	39331.23,
	37647.63,
	36119.16,
	34732.62,
	33399.32,
	32265.44,
	31170.05,
	30111.86,
	29156.65,
	28231.74,
	27336.16,
	26469.00,
	25629.35,
	24816.33,
	24029.10,
	23266.85,
	22476.96,
	21713.89,
	20976.72,
	20264.58,
	19531.59,
	18781.82,
	18102.46,
	17367.51,
	16700.81,
	16022.77,
	15336.90,
	14680.39,
	14051.98,
	13419.54,
	12238.76,
	12238.76,
	11136.21,
	11136.21,
	10109.68,
	10109.68,
	9177.78,
	9177.78,
	8331.78,
	8331.78,
	7598.67,
	7598.67,
	6962.06,
	6962.06,
	6408.22,
	6408.22,
	5953.02,
	5953.02,
	5581.33,
	5581.33,
	5293.44,
	5293.44,
	5078.52,
	5078.52,
	4928.76,
	4928.76,
	4861.13,
	4861.13,
	4849.95,
	4849.95,
	4917.42,
	4917.42,
	5043.56,
	5043.56,
	5232.84,
	5232.84,
	5504.75,
	5504.75,
	5844.37,
	5844.37,
	6262.35,
	6262.35,
	6756.75,
	6756.75,
	7323.82,
	7323.82,
	7975.13,
	7975.13,
	9500.31,
	9500.31,
	9500.31,
	9500.31,
	11239.26,
	11239.26,
	11239.26,
	11239.26,
	13174.60,
	13174.60,
	13174.60,
	13174.60,
	15126.47,
	15126.47,
	15126.47,
	15126.47,
	17011.30,
	17011.30,
	17011.30,
	17011.30,
	18738.62,
	18738.62,
	18738.62,
	18738.62,
	20264.58,
	20264.58,
	20264.58,
	20264.58,
	21614.12,
	21614.12,
	21614.12,
	21614.12,
	22789.65,
	22789.65,
	22789.65,
	22789.65,
	23808.80,
	23808.80,
	23808.80,
	23808.80,
	24816.33,
	24816.33,
	24816.33,
	24816.33,
	25807.00,
	25807.00,
	25807.00,
	25807.00,
	26837.22,
	26837.22,
	26837.22,
	26837.22,
	27972.91,
	27972.91,
	27972.91,
	27972.91,
	29223.86,
	29223.86,
	29223.86,
	29223.86,
	30671.68,
	30671.68,
	30671.68,
	30671.68,
	32265.44,
	32265.44,
	32265.44,
	32265.44,
	34098.68,
	34098.68,
	34098.68,
	34098.68,
	36119.16,
	36119.16,
	36119.16,
	36119.16,
	38524.55,
	38524.55,
	38524.55,
	38524.55,
	41279.80,
	41279.80,
	41279.80,
	41279.80,
	44436.27,
	44436.27,
	44436.27,
	44436.27,
	48054.89,
	48054.89,
	48054.89,
	48054.89,
	52328.41,
	52328.41,
	52328.41,
	52328.41,
	62912.59,
	62912.59,
	62912.59,
	62912.59,
	62912.59,
	62912.59,
	62912.59,
	62912.59,
	77756.66,
	77756.66,
	77756.66,
	77756.66,
	77756.66,
	77756.66,
	77756.66,
	77756.66,
	98568.38,
	98568.38,
	98568.38,
	98568.38,
	98568.38,
	98568.38,
	98568.38,
	98568.38,
	128451.02,
	128451.02,
	128451.02,
	128451.02,
	128451.02,
	128451.02,
	128451.02,
	128451.02,
	172877.14,
	172877.14,
	172877.14,
	172877.14,
	172877.14,
	172877.14,
	172877.14,
	172877.14,
	240291.06,
	240291.06,
	240291.06,
	240291.06,
	240291.06,
	240291.06,
	240291.06,
	240291.06,
	346527.44,
	346527.44,
	346527.44,
	346527.44,
	346527.44,
	346527.44,
	346527.44,
	346527.44,
	517294.19,
	517294.19,
	517294.19,
	517294.19,
	517294.19,
	517294.19,
	517294.19,
	517294.19,
	806747.31,
	806747.31,
	806747.31,
	806747.31,
	806747.31,
	806747.31,
	806747.31,
	806747.31,
	1308391.13,
	1308391.13,
	1308391.13,
	1308391.13,
	1308391.13,
	1308391.13,
	1308391.13,
	1308391.13,
	2227088.75,
	2227088.75,
	2227088.75,
	2227088.75,
	2227088.75,
	2227088.75,
	2227088.75,
	2227088.75,
	3969516.00,
	3969516.00,
	3969516.00,
	3969516.00,
	3969516.00,
	3969516.00,
	3969516.00,
	3969516.00,
	7442819.50,
	7442819.50,
	7442819.50,
	7442819.50,
	7442819.50,
	7442819.50,
	7442819.50,
	7442819.50,
	14714232.00,
	14714232.00,
	14714232.00,
	14714232.00,
	14714232.00,
	14714232.00,
	14714232.00,
	14714232.00,
	30742394.00,
	30742394.00,
	30742394.00,
	30742394.00,
	30742394.00,
	30742394.00,
	30742394.00,
	30742394.00,
	68349824.00,
	68349824.00,
	68349824.00,
	68349824.00,
	68349824.00,
	68349824.00,
	68349824.00,
	68349824.00,
	161338400.00,
	161338400.00,
	161338400.00,
	161338400.00,
	161338400.00,
	161338400.00,
	161338400.00,
	161338400.00,
	407134048.00,
	407134048.00,
	407134048.00,
	407134048.00,
	407134048.00,
	407134048.00,
	407134048.00,
	407134048.00,
	1100874368.00,
	1100874368.00,
	1100874368.00,
	1100874368.00,
	1100874368.00,
	1100874368.00,
	1100874368.00,
	1100874368.00,
	3196962048.00,
	3196962048.00,
	3196962048.00,
	3196962048.00,
	3196962048.00,
	3196962048.00,
	3196962048.00,
	3196962048.00,
	10016993280.00,
	10016993280.00,
	10016993280.00,
	10016993280.00,
	10016993280.00,
	10016993280.00,
	10016993280.00,
	10016993280.00,
	34020253696.00,
	34020253696.00,
	34020253696.00,
	34020253696.00,
	34020253696.00,
	34020253696.00,
	34020253696.00,
	34020253696.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	124950298624.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00
},{	
	247592464.00,
	3987838.75,
	852584.69,
	372166.75,
	220667.11,
	153016.27,
	116879.30,
	95003.05,
	80489.19,
	70103.16,
	62479.50,
	56720.18,
	52087.99,
	48276.70,
	45158.30,
	42534.13,
	40247.38,
	38347.55,
	36537.39,
	35054.00,
	33630.83,
	32339.82,
	31098.37,
	29973.51,
	28955.93,
	27972.91,
	26961.10,
	26045.79,
	25161.56,
	24307.35,
	23428.13,
	22632.76,
	21814.11,
	20976.72,
	20171.47,
	19397.13,
	18609.62,
	17813.02,
	17089.82,
	16320.66,
	15586.10,
	14884.61,
	14182.00,
	13481.48,
	12845.10,
	12210.62,
	11580.77,
	10983.42,
	9902.33,
	9902.33,
	8907.13,
	8907.13,
	8030.41,
	8030.41,
	7273.40,
	7273.40,
	6633.42,
	6633.42,
	6105.73,
	6105.73,
	5672.02,
	5672.02,
	5330.13,
	5330.13,
	5090.23,
	5090.23,
	4928.76,
	4928.76,
	4849.95,
	4849.95,
	4861.13,
	4861.13,
	4940.12,
	4940.12,
	5101.97,
	5101.97,
	5354.73,
	5354.73,
	5685.09,
	5685.09,
	6091.69,
	6091.69,
	6602.94,
	6602.94,
	7206.72,
	7206.72,
	7902.01,
	7902.01,
	8684.36,
	8684.36,
	9544.16,
	9544.16,
	10489.08,
	10489.08,
	11474.60,
	11474.60,
	13574.93,
	13574.93,
	13574.93,
	13574.93,
	15694.14,
	15694.14,
	15694.14,
	15694.14,
	17690.40,
	17690.40,
	17690.40,
	17690.40,
	19486.67,
	19486.67,
	19486.67,
	19486.67,
	21025.08,
	21025.08,
	21025.08,
	21025.08,
	22373.69,
	22373.69,
	22373.69,
	22373.69,
	23536.27,
	23536.27,
	23536.27,
	23536.27,
	24645.50,
	24645.50,
	24645.50,
	24645.50,
	25747.65,
	25747.65,
	25747.65,
	25747.65,
	26899.09,
	26899.09,
	26899.09,
	26899.09,
	28102.02,
	28102.02,
	28102.02,
	28102.02,
	29494.26,
	29494.26,
	29494.26,
	29494.26,
	31098.37,
	31098.37,
	31098.37,
	31098.37,
	32865.30,
	32865.30,
	32865.30,
	32865.30,
	34973.38,
	34973.38,
	34973.38,
	34973.38,
	37388.46,
	37388.46,
	37388.46,
	37388.46,
	40154.81,
	40154.81,
	40154.81,
	40154.81,
	43424.77,
	43424.77,
	43424.77,
	43424.77,
	47286.54,
	47286.54,
	47286.54,
	47286.54,
	51848.66,
	51848.66,
	51848.66,
	51848.66,
	57113.34,
	57113.34,
	57113.34,
	57113.34,
	63348.68,
	63348.68,
	63348.68,
	63348.68,
	70914.91,
	70914.91,
	70914.91,
	70914.91,
	79935.11,
	79935.11,
	79935.11,
	79935.11,
	103929.20,
	103929.20,
	103929.20,
	103929.20,
	103929.20,
	103929.20,
	103929.20,
	103929.20,
	140196.64,
	140196.64,
	140196.64,
	140196.64,
	140196.64,
	140196.64,
	140196.64,
	140196.64,
	195766.14,
	195766.14,
	195766.14,
	195766.14,
	195766.14,
	195766.14,
	195766.14,
	195766.14,
	284929.63,
	284929.63,
	284929.63,
	284929.63,
	284929.63,
	284929.63,
	284929.63,
	284929.63,
	433249.00,
	433249.00,
	433249.00,
	433249.00,
	433249.00,
	433249.00,
	433249.00,
	433249.00,
	688236.44,
	688236.44,
	688236.44,
	688236.44,
	688236.44,
	688236.44,
	688236.44,
	688236.44,
	1150105.38,
	1150105.38,
	1150105.38,
	1150105.38,
	1150105.38,
	1150105.38,
	1150105.38,
	1150105.38,
	2026457.63,
	2026457.63,
	2026457.63,
	2026457.63,
	2026457.63,
	2026457.63,
	2026457.63,
	2026457.63,
	3782140.25,
	3782140.25,
	3782140.25,
	3782140.25,
	3782140.25,
	3782140.25,
	3782140.25,
	3782140.25,
	7477175.00,
	7477175.00,
	7477175.00,
	7477175.00,
	7477175.00,
	7477175.00,
	7477175.00,
	7477175.00,
	15766581.00,
	15766581.00,
	15766581.00,
	15766581.00,
	15766581.00,
	15766581.00,
	15766581.00,
	15766581.00,
	35541636.00,
	35541636.00,
	35541636.00,
	35541636.00,
	35541636.00,
	35541636.00,
	35541636.00,
	35541636.00,
	86047336.00,
	86047336.00,
	86047336.00,
	86047336.00,
	86047336.00,
	86047336.00,
	86047336.00,
	86047336.00,
	224252560.00,
	224252560.00,
	224252560.00,
	224252560.00,
	224252560.00,
	224252560.00,
	224252560.00,
	224252560.00,
	632029568.00,
	632029568.00,
	632029568.00,
	632029568.00,
	632029568.00,
	632029568.00,
	632029568.00,
	632029568.00,
	1939713920.00,
	1939713920.00,
	1939713920.00,
	1939713920.00,
	1939713920.00,
	1939713920.00,
	1939713920.00,
	1939713920.00,
	6497371136.00,
	6497371136.00,
	6497371136.00,
	6497371136.00,
	6497371136.00,
	6497371136.00,
	6497371136.00,
	6497371136.00,
	23863681024.00,
	23863681024.00,
	23863681024.00,
	23863681024.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	96324681728.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00,
	60776765194240.00
},{	
	15000.00,
	15000.00,
	15000.00,
	15000.00,
	15000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	5000.00,
	15000.00,
	15000.00,
	15000.00,
	15000.00,
	115000.00,
	215000.00,
	315000.00,
	415000.00,
	515000.00,
	615000.00,
	715000.00
	}
};


#endif


// vim:ts=4:sw=4:nowrap: 
