#ifndef _MAC_PCU_H
#define _MAC_PCU_H

#define FIFO_BOUND	1024

#define CLK32_TIMER0		0
#define CLK32_TIMER1		1
#define CLK32_TIMER2		2
#define CLK32_TIMER3		3
#define CLK32_TSF_L32		4
#define CLK32_TSF_U32		5
#define CLK32_SLP1		6
#define CLK32_SLP2		7
#define CLK32_SLP3		8
#define CLK32_QT1		9
#define CLK32_QT2		10
//#define CLK32_TSFCAL		11

//#define CLK_S_SYNC1		0
//#define CLK_S_SYNC6		1
//#define CLK_S_SYNC7		2
//#define CLK_S_SYNC8		3

#define KTYPE_40		0
#define KTYPE_104		1
#define KTYPE_TKIP_NO_MIC	2
#define KTYPE_128		3
#define KTYPE_TKIP		4
//#define KTYPE_AES_OCB		5
#define KTYPE_WAPI              5
#define KTYPE_AES_CCM		6
#define KTYPE_NOTHING		7

//Frame Type in Descriptor
#define TXDESC_FT_NORMAL		0
#define TXDESC_FT_ATIM			1
#define TXDESC_FT_PS_POLL		2
#define TXDESC_FT_BEACON		3
#define TXDESC_FT_PROBE_RESP		4
#define TXDESC_FT_CHIRP			5
#define TXDESC_FT_GROUP_POLL		6
#define TXDESC_FT_DIRECT_POLL		7
//#define TXDESC_FT_SYNC		8
#define TXDESC_FT_BEACON_NO_TSF_UPDATE	9

//Frame Type: Management
#define FTYPE_ASSOCIATION_REQ	0x00
#define FTYPE_ASSOCIATION_RES	0x04
#define FTYPE_REASSOCIATION_REQ	0x08
#define FTYPE_REASSOCIATION_RES	0x0c
#define FTYPE_PBREQ		0x10 // change to TYPE_PROBE_REQ TBD
#define FTYPE_PBRES		0x14 // change to TYPE_PROBE_RES TBD
#define FTYPE_BEACON		0x20
#define FTYPE_ATIM		0x24
#define FTYPE_DISASSOCIATE	0x28
#define FTYPE_AUTHENICATE	0x2c
#define FTYPE_DEAUTHENICATE	0x30

//Frame Type: Control
#define FTYPE_PSPOLL		0x29
#define FTYPE_RTS		0x2d
#define FTYPE_CTS		0x31
#define FTYPE_ACK		0x35
#define FTYPE_CFEND		0x39
#define FTYPE_CFEND_ACK		0x3d		// change to FTYPE_CFEND_ACK TBD

//Frame Type: Data
#define FTYPE_DATA		0x02
#define FTYPE_DATA_CFACK	0x06
#define FTYPE_DATA_CFPOLL	0x0a
#define FTYPE_DATA_CFACK_CFPOLL	0x0e
#define FTYPE_NULL		0x12
#define FTYPE_CFACK		0x16
#define FTYPE_CFPOLL		0x1a
#define FTYPE_CFACK_CFPOLL	0x1e

//Frame Control Fields
#define FCTL_TO_DS	8
#define FCTL_FROM_DS	9
#define FCTL_MORE_FRAG	10
#define FCTL_RETRY	11
#define FCTL_POWER_MGNT	12
#define FCTL_MORE_DATA	13
#define FCTL_WEP	14
#define FCTL_TYPE       3:2

//Rate
#define OFDM_RATE_6Mb		0x0b
#define OFDM_RATE_9Mb		0x0f
#define OFDM_RATE_12Mb		0x0a
#define OFDM_RATE_18Mb		0x0e
#define OFDM_RATE_24Mb		0x09
#define OFDM_RATE_36Mb		0x0d
#define OFDM_RATE_48Mb		0x08
#define OFDM_RATE_54Mb		0x0c
#define CCK_RATE_1Mb_L		0x1b
#define CCK_RATE_2Mb_L		0x1a
#define CCK_RATE_2Mb_S		0x1e
#define CCK_RATE_5_5Mb_L	0x19
#define CCK_RATE_5_5Mb_S	0x1d
#define CCK_RATE_11Mb_L		0x18

#define CCK_RATE_11Mb_S		0x1c
#define XR_RATE_0_25Mb		0x03
#define XR_RATE_0_5Mb		0x07
#define XR_RATE_1Mb		0x02
#define XR_RATE_2Mb		0x06
#define XR_RATE_3Mb		0x01

//Registers
#define PCU_REG		0x0
#define KEY_REG		0x1
#define D2A2_REG	0x3

#define REG_STA_ID0	0x0
#define STA_ADDR_L32	31:0

#define REG_STA_ID1     0x1
#define STA_ADDR_U16	15:0
#define AP		16
#define ADHOC		17
#define PWR_SV		18
#define NO_KEYSRCH	19
#define PCF		20
#define USE_DEF_ANT	21
#define DEF_ANT_UPDATE	22
#define RTS_DEF_ANT	23
#define ACKCTS_6MB 	24
#define RATE_11B 	25
#define SECTOR_SELF_GEN	26
#define CRPT_MIC_ENABLE	27
#define KSRCH_MODE	28
#define PRESERVE_SEQNUM	29
#define CBCIV_ENDIAN    30
#define ADHOC_MCAST_SEARCH 31

#define REG_BSS_ID0	0x2
#define BSSID_L32	31:0

#define REG_BSS_ID1	0x3
#define BSSID_U16	15:0
#define AID		31:16

#define MAC_PCU_REG_BCNRSSI_OFFSET			0x4
#define MAC_PCU_REG_BCNRSSI_BCN_RSSI_AVE_FIELD		11:0
#define MAC_PCU_REG_BCNRSSI_BCN_RSSI_AVE_RESET		0x800

#define REG_TIME_OUT	0x5
#define ACK_TIME_OUT	15:0
#define CTS_TIME_OUT	31:16

#define MAC_PCU_REG_BCNSIG_OFFSET			0x6
#define MAC_PCU_REG_BCNSIG_BCN_RSSI_LO_THR_FIELD	7:0
#define MAC_PCU_REG_BCNSIG_BCN_MISS_THR_FIELD		15:8
#define MAC_PCU_REG_BCNSIG_BCN_RSSI_HI_THR_FIELD	23:16
#define MAC_PCU_REG_BCNSIG_BCN_RSSI_WEIGHT_FIELD	28:24
#define MAC_PCU_REG_BCNSIG_BCN_RSSI_RESET_FIELD		29
#define MAC_PCU_REG_BCNSIG_BCN_RSSI_LO_THR_RESET	0
#define MAC_PCU_REG_BCNSIG_BCN_MISS_THR_RESET		0xFF
#define MAC_PCU_REG_BCNSIG_BCN_RSSI_HI_THR_RESET	0x7F
#define MAC_PCU_REG_BCNSIG_BCN_RSSI_WEIGHT_RESET	0

#define REG_USEC	0x7
#define USEC		6:0
#define USEC32		13:7
#define TX_DELAY	18:14
#define RX_DELAY	24:19

#define REG_BEACON	0x8
#define BEACON_PERIOD	15:0
#define TIM_OFFSET	22:16
#define RESET_TSF	24

#define REG_CFP_PERIOD	0x9

#define REG_TIMER0	0xa

#define REG_TIMER1	0xb

#define REG_TIMER2	0xc

#define REG_TIMER3	0xd

#define REG_CFP_DUR	0xe

#define REG_RX_FILTER	0xf
#define UNICAST		0
#define MULTICAST	1
#define BROADCAST	2
#define CONTROL		3
#define BEACON		4
#define PROMISCUOUS	5
#define XR_POLL		6
#define PROBE_REQ	7
//#define SYNC		8
#define MY_BEACON	9
	
#define REG_MCAST_FIL0	0x10

#define REG_MCAST_FIL1	0x11

#define MAC_PCU_REG_DIAGSW_OFFSET			0x12
#define MAC_PCU_REG_DIAGSW_DIS_WEP_ACK_FIELD		0
#define MAC_PCU_REG_DIAGSW_DIS_ACK_FIELD		1
#define MAC_PCU_REG_DIAGSW_DIS_CTS_FIELD		2
#define MAC_PCU_REG_DIAGSW_DIS_ENC_FIELD		3
#define MAC_PCU_REG_DIAGSW_DIS_DEC_FIELD		4
#define MAC_PCU_REG_DIAGSW_DIS_RX_FIELD			5
#define MAC_PCU_REG_DIAGSW_LOOP_BACK_FIELD		6
#define MAC_PCU_REG_DIAGSW_CORR_FCS_FIELD		7
#define MAC_PCU_REG_DIAGSW_CHAN_INFO_FIELD		8
#define MAC_PCU_REG_DIAGSW_RESERVED_FIELD		16:9
#define MAC_PCU_REG_DIAGSW_ACCEPT_NONV0_FIELD		17
#define MAC_PCU_REG_DIAGSW_OBS_SEL_0_1_FIELD		19:18
#define MAC_PCU_REG_DIAGSW_RXCLR_HIGH_FIELD		20
#define MAC_PCU_REG_DIAGSW_IGNORE_NAV_FIELD		21
#define MAC_PCU_REG_DIAGSW_CHANIDLE_HIGH_FIELD		22
#define MAC_PCU_REG_DIAGSW_PHYERR_ENABLE_NEW_FIELD	23
#define MAC_PCU_REG_DIAGSW_DUAL_CHAIN_CHAN_INFO_FIELD	24
#define MAC_PCU_REG_DIAGSW_FORCE_RX_ABORT_FIELD		25
#define MAC_PCU_REG_DIAGSW_SATURATE_CYCLE_CNT_FIELD	26
#define MAC_PCU_REG_DIAGSW_OBS_SEL_2_FIELD		27
#define MAC_PCU_REG_DIAGSW_DIS_WEP_ACK_RESET		0
#define MAC_PCU_REG_DIAGSW_DIS_ACK_RESET		0
#define MAC_PCU_REG_DIAGSW_DIS_CTS_RESET		0
#define MAC_PCU_REG_DIAGSW_DIS_ENC_RESET		0
#define MAC_PCU_REG_DIAGSW_DIS_DEC_RESET		0
#define MAC_PCU_REG_DIAGSW_DIS_RX_RESET			0
#define MAC_PCU_REG_DIAGSW_LOOP_BACK_RESET		0
#define MAC_PCU_REG_DIAGSW_CORR_FCS_RESET		0
#define MAC_PCU_REG_DIAGSW_CHAN_INFO_RESET		0
#define MAC_PCU_REG_DIAGSW_RESERVED_RESET		0
#define MAC_PCU_REG_DIAGSW_ACCEPT_NONV0_RESET		0
#define MAC_PCU_REG_DIAGSW_OBS_SEL_0_1_RESET		0
#define MAC_PCU_REG_DIAGSW_RXCLR_HIGH_RESET		0
#define MAC_PCU_REG_DIAGSW_IGNORE_NAV_RESET		0
#define MAC_PCU_REG_DIAGSW_CHANIDLE_HIGH_RESET		0
#define MAC_PCU_REG_DIAGSW_PHYERR_ENABLE_NEW_RESET	0 
#define MAC_PCU_REG_DIAGSW_DUAL_CHAIN_CHAN_INFO_RESET	0
#define MAC_PCU_REG_DIAGSW_FORCE_RX_ABORT_RESET		0
#define MAC_PCU_REG_DIAGSW_SATURATE_CYCLE_CNT_RESET	0
#define MAC_PCU_REG_DIAGSW_OBS_SEL_2_RESET		0

#define REG_TSF_L32	0x13

#define REG_TSF_U32	0x14

#define REG_TST_ADDAC	0x15
#define TEST_MODE	0
#define TEST_LOOP	1
#define LOOP_LEN	12:2
#define TEST_UPPER_8B	13
#define TEST_MSB	14
#define TEST_CAPTURE	15

#define REG_DEF_ANT 	0x16

#define MAC_PCU_REG_MUTE_MASKS0_OFFSET			0x17
#define MAC_PCU_REG_MUTE_MASKS0_FC_FIELD		15:0
#define MAC_PCU_REG_MUTE_MASKS0_QOS_FIELD		31:16
#define MAC_PCU_REG_MUTE_MASKS0_FC_RESET		0xC7FF
#define MAC_PCU_REG_MUTE_MASKS0_QOS_RESET		0xFFFF

#define MAC_PCU_REG_MUTE_MASKS1_OFFSET			0x18
#define MAC_PCU_REG_MUTE_MASKS1_SEQ_FIELD		15:0
#define MAC_PCU_REG_MUTE_MASKS1_FC_MGMT_FIELD		31:16
#define MAC_PCU_REG_MUTE_MASKS1_SEQ_RESET		0x000F
#define MAC_PCU_REG_MUTE_MASKS1_FC_MGMT_RESET		0xE7FF

#define MAC_PCU_REG_GATED_CLKS_OFFSET			0x19
//#define MAC_PCU_REG_GATED_SYNC_FIELD			0
#define MAC_PCU_REG_GATED_TX_FIELD			1
#define MAC_PCU_REG_GATED_RX_FIELD			2
#define MAC_PCU_REG_GATED_REG_FIELD			3
//#define MAC_PCU_REG_GATED_SYNC_RESET			0x1
#define MAC_PCU_REG_GATED_TX_RESET			0x0
#define MAC_PCU_REG_GATED_RX_RESET			0x0
#define MAC_PCU_REG_GATED_REG_RESET			0x0

#define MAC_PCU_REG_OBS2_OFFSET				0x1a
#define MAC_PCU_REG_OBS2_OBS_BUS_FIELD			17:0

#define MAC_PCU_REG_OBS1_OFFSET				0x1b
#define MAC_PCU_REG_OBS1_TX_STATE_FIELD			28:24
#define MAC_PCU_REG_OBS1_RX_STATE_FIELD			23:20
#define MAC_PCU_REG_OBS1_WEP_STATE_FIELD		17:12
#define MAC_PCU_REG_OBS1_RX_CLEAR_FIELD			11
#define MAC_PCU_REG_OBS1_RX_FRAME_FIELD			10
#define MAC_PCU_REG_OBS1_TX_FRAME_FIELD			9
#define MAC_PCU_REG_OBS1_TX_HOLD_FIELD			8
#define MAC_PCU_REG_OBS1_CHAN_IDLE_FIELD		7
#define MAC_PCU_REG_OBS1_QUIET_TIME_FIELD		6
#define MAC_PCU_REG_OBS1_TX_HCF_FIELD			5
#define MAC_PCU_REG_OBS1_FILTER_PASS_FIELD		4
#define MAC_PCU_REG_OBS1_RX_MY_BEACON_FIELD		3
#define MAC_PCU_REG_OBS1_RX_WEP_FIELD			2
#define MAC_PCU_REG_OBS1_PCU_RX_END_FIELD		1
#define MAC_PCU_REG_OBS1_PCU_DIRECTED_FIELD		0

#define REG_LAST_TSTP	0x20

#define REG_NAV		0x21

#define REG_RTS_OK	0x22

#define REG_RTS_FAIL	0x23

#define REG_ACK_FAIL	0x24

#define REG_FCS_FAIL	0x25

#define REG_BEACON_CNT	0x26

#define MAC_PCU_REG_XRMODE_OFFSET			0x30
#define MAC_PCU_REG_XRMODE_XR_POLL_TYPE_FIELD		5:0
#define MAC_PCU_REG_XRMODE_XR_WAIT_FOR_POLL_FIELD	7
#define MAC_PCU_REG_XRMODE_XR_FRAME_HOLD_FIELD		31:20
#define MAC_PCU_REG_XRMODE_XR_POLL_TYPE_RESET		0x1A
#define MAC_PCU_REG_XRMODE_XR_WAIT_FOR_POLL_RESET	0x0
#define MAC_PCU_REG_XRMODE_XR_FRAME_HOLD_RESET		680

#define MAC_PCU_REG_XRDEL_OFFSET			0x31
#define MAC_PCU_REG_XRDEL_XR_SLOT_DELAY_FIELD		15:0
#define MAC_PCU_REG_XRDEL_XR_CHIRP_DATA_DELAY_FIELD	31:16
#define MAC_PCU_REG_XRDEL_XR_SLOT_DELAY_RESET		360
#define MAC_PCU_REG_XRDEL_XR_CHIRP_DATA_DELAY_RESET	1680

#define MAC_PCU_REG_XRTO_OFFSET				0x32
#define MAC_PCU_REG_XRTO_XR_CHIRP_TIMEOUT_FIELD		15:0
#define MAC_PCU_REG_XRTO_XR_POLL_TIMEOUT_FIELD		31:16
#define MAC_PCU_REG_XRTO_XR_CHIRP_TIMEOUT_RESET		7200
#define MAC_PCU_REG_XRTO_XR_POLL_TIMEOUT_RESET		5000

#define MAC_PCU_REG_XRCRP_OFFSET			0x33
#define MAC_PCU_REG_XRCRP_XR_SEND_CHIRP_FIELD		0
#define MAC_PCU_REG_XRCRP_XR_CHIRP_GAP_FIELD		31:16
#define MAC_PCU_REG_XRCRP_XR_SEND_CHIRP_RESET		0x0
#define MAC_PCU_REG_XRCRP_XR_CHIRP_GAP_RESET		500

#define MAC_PCU_REG_XRSTMP_OFFSET			0x34
#define MAC_PCU_REG_XRSTMP_RX_ABORT_RSSI_FIELD		0
#define MAC_PCU_REG_XRSTMP_RX_ABORT_BSSID_FIELD		1
#define MAC_PCU_REG_XRSTMP_TX_STOMP_RSSI_FIELD		2
#define MAC_PCU_REG_XRSTMP_TX_STOMP_BSSID_FIELD		3
#define MAC_PCU_REG_XRSTMP_TX_STOMP_DATA_FIELD		4
#define MAC_PCU_REG_XRSTMP_RX_ABORT_DATA_FIELD		5
#define MAC_PCU_REG_XRSTMP_TX_STOMP_RSSI_THRESH_FIELD	15:8
#define MAC_PCU_REG_XRSTMP_RX_ABORT_RSSI_THRESH_FIELD	23:16
#define MAC_PCU_REG_XRSTMP_RX_ABORT_RSSI_RESET		0x0
#define MAC_PCU_REG_XRSTMP_RX_ABORT_BSSID_RESET		0x0
#define MAC_PCU_REG_XRSTMP_TX_STOMP_RSSI_RESET		0x0
#define MAC_PCU_REG_XRSTMP_TX_STOMP_BSSID_RESET		0x0
#define MAC_PCU_REG_XRSTMP_TX_STOMP_DATA_RESET		0x0
#define MAC_PCU_REG_XRSTMP_RX_ABORT_DATA_RESET		0x0
#define MAC_PCU_REG_XRSTMP_TX_STOMP_RSSI_THRESH_RESET	0x25
#define MAC_PCU_REG_XRSTMP_RX_ABORT_RSSI_THRESH_RESET	0x25

#define MAC_PCU_REG_SLP1_OFFSET				0x35
//#define MAC_PCU_REG_SLP1_NEXT_DTIM_FIELD		18:0
#define MAC_PCU_REG_SLP1_CAB_TIMEOUT_EXT_FIELD		4:0
#define MAC_PCU_REG_SLP1_ASSUME_DTIM_FIELD		19
//#define MAC_PCU_REG_SLP1_ENH_SLEEP_ENABLE_FIELD	20
#define MAC_PCU_REG_SLP1_CAB_TIMEOUT_FIELD		31:21
// #define MAC_PCU_REG_SLP1_NEXT_DTIM_RESET		0x2aaaa
#define MAC_PCU_REG_SLP1_CAB_TIMEOUT_EXT_RESET		0x0
#define MAC_PCU_REG_SLP1_ASSUME_DTIM_RESET		0x0
//#define MAC_PCU_REG_SLP1_ENH_SLEEP_ENABLE_RESET	0x1
#define MAC_PCU_REG_SLP1_CAB_TIMEOUT_RESET		5

#define MAC_PCU_REG_SLP2_OFFSET				0x36
//#define MAC_PCU_REG_SLP2_NEXT_TIM_FIELD		18:0
#define MAC_PCU_REG_SLP2_BEACON_TIMEOUT_EXT_FIELD	4:0
#define MAC_PCU_REG_SLP2_BEACON_TIMEOUT_FIELD		31:21
//#define MAC_PCU_REG_SLP2_NEXT_TIM_RESET		0x55555
#define MAC_PCU_REG_SLP2_BEACON_TIMEOUT_EXT_RESET	0x0
#define MAC_PCU_REG_SLP2_BEACON_TIMEOUT_RESET		2

//#define MAC_PCU_REG_SLP3_OFFSET			0x37
//#define MAC_PCU_REG_SLP3_TIM_PERIOD_FIELD		15:0
//#define MAC_PCU_REG_SLP3_DTIM_PERIOD_FIELD		31:16
//#define MAC_PCU_REG_SLP3_TIM_PERIOD_RESET		2
//#define MAC_PCU_REG_SLP3_DTIM_PERIOD_RESET		3

#define MAC_PCU_REG_BSSMSKL_OFFSET			0x38
#define MAC_PCU_REG_BSSMSKL_BSSID_MASK_L_FIELD		31:0
#define MAC_PCU_REG_BSSMSKL_BSSID_MASK_L_RESET		0xFFFFFFFF

#define MAC_PCU_REG_BSSMSKH_OFFSET			0x39
#define MAC_PCU_REG_BSSMSKH_BSSID_MASK_H_FIELD		15:0
#define MAC_PCU_REG_BSSMSKH_BSSID_MASK_H_RESET		0xFFFF

#define MAC_PCU_REG_TPC_OFFSET				0x3A
#define MAC_PCU_REG_TPC_ACK_PWR_FIELD			5:0
#define MAC_PCU_REG_TPC_CTS_PWR_FIELD			13:8
#define MAC_PCU_REG_TPC_CHIRP_PWR_FIELD			21:16
#define MAC_PCU_REG_TPC_ACK_PWR_RESET			0x3f
#define MAC_PCU_REG_TPC_CTS_PWR_RESET			0x3f
#define MAC_PCU_REG_TPC_CHIRP_PWR_RESET			0x3f

#define MAC_PCU_REG_TFC_OFFSET				0x3B
#define MAC_PCU_REG_TFC_TX_FRAME_CNT_FIELD		31:0
#define MAC_PCU_REG_TFC_TX_FRAME_CNT_RESET		0

#define MAC_PCU_REG_RFC_OFFSET				0x3C
#define MAC_PCU_REG_RFC_RX_FRAME_CNT_FIELD		31:0
#define MAC_PCU_REG_RFC_RX_FRAME_CNT_RESET		0

#define MAC_PCU_REG_RCC_OFFSET				0x3D
#define MAC_PCU_REG_RCC_RX_CLEAR_CNT_FIELD		31:0
#define MAC_PCU_REG_RCC_RX_CLEAR_CNT_RESET		0

#define MAC_PCU_REG_CC_OFFSET				0x3E
#define MAC_PCU_REG_CC_CYCLE_CNT_FIELD			31:0
#define MAC_PCU_REG_CC_CYCLE_CNT_RESET			0

#define MAC_PCU_REG_QT1_OFFSET				0x3F
#define MAC_PCU_REG_QT1_NEXT_QUIET_FIELD		15:0
#define MAC_PCU_REG_QT1_QUIET_ENABLE_FIELD		16
#define MAC_PCU_REG_QT1_QUIET_ACK_CTS_ENABLE_FIELD	17
#define MAC_PCU_REG_QT1_NEXT_QUIET_RESET		0
#define MAC_PCU_REG_QT1_QUIET_ENABLE_RESET		0x0
#define MAC_PCU_REG_QT1_QUIET_ACK_CTS_ENABLE_RESET	0x1

#define MAC_PCU_REG_QT2_OFFSET				0x40
#define MAC_PCU_REG_QT2_QUIET_PERIOD_FIELD		15:0
#define MAC_PCU_REG_QT2_QUIET_DURATION_FIELD		31:16
#define MAC_PCU_REG_QT2_QUIET_PERIOD_RESET		0002
#define MAC_PCU_REG_QT2_QUIET_DURATION_RESET		0001

#define MAC_PCU_REG_TSF_OFFSET				0x41
#define MAC_PCU_REG_TSF_INCREMENT_FIELD			7:0
#define MAC_PCU_REG_TSF_INCREMENT_RESET			0x01

#define MAC_PCU_REG_NOACK_OFFSET			0x42
#define MAC_PCU_REG_NOACK_2_BIT_VALUES_FIELD		3:0
#define MAC_PCU_REG_NOACK_BIT_OFFSET_FIELD		6:4
#define MAC_PCU_REG_NOACK_BYTE_OFFSET_FIELD		8:7
#define MAC_PCU_REG_NOACK_2_BIT_VALUES_RESET		0x2
#define MAC_PCU_REG_NOACK_BIT_OFFSET_RESET		0x5
#define MAC_PCU_REG_NOACK_BYTE_OFFSET_RESET		0x0

#define MAC_PCU_REG_PHYERR_OFFSET			0x43
#define MAC_PCU_REG_PHYERR_MASK_FIELD			31:0
#define MAC_PCU_REG_PHYERR_MASK_RESET			0x0

#define MAC_PCU_REG_XRLAT_OFFSET			0x44
#define MAC_PCU_REG_XRLAT_XR_TX_DELAY_FIELD		11:0
#define MAC_PCU_REG_XRLAT_XR_TX_DELAY_RESET		0x168

#define MAC_PCU_REG_ACKSIFS_OFFSET_RESERVED		0x45
#define MAC_PCU_REG_ACKSIFS_INCREMENT_FIELD_RESERVED	7:0
#define MAC_PCU_REG_ACKSIFS_INCREMENT_RESET_RESERVED	0x0

#define MAC_PCU_REG_MICQOSCTL_OFFSET			0x46
#define MAC_PCU_REG_MICQOSCTL_FIELD			15:0
#define MAC_PCU_REG_MICQOSCTL_ENABLE_FIELD		16
#define MAC_PCU_REG_MICQOSCTL_RESET			0x00aa
#define MAC_PCU_REG_MICQOSCTL_ENABLE_RESET		0x1

#define MAC_PCU_REG_MICQOSSEL_OFFSET			0x47
#define MAC_PCU_REG_MICQOSSEL_FIELD			31:0
#define MAC_PCU_REG_MICQOSSEL_RESET			0x00003210

#define MAC_PCU_REG_MISCMODE_OFFSET			0x48
#define MAC_PCU_REG_MISCMODE_BSSID_MATCH_FORCE_FIELD	0
#define MAC_PCU_REG_MISCMODE_ACKSIFS_MEMORY_FIELD_RESERVED	1
#define MAC_PCU_REG_MISCMODE_MIC_NEW_LOCATION_FIELD	2
#define MAC_PCU_REG_MISCMODE_TX_ADD_TSF_FIELD		3
#define MAC_PCU_REG_MISCMODE_CCK_SIFS_MODE_FIELD	4
#define MAC_PCU_REG_MISCMODE_BFCOEF_MODE_FIELD_RESERVED		5
#define MAC_PCU_REG_MISCMODE_BFCOEF_ENABLE_FIELD	6
#define MAC_PCU_REG_MISCMODE_BFCOEF_UPDATE_SELF_GEN_FIELD	7
#define MAC_PCU_REG_MISCMODE_BFCOEF_MCAST_FIELD		8
#define MAC_PCU_REG_MISCMODE_DUAL_CHAIN_ANT_MODE_FIELD	9
#define MAC_PCU_REG_MISCMODE_FALCON_DESC_MODE_FIELD	10
#define MAC_PCU_REG_MISCMODE_KC_RX_ANT_UPDATE_FIELD	11
#define MAC_PCU_REG_MISCMODE_TXOP_TBTT_LIMIT_FIELD	12
#define MAC_PCU_REG_MISCMODE_FALCON_BB_INTERFACE_FIELD	13
#define MAC_PCU_REG_MISCMODE_MISS_BEACON_IN_SLEEP_FIELD	14
#define MAC_PCU_REG_MISCMODE_BUG_12306_FIX_ENABLE_FIELD	17
#define MAC_PCU_REG_MISCMODE_FORCE_QUIET_COLLISION_FIELD 18
#define MAC_PCU_REG_MISCMODE_BUG_12549_FORCE_TXBF_FIELD	19
#define MAC_PCU_REG_MISCMODE_BT_ANT_PREVENTS_RX_FIELD	20
#define MAC_PCU_REG_MISCMODE_TBTT_PROTECT_FIELD		21
#define MAC_PCU_REG_MISCMODE_HCF_POLL_CANCELS_NAV_FIELD	22
#define MAC_PCU_REG_MISCMODE_RX_HCF_POLL_ENABLE_FIELD	23
#define MAC_PCU_REG_MISCMODE_CLEAR_VMF_FIELD		24
#define MAC_PCU_REG_MISCMODE_CLEAR_FIRST_HCF_FIELD	25
#define MAC_PCU_REG_MISCMODE_ADHOC_MCAST_KEYID_ENABLE_FIELD 26
#define MAC_PCU_REG_MISCMODE_ALLOW_RAC_FIELD                27
#define MAC_PCU_REG_MISCMODE_BSSID_MATCH_FORCE_RESET	0x0
#define MAC_PCU_REG_MISCMODE_ACKSIFS_MEMORY_RESET_RESERVED	0x0
#define MAC_PCU_REG_MISCMODE_MIC_NEW_LOCATION_RESET	0x0
#define MAC_PCU_REG_MISCMODE_TX_ADD_TSF_RESET		0x0
#define MAC_PCU_REG_MISCMODE_CCK_SIFS_MODE_RESET	0x0
#define MAC_PCU_REG_MISCMODE_BFCOEF_MODE_RESET_RESERVED		0x0
#define MAC_PCU_REG_MISCMODE_BFCOEF_ENABLE_RESET	0x0
#define MAC_PCU_REG_MISCMODE_BFCOEF_UPDATE_SELF_GEN_RESET	0x1
#define MAC_PCU_REG_MISCMODE_BFCOEF_MCAST_RESET		0x1
#define MAC_PCU_REG_MISCMODE_DUAL_CHAIN_ANT_MODE_RESET	0x0
#define MAC_PCU_REG_MISCMODE_FALCON_DESC_MODE_RESET	0x0
#define MAC_PCU_REG_MISCMODE_KC_RX_ANT_UPDATE_RESET	0x1
#define MAC_PCU_REG_MISCMODE_TXOP_TBTT_LIMIT_RESET	0x0
#define MAC_PCU_REG_MISCMODE_FALCON_BB_INTERFACE_RESET	0x0
#define MAC_PCU_REG_MISCMODE_MISS_BEACON_IN_SLEEP_RESET	0x1
#define MAC_PCU_REG_MISCMODE_BUG_12306_FIX_ENABLE_RESET	0x1
#define MAC_PCU_REG_MISCMODE_FORCE_QUIET_COLLISION_RESET 0x0
#define MAC_PCU_REG_MISCMODE_BUG_12549_FORCE_TXBF_RESET	0x0
#define MAC_PCU_REG_MISCMODE_BT_ANT_PREVENTS_RX_RESET	0x1
#define MAC_PCU_REG_MISCMODE_TBTT_PROTECT_RESET		0x1
#define MAC_PCU_REG_MISCMODE_HCF_POLL_CANCELS_NAV_RESET	0x1
#define MAC_PCU_REG_MISCMODE_RX_HCF_POLL_ENABLE_RESET	0x1
#define MAC_PCU_REG_MISCMODE_CLEAR_VMF_RESET		0x0
#define MAC_PCU_REG_MISCMODE_CLEAR_FIRST_HCF_RESET	0x0
#define MAC_PCU_REG_MISCMODE_ADHOC_MCAST_KEYID_ENABLE_RESET 0x0
#define MAC_PCU_REG_MISCMODE_ALLOW_RAC_RESET            0x0

#define MAC_PCU_REG_FILTOFDM_OFFSET			0x49
#define MAC_PCU_REG_FILTOFDM_CNT_FIELD			23:0
#define MAC_PCU_REG_FILTOFDM_CNT_RESET			0x0

#define MAC_PCU_REG_FILTCCK_OFFSET			0x4A
#define MAC_PCU_REG_FILTCCK_CNT_FIELD			23:0
#define MAC_PCU_REG_FILTCCK_CNT_RESET			0x0

#define MAC_PCU_REG_PHYCNT1_OFFSET			0x4B
#define MAC_PCU_REG_PHYCNT1_FIELD			23:0
#define MAC_PCU_REG_PHYCNT1_RESET			0x0

#define MAC_PCU_REG_PHYCNTMASK1_OFFSET			0x4C
#define MAC_PCU_REG_PHYCNTMASK1_FIELD			31:0
#define MAC_PCU_REG_PHYCNTMASK1_RESET			0x0

#define MAC_PCU_REG_PHYCNT2_OFFSET			0x4D
#define MAC_PCU_REG_PHYCNT2_FIELD			23:0
#define MAC_PCU_REG_PHYCNT2_RESET			0x0

#define MAC_PCU_REG_PHYCNTMASK2_OFFSET			0x4E
#define MAC_PCU_REG_PHYCNTMASK2_FIELD			31:0
#define MAC_PCU_REG_PHYCNTMASK2_RESET			0x0

#define MAC_PCU_REG_TSFTHRESH_OFFSET			0x4F
#define MAC_PCU_REG_TSFTHRESH_FIELD			15:0
#define MAC_PCU_REG_TSFTHRESH_RESET			0xFFFF

//#define MAC_PCU_REG_TSFCAL_OFFSET			0x50
//#define MAC_PCU_REG_TSFCAL_COUNT_FIELD			3:0
//#define MAC_PCU_REG_TSFCAL_INTERVAL_FIELD		7:4
//#define MAC_PCU_REG_TSFCAL_ENABLE_FIELD			8	
//#define MAC_PCU_REG_TSFCAL_AUTO_CAL_FIELD		9
//#define MAC_PCU_REG_TSFCAL_VALUE_WE_FIELD		10
//#define MAC_PCU_REG_TSFCAL_VALUE_FIELD			31:16	
//#define MAC_PCU_REG_TSFCAL_COUNT_RESET			0x8
//#define MAC_PCU_REG_TSFCAL_INTERVAL_RESET		0xa
//#define MAC_PCU_REG_TSFCAL_ENABLE_RESET			0x1
//#define MAC_PCU_REG_TSFCAL_AUTO_CAL_RESET		0x1
//#define MAC_PCU_REG_TSFCAL_VALUE_WE_RESET		0x0
//#define MAC_PCU_REG_TSFCAL_VALUE_RESET			0x8000

#define MAC_PCU_REG_PHYERR_EIFS_OFFSET			0x51
#define MAC_PCU_REG_PHYERR_EIFS_MASK_FIELD		31:0
#define MAC_PCU_REG_PHYERR_EIFS_MASK_RESET		0x0

//#define MAC_PCU_REG_SYNC1_OFFSET			0x52
//#define MAC_PCU_REG_SYNC1_TIME_FIELD			30:0
//#define MAC_PCU_REG_SYNC1_TIME_RESET			0x0

//#define MAC_PCU_REG_SYNC2_OFFSET			0x53
//#define MAC_PCU_REG_SYNC2_TIME_OFFSET_FIELD		7:0
//#define MAC_PCU_REG_SYNC2_MASTER_FIELD			8
//#define MAC_PCU_REG_SYNC2_REPLACE_FIELD			9
//#define MAC_PCU_REG_SYNC2_TUNE_FIELD			10
//#define MAC_PCU_REG_SYNC2_CLEAR_FIELD			11
//#define MAC_PCU_REG_SYNC2_INTR_THRESH_FIELD		31:16
//#define MAC_PCU_REG_SYNC2_TIME_OFFSET_RESET		0x0
//#define MAC_PCU_REG_SYNC2_MASTER_RESET			0x0
//#define MAC_PCU_REG_SYNC2_REPLACE_RESET			0x0
//#define MAC_PCU_REG_SYNC2_TUNE_RESET			0x0
//#define MAC_PCU_REG_SYNC2_CLEAR_RESET			0x0
//#define MAC_PCU_REG_SYNC2_INTR_THRESH_RESET		0xFFFF

//#define MAC_PCU_REG_SYNC3_OFFSET			0x54
//#define MAC_PCU_REG_SYNC3_MCAST_ADDR_L_FIELD		31:0
//#define MAC_PCU_REG_SYNC3_MCAST_ADDR_L_RESET		0x0

//#define MAC_PCU_REG_SYNC4_OFFSET			0x55
//#define MAC_PCU_REG_SYNC4_MCAST_ADDR_U_FIELD		15:0
//#define MAC_PCU_REG_SYNC4_MCAST_ADDR_U_RESET		0x0

//#define MAC_PCU_REG_SYNC5_OFFSET			0x56
//#define MAC_PCU_REG_SYNC5_RX_TIME_FIELD			30:0

//#define MAC_PCU_REG_SYNC6_OFFSET			0x57
//#define MAC_PCU_REG_SYNC6_INC_FIELD			31:0

//#define MAC_PCU_REG_SYNC7_OFFSET			0x58
//#define MAC_PCU_REG_SYNC7_LAST_TIME_FIELD		30:0

//#define MAC_PCU_REG_SYNC8_OFFSET			0x59
//#define MAC_PCU_REG_SYNC8_UPDATED_TIME_FIELD		30:0

#define MAC_PCU_REG_PHYCNT3_OFFSET			0x5A
#define MAC_PCU_REG_PHYCNT3_FIELD			23:0
#define MAC_PCU_REG_PHYCNT3_RESET			0x0

#define MAC_PCU_REG_PHYCNTMASK3_OFFSET			0x5B
#define MAC_PCU_REG_PHYCNTMASK3_FIELD			31:0
#define MAC_PCU_REG_PHYCNTMASK3_RESET			0x0

#define MAC_PCU_REG_BTMODE_OFFSET			0x5C
#define MAC_PCU_REG_BTMODE_TIME_EXTEND_FIELD		7:0
#define MAC_PCU_REG_BTMODE_TXSTATE_EXTEND_FIELD		8
#define MAC_PCU_REG_BTMODE_TX_FRAME_EXTEND_FIELD	9
#define MAC_PCU_REG_BTMODE_MODE_FIELD			11:10
#define MAC_PCU_REG_BTMODE_QUIET_FIELD			12
#define MAC_PCU_REG_BTMODE_QCU_THRESH_FIELD		16:13
#define MAC_PCU_REG_BTMODE_RX_CLEAR_POLARITY_FIELD	17
#define MAC_PCU_REG_BTMODE_PRIORITY_TIME_FIELD		23:18
#define MAC_PCU_REG_BTMODE_FIRST_SLOT_TIME_FIELD	31:24
#define MAC_PCU_REG_BTMODE_TIME_EXTEND_RESET		0x20
#define MAC_PCU_REG_BTMODE_TXSTATE_EXTEND_RESET		0x1
#define MAC_PCU_REG_BTMODE_TX_FRAME_EXTEND_RESET	0x1
#define MAC_PCU_REG_BTMODE_MODE_RESET			0x3
#define MAC_PCU_REG_BTMODE_QUIET_RESET			0x1
#define MAC_PCU_REG_BTMODE_QCU_THRESH_RESET		0x1
#define MAC_PCU_REG_BTMODE_RX_CLEAR_POLARITY_RESET	0x0
#define MAC_PCU_REG_BTMODE_PRIORITY_TIME_RESET		0x05
#define MAC_PCU_REG_BTMODE_FIRST_SLOT_TIME_RESET	0x9B

#define MAC_PCU_REG_BTWEIGHT_OFFSET			0x5D
#define MAC_PCU_REG_BTWEIGHT_BT_WEIGHT_FIELD		15:0
#define MAC_PCU_REG_BTWEIGHT_WL_WEIGHT_FIELD		31:16
#define MAC_PCU_REG_BTWEIGHT_BT_WEIGHT_RESET		0xFA50
#define MAC_PCU_REG_BTWEIGHT_WL_WEIGHT_RESET		0xFAA4 

#define MAC_PCU_REG_HCF_OFFSET				0x5E
#define MAC_PCU_REG_HCF_TIMEOUT_FIELD			15:0
#define MAC_PCU_REG_HCF_TIMEOUT_RESET			0x100

#define MAC_PCU_REG_BTMODE2_OFFSET			0x5F
#define MAC_PCU_REG_BTMODE2_BT_BCN_MISS_THRESH_FIELD	7:0
#define MAC_PCU_REG_BTMODE2_BCN_MISS_CNT_FIELD		15:8
#define MAC_PCU_REG_BTMODE2_BT_HOLD_RX_CLEAR_FIELD	16
#define MAC_PCU_REG_BTMODE2_WL_CONTROL_ANT_FIELD	17
#define MAC_PCU_REG_BTMODE2_RESPOND_TO_BT_ACTIVE_FIELD	18
#define MAC_PCU_REG_BTMODE2_PROTECT_BT_AFTER_WAKEUP_FIELD	19
#define MAC_PCU_REG_BTMODE2_DISABLE_BT_ANT_FIELD	20
#define MAC_PCU_REG_BTMODE2_BT_BCN_MISS_THRESH_RESET	0
#define MAC_PCU_REG_BTMODE2_BT_HOLD_RX_CLEAR_RESET	0
#define MAC_PCU_REG_BTMODE2_WL_CONTROL_ANT_RESET	0x0
#define MAC_PCU_REG_BTMODE2_RESPOND_TO_BT_ACTIVE_RESET	0x0
#define MAC_PCU_REG_BTMODE2_PROTECT_BT_AFTER_WAKEUP_RESET	0x0
#define MAC_PCU_REG_BTMODE2_DISABLE_BT_ANT_RESET	0x0

#define MAC_PCU_REG_BFCOEF1_OFFSET			0x60
#define MAC_PCU_REG_BFCOEF1_UPPER_OFFSET		0x67
#define MAC_PCU_REG_BFCOEF1_KEY_VALID_FIELD		31
#define MAC_PCU_REG_BFCOEF1_KEYIDX_FIELD		30:24
#define MAC_PCU_REG_BFCOEF1_TSF_FIELD			23:0
#define MAC_PCU_REG_BFCOEF1_KEY_VALID_RESET		0x0

#define MAC_PCU_REG_BFCOEF2_OFFSET			0x70
#define MAC_PCU_REG_BFCOEF2_THRESH_FIELD		22:0
#define MAC_PCU_REG_BFCOEF2_LOCK_FIELD			31:24
#define MAC_PCU_REG_BFCOEF2_THRESH_RESET		0x0
#define MAC_PCU_REG_BFCOEF2_LOCK_RESET			0x0

#define MAC_PCU_REG_KCMASK_OFFSET			0x71
#define MAC_PCU_REG_KCMASK_47_32_FIELD			15:0
#define MAC_PCU_REG_KCMASK_47_32_RESET			0
#define MAC_PCU_REG_KCMASK_31_0_FIELD			16
#define MAC_PCU_REG_KCMASK_31_0_RESET			0

#define MAC_PCU_REG_TXSIFS_OFFSET			0x74
#define MAC_PCU_REG_TXSIFS_SIFS_TIME_FIELD		7:0
#define MAC_PCU_REG_TXSIFS_TX_LATENCY_FIELD		11:8
#define MAC_PCU_REG_TXSIFS_ACK_SHIFT_FIELD		14:12
#define MAC_PCU_REG_TXSIFS_SIFS_TIME_RESET		16
#define MAC_PCU_REG_TXSIFS_TX_LATENCY_RESET		2
#define MAC_PCU_REG_TXSIFS_ACK_SHIFT_RESET		3

#define MAC_PCU_REG_TXOP_X_OFFSET			0x7b
#define MAC_PCU_REG_TXOP_X_FIELD			7:0
#define MAC_PCU_REG_TXOP_X_RESET			0

#define MAC_PCU_REG_TXOP_0_3_OFFSET			0x7c
#define MAC_PCU_REG_TXOP_0_FIELD			7:0
#define MAC_PCU_REG_TXOP_1_FIELD			15:8
#define MAC_PCU_REG_TXOP_2_FIELD			23:16
#define MAC_PCU_REG_TXOP_3_FIELD			31:24
#define MAC_PCU_REG_TXOP_0_RESET			0
#define MAC_PCU_REG_TXOP_1_RESET			0
#define MAC_PCU_REG_TXOP_2_RESET			0
#define MAC_PCU_REG_TXOP_3_RESET			0

#define MAC_PCU_REG_TXOP_4_7_OFFSET			0x7d
#define MAC_PCU_REG_TXOP_4_FIELD			7:0
#define MAC_PCU_REG_TXOP_5_FIELD			15:8
#define MAC_PCU_REG_TXOP_6_FIELD			23:16
#define MAC_PCU_REG_TXOP_7_FIELD			31:24
#define MAC_PCU_REG_TXOP_4_RESET			0
#define MAC_PCU_REG_TXOP_5_RESET			0
#define MAC_PCU_REG_TXOP_6_RESET			0
#define MAC_PCU_REG_TXOP_7_RESET			0

#define MAC_PCU_REG_TXOP_8_11_OFFSET			0x7e
#define MAC_PCU_REG_TXOP_8_FIELD			7:0
#define MAC_PCU_REG_TXOP_9_FIELD			15:8
#define MAC_PCU_REG_TXOP_10_FIELD			23:16
#define MAC_PCU_REG_TXOP_11_FIELD			31:24
#define MAC_PCU_REG_TXOP_8_RESET			0
#define MAC_PCU_REG_TXOP_9_RESET			0
#define MAC_PCU_REG_TXOP_10_RESET			0
#define MAC_PCU_REG_TXOP_11_RESET			0

#define MAC_PCU_REG_TXOP_12_15_OFFSET			0x7f
#define MAC_PCU_REG_TXOP_12_FIELD			7:0
#define MAC_PCU_REG_TXOP_13_FIELD			15:8
#define MAC_PCU_REG_TXOP_14_FIELD			23:16
#define MAC_PCU_REG_TXOP_15_FIELD			31:24
#define MAC_PCU_REG_TXOP_12_RESET			0
#define MAC_PCU_REG_TXOP_13_RESET			0
#define MAC_PCU_REG_TXOP_14_RESET			0
#define MAC_PCU_REG_TXOP_15_RESET			0

#define MAC_PCU_REG_GNRCTMR_N_OFFSET			0x80
#define MAC_PCU_REG_GNRCTMR_N_UPPER_OFFSET		0x87
#define MAC_PCU_REG_GNRCTMR_N_FIELD			31:0

#define MAC_PCU_REG_GNRCTMR_P_OFFSET			0x88
#define MAC_PCU_REG_GNRCTMR_P_UPPER_OFFSET		0x8F
#define MAC_PCU_REG_GNRCTMR_P_FIELD			27:0

#define MAC_PCU_REG_GNRCTMR_M_OFFSET			0x90
#define MAC_PCU_REG_GNRCTMR_M_ENABLE_FIELD		7:0
#define MAC_PCU_REG_GNRCTMR_M_OVERFLOW_INDEX_FIELD	10:8
#define MAC_PCU_REG_GNRCTMR_M_THRESH_FIELD		31:12
#define MAC_PCU_REG_GNRCTMR_M_ENABLE_RESET		0x0
#define MAC_PCU_REG_GNRCTMR_M_THRESH_RESET		0x00100

#define MAC_PCU_REG_SLP32_MODE_OFFSET			0x91
#define MAC_PCU_REG_SLP32_MODE_HALF_CLK_LATENCY_FIELD	19:0
#define MAC_PCU_REG_SLP32_MODE_ENABLE_FIELD		20
#define MAC_PCU_REG_SLP32_MODE_TSF_WRITE_STAT_FIELD	21
#define MAC_PCU_REG_SLP32_MODE_HALF_CLK_LATENCY_RESET	0x0F424
#define MAC_PCU_REG_SLP32_MODE_ENABLE_RESET		0x1

#define MAC_PCU_REG_SLP32_WAKE_OFFSET			0x92
#define MAC_PCU_REG_SLP32_WAKE_XTL_TIME_FIELD		15:0
#define MAC_PCU_REG_SLP32_WAKE_XTL_TIME_RESET		0x07EF

#define MAC_PCU_REG_SLP32_TSF_INC_OFFSET		0x93
#define MAC_PCU_REG_SLP32_TSF_INC_FIELD			19:0
#define MAC_PCU_REG_SLP32_TSF_INC_RESET			0x1E848

#define MAC_PCU_REG_SLPMIB1_OFFSET			0x94
#define MAC_PCU_REG_SLPMIB1_SLEEP_CNT_FIELD		31:0

#define MAC_PCU_REG_SLPMIB2_OFFSET			0x95
#define MAC_PCU_REG_SLPMIB2_CYCLE_CNT_FIELD		31:0

#define MAC_PCU_REG_SLPMIB3_OFFSET			0x96
#define MAC_PCU_REG_SLPMIB3_CLR_CNT_FIELD		0
#define MAC_PCU_REG_SLPMIB3_PEND_FIELD			1

#define MAC_PCU_REG_MISCMODE2_OFFSET				0x97
#define MAC_PCU_REG_MISCMODE2_MGMT_CRYPTO_ENABLE_FIELD		0
#define MAC_PCU_REG_MISCMODE2_NO_CRYPTO_FOR_NON_DATA_PKT_FIELD	1
#define MAC_PCU_REG_MISCMODE2_MGMT_QOS_FIELD			15:8
#define MAC_PCU_REG_MISCMODE2_BC_MC_WAPI_MODE_FIELD		16
#define MAC_PCU_REG_MISCMODE2_IGNORE_TXOP_FOR_1ST_PKT_FIELD	17
#define MAC_PCU_REG_MISCMODE2_IGNORE_TXOP_IF_ZERO_FIELD		18
#define MAC_PCU_REG_MISCMODE2_MGMT_CRYPTO_ENABLE_RESET		0x0
#define MAC_PCU_REG_MISCMODE2_NO_CRYPTO_FOR_NON_DATA_PKT_RESET	0x0
#define MAC_PCU_REG_MISCMODE2_MGMT_QOS_RESET			0x10
#define MAC_PCU_REG_MISCMODE2_BC_MC_WAPI_MODE_RESET		0x0
#define MAC_PCU_REG_MISCMODE2_IGNORE_TXOP_FOR_1ST_PKT_RESET	0x0
#define MAC_PCU_REG_MISCMODE2_IGNORE_TXOP_IF_ZERO_RESET		0x0

#define MAC_PCU_REG_SLP4_OFFSET				0x98
#define MAC_PCU_REG_SLP4_CAB_AWAKE_DUR_FIELD		15:0
#define MAC_PCU_REG_SLP4_CAB_AWAKE_ENABLE_FIELD		16
#define MAC_PCU_REG_SLP4_CAB_AWAKE_DUR_RESET		0x5
#define MAC_PCU_REG_SLP4_CAB_AWAKE_ENABLE_RESET		0x0

#define MAC_PCU_REG_SLP5_OFFSET				0x99
#define MAC_PCU_REG_SLP5_BMISS_TIMEOUT_FIELD		23:0
#define MAC_PCU_REG_SLP5_BMISS_TIMEOUT_ENABLE_FIELD	24
#define MAC_PCU_REG_SLP5_BMISS_TIMEOUT_RESET		0xff_ffff
#define MAC_PCU_REG_SLP5_BMISS_TIMEOUT_ENABLE_RESET	0x0

#define MAC_PCU_REG_MCICTL_OFFSET                       0x9a
#define MAC_PCU_REG_MCICTL_MCI_ENABLE_FIELD             0 
#define MAC_PCU_REG_MCICTL_OLA_ENABLE_FIELD             1
#define MAC_PCU_REG_MCICTL_PREEMPT_ENABLE_FIELD         2
#define MAC_PCU_REG_MCICTL_CHANNEL_BUSY_ENABLE_FIELD    3
#define MAC_PCU_REG_MCICTL_EARLY_NOTIFY_DELAY_FIELD     9:4
#define MAC_PCU_REG_MCICTL_BMISS_FORCE_WL_FIELD    	10
#define MAC_PCU_REG_MCICTL_SLEEP_FORCE_BT_FIELD    	11
#define MAC_PCU_REG_MCICTL_HP_QCU_STOMP_BT_FIELD    	12
#define MAC_PCU_REG_MCICTL_MCI_BUSY_FIELD               31 
#define MAC_PCU_REG_MCICTL_MCI_ENABLE_RESET             0x0 
#define MAC_PCU_REG_MCICTL_OLA_ENABLE_RESET             0x1 
#define MAC_PCU_REG_MCICTL_PREEMPT_ENABLE_RESET         0x1
#define MAC_PCU_REG_MCICTL_CHANNEL_BUSY_ENABLE_RESET    0x1
#define MAC_PCU_REG_MCICTL_EARLY_NOTIFY_DELAY_RESET     0x5
#define MAC_PCU_REG_MCICTL_BMISS_FORCE_WL_RESET    	0x0
#define MAC_PCU_REG_MCICTL_SLEEP_FORCE_BT_RESET    	0x1
#define MAC_PCU_REG_MCICTL_HP_QCU_STOMP_BT_RESET    	0x0

#define MAC_PCU_REG_MCIISR_OFFSET                       0x9b
#define MAC_PCU_REG_MCIISR_ACT_RPT_RCV_INT_FIELD        0
#define MAC_PCU_REG_MCIISR_ACT_DEN_RCV_INT_FIELD        1
#define MAC_PCU_REG_MCIISR_FRQ_RPT_RCV_INT_FIELD        2
#define MAC_PCU_REG_MCIISR_QOS_RPT_RCV_INT_FIELD        3
#define MAC_PCU_REG_MCIISR_GEN_RPT_RCV_INT_FIELD        4
#define MAC_PCU_REG_MCIISR_ACT_RPT_RCV_INT_RESET        0x0
#define MAC_PCU_REG_MCIISR_ACT_DEN_RCV_INT_RESET        0x0
#define MAC_PCU_REG_MCIISR_FRQ_RPT_RCV_INT_RESET        0x0
#define MAC_PCU_REG_MCIISR_QOS_RPT_RCV_INT_RESET        0x0
#define MAC_PCU_REG_MCIISR_GEN_RPT_RCV_INT_RESET        0x0

#define MAC_PCU_REG_MCIIER_OFFSET                       0x9c
#define MAC_PCU_REG_MCIIER_ACT_RPT_RCV_INT_ENABLE_FIELD 0
#define MAC_PCU_REG_MCIIER_ACT_DEN_RCV_INT_ENABLE_FIELD 1
#define MAC_PCU_REG_MCIIER_FRQ_RPT_RCV_INT_ENABLE_FIELD 2
#define MAC_PCU_REG_MCIIER_QOS_RPT_RCV_INT_ENABLE_FIELD 3
#define MAC_PCU_REG_MCIIER_GEN_RPT_RCV_INT_ENABLE_FIELD 4
#define MAC_PCU_REG_MCIIER_ACT_RPT_RCV_INT_ENABLE_RESET 0x0
#define MAC_PCU_REG_MCIIER_ACT_DEN_RCV_INT_ENABLE_RESET 0x0
#define MAC_PCU_REG_MCIIER_FRQ_RPT_RCV_INT_ENABLE_RESET 0x0
#define MAC_PCU_REG_MCIIER_QOS_RPT_RCV_INT_ENABLE_RESET 0x0
#define MAC_PCU_REG_MCIIER_GEN_RPT_RCV_INT_ENABLE_RESET 0x0

#define MAC_PCU_REG_MCIWLP_OFFSET                       0x9d
#define MAC_PCU_REG_MCIWLP_RESET                        0x0

#define MAC_PCU_REG_MCIARW_OFFSET                       0x9e
#define MAC_PCU_REG_MCIARW_RESET                        0x0

#define MAC_PCU_REG_MCIARR_OFFSET                       0x9f

#define MAC_PCU_REG_MCIADW_OFFSET                       0xa0
#define MAC_PCU_REG_MCIADW_RESET                        0x0

#define MAC_PCU_REG_MCIADR_OFFSET                       0xa1

#define MAC_PCU_REG_MCIFRW_OFFSET                       0xa2
#define MAC_PCU_REG_MCIFRW_RESET                        0x0

#define MAC_PCU_REG_MCIFRR_OFFSET                       0xa3

#define MAC_PCU_REG_MCIQRW_OFFSET                       0xa4
#define MAC_PCU_REG_MCIQRW_RESET                        0x0

#define MAC_PCU_REG_MCIQRR_OFFSET                       0xa5

#define MAC_PCU_REG_MCIGRW_OFFSET                       0xa6
#define MAC_PCU_REG_MCIGRW_RESET                        0x0

#define MAC_PCU_REG_MCIGRR_OFFSET                       0xa7

#define MAC_PCU_REG_MCISTAT_OFFSET                       0xa8
#define MAC_PCU_REG_MCISTAT_ACT_RPT_RCV_CNT_FIELD       7:0 
#define MAC_PCU_REG_MCISTAT_QC_CNT_FIELD         	15:8
#define MAC_PCU_REG_MCISTAT_OLA_CNT_FIELD         	23:16
#define MAC_PCU_REG_MCISTAT_PREEMPT_CNT_FIELD         	31:24
#define MAC_PCU_REG_MCISTAT_ACT_RPT_RCV_CNT_RESET       0x0 
#define MAC_PCU_REG_MCISTAT_QC_CNT_RESET         	0x0
#define MAC_PCU_REG_MCISTAT_OLA_CNT_RESET         	0x0
#define MAC_PCU_REG_MCISTAT_PREEMPT_CNT_RESET         	0x0

#define MAC_PCU_REG_BASIC_RATE_SET0_OFFSET		0xa9
#define MAC_PCU_REG_BRATE_1MB_L_FIELD			4:0
#define MAC_PCU_REG_BRATE_2MB_L_FIELD			9:5
#define MAC_PCU_REG_BRATE_2MB_S_FIELD			14:10
#define MAC_PCU_REG_BRATE_5_5MB_L_FIELD			19:15
#define MAC_PCU_REG_BRATE_5_5MB_S_FIELD			24:20
#define MAC_PCU_REG_BRATE_11MB_L_FIELD			29:25
#define MAC_PCU_REG_BRATE_1MB_L_RESET			#CCK_RATE_1Mb_L
#define MAC_PCU_REG_BRATE_2MB_L_RESET			#CCK_RATE_2Mb_L
#define MAC_PCU_REG_BRATE_2MB_S_RESET			#CCK_RATE_2Mb_S
#define MAC_PCU_REG_BRATE_5_5MB_L_RESET			#CCK_RATE_5_5Mb_L
#define MAC_PCU_REG_BRATE_5_5MB_S_RESET			#CCK_RATE_5_5Mb_S
#define MAC_PCU_REG_BRATE_11MB_L_RESET			#CCK_RATE_11Mb_L

#define MAC_PCU_REG_BASIC_RATE_SET1_OFFSET		0xaa
#define MAC_PCU_REG_BRATE_11MB_S_FIELD			4:0
#define MAC_PCU_REG_BRATE_6MB_FIELD			9:5
#define MAC_PCU_REG_BRATE_9MB_FIELD			14:10
#define MAC_PCU_REG_BRATE_12MB_FIELD			19:15
#define MAC_PCU_REG_BRATE_18MB_FIELD			24:20
#define MAC_PCU_REG_BRATE_24MB_FIELD			29:25
#define MAC_PCU_REG_BRATE_11MB_S_RESET			#CCK_RATE_11Mb_S
#define MAC_PCU_REG_BRATE_6MB_RESET			#OFDM_RATE_6Mb
#define MAC_PCU_REG_BRATE_9MB_RESET			#OFDM_RATE_6Mb
#define MAC_PCU_REG_BRATE_12MB_RESET			#OFDM_RATE_12Mb
#define MAC_PCU_REG_BRATE_18MB_RESET			#OFDM_RATE_12Mb
#define MAC_PCU_REG_BRATE_24MB_RESET			#OFDM_RATE_24Mb

#define MAC_PCU_REG_BASIC_RATE_SET2_OFFSET		0xab
#define MAC_PCU_REG_BRATE_36MB_FIELD			4:0
#define MAC_PCU_REG_BRATE_48MB_FIELD			9:5
#define MAC_PCU_REG_BRATE_54MB_FIELD			14:10
#define MAC_PCU_REG_BRATE_36MB_RESET			#OFDM_RATE_24Mb
#define MAC_PCU_REG_BRATE_48MB_RESET			#OFDM_RATE_24Mb
#define MAC_PCU_REG_BRATE_54MB_RESET			#OFDM_RATE_24Mb

#define MAC_PCU_REG_SEC_BSSID_L32_OFFSET		0xac
#define MAC_PCU_REG_SEC_BSSID_L32_FIELD			31:0
#define MAC_PCU_REG_SEC_BSSID_L32_RESET			0x0

#define MAC_PCU_REG_SEC_BSSID_U16_OFFSET		0xad
#define MAC_PCU_REG_SEC_BSSID_U16_FIELD			15:0
#define MAC_PCU_REG_SEC_BSSID_ENABLE_FIELD		16
#define MAC_PCU_REG_SEC_BSSID_U16_RESET			0x0
#define MAC_PCU_REG_SEC_BSSID_ENABLE_RESET		0x0

#define MAC_PCU_REG_FTYPE_OFFSET			0x140
#define MAC_PCU_REG_FTYPE_UPPER_OFFSET			0x17F
#define MAC_PCU_REG_FTYPE_BFCOEF_RX_UPDATE_NORMAL_FIELD			0
#define MAC_PCU_REG_FTYPE_BFCOEF_RX_UPDATE_SELF_GEN_FIELD		1
#define MAC_PCU_REG_FTYPE_BFCOEF_TX_ENABLE_NORMAL_FIELD			2
#define MAC_PCU_REG_FTYPE_BFCOEF_TX_ENABLE_SELF_GEN_FIELD		3
#define MAC_PCU_REG_FTYPE_BFCOEF_TX_ENABLE_GEN_FIELD			4
#define MAC_PCU_REG_FTYPE_BFCOEF_TX_ENABLE_MCAST_FIELD			5
#define MAC_PCU_REG_FTYPE_FILTER_PASS_IF_ALL_FIELD			6
#define MAC_PCU_REG_FTYPE_FILTER_PASS_IF_DIRECTED_FIELD			7
#define MAC_PCU_REG_FTYPE_FILTER_PASS_IF_MCAST_FIELD			8
#define MAC_PCU_REG_FTYPE_FILTER_PASS_IF_BCAST_FIELD			9
#define MAC_PCU_REG_FTYPE_FILTER_PASS_MC_BC_BSSID_FIELD			10

#define MAC_PCU_REG_ACKSIFSMEM_OFFSET_RESERVED		0x1A0
#define MAC_PCU_REG_ACKSIFSMEM_UPPER_OFFSET_RESERVED	0x1BF
#define MAC_PCU_REG_ACKSIFSMEM_NORMAL_FIELD_RESERVED	9:0
#define MAC_PCU_REG_ACKSIFSMEM_TURBO_FIELD_RESERVED	19:10

#define MAC_PCU_REG_DUR_OFFSET				0x1C0
#define MAC_PCU_REG_DUR_UPPER_OFFSET			0x1DF
#define MAC_PCU_REG_DUR_RATE_TO_DURATION_FIELD		15:0

#define MAC_PCU_REG_RTD_OFFSET				0x1F0
#define MAC_PCU_REG_RTD_UPPER_OFFSET			0x1F7
#define MAC_PCU_REG_RTD_RATE_TO_DB_0_FIELD		4:0
#define MAC_PCU_REG_RTD_RATE_TO_DB_1_FIELD		12:8
#define MAC_PCU_REG_RTD_RATE_TO_DB_2_FIELD		20:16
#define MAC_PCU_REG_RTD_RATE_TO_DB_3_FIELD		28:24

#define MAC_PCU_REG_DTR_OFFSET				0x1F8
#define MAC_PCU_REG_DTR_UPPER_OFFSET			0x1FF
#define MAC_PCU_REG_DTR_DB_TO_RATE_0_FIELD		4:0
#define MAC_PCU_REG_DTR_DB_TO_RATE_1_FIELD		12:8
#define MAC_PCU_REG_DTR_DB_TO_RATE_2_FIELD		20:16
#define MAC_PCU_REG_DTR_DB_TO_RATE_3_FIELD		28:24

#define MAC_PCU_REG_KC_OFFSET				0x200
#define MAC_PCU_REG_KC_UPPER_OFFSET			0x5FF
#define MAC_PCU_REG_KC_KEY_31_0_FIELD			31:0
#define MAC_PCU_REG_KC_KEY_47_32_FIELD			15:0
#define MAC_PCU_REG_KC_KEY_79_48_FIELD			31:0
#define MAC_PCU_REG_KC_KEY_95_80_FIELD			15:0
#define MAC_PCU_REG_KC_KEY_127_96_FIELD			31:0
#define MAC_PCU_REG_KC_KEY_TYPE_FIELD			2:0
#define MAC_PCU_REG_KC_LAST_ANTENNA_FIELD		3
#define MAC_PCU_REG_KC_ASYNC_ACK_OFFSET_FIELD		8:4
#define MAC_PCU_REG_KC_UPDATE_BEAM_FORMING_FIELD	9
#define MAC_PCU_REG_KC_RX_CHAIN_0_ACK_ANT_FIELD		10
#define MAC_PCU_REG_KC_RX_CHAIN_1_ACK_ANT_FIELD		11
#define MAC_PCU_REG_KC_TX_CHAIN_0_ANT_SEL_FIELD		12
#define MAC_PCU_REG_KC_TX_CHAIN_1_ANT_SEL_FIELD		13
#define MAC_PCU_REG_KC_TX_CHAIN_SEL_FIELD		14
#define MAC_PCU_REG_KC_ADDR_32_1_FIELD			31:0
#define MAC_PCU_REG_KC_ADDR_47_33_FIELD			14:0
#define MAC_PCU_REG_KC_VALID_FIELD			1

//Misc
#define ELEM_START	36
#define CFP_ELEM	4

#endif
