#   FILE: libss.spec.new.in -
# AUTHOR: W. Michael Petullo (mike@flyn.org)
#   DATE: 17 July 2002
# 
# Copyright (C) 2002 W. Michael Petullo (mike@flyn.org)
# All rights reserved.


%define rel 1
%define prefix /usr

Summary: one_liner_libss.txt
Name: libss
Version: 0.0.2
Release: %rel
Copyright: GPL
Group: System Environment/Libraries
Source: %name-%{PACKAGE_VERSION}.tar.gz
BuildRoot: /home/mike/development/live
Packager: W. Michael Petullo <mike@flyn.org>
Vendor: Flyn Computing
Distribution: Flyn Linux
URL: http://www.flyn.org

# ============================= description ====================================
%description

     _________________________________________________________

   Table of Contents

   Libss    is   a   cross-platform   library   for   controlling
   screensavers.   It   allows   one  to  temporarily  disable  a
   screensaver.   This   is   useful   for   fullscreen,   visual
   applications that take little input.


# ============================= package devel ================================= 
%package devel
Summary: Header files and documentation for libss
Group: Development/Libraries

# ============================= description devel ============================= 
%description devel
Header files and documentation for libss

# ============================= changelog ======================================
%changelog

# ============================= prep ===========================================
%prep

# ============================= setup ==========================================
%setup

# ============================= build ==========================================
%build
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=/usr
make

# ============================= install ========================================
%install
mkdir -p $RPM_BUILD_ROOT/usr/bin

# NOTE: The following trick only works with a modified header-vars.am.
# Change the line ``DESTDIR ='' in this file to ``DESTDIR =
# ${ENV_DESTDIR}.''
export ENV_DESTDIR=$RPM_BUILD_ROOT
make install

gzip -9 AUTHORS COPYING ChangeLog INSTALL NEWS README

# ============================= clean ==========================================
%clean
rm -rf $RPM_BUILD_ROOT

# ============================= pre ============================================
%pre

# ============================= post ===========================================
%post -p /sbin/ldconfig

# ============================= preun ==========================================
%preun

# ============================= postun =========================================
%postun -p /sbin/ldconfig

# ============================= files ==========================================
%files
%defattr(-, root, root)
%{prefix}/lib/libss.so.%{PACKAGE_VERSION}
%{prefix}/man/man1/libss.1

# ============================= files devel =================================== 
%files devel
%defattr(-, root, root)
%{prefix}/include/libss.h

# ============================= doc ============================================
%doc AUTHORS.gz COPYING.gz ChangeLog.gz INSTALL.gz NEWS.gz README.gz

# ============================= config =========================================
%config
