#!/bin/bash
XINIT=`which xinit`
XSERVER=`which X`
EVCALIBRATE=`which ev_calibrate || echo ./ev_calibrate`

echo $EVCALIBRATE

if ! [ -x "$EVCALIBRATE" ] ; then
	echo "ev_calibrate not found exiting ..."
	exit 1;
fi
echo "evalibrate located at $EVCALIBRATE"

if [ -z "$XINIT" ]; then
    echo "xinit not found exiting ..."
    exit 1;
fi
echo "xinit located at $XINIT"
if [ -z "$XSERVER" ]; then
    echo "X not found exiting ..."
    exit 1;
fi
echo "xserver located at $XSERVER"
if [ -e /tmp/ev_calibrate ]; then
	rm /tmp/ev_calibrate;
fi
echo "Creating FIFO..."
mknod /tmp/ev_calibrate p

#for development only :)
#cp evtouch_drv.o /usr/X11R6/lib/modules/input
#xinit /usr/bin/ddd ev_calibrate -- /usr/X11R6/bin/X
echo "Starting calibration program..."
sleep 2

$XINIT $EVCALIBRATE -- $XSERVER
exit 0
